/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.ups;

import java.util.List;
import java.util.Optional;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4chee.arc.conf.ArchiveAEExtension;

public class UPSEvent {
    public final Type type;
    public final String upsIUID;
    public final Attributes attrs;
    public final List<String> subscriberAETs;
    public final ArchiveAEExtension arcAE;

    public UPSEvent(ArchiveAEExtension arcAE, Type type, String upsIUID, Attributes attrs, List<String> subscriberAETs) {
        this.arcAE = arcAE;
        this.type = type;
        this.upsIUID = upsIUID;
        this.attrs = attrs;
        this.subscriberAETs = subscriberAETs;
    }

    public Optional<Attributes> inprocessStateReport() {
        if (this.type != Type.StateReportInProcessAndCanceled) {
            return Optional.empty();
        }
        Attributes eventInformation = new Attributes(6);
        eventInformation.setString(0x404041, VR.CS, this.attrs.getString(0x404041));
        eventInformation.setString(7606272, VR.CS, "IN PROGRESS");
        return Optional.of(eventInformation);
    }

    public Attributes withCommandAttributes(Attributes src, int messageID) {
        Attributes dest = new Attributes(src);
        dest.setString(2, VR.UI, "1.2.840.10008.5.1.4.34.6.1");
        dest.setInt(272, VR.US, new int[]{messageID});
        dest.setString(4096, VR.UI, this.upsIUID);
        dest.setInt(4098, VR.US, new int[]{this.type.eventTypeID()});
        return dest;
    }

    public ArchiveAEExtension getArchiveAEExtension() {
        return this.arcAE;
    }

    public static enum Type {
        StateReportInProcessAndCanceled{

            @Override
            public int eventTypeID() {
                return 1;
            }
        }
        ,
        StateReport,
        CancelRequested,
        ProgressReport,
        StatusChange,
        Assigned;


        public int eventTypeID() {
            return this.ordinal();
        }
    }
}

