/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.study.impl;

import java.net.Socket;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.hl7.UnparsedHL7Message;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.patient.NonUniquePatientException;
import org.dcm4chee.arc.patient.PatientMergedException;
import org.dcm4chee.arc.patient.PatientMgtContext;
import org.dcm4chee.arc.patient.PatientMismatchException;
import org.dcm4chee.arc.study.StudyMgtContext;
import org.dcm4chee.arc.study.StudyMissingException;
import org.dcm4chee.arc.study.StudyService;
import org.dcm4chee.arc.study.impl.StudyMgtContextImpl;
import org.dcm4chee.arc.study.impl.StudyServiceEJB;

@ApplicationScoped
public class StudyServiceImpl
implements StudyService {
    @Inject
    private Device device;
    @Inject
    private StudyServiceEJB ejb;
    @Inject
    private Event<StudyMgtContext> updateStudyEvent;

    @Override
    public StudyMgtContext createStudyMgtContextWEB(HttpServletRequestInfo httpRequest, ApplicationEntity ae) {
        return new StudyMgtContextImpl(this.device).withHttpRequest(httpRequest).withApplicationEntity(ae);
    }

    @Override
    public StudyMgtContext createStudyMgtContextHL7(Socket socket, UnparsedHL7Message msg) {
        return new StudyMgtContextImpl(this.device).withSocket(socket).withUnparsedHL7Message(msg);
    }

    @Override
    public void updateStudy(StudyMgtContext ctx) throws StudyMissingException, PatientMismatchException {
        try {
            this.ejb.updateStudy(ctx);
        }
        catch (RuntimeException e) {
            ctx.setException(e);
            throw e;
        }
        finally {
            if (ctx.getEventActionCode() != null) {
                this.updateStudyEvent.fire((Object)ctx);
            }
        }
    }

    @Override
    public void updateSeries(StudyMgtContext ctx) throws StudyMissingException, PatientMismatchException {
        try {
            this.ejb.updateSeries(ctx);
        }
        catch (RuntimeException e) {
            ctx.setException(e);
            throw e;
        }
        finally {
            if (ctx.getEventActionCode() != null) {
                this.updateStudyEvent.fire((Object)ctx);
            }
        }
    }

    @Override
    public void updateStudyRequest(StudyMgtContext ctx) throws StudyMissingException {
        try {
            this.ejb.updateStudyRequest(ctx);
        }
        catch (RuntimeException e) {
            ctx.setException(e);
            throw e;
        }
        finally {
            if (ctx.getEventActionCode() != null) {
                this.updateStudyEvent.fire((Object)ctx);
            }
        }
    }

    @Override
    public void updateSeriesRequest(StudyMgtContext ctx) throws StudyMissingException {
        try {
            this.ejb.updateSeriesRequest(ctx);
        }
        catch (RuntimeException e) {
            ctx.setException(e);
            throw e;
        }
        finally {
            if (ctx.getEventActionCode() != null) {
                this.updateStudyEvent.fire((Object)ctx);
            }
        }
    }

    @Override
    public void updateExpirationDate(StudyMgtContext ctx) {
        try {
            this.ejb.updateExpirationDate(ctx);
        }
        catch (Exception e) {
            ctx.setException(e);
            throw e;
        }
        finally {
            if (ctx.getEventActionCode() != null) {
                this.updateStudyEvent.fire((Object)ctx);
            }
        }
    }

    @Override
    public void updateAccessControlID(StudyMgtContext ctx) throws StudyMissingException {
        try {
            this.ejb.updateAccessControlID(ctx);
        }
        catch (RuntimeException e) {
            ctx.setException(e);
            throw e;
        }
        finally {
            if (ctx.getEventActionCode() != null) {
                this.updateStudyEvent.fire((Object)ctx);
            }
        }
    }

    @Override
    public void moveStudyToPatient(String studyUID, PatientMgtContext ctx) throws StudyMissingException, NonUniquePatientException, PatientMergedException {
        try {
            this.ejb.moveStudyToPatient(studyUID, ctx);
        }
        catch (RuntimeException e) {
            ctx.setException((Exception)e);
            throw e;
        }
    }
}

