/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.study.impl;

import java.time.LocalDate;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Code;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.Device;
import org.dcm4che3.soundex.FuzzyStr;
import org.dcm4chee.arc.code.CodeCache;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.AttributeFilter;
import org.dcm4chee.arc.entity.CodeEntity;
import org.dcm4chee.arc.entity.ExpirationState;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.entity.Series;
import org.dcm4chee.arc.entity.SeriesRequestAttributes;
import org.dcm4chee.arc.entity.Study;
import org.dcm4chee.arc.patient.PatientMgtContext;
import org.dcm4chee.arc.patient.PatientMismatchException;
import org.dcm4chee.arc.patient.PatientService;
import org.dcm4chee.arc.study.StudyMgtContext;
import org.dcm4chee.arc.study.StudyMissingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class StudyServiceEJB {
    private static final Logger LOG = LoggerFactory.getLogger(StudyServiceEJB.class);
    @PersistenceContext(unitName="dcm4chee-arc")
    private EntityManager em;
    @Inject
    private CodeCache codeCache;
    @Inject
    private PatientService patientService;
    @Inject
    private Device device;

    public void updateStudy(StudyMgtContext ctx) throws StudyMissingException, PatientMismatchException {
        AttributeFilter filter = ctx.getStudyAttributeFilter();
        Study study = this.findStudy(ctx.getStudyInstanceUID());
        Attributes attrs = study.getAttributes();
        Attributes newAttrs = new Attributes(ctx.getAttributes(), filter.getSelection(false));
        Attributes modified = new Attributes();
        if (attrs.diff(newAttrs, filter.getSelection(false), modified, true) == 0) {
            return;
        }
        ctx.setEventActionCode("U");
        ctx.setStudy(study);
        if (ctx.getPatient() == null) {
            ctx.setPatient(study.getPatient());
        } else if (study.getPatient().getPk() != ctx.getPatient().getPk()) {
            throw new PatientMismatchException(ctx.getPatient() + " does not match " + study.getPatient() + " in existing " + study);
        }
        Attributes.unifyCharacterSets((Attributes[])new Attributes[]{newAttrs, attrs});
        newAttrs.addSelected(attrs, null, 67110241);
        attrs = newAttrs;
        study.setAttributes(ctx.getReasonForModification() != null ? attrs.addOriginalAttributes(ctx.getSourceOfPreviousValues(), new Date(), ctx.getReasonForModification(), this.device.getDeviceName(), modified) : attrs, filter, true, ctx.getFuzzyStr());
        this.setCodes(study.getProcedureCodes(), attrs.getSequence(528434));
        this.em.createNamedQuery("Series.scheduleMetadataUpdateForStudy").setParameter(1, (Object)study).executeUpdate();
    }

    public void updateSeries(StudyMgtContext ctx) throws StudyMissingException, PatientMismatchException {
        AttributeFilter filter = ctx.getSeriesAttributeFilter();
        Series series = this.findSeries(ctx);
        Attributes attrs = series.getAttributes();
        Attributes newAttrs = new Attributes(ctx.getAttributes(), filter.getSelection(false));
        Attributes modified = new Attributes();
        if (attrs.diff(newAttrs, filter.getSelection(false), modified, true) == 0) {
            return;
        }
        ctx.setEventActionCode("U");
        ctx.setStudy(series.getStudy());
        if (ctx.getPatient() == null) {
            ctx.setPatient(series.getStudy().getPatient());
        } else if (series.getStudy().getPatient().getPk() != ctx.getPatient().getPk()) {
            throw new PatientMismatchException(ctx.getPatient() + " does not match " + series.getStudy().getPatient() + " in existing " + series.getStudy());
        }
        Attributes.unifyCharacterSets((Attributes[])new Attributes[]{newAttrs, attrs});
        newAttrs.addSelected(attrs, null, 67110241);
        attrs = newAttrs;
        series.setAttributes(ctx.getReasonForModification() != null ? attrs.addOriginalAttributes(ctx.getSourceOfPreviousValues(), new Date(), ctx.getReasonForModification(), this.device.getDeviceName(), modified) : attrs, filter, true, ctx.getFuzzyStr());
        this.em.createNamedQuery("Series.scheduleMetadataUpdateForSeries").setParameter(1, (Object)series.getPk()).executeUpdate();
    }

    public void updateStudyRequest(StudyMgtContext ctx) throws StudyMissingException {
        AttributeFilter studyAttrFilter = ctx.getStudyAttributeFilter();
        List seriesList = this.em.createNamedQuery("Series.findSeriesOfStudyByStudyIUIDEager", Series.class).setParameter(1, (Object)ctx.getStudyInstanceUID()).getResultList();
        if (seriesList.isEmpty()) {
            throw new StudyMissingException("Study to be updated does not exist: " + ctx.getStudyInstanceUID());
        }
        for (Object series : seriesList) {
            this.updateSeriesRequest(ctx, (Series)series);
        }
        if (ctx.getEventActionCode() == null) {
            return;
        }
        IDWithIssuer accWithIssuer = null;
        for (Attributes requestAttribute : ctx.getRequestAttributes()) {
            IDWithIssuer accWithIssuerI = IDWithIssuer.valueOf((Attributes)requestAttribute, (int)524368, (int)524369);
            if (accWithIssuerI == null) continue;
            if (accWithIssuer == null) {
                accWithIssuer = accWithIssuerI;
                continue;
            }
            if (accWithIssuer.equals((Object)accWithIssuerI)) continue;
            return;
        }
        if (accWithIssuer == null) {
            return;
        }
        Study study = ctx.getStudy();
        Attributes attrs = study.getAttributes();
        if (accWithIssuer.equals((Object)IDWithIssuer.valueOf((Attributes)attrs, (int)524368, (int)524369))) {
            return;
        }
        Attributes modified = ctx.getReasonForModification() != null ? new Attributes(attrs, new int[]{524368, 524369}) : null;
        attrs.setString(524368, VR.SH, accWithIssuer.getID());
        if (accWithIssuer.getIssuer() == null) {
            attrs.setNull(524369, VR.SQ);
        } else {
            attrs.newSequence(524369, 1).add(accWithIssuer.getIssuer().toItem());
        }
        study.setAttributes(modified != null ? attrs.addOriginalAttributes(ctx.getSourceOfPreviousValues(), new Date(), ctx.getReasonForModification(), this.device.getDeviceName(), modified) : attrs, studyAttrFilter, true, ctx.getFuzzyStr());
    }

    public void updateSeriesRequest(StudyMgtContext ctx) throws StudyMissingException {
        this.updateSeriesRequest(ctx, this.findSeries(ctx));
    }

    private void updateSeriesRequest(StudyMgtContext ctx, Series series) {
        Attributes seriesAttr = series.getAttributes();
        List<Attributes> requestAttrs = ctx.getRequestAttributes();
        Sequence origRequestAttributes = seriesAttr.getSequence(4194933);
        if (Objects.equals(origRequestAttributes, requestAttrs)) {
            return;
        }
        Attributes modified = null;
        if (ctx.getReasonForModification() != null && origRequestAttributes != null) {
            modified = new Attributes(1);
            Sequence rqAttrsSeq = modified.newSequence(4194933, origRequestAttributes.size());
            for (Attributes requestAttr : origRequestAttributes) {
                rqAttrsSeq.add(new Attributes(requestAttr));
            }
        }
        FuzzyStr fuzzyStr = ((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getFuzzyStr();
        Sequence rqAttrsSeq = seriesAttr.newSequence(4194933, requestAttrs.size());
        Collection requestAttributes = series.getRequestAttributes();
        requestAttributes.clear();
        for (Attributes requestAttr : requestAttrs) {
            rqAttrsSeq.add(new Attributes(requestAttr));
            requestAttributes.add(new SeriesRequestAttributes(requestAttr, fuzzyStr));
        }
        AttributeFilter seriesAttrFilter = ctx.getSeriesAttributeFilter();
        series.setAttributes(modified != null ? seriesAttr.addOriginalAttributes(ctx.getSourceOfPreviousValues(), new Date(), ctx.getReasonForModification(), this.device.getDeviceName(), modified) : seriesAttr, seriesAttrFilter, true, ctx.getFuzzyStr());
        ctx.setStudy(series.getStudy());
        ctx.setPatient(series.getStudy().getPatient());
        ctx.setEventActionCode("U");
    }

    private Study findStudy(String studyUID) throws StudyMissingException {
        try {
            return (Study)this.em.createNamedQuery("Study.findByStudyIUIDEager", Study.class).setParameter(1, (Object)studyUID).getSingleResult();
        }
        catch (NoResultException e) {
            throw new StudyMissingException("Study to be updated does not exist: " + studyUID);
        }
    }

    private Series findSeries(StudyMgtContext ctx) throws StudyMissingException {
        try {
            return (Series)this.em.createNamedQuery("Series.findBySeriesIUIDEager", Series.class).setParameter(1, (Object)ctx.getStudyInstanceUID()).setParameter(2, (Object)ctx.getSeriesInstanceUID()).getSingleResult();
        }
        catch (NoResultException e) {
            throw new StudyMissingException("Series[uid=" + ctx.getSeriesInstanceUID() + "] of Study[uid=" + ctx.getStudyInstanceUID() + "] to be updated does not exist");
        }
    }

    private void updateStudyExpirationDate(StudyMgtContext ctx) {
        List seriesOfStudy = this.em.createNamedQuery("Series.FindSeriesOfStudy", Series.class).setParameter(1, (Object)ctx.getStudyInstanceUID()).getResultList();
        Study study = !seriesOfStudy.isEmpty() ? ((Series)seriesOfStudy.get(0)).getStudy() : (Study)this.em.createNamedQuery("Study.findByStudyIUID", Study.class).setParameter(1, (Object)ctx.getStudyInstanceUID()).getSingleResult();
        ctx.setStudy(study);
        ctx.setPatient(study.getPatient());
        ctx.setAttributes(study.getAttributes());
        ctx.setEventActionCode("U");
        ExpirationOperation expirationOp = ExpirationOperation.compute(ctx, study);
        if (expirationOp == ExpirationOperation.Protect) {
            this.studyExpirationTo(expirationOp, ctx, study);
            seriesOfStudy.forEach(series -> this.seriesExpirationTo(expirationOp, ctx, (Series)series));
            return;
        }
        if (expirationOp == ExpirationOperation.Skip) {
            LOG.info("{} updating {} Study[UID={}, ExpirationDate[={}]] with ExpirationDate[={}]", new Object[]{expirationOp.name(), expirationOp.expirationState, study.getStudyInstanceUID(), study.getExpirationDate(), ctx.getExpirationDate()});
            ctx.setEventActionCode(null);
            return;
        }
        this.studyExpirationTo(expirationOp, ctx, study);
        if (expirationOp == ExpirationOperation.Update) {
            seriesOfStudy.forEach(series -> {
                LocalDate seriesExpirationDate = series.getExpirationDate();
                if (seriesExpirationDate != null && seriesExpirationDate.isAfter(ctx.getExpirationDate())) {
                    this.seriesExpirationTo(expirationOp, ctx, (Series)series);
                }
            });
        } else {
            seriesOfStudy.forEach(series -> this.seriesExpirationTo(expirationOp, ctx, (Series)series));
        }
    }

    private void studyExpirationTo(ExpirationOperation expirationOp, StudyMgtContext ctx, Study study) {
        LOG.info("{} Study[UID={}] with ExpirationDate[={}] and ExpirationState[={}]", new Object[]{expirationOp.name(), study.getStudyInstanceUID(), ctx.getExpirationDate(), expirationOp.expirationState});
        study.setExpirationDate(ctx.getExpirationDate());
        study.setExpirationExporterID(ctx.getExpirationExporterID());
        study.setExpirationState(expirationOp.expirationState);
    }

    private void seriesExpirationTo(ExpirationOperation expirationOp, StudyMgtContext ctx, Series series) {
        LOG.info("{} Series[UID={}] with ExpirationDate[={}] and ExpirationState[={}]", new Object[]{expirationOp.name(), series.getSeriesInstanceUID(), ctx.getExpirationDate(), expirationOp.expirationState});
        series.setExpirationDate(ctx.getExpirationDate());
        series.setExpirationExporterID(ctx.getExpirationExporterID());
        series.setExpirationState(expirationOp.expirationState);
    }

    private void updateSeriesExpirationDate(StudyMgtContext ctx) {
        Series series = (Series)this.em.createNamedQuery("Series.findBySeriesIUID", Series.class).setParameter(1, (Object)ctx.getStudyInstanceUID()).setParameter(2, (Object)ctx.getSeriesInstanceUID()).getSingleResult();
        Study study = series.getStudy();
        LocalDate expirationDate = ctx.getExpirationDate();
        if (series.getExpirationState() == ExpirationState.FROZEN) {
            LOG.info("Skip updating frozen Series[UID={}, ExpirationDate={}] of Study[UID={}] with ExpirationDate[={}]", new Object[]{series.getSeriesInstanceUID(), series.getExpirationDate(), study.getStudyInstanceUID(), expirationDate});
            return;
        }
        LocalDate studyExpirationDate = study.getExpirationDate();
        this.seriesExpirationTo(ExpirationOperation.Update, ctx, series);
        ctx.setStudy(study);
        ctx.setPatient(study.getPatient());
        ctx.setAttributes(study.getAttributes());
        if (studyExpirationDate == null || studyExpirationDate.isBefore(expirationDate)) {
            this.studyExpirationTo(ExpirationOperation.Update, ctx, study);
        }
        ctx.setEventActionCode("U");
    }

    public void updateExpirationDate(StudyMgtContext ctx) {
        if (ctx.getSeriesInstanceUID() != null) {
            this.updateSeriesExpirationDate(ctx);
            return;
        }
        this.updateStudyExpirationDate(ctx);
    }

    public void updateAccessControlID(StudyMgtContext ctx) throws StudyMissingException {
        if (ctx.getAttributes() != null) {
            this.em.createNamedQuery("Study.updateAccessControlID").setParameter(1, (Object)ctx.getStudyInstanceUID()).setParameter(2, (Object)ctx.getAccessControlID()).executeUpdate();
            return;
        }
        Study study = this.findStudy(ctx.getStudyInstanceUID());
        ctx.setAttributes(study.getAttributes());
        ctx.setPatient(study.getPatient());
        ctx.setEventActionCode("U");
        study.setAccessControlID(ctx.getAccessControlID());
    }

    public void moveStudyToPatient(String studyUID, PatientMgtContext ctx) throws StudyMissingException {
        Study study = this.findStudy(studyUID);
        Patient patient = this.patientService.updatePatient(ctx);
        patient.incrementNumberOfStudies();
        study.getPatient().decrementNumberOfStudies();
        study.setPatient(patient);
    }

    private void setCodes(Collection<CodeEntity> codes, Sequence seq) {
        codes.clear();
        if (seq != null) {
            for (Attributes item : seq) {
                try {
                    codes.add(this.codeCache.findOrCreate(new Code(item)));
                }
                catch (Exception e) {
                    LOG.info("Illegal Procedure Code:\n{}", (Object)item);
                }
            }
        }
    }

    static enum ExpirationOperation {
        Freeze(ExpirationState.FROZEN),
        Unfreeze(ExpirationState.UPDATEABLE),
        Protect(ExpirationState.FROZEN),
        Update(ExpirationState.UPDATEABLE),
        Skip(ExpirationState.FROZEN);

        final ExpirationState expirationState;

        private ExpirationOperation(ExpirationState expirationState) {
            this.expirationState = expirationState;
        }

        static ExpirationOperation compute(StudyMgtContext ctx, Study study) {
            return ctx.getExpirationDate() == null ? Protect : (study.getExpirationState() == ExpirationState.FROZEN ? (ctx.isUnfreezeExpirationDate() ? Unfreeze : Skip) : (ctx.isFreezeExpirationDate() ? Freeze : Update));
        }
    }
}

