/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.store.scp;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.PDVInputStream;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.service.BasicCStoreSCP;
import org.dcm4che3.net.service.DicomService;
import org.dcm4che3.util.SafeClose;
import org.dcm4chee.arc.store.StoreContext;
import org.dcm4chee.arc.store.StoreService;
import org.dcm4chee.arc.store.StoreSession;

@ApplicationScoped
@Typed(value={DicomService.class})
class CStoreSCP
extends BasicCStoreSCP {
    @Inject
    private StoreService storeService;

    CStoreSCP() {
    }

    protected void store(Association as, PresentationContext pc, Attributes rq, PDVInputStream data, Attributes rsp) throws IOException {
        StoreSession session = this.getStoreSession(as);
        StoreContext ctx = this.newStoreContext(session, pc, rq);
        this.storeService.store(ctx, (InputStream)data);
    }

    private StoreContext newStoreContext(StoreSession session, PresentationContext pc, Attributes rq) {
        StoreContext ctx = this.storeService.newStoreContext(session);
        ctx.setReceiveTransferSyntax(pc.getTransferSyntax());
        ctx.setMoveOriginatorMessageID(rq.getInt(4145, 0));
        ctx.setMoveOriginatorAETitle(rq.getString(4144));
        return ctx;
    }

    private StoreSession getStoreSession(Association as) {
        StoreSession session = (StoreSession)as.getProperty(StoreSession.class);
        if (session == null) {
            session = this.storeService.newStoreSession(as);
            as.setProperty(StoreSession.class, (Object)session);
        }
        return session;
    }

    public void onClose(Association as) {
        SafeClose.close((Closeable)((Closeable)as.getProperty(StoreSession.class)));
    }
}

