/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.store.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipInputStream;
import javax.ejb.EJBException;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import org.dcm4che3.conf.api.ConfigurationChanges;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.DicomConfiguration;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.AttributesCoercion;
import org.dcm4che3.data.BulkData;
import org.dcm4che3.data.Fragments;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.MergeAttributesCoercion;
import org.dcm4che3.data.NullifyAttributesCoercion;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.TrimISO2020CharacterSetAttributesCoercion;
import org.dcm4che3.data.VR;
import org.dcm4che3.imageio.codec.ImageDescriptor;
import org.dcm4che3.imageio.codec.Transcoder;
import org.dcm4che3.imageio.codec.TransferSyntaxType;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.io.DicomOutputStream;
import org.dcm4che3.io.DicomStreamException;
import org.dcm4che3.io.SAXTransformer;
import org.dcm4che3.io.TemplatesCache;
import org.dcm4che3.io.XSLTAttributesCoercion;
import org.dcm4che3.json.JSONWriter;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.net.hl7.HL7Application;
import org.dcm4che3.net.hl7.UnparsedHL7Message;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.util.CountingInputStream;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.UIDUtils;
import org.dcm4chee.arc.Cache;
import org.dcm4chee.arc.LeadingCFindSCPQueryCache;
import org.dcm4chee.arc.MergeMWLCache;
import org.dcm4chee.arc.MergeMWLQueryParam;
import org.dcm4chee.arc.coerce.CoercionFactory;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveAttributeCoercion;
import org.dcm4chee.arc.conf.ArchiveAttributeCoercion2;
import org.dcm4chee.arc.conf.ArchiveCompressionRule;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.MergeMWLMatchingKey;
import org.dcm4chee.arc.conf.SPSStatus;
import org.dcm4chee.arc.conf.StorageDescriptor;
import org.dcm4chee.arc.conf.UseCallingAETitleAsCoercion;
import org.dcm4chee.arc.entity.Instance;
import org.dcm4chee.arc.entity.Location;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.event.SoftwareConfiguration;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.metrics.MetricsService;
import org.dcm4chee.arc.mima.SupplementAssigningAuthorities;
import org.dcm4chee.arc.patient.PatientService;
import org.dcm4chee.arc.query.QueryService;
import org.dcm4chee.arc.query.scu.CFindSCU;
import org.dcm4chee.arc.query.scu.CFindSCUAttributeCoercion;
import org.dcm4chee.arc.storage.ReadContext;
import org.dcm4chee.arc.storage.Storage;
import org.dcm4chee.arc.storage.StorageException;
import org.dcm4chee.arc.storage.StorageFactory;
import org.dcm4chee.arc.storage.WriteContext;
import org.dcm4chee.arc.store.InstanceLocations;
import org.dcm4chee.arc.store.StoreContext;
import org.dcm4chee.arc.store.StoreService;
import org.dcm4chee.arc.store.StoreSession;
import org.dcm4chee.arc.store.UpdateLocation;
import org.dcm4chee.arc.store.impl.StoreContextImpl;
import org.dcm4chee.arc.store.impl.StoreServiceEJB;
import org.dcm4chee.arc.store.impl.StoreSessionImpl;
import org.dcm4chee.arc.store.impl.UpdateDBResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@ApplicationScoped
class StoreServiceImpl
implements StoreService {
    static final Logger LOG = LoggerFactory.getLogger(StoreServiceImpl.class);
    static final int DIFF_STUDY_INSTANCE_UID = 50185;
    static final int FAILED_TO_PARSE_DICOM_STREAM = 50329;
    @Inject
    private DicomConfiguration conf;
    @Inject
    private StorageFactory storageFactory;
    @Inject
    private StoreServiceEJB ejb;
    @Inject
    private PatientService patientService;
    @Inject
    private QueryService queryService;
    @Inject
    private Event<StoreContext> storeEvent;
    @Inject
    private Event<SoftwareConfiguration> softwareConfigurationEvent;
    @Inject
    private MergeMWLCache mergeMWLCache;
    @Inject
    private MetricsService metricsService;
    @Inject
    private CFindSCU cfindscu;
    @Inject
    private Device device;
    @Inject
    private LeadingCFindSCPQueryCache leadingCFindSCPQueryCache;
    @Inject
    private CoercionFactory coercionFactory;

    StoreServiceImpl() {
    }

    @Override
    public StoreSession newStoreSession(Association as) {
        StoreSessionImpl session = new StoreSessionImpl(this);
        session.setAssociation(as);
        return session;
    }

    @Override
    public StoreSession newStoreSession(HttpServletRequestInfo httpRequest, ApplicationEntity ae, String aet, String sourceAET) {
        StoreSessionImpl session = new StoreSessionImpl(this);
        session.setHttpRequest(httpRequest);
        session.setApplicationEntity(ae);
        session.setCalledAET(aet);
        session.setCallingAET(sourceAET);
        return session;
    }

    @Override
    public StoreSession newStoreSession(ApplicationEntity ae) {
        StoreSessionImpl session = new StoreSessionImpl(this);
        session.setApplicationEntity(ae);
        return session;
    }

    @Override
    public StoreSession newStoreSession(HL7Application hl7App, Socket socket, UnparsedHL7Message msg, ApplicationEntity ae) {
        StoreSessionImpl session = new StoreSessionImpl(this);
        session.setApplicationEntity(ae);
        session.setSocket(socket);
        session.setMsg(msg);
        session.setHL7Application(hl7App);
        return session;
    }

    @Override
    public StoreContext newStoreContext(StoreSession session) {
        return new StoreContextImpl(session);
    }

    @Override
    public void store(StoreContext ctx, InputStream data) throws IOException {
        this.store(ctx, data, attrs -> {});
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void store(StoreContext ctx, InputStream data, Consumer<Attributes> coerce) throws IOException {
        UpdateDBResult result = null;
        try {
            CountingInputStream countingInputStream = new CountingInputStream(data);
            long startTime = System.nanoTime();
            this.writeToStorage(ctx, (InputStream)countingInputStream);
            coerce.accept(ctx.getAttributes());
            String callingAET = ctx.getStoreSession().getCallingAET();
            if (callingAET != null) {
                this.metricsService.acceptDataRate("receive-from-" + callingAET, countingInputStream.getCount(), startTime);
            }
            if (ctx.getAcceptedStudyInstanceUID() != null && !ctx.getAcceptedStudyInstanceUID().equals(ctx.getStudyInstanceUID())) {
                LOG.info("{}: Received Instance[studyUID={},seriesUID={},objectUID={}] does not match requested studyUID={}", new Object[]{ctx.getStoreSession(), ctx.getStudyInstanceUID(), ctx.getSeriesInstanceUID(), ctx.getSopInstanceUID(), ctx.getAcceptedStudyInstanceUID()});
                throw new DicomServiceException(50185);
            }
            this.supplementDefaultCharacterSet(ctx);
            this.storeMetadata(ctx);
            this.coerceAttributes(ctx);
            result = this.updateDB(ctx);
            this.postUpdateDB(ctx, result);
        }
        catch (DicomServiceException e) {
            try {
                ctx.setException((Exception)((Object)e));
                throw e;
                catch (Exception e2) {
                    LOG.info("{}: Unexpected Exception: ", (Object)ctx.getStoreSession(), (Object)e2);
                    DicomServiceException dse = new DicomServiceException(272, (Throwable)e2);
                    ctx.setException((Exception)((Object)dse));
                    throw dse;
                }
            }
            catch (Throwable throwable) {
                StoreServiceImpl.revokeStorage(ctx, result);
                this.fireStoreEvent(ctx);
                throw throwable;
            }
        }
        StoreServiceImpl.revokeStorage(ctx, result);
        this.fireStoreEvent(ctx);
    }

    private void writeToStorage(StoreContext ctx, InputStream data) throws DicomServiceException {
        String receiveTranferSyntax = ctx.getReceiveTranferSyntax();
        ArchiveAEExtension arcAE = ctx.getStoreSession().getArchiveAEExtension();
        ArchiveDeviceExtension arcDev = arcAE.getArchiveDeviceExtension();
        try (Transcoder transcoder = receiveTranferSyntax != null ? new Transcoder(data, receiveTranferSyntax) : new Transcoder(data);){
            ctx.setReceiveTransferSyntax(transcoder.getSourceTransferSyntax());
            transcoder.setIncludeBulkData(DicomInputStream.IncludeBulkData.URI);
            transcoder.setBulkDataDescriptor(arcAE.getBulkDataDescriptor());
            transcoder.setPixelDataBulkDataURI("");
            transcoder.setConcatenateBulkDataFiles(true);
            transcoder.setBulkDataDirectory(arcAE.getBulkDataSpoolDirectoryFile());
            transcoder.setIncludeFileMetaInformation(true);
            transcoder.setIncludeImplementationVersionName(arcDev.isStoreImplementationVersionName());
            transcoder.setDeleteBulkDataFiles(true);
            transcoder.transcode((Transcoder.Handler)new TranscoderHandler(ctx));
        }
        catch (StorageException e) {
            LOG.warn("{}: Failed to store received object:\n", (Object)ctx.getStoreSession(), (Object)e);
            throw new DicomServiceException(42752, (Throwable)e);
        }
        catch (DicomStreamException e) {
            LOG.warn("{}: Failed to parse received object:\n", (Object)ctx.getStoreSession(), (Object)e);
            throw new DicomServiceException(50329, (Throwable)e);
        }
        catch (Throwable e) {
            LOG.warn("{}: Failed to store received object:\n", (Object)ctx.getStoreSession(), (Object)e);
            throw new DicomServiceException(272, e);
        }
    }

    private UpdateDBResult updateDB(StoreContext ctx) throws DicomServiceException {
        StoreSession session = ctx.getStoreSession();
        ArchiveAEExtension arcAE = session.getArchiveAEExtension();
        ArchiveDeviceExtension arcDev = arcAE.getArchiveDeviceExtension();
        int retries = arcDev.getStoreUpdateDBMaxRetries();
        while (true) {
            try {
                UpdateDBResult result = new UpdateDBResult(ctx);
                long start = System.currentTimeMillis();
                this.ejb.updateDB(ctx, result);
                long time = System.currentTimeMillis() - start;
                LOG.info("{}: Updated DB in {} ms", (Object)session, (Object)time);
                this.metricsService.accept("db-update-on-store", (double)time);
                return result;
            }
            catch (EJBException e) {
                session.invalidateCachedStudyAndSeries();
                if (retries-- <= 0) {
                    LOG.warn("{}: Failed to update DB:\n", (Object)session, (Object)e);
                    throw e;
                }
                LOG.info("{}: Failed to update DB caused by {} - retry", (Object)session, (Object)DicomServiceException.initialCauseOf((Throwable)e).toString());
                LOG.debug("{}: Failed to update DB - retry:\n", (Object)session, (Object)e);
                try {
                    Thread.sleep(arcDev.storeUpdateDBRetryDelay());
                    continue;
                }
                catch (InterruptedException e2) {
                    LOG.info("{}: Failed to delay retry to update DB:\n", (Object)session, (Object)e2);
                    continue;
                }
            }
            break;
        }
    }

    private void postUpdateDB(StoreContext ctx, UpdateDBResult result) throws IOException {
        StoreSession storeSession = ctx.getStoreSession();
        LOG.debug("{}: Enter postUpdateDB", (Object)storeSession);
        Instance instance = result.getCreatedInstance();
        if (instance != null) {
            IDWithIssuer pid;
            Patient createdPatient = result.getCreatedPatient();
            if (createdPatient != null && (pid = IDWithIssuer.pidOf((Attributes)ctx.getAttributes())) != null) {
                try {
                    if (this.patientService.deleteDuplicateCreatedPatient(pid, createdPatient, result.getCreatedStudy())) {
                        result.setCreatedPatient(null);
                    }
                }
                catch (Exception e) {
                    LOG.warn("{}: Failed to remove duplicate created {}:\n", new Object[]{storeSession, createdPatient, e});
                }
            }
            storeSession.cacheSeries(instance.getSeries());
        }
        this.commitStorage(result);
        ctx.getLocations().clear();
        ctx.getLocations().addAll(result.getLocations());
        ctx.setRejectionNote(result.getRejectionNote());
        ctx.setRejectedInstance(result.getRejectedInstance());
        ctx.setPreviousInstance(result.getPreviousInstance());
        ctx.setStoredInstance(result.getStoredInstance());
        ctx.setAttributes(result.getStoredAttributes());
        ctx.setCoercedAttributes(result.getCoercedAttributes());
        LOG.debug("{}: Leave postUpdateDB", (Object)storeSession);
        if (result.getException() != null) {
            throw result.getException();
        }
    }

    private void commitStorage(UpdateDBResult result) throws IOException {
        for (WriteContext writeContext : result.getWriteContexts()) {
            Storage storage = writeContext.getStorage();
            storage.commitStorage(writeContext);
        }
    }

    @Override
    public List<String> studyIUIDsByAccessionNo(String accNo) {
        return accNo != null ? this.ejb.studyIUIDsByAccessionNo(accNo) : Collections.emptyList();
    }

    @Override
    public void addLocation(StoreSession session, Long instancePk, Location location) {
        this.ejb.addLocation(session, instancePk, location);
    }

    @Override
    public void replaceLocation(StoreSession session, Long instancePk, Location newLocation, List<Location> replaceLocations) {
        this.ejb.replaceLocation(session, instancePk, newLocation, replaceLocations);
    }

    @Override
    public void compress(StoreContext ctx, InstanceLocations inst, InputStream data) throws IOException {
        this.writeToStorage(ctx, data);
        this.ejb.replaceLocation(ctx, inst);
    }

    @Override
    public void addStorageID(String studyIUID, String storageID) {
        this.ejb.addStorageID(studyIUID, storageID);
    }

    @Override
    public void scheduleMetadataUpdate(String studyIUID, String seriesIUID) {
        this.ejb.scheduleMetadataUpdate(studyIUID, seriesIUID);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void store(StoreContext ctx, Attributes attrs) throws IOException {
        ctx.setAttributes(attrs);
        List<Location> locations = ctx.getLocations();
        UpdateDBResult result = null;
        try {
            if (locations.isEmpty()) {
                try (DicomOutputStream dos = new DicomOutputStream(this.openOutputStream(ctx, Location.ObjectType.DICOM_FILE), "1.2.840.10008.1.2.1");){
                    dos.writeDataset(attrs.createFileMetaInformation(ctx.getStoreTranferSyntax()), attrs);
                }
                this.adjustPixelDataBulkData(attrs);
                this.supplementDefaultCharacterSet(ctx);
                this.storeMetadata(ctx);
                this.coerceAttributes(ctx);
            }
            result = this.updateDB(ctx);
            this.postUpdateDB(ctx, result);
        }
        catch (DicomServiceException e) {
            try {
                ctx.setException((Exception)((Object)e));
                throw e;
                catch (Exception e2) {
                    LOG.info("{}: Unexpected Exception:\n", (Object)ctx.getStoreSession(), (Object)e2);
                    DicomServiceException dse = new DicomServiceException(272, (Throwable)e2);
                    ctx.setException((Exception)((Object)dse));
                    throw dse;
                }
            }
            catch (Throwable throwable) {
                StoreServiceImpl.revokeStorage(ctx, result);
                this.fireStoreEvent(ctx);
                throw throwable;
            }
        }
        StoreServiceImpl.revokeStorage(ctx, result);
        this.fireStoreEvent(ctx);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void importInstanceOnStorage(StoreContext ctx, Attributes attrs, ReadContext readCtx) throws IOException {
        ctx.setAttributes(Objects.requireNonNull(attrs));
        ctx.setReadContext(Objects.requireNonNull(readCtx));
        UpdateDBResult result = null;
        try {
            this.adjustPixelDataBulkData(attrs);
            this.supplementDefaultCharacterSet(ctx);
            this.storeMetadata(ctx);
            this.coerceAttributes(ctx);
            result = this.updateDB(ctx);
            this.postUpdateDB(ctx, result);
        }
        catch (DicomServiceException e) {
            try {
                ctx.setException((Exception)((Object)e));
                throw e;
                catch (Exception e2) {
                    LOG.info("{}: Unexpected Exception:\n", (Object)ctx.getStoreSession(), (Object)e2);
                    DicomServiceException dse = new DicomServiceException(272, (Throwable)e2);
                    ctx.setException((Exception)((Object)dse));
                    throw dse;
                }
            }
            catch (Throwable throwable) {
                StoreServiceImpl.revokeStorage(ctx, result);
                this.fireStoreEvent(ctx);
                throw throwable;
            }
        }
        StoreServiceImpl.revokeStorage(ctx, result);
        this.fireStoreEvent(ctx);
    }

    public void fireStoreEvent(StoreContext ctx) throws DicomServiceException {
        try {
            LOG.debug("{}: Firing Store Event", (Object)ctx.getStoreSession());
            this.storeEvent.fire((Object)ctx);
            LOG.debug("{}: Fired Store Event", (Object)ctx.getStoreSession());
        }
        catch (RuntimeException e) {
            LOG.warn("{}: Firing Store Event throws Exception:\n", (Object)ctx.getStoreSession(), (Object)e);
            DicomServiceException dse = new DicomServiceException(272, (Throwable)e);
            ctx.setException((Exception)((Object)dse));
            throw dse;
        }
    }

    private void adjustPixelDataBulkData(Attributes attrs) {
        Object value = attrs.getValue(2145386512);
        if (value instanceof Fragments) {
            attrs.setValue(2145386512, VR.OB, (Object)new BulkData(null, "", false));
        }
    }

    @Override
    public Attributes copyInstances(StoreSession session, Collection<InstanceLocations> instances, Attributes coerceAttrs, Attributes.UpdatePolicy updatePolicy) throws Exception {
        Attributes result = new Attributes();
        if (instances != null) {
            Sequence refSOPSeq = result.newSequence(528793, 10);
            Sequence failedSOPSeq = result.newSequence(528792, 10);
            for (InstanceLocations il : instances) {
                Attributes attr = il.getAttributes();
                StoreContext ctx = this.newStoreContext(session);
                UIDUtils.remapUIDs((Attributes)attr, session.getUIDMap(), (Attributes)ctx.getCoercedAttributes());
                this.coerceAttrs(ctx, attr, coerceAttrs, updatePolicy);
                for (Location location : il.getLocations()) {
                    ctx.getLocations().add(location);
                    if (location.getObjectType() != Location.ObjectType.DICOM_FILE) continue;
                    ctx.setStoreTranferSyntax(location.getTransferSyntaxUID());
                }
                ctx.setRetrieveAETs(il.getRetrieveAETs());
                ctx.setAvailability(il.getAvailability());
                try {
                    this.store(ctx, attr);
                    this.populateResult(refSOPSeq, attr);
                }
                catch (DicomServiceException e) {
                    result.setString(528791, VR.US, Integer.toString(e.getStatus()));
                    attr.setString(524312, VR.UI, il.getSopInstanceUID());
                    this.populateResult(failedSOPSeq, attr);
                }
            }
        }
        return result;
    }

    private void coerceAttrs(StoreContext ctx, Attributes attrs, Attributes coerceAttrs, Attributes.UpdatePolicy updatePolicy) {
        if (coerceAttrs == null) {
            return;
        }
        StoreSession session = ctx.getStoreSession();
        ArchiveAEExtension arcAE = session.getArchiveAEExtension();
        ArchiveDeviceExtension arcDev = arcAE.getArchiveDeviceExtension();
        coerceAttrs = new Attributes(coerceAttrs);
        Attributes.unifyCharacterSets((Attributes[])new Attributes[]{attrs, coerceAttrs});
        attrs.update(updatePolicy, coerceAttrs, ctx.getCoercedAttributes());
    }

    private void populateResult(Sequence refSOPSeq, Attributes ilAttr) {
        Attributes refSOP = new Attributes(2);
        refSOP.setString(528720, VR.UI, ilAttr.getString(524310));
        refSOP.setString(528725, VR.UI, ilAttr.getString(524312));
        refSOPSeq.add(refSOP);
    }

    private void supplementDefaultCharacterSet(StoreContext ctx) {
        Attributes attrs = ctx.getAttributes();
        if (attrs.containsValue(524293)) {
            return;
        }
        StoreSession session = ctx.getStoreSession();
        String defaultCharacterSet = session.getArchiveAEExtension().defaultCharacterSet();
        if (defaultCharacterSet != null) {
            LOG.info("{}: No Specific Character Set (0008,0005) in received data set - supplement configured Default Character Set: {}", (Object)session, (Object)defaultCharacterSet);
            attrs.setString(524293, VR.CS, defaultCharacterSet);
        }
    }

    private void storeMetadata(StoreContext ctx) throws IOException {
        ArchiveAEExtension arcAE = ctx.getStoreSession().getArchiveAEExtension();
        if (arcAE.getMetadataStorageIDs().length > 0) {
            try (JsonGenerator gen = Json.createGenerator((OutputStream)this.openOutputStream(ctx, Location.ObjectType.METADATA));){
                JSONWriter jsonWriter = arcAE.encodeAsJSONNumber(new JSONWriter(gen));
                jsonWriter.setReplaceBulkDataURI("");
                jsonWriter.write(ctx.getAttributes());
            }
        }
    }

    private static void revokeStorage(StoreContext ctx, UpdateDBResult result) {
        for (WriteContext writeCtx : ctx.getWriteContexts()) {
            if (result != null && result.getWriteContexts().contains(writeCtx) || writeCtx.getStoragePath() == null) continue;
            Storage storage = writeCtx.getStorage();
            try {
                storage.revokeStorage(writeCtx);
            }
            catch (Exception e) {
                LOG.warn("Failed to revoke storage", (Throwable)e);
            }
        }
    }

    private void coerceAttributes(StoreContext ctx) throws Exception {
        block8: {
            List coercions;
            StoreSession session;
            block7: {
                session = ctx.getStoreSession();
                coercions = session.getArchiveAEExtension().attributeCoercions2().filter(descriptor -> descriptor.match(TransferCapability.Role.SCU, Dimse.C_STORE_RQ, ctx.getSopClassUID(), session.getRemoteHostName(), session.getCallingAET(), session.getLocalHostName(), session.getCalledAET(), ctx.getAttributes())).collect(Collectors.toList());
                if (!coercions.isEmpty()) break block7;
                ArchiveAttributeCoercion rule = session.getArchiveAEExtension().findAttributeCoercion(Dimse.C_STORE_RQ, TransferCapability.Role.SCU, ctx.getSopClassUID(), session.getRemoteHostName(), session.getCallingAET(), session.getLocalHostName(), session.getCalledAET(), ctx.getAttributes());
                if (rule == null) break block8;
                this.coerceLegacy(ctx, session, rule);
                break block8;
            }
            block6: for (ArchiveAttributeCoercion2 coercion : coercions) {
                try {
                    if (!this.coercionFactory.getCoercionProcessor(coercion).coerce(coercion, ctx.getSopClassUID(), session.getRemoteHostName(), session.getCallingAET(), session.getLocalHostName(), session.getCalledAET(), ctx.getAttributes(), ctx.getCoercedAttributes()) || !coercion.isCoercionSufficient()) continue;
                }
                catch (Exception e) {
                    LOG.info("{}: Failed to apply {}:\n", new Object[]{session, coercion, e});
                    switch (coercion.getCoercionOnFailure()) {
                        case RETHROW: {
                            throw e;
                        }
                        case CONTINUE: {
                            continue block6;
                        }
                    }
                }
                break;
            }
        }
    }

    private void coerceLegacy(StoreContext ctx, StoreSession session, ArchiveAttributeCoercion rule) throws Exception {
        AttributesCoercion coercion = null;
        coercion = this.coerceAttributesByXSL(ctx, rule, coercion);
        coercion = this.mergeAttributesFromMWL(ctx, rule, coercion);
        coercion = SupplementAssigningAuthorities.forInstance((Device)rule.getSupplementFromDevice(), (AttributesCoercion)coercion);
        coercion = rule.supplementIssuerOfPatientID(coercion);
        coercion = rule.nullifyIssuerOfPatientID(ctx.getAttributes(), coercion);
        coercion = rule.mergeAttributes(coercion);
        coercion = NullifyAttributesCoercion.valueOf((int[])rule.getNullifyTags(), (AttributesCoercion)coercion);
        if (rule.isTrimISO2022CharacterSet()) {
            coercion = new TrimISO2020CharacterSetAttributesCoercion(coercion);
        }
        coercion = UseCallingAETitleAsCoercion.of((UseCallingAETitleAsCoercion.Type)rule.getUseCallingAETitleAs(), (String)session.getCallingAET(), (AttributesCoercion)coercion);
        String leadingCFindSCP = rule.getLeadingCFindSCP();
        if (leadingCFindSCP != null) {
            coercion = new CFindSCUAttributeCoercion(session.getLocalApplicationEntity(), leadingCFindSCP, rule.getAttributeUpdatePolicy(), this.cfindscu, this.leadingCFindSCPQueryCache, coercion);
        }
        if (coercion != null) {
            coercion.coerce(ctx.getAttributes(), ctx.getCoercedAttributes());
        }
    }

    private AttributesCoercion coerceAttributesByXSL(StoreContext ctx, ArchiveAttributeCoercion rule, AttributesCoercion next) {
        String xsltStylesheetURI = rule.getXSLTStylesheetURI();
        if (xsltStylesheetURI != null) {
            try {
                Templates tpls = TemplatesCache.getDefault().get(StringUtils.replaceSystemProperties((String)xsltStylesheetURI));
                LOG.info("Coerce Attributes from rule: {}", (Object)rule);
                return new XSLTAttributesCoercion(tpls, null).includeKeyword(!rule.isNoKeywords()).setupTransformer(this.setupTransformer(ctx.getStoreSession()));
            }
            catch (TransformerConfigurationException e) {
                LOG.error("{}: Failed to compile XSL: {}", new Object[]{ctx.getStoreSession(), xsltStylesheetURI, e});
            }
        }
        return next;
    }

    private SAXTransformer.SetupTransformer setupTransformer(StoreSession session) {
        return t -> {
            t.setParameter("LocalAET", session.getCalledAET());
            if (session.getCallingAET() != null) {
                t.setParameter("RemoteAET", session.getCallingAET());
            }
            if (session.getRemoteHostName() != null) {
                t.setParameter("RemoteHost", session.getRemoteHostName());
            }
        };
    }

    private AttributesCoercion mergeAttributesFromMWL(StoreContext ctx, ArchiveAttributeCoercion rule, AttributesCoercion next) {
        Attributes requestAttrs = this.queryMWL(ctx, rule);
        if (requestAttrs == null) {
            return next;
        }
        LOG.info("{}: Coerce Request Attributes from matching MWL item(s) using rule: {}", (Object)ctx.getStoreSession(), (Object)rule);
        return new MergeAttributesCoercion(requestAttrs, next);
    }

    private Attributes queryMWL(StoreContext ctx, ArchiveAttributeCoercion rule) {
        List<Attributes> mwlItems;
        MergeMWLMatchingKey mergeMWLMatchingKey = rule.getMergeMWLMatchingKey();
        String tplURI = rule.getMergeMWLTemplateURI();
        if (mergeMWLMatchingKey == null || tplURI == null) {
            return null;
        }
        MergeMWLQueryParam queryParam = MergeMWLQueryParam.valueOf((String)rule.getMergeMWLSCP(), (String[])rule.getMergeLocalMWLWorklistLabels(), (SPSStatus[])rule.getMergeLocalMWLWithStatus(), (MergeMWLMatchingKey)mergeMWLMatchingKey, (Attributes)ctx.getAttributes(), (String)tplURI);
        Cache.Entry entry = this.mergeMWLCache.getEntry((Object)queryParam);
        if (entry != null) {
            return (Attributes)entry.value();
        }
        if (queryParam.mwlSCP == null) {
            mwlItems = this.queryService.queryMWL(queryParam);
        } else {
            try {
                mwlItems = this.findMWL(ctx, queryParam, rule.isFilterBySCU());
            }
            catch (Exception e) {
                LOG.warn("{}: Failed to query MWL: {}", new Object[]{ctx.getStoreSession(), queryParam.mwlSCP, e});
                return null;
            }
        }
        if (mwlItems == null) {
            this.mergeMWLCache.put((Object)queryParam, null);
            return null;
        }
        Attributes result = null;
        Sequence reqAttrsSeq = null;
        try {
            Templates tpls = TemplatesCache.getDefault().get(StringUtils.replaceSystemProperties((String)tplURI));
            Collections.sort(mwlItems, Comparator.comparing(StoreServiceImpl::startDateTime).reversed());
            for (Attributes mwlItem : mwlItems) {
                Attributes attrs = SAXTransformer.transform((Attributes)mwlItem, (Templates)tpls, (boolean)false, (boolean)rule.isNoKeywords());
                if (reqAttrsSeq == null) {
                    result = attrs;
                    reqAttrsSeq = attrs.getSequence(4194933);
                    continue;
                }
                reqAttrsSeq.add(new Attributes(attrs.getNestedDataset(4194933)));
            }
        }
        catch (TransformerConfigurationException tce) {
            LOG.error("{}: Failed to compile XSL: {}", new Object[]{ctx.getStoreSession(), tplURI, tce});
        }
        catch (SAXException e) {
            LOG.error("{}: Failed to apply XSL: {}", new Object[]{ctx.getStoreSession(), tplURI, e});
        }
        this.mergeMWLCache.put((Object)queryParam, result);
        return result;
    }

    private static Date startDateTime(Attributes mwlItem) {
        Date date;
        Attributes item = mwlItem.getNestedDataset(0x400100);
        return item != null && (date = item.getDate(18014407103610883L)) != null ? date : new Date(0L);
    }

    private List<Attributes> findMWL(StoreContext ctx, MergeMWLQueryParam queryParam, boolean filterbyscu) throws Exception {
        StoreSession session = ctx.getStoreSession();
        LOG.info("{}: Query for MWL Items with {}", (Object)session, (Object)queryParam);
        List matches = this.cfindscu.findMWLItems(session.getLocalApplicationEntity(), queryParam, 0);
        if (filterbyscu) {
            matches.removeIf(item -> !item.matches(queryParam.setMatchingKeys(new Attributes()), false, false));
        }
        if (matches.isEmpty()) {
            LOG.info("{}: No matching MWL Items found", (Object)ctx.getStoreSession());
            return null;
        }
        LOG.info("{}: Found {} matching MWL Items", (Object)ctx.getStoreSession(), (Object)matches.size());
        return matches;
    }

    private OutputStream openOutputStream(StoreContext storeContext, Location.ObjectType objectType) throws IOException {
        StoreSession session = storeContext.getStoreSession();
        Storage storage = objectType == Location.ObjectType.DICOM_FILE ? this.selectObjectStorage(session) : this.selectMetadataStorage(session);
        WriteContext writeCtx = storage.createWriteContext(storeContext.getAttributes());
        writeCtx.setStudyInstanceUID(storeContext.getStudyInstanceUID());
        writeCtx.setMessageDigest(storage.getStorageDescriptor().getMessageDigest());
        storeContext.setWriteContext(objectType, writeCtx);
        return storage.openOutputStream(writeCtx);
    }

    private Storage selectObjectStorage(StoreSession session) throws IOException {
        if (session.getObjectStorageID() != null) {
            return session.getStorage(session.getObjectStorageID(), this.storageFactory);
        }
        ArchiveAEExtension arcAE = session.getArchiveAEExtension();
        ArchiveDeviceExtension arcDev = arcAE.getArchiveDeviceExtension();
        String[] storageIDs = arcAE.getObjectStorageIDs();
        List freeStorages = arcDev.getFreeStorageDescriptors(storageIDs);
        List fullStorages = arcDev.getFullStorageDescriptors(storageIDs);
        int storageCount = Math.min(arcAE.getObjectStorageCount(), freeStorages.size());
        if (storageCount > 1) {
            int index = session.getSerialNo() % storageCount;
            freeStorages.add(0, (StorageDescriptor)freeStorages.remove(index));
        }
        StorageFactory.UsableStorage usableStorage = this.storageFactory.getUsableStorage(freeStorages, fullStorages);
        String storageID = usableStorage.storage.getStorageDescriptor().getStorageID();
        session.putStorage(storageID, usableStorage.storage);
        session.withObjectStorageID(storageID);
        if (usableStorage.updateStorageIDs != null) {
            arcAE.setObjectStorageIDs(usableStorage.updateStorageIDs);
            this.updateDeviceConfiguration(arcDev);
        }
        return usableStorage.storage;
    }

    private void updateDeviceConfiguration(ArchiveDeviceExtension arcDev) {
        Device device = arcDev.getDevice();
        try {
            LOG.info("Update Storage configuration of Device: {}", (Object)device.getDeviceName());
            ConfigurationChanges diffs = this.conf.merge(device, EnumSet.of(DicomConfiguration.Option.PRESERVE_VENDOR_DATA, DicomConfiguration.Option.PRESERVE_CERTIFICATE, arcDev.isAuditSoftwareConfigurationVerbose() ? DicomConfiguration.Option.CONFIGURATION_CHANGES_VERBOSE : DicomConfiguration.Option.CONFIGURATION_CHANGES));
            this.softwareConfigurationEvent.fire((Object)new SoftwareConfiguration(null, device.getDeviceName(), diffs));
        }
        catch (ConfigurationException e) {
            LOG.warn("Failed to update Storage configuration of Device: {}:\n", (Object)device.getDeviceName(), (Object)e);
        }
    }

    private Storage selectMetadataStorage(StoreSession session) throws IOException {
        if (session.getMetadataStorageID() != null) {
            return session.getStorage(session.getMetadataStorageID(), this.storageFactory);
        }
        ArchiveAEExtension arcAE = session.getArchiveAEExtension();
        ArchiveDeviceExtension arcDev = arcAE.getArchiveDeviceExtension();
        String[] storageIDs = arcAE.getMetadataStorageIDs();
        List freeStorages = arcDev.getFreeStorageDescriptors(storageIDs);
        List fullStorages = arcDev.getFullStorageDescriptors(storageIDs);
        StorageFactory.UsableStorage usableStorage = this.storageFactory.getUsableStorage(freeStorages, fullStorages);
        String storageID = usableStorage.storage.getStorageDescriptor().getStorageID();
        session.putStorage(storageID, usableStorage.storage);
        session.setMetadataStorageID(storageID);
        if (usableStorage.updateStorageIDs != null) {
            arcAE.setMetadataStorageIDs(usableStorage.updateStorageIDs);
            this.updateDeviceConfiguration(arcDev);
        }
        return usableStorage.storage;
    }

    @Override
    public ZipInputStream openZipInputStream(StoreSession session, String storageID, String storagePath, String studyUID) throws IOException {
        Storage storage = session.getStorage(storageID, this.storageFactory);
        ReadContext readContext = storage.createReadContext();
        readContext.setStoragePath(storagePath);
        readContext.setStudyInstanceUID(studyUID);
        return new ZipInputStream(storage.openInputStream(readContext));
    }

    @Override
    public List<Instance> restoreInstances(StoreSession session, String studyUID, String seriesUID, Duration duration) throws IOException {
        return this.ejb.restoreInstances(session, studyUID, seriesUID, duration);
    }

    private ArchiveCompressionRule selectCompressionRule(Transcoder transcoder, StoreContext storeContext) {
        ImageDescriptor imageDescriptor = transcoder.getImageDescriptor();
        if (imageDescriptor == null) {
            return null;
        }
        if (transcoder.getSourceTransferSyntaxType() != TransferSyntaxType.NATIVE) {
            return null;
        }
        StoreSession session = storeContext.getStoreSession();
        Optional<ArchiveCompressionRule> matchingRule = session.getArchiveAEExtension().compressionRules().filter(rule -> rule.match(session.getRemoteHostName(), session.getCallingAET(), session.getLocalHostName(), session.getCalledAET(), storeContext.getAttributes())).findFirst();
        if (matchingRule.isPresent()) {
            if (!imageDescriptor.isMultiframeWithEmbeddedOverlays()) {
                return matchingRule.get();
            }
            LOG.info("Compression of multi-frame image with embedded overlays not supported");
        }
        return null;
    }

    @Override
    public void updateLocations(ArchiveAEExtension arcAE, List<UpdateLocation> updateLocations) {
        Map<String, Map<String, List<UpdateLocation>>> updateLocationsByStudyAndSeriesIUID = updateLocations.stream().collect(Collectors.groupingBy(x -> x.instanceLocation.getAttributes().getString(0x20000D), Collectors.groupingBy(x -> x.instanceLocation.getAttributes().getString(0x20000E))));
        updateLocationsByStudyAndSeriesIUID.forEach((studyIUID, seriesMap) -> seriesMap.forEach((seriesIUID, updateLocationsOfSeries) -> this.updateLocationsOfSeries(arcAE, (String)studyIUID, (String)seriesIUID, (List<UpdateLocation>)updateLocationsOfSeries)));
    }

    private void updateLocationsOfSeries(ArchiveAEExtension arcAE, String studyIUID, String seriesIUID, List<UpdateLocation> updateLocationsOfSeries) {
        boolean instancesPurged;
        boolean bl = instancesPurged = updateLocationsOfSeries.get((int)0).location.getPk() == 0L;
        if (instancesPurged) {
            try {
                this.restoreInstances(arcAE, studyIUID, seriesIUID, updateLocationsOfSeries);
                instancesPurged = false;
            }
            catch (Exception e) {
                LOG.warn("Failed to restore Instance records of Series[uid={}] of Study[uid={}] - cannot update Location records\n", new Object[]{seriesIUID, studyIUID, e});
            }
        }
        if (!instancesPurged) {
            for (UpdateLocation updateLocation : updateLocationsOfSeries) {
                if (updateLocation.newStatus != null) {
                    LOG.debug("Update status of {} of Instance[uid={}] of Study[uid={}] to {}", new Object[]{updateLocation.location, updateLocation.instanceLocation.getSopInstanceUID(), studyIUID, updateLocation.newStatus});
                    this.ejb.setStatus(updateLocation.location.getPk(), updateLocation.newStatus);
                    continue;
                }
                LOG.debug("Set missing digest of {} of Instance[uid={}] of Study[uid={}]", new Object[]{updateLocation.location, updateLocation.instanceLocation.getSopInstanceUID(), studyIUID});
                this.ejb.setDigest(updateLocation.location.getPk(), updateLocation.newDigest);
            }
            this.scheduleMetadataUpdate(studyIUID, seriesIUID);
        }
    }

    private void restoreInstances(ArchiveAEExtension arcAE, String studyIUID, String seriesIUID, List<UpdateLocation> updateLocations) throws IOException {
        List<Instance> instances = this.ejb.restoreInstances(this.newStoreSession(arcAE.getApplicationEntity()), studyIUID, seriesIUID, arcAE.getPurgeInstanceRecordsDelay());
        Map restoredLocations = instances.stream().flatMap(inst -> inst.getLocations().stream()).collect(Collectors.groupingBy(l -> l.getStorageID(), Collectors.toMap(l -> l.getStoragePath(), Function.identity())));
        Iterator<UpdateLocation> iter = updateLocations.iterator();
        while (iter.hasNext()) {
            UpdateLocation updateLocation = iter.next();
            Location l2 = updateLocation.location;
            updateLocation.location = (Location)restoredLocations.get(l2.getStorageID()).get(l2.getStoragePath());
            if (updateLocation.location != null) continue;
            LOG.warn("Failed to find {} record of Instance[uid={}] of Series[uid={}] of Study[uid={}] - cannot update Location record", new Object[]{l2, updateLocation.instanceLocation.getSopInstanceUID(), seriesIUID, studyIUID});
            iter.remove();
        }
    }

    private final class TranscoderHandler
    implements Transcoder.Handler {
        private final StoreContext storeContext;

        private TranscoderHandler(StoreContext storeContext) {
            this.storeContext = storeContext;
        }

        public OutputStream newOutputStream(Transcoder transcoder, Attributes dataset) throws IOException {
            this.storeContext.setAttributes(dataset);
            ArchiveCompressionRule compressionRule = this.storeContext.getCompressionRule();
            if (compressionRule == null) {
                compressionRule = StoreServiceImpl.this.selectCompressionRule(transcoder, this.storeContext);
                this.storeContext.setCompressionRule(compressionRule);
            }
            if (compressionRule != null && compressionRule.getDelay() == null) {
                transcoder.setDestinationTransferSyntax(compressionRule.getTransferSyntax());
                transcoder.setCompressParams(compressionRule.getImageWriteParams());
                this.storeContext.setStoreTranferSyntax(compressionRule.getTransferSyntax());
            }
            return StoreServiceImpl.this.openOutputStream(this.storeContext, Location.ObjectType.DICOM_FILE);
        }
    }
}

