/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.enterprise.concurrent.ManagedScheduledExecutorService;
import javax.inject.Inject;
import org.dcm4che3.net.Device;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Duration;
import org.slf4j.Logger;

public abstract class Scheduler
implements Runnable {
    @Inject
    protected Device device;
    private final Mode mode;
    private volatile long pollingIntervalInSeconds;
    private volatile ScheduledFuture<?> running;
    @Resource
    private ManagedScheduledExecutorService scheduledExecutor;

    protected Scheduler(Mode mode) {
        this.mode = mode;
    }

    @Override
    public void run() {
        this.log().info("start {}.execute()", (Object)this.getClass().getSimpleName());
        try {
            this.execute();
        }
        catch (Throwable e) {
            this.log().warn("{}.execute() throws:\n", (Object)this.getClass().getSimpleName(), (Object)e);
        }
        this.log().info("finished {}.execute()", (Object)this.getClass().getSimpleName());
    }

    public void start() {
        Duration pollingInterval = this.getPollingInterval();
        if (pollingInterval != null) {
            this.pollingIntervalInSeconds = pollingInterval.getSeconds();
            this.running = this.mode.schedule(this, this.getInitialDelay(), this.pollingIntervalInSeconds);
        }
    }

    public void stop() {
        if (this.running != null) {
            this.running.cancel(false);
            this.running = null;
            this.pollingIntervalInSeconds = 0L;
        }
    }

    public void reload() {
        Duration pollingInterval = this.getPollingInterval();
        if (pollingInterval == null || this.pollingIntervalInSeconds != pollingInterval.getSeconds()) {
            this.stop();
            this.start();
        }
    }

    protected abstract Duration getPollingInterval();

    protected abstract Logger log();

    protected abstract void execute();

    protected long getInitialDelay() {
        return ((ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class)).getSchedulerMinStartDelay() + ThreadLocalRandom.current().nextInt((int)this.pollingIntervalInSeconds);
    }

    public static enum Mode {
        scheduleWithFixedDelay{

            @Override
            public ScheduledFuture schedule(Scheduler scheduler, long initialDelay, long periodOrDelay) {
                return scheduler.scheduledExecutor.scheduleWithFixedDelay((Runnable)scheduler, initialDelay, periodOrDelay, TimeUnit.SECONDS);
            }
        }
        ,
        scheduleAtFixedRate{

            @Override
            public ScheduledFuture schedule(Scheduler scheduler, long initialDelay, long periodOrDelay) {
                return scheduler.scheduledExecutor.scheduleAtFixedRate((Runnable)scheduler, initialDelay, periodOrDelay, TimeUnit.SECONDS);
            }
        };


        public abstract ScheduledFuture schedule(Scheduler var1, long var2, long var4);
    }
}

