/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.query.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.json.Json;
import javax.persistence.EntityManager;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.json.JSONReader;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.util.SafeClose;
import org.dcm4chee.arc.code.CodeCache;
import org.dcm4chee.arc.conf.Availability;
import org.dcm4chee.arc.conf.Entity;
import org.dcm4chee.arc.conf.QueryRetrieveView;
import org.dcm4chee.arc.entity.AttributesBlob;
import org.dcm4chee.arc.entity.AttributesBlob_;
import org.dcm4chee.arc.entity.CodeEntity;
import org.dcm4chee.arc.entity.Instance;
import org.dcm4chee.arc.entity.Instance_;
import org.dcm4chee.arc.entity.Metadata_;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.entity.RejectedInstance;
import org.dcm4chee.arc.entity.Series;
import org.dcm4chee.arc.entity.Series_;
import org.dcm4chee.arc.entity.Study;
import org.dcm4chee.arc.entity.Study_;
import org.dcm4chee.arc.query.QueryContext;
import org.dcm4chee.arc.query.impl.AbstractQuery;

class InstanceQuery
extends AbstractQuery {
    private static final int[] ARCHIVE_INST_TAGS = new int[]{0x77770010, 2004291648, 2004291649, 2004291650, 2004291651, 2004291664, 2004291665, 2004291666, 2004291667, 2004291668, 2004291670, 2004291671};
    private final CodeCache codeCache;
    private Root<Instance> instance;
    private Join<Instance, Series> series;
    private Join<Series, Study> study;
    private Join<Study, Patient> patient;
    private Path<byte[]> instanceAttrBlob;
    private Long seriesPk;
    private Attributes seriesAttrs;
    private List<MetadataStoragePath> seriesMetadataStoragePaths;
    private ZipInputStream seriesMetadataStream;
    private Attributes nextMatchFromMetadata;
    private String[] sopInstanceUIDs;
    private int[] instTags;
    private Attributes instQueryKeys;
    private Map<String, CodeEntity> rejectedInstancesOfSeries;

    InstanceQuery(QueryContext context, EntityManager em, CodeCache codeCache) {
        super(context, em);
        this.codeCache = codeCache;
    }

    @Override
    protected CriteriaQuery<Tuple> multiselect() {
        CriteriaQuery q = this.cb.createTupleQuery();
        this.instance = q.from(Instance.class);
        this.series = this.instance.join(Instance_.series);
        this.study = this.series.join(Series_.study);
        this.patient = this.study.join(Study_.patient);
        Selection[] selectionArray = new Selection[8];
        selectionArray[0] = this.series.get(Series_.pk);
        selectionArray[1] = this.instance.get(Instance_.pk);
        selectionArray[2] = this.instance.get(Instance_.retrieveAETs);
        selectionArray[3] = this.instance.get(Instance_.externalRetrieveAET);
        selectionArray[4] = this.instance.get(Instance_.availability);
        selectionArray[5] = this.instance.get(Instance_.createdTime);
        selectionArray[6] = this.instance.get(Instance_.updatedTime);
        this.instanceAttrBlob = this.instance.join(Instance_.attributesBlob).get(AttributesBlob_.encodedAttributes);
        selectionArray[7] = this.instanceAttrBlob;
        return this.order(this.restrict(q, this.patient, this.study, this.series, this.instance)).multiselect(selectionArray);
    }

    @Override
    protected CriteriaQuery<Long> count() {
        CriteriaQuery q = this.cb.createQuery(Long.class);
        Root instance = q.from(Instance.class);
        Join series = instance.join(Instance_.series);
        Join study = series.join(Series_.study);
        Join patient = study.join(Study_.patient);
        return this.restrict(q, (Join<Study, Patient>)patient, (Join<Series, Study>)study, (Join<Instance, Series>)series, (Root<Instance>)instance).select((Selection)this.cb.count((Expression)instance));
    }

    @Override
    protected Attributes toAttributes(Tuple results) {
        Long seriesPk = (Long)results.get((TupleElement)this.series.get(Series_.pk));
        Availability availability = (Availability)results.get((TupleElement)this.instance.get(Instance_.availability));
        if (!seriesPk.equals(this.seriesPk)) {
            this.seriesAttrs = this.context.getQueryService().getSeriesAttributes(this.context, seriesPk);
            this.seriesPk = seriesPk;
            if (this.context.isReturnPrivate()) {
                this.rejectedInstancesOfSeries = this.getRejectedInstancesOfSeries(this.seriesAttrs);
            }
        }
        Attributes instAttrs = AttributesBlob.decodeAttributes((byte[])((byte[])results.get(this.instanceAttrBlob)), null);
        Attributes.unifyCharacterSets((Attributes[])new Attributes[]{this.seriesAttrs, instAttrs});
        Attributes attrs = new Attributes(this.seriesAttrs.size() + instAttrs.size() + 10);
        attrs.addAll(this.seriesAttrs);
        attrs.addAll(instAttrs, true);
        attrs.setString(524372, VR.AE, this.retrieveAETs((String)results.get((TupleElement)this.instance.get(Instance_.retrieveAETs)), (String)results.get((TupleElement)this.instance.get(Instance_.externalRetrieveAET))));
        attrs.setString(524374, VR.CS, availability.toString());
        if (!this.context.isReturnPrivate()) {
            return attrs;
        }
        InstanceQuery.setDTwTZ(attrs, 0x77770040, (Date)results.get((TupleElement)this.instance.get(Instance_.createdTime)));
        InstanceQuery.setDTwTZ(attrs, 2004287553, (Date)results.get((TupleElement)this.instance.get(Instance_.updatedTime)));
        this.addRejectionNoteCode(attrs, this.rejectedInstancesOfSeries.get(instAttrs.getString(524312)));
        this.context.getQueryService().addLocationAttributes(attrs, (Long)results.get((TupleElement)this.instance.get(Instance_.pk)));
        return attrs;
    }

    private Map<String, CodeEntity> getRejectedInstancesOfSeries(Attributes seriesAttrs) {
        return this.em.createNamedQuery("RejectedInstance.findBySeriesUID", RejectedInstance.class).setParameter(1, (Object)seriesAttrs.getString(0x20000D)).setParameter(2, (Object)seriesAttrs.getString(0x20000E)).getResultStream().collect(Collectors.toMap(RejectedInstance::getSopInstanceUID, RejectedInstance::getRejectionNoteCode));
    }

    private void addRejectionNoteCode(Attributes attrs, CodeEntity rejectionCode) {
        if (rejectionCode != null) {
            attrs.newSequence("DCM4CHEE Archive 5", 2004287554, 1).add(rejectionCode.getCode().toItem());
        }
    }

    @Override
    public boolean isOptionalKeysNotSupported() {
        return false;
    }

    @Override
    public boolean hasMoreMatches() throws DicomServiceException {
        if (this.nextMatchFromMetadata != null) {
            return true;
        }
        try {
            if (this.seriesMetadataStoragePaths == null) {
                boolean hasMoreMatches = super.hasMoreMatches();
                if (hasMoreMatches || !this.context.isConsiderPurgedInstances()) {
                    return hasMoreMatches;
                }
                this.seriesMetadataStoragePaths = this.queryMetadataStoragePath();
                if (!this.nextSeriesMetadataStream()) {
                    return false;
                }
                int[] tags = this.context.getArchiveAEExtension().getArchiveDeviceExtension().getAttributeFilter(Entity.Instance).getSelection(true);
                this.instTags = new int[tags.length + ARCHIVE_INST_TAGS.length];
                System.arraycopy(tags, 0, this.instTags, 0, tags.length);
                System.arraycopy(ARCHIVE_INST_TAGS, 0, this.instTags, tags.length, ARCHIVE_INST_TAGS.length);
                Attributes queryKeys = this.context.getQueryKeys();
                this.instQueryKeys = new Attributes(queryKeys, tags);
                this.sopInstanceUIDs = queryKeys.getStrings(524312);
            }
            this.nextMatchFromMetadata = this.nextMatchFromMetadata();
        }
        catch (IOException e) {
            throw new DicomServiceException(42753, (Throwable)e);
        }
        return this.nextMatchFromMetadata != null;
    }

    private CriteriaQuery<Tuple> order(CriteriaQuery<Tuple> q) {
        if (this.context.getOrderByTags() != null) {
            q = q.orderBy(this.builder.orderInstances(this.patient, this.study, this.series, this.instance, this.context.getOrderByTags()));
        }
        return q;
    }

    private <T> CriteriaQuery<T> restrict(CriteriaQuery<T> q, Join<Study, Patient> patient, Join<Series, Study> study, Join<Instance, Series> series, Root<Instance> instance) {
        List predicates = this.builder.instancePredicates(q, patient, study, series, instance, this.context.getPatientIDs(), this.context.getIssuerOfPatientID(), this.context.getQueryKeys(), this.context.getQueryParam(), this.codeCache.findOrCreateEntities(this.context.getQueryParam().getQueryRetrieveView().getShowInstancesRejectedByCodes()), this.codeCache.findOrCreateEntities(this.context.getQueryParam().getQueryRetrieveView().getHideRejectionNotesWithCodes()));
        if (!predicates.isEmpty()) {
            q.where(predicates.toArray(new Predicate[0]));
        }
        return q;
    }

    private List<MetadataStoragePath> queryMetadataStoragePath() {
        Attributes keys = this.context.getQueryKeys();
        String studyInstanceUID = keys.getString(0x20000D);
        String seriesInstanceUID = keys.getString(0x20000E);
        if (studyInstanceUID == null && seriesInstanceUID == null) {
            return Collections.emptyList();
        }
        CriteriaQuery q = this.cb.createTupleQuery();
        Root series = q.from(Series.class);
        Join metadata = series.join(Series_.metadata);
        Join study = series.join(Series_.study);
        Join patient = study.join(Study_.patient);
        TypedQuery query = this.em.createQuery(this.restrict((CriteriaQuery<Tuple>)q, (Join<Study, Patient>)patient, (Join<Series, Study>)study, (Root<Series>)series).multiselect(new Selection[]{series.get(Series_.pk), metadata.get(Metadata_.storageID), metadata.get(Metadata_.storagePath)}));
        try (Stream resultStream = query.getResultStream();){
            List<MetadataStoragePath> list = resultStream.map(t -> new MetadataStoragePath((Long)t.get((TupleElement)series.get(Series_.pk)), (String)t.get((TupleElement)metadata.get(Metadata_.storageID)), (String)t.get((TupleElement)metadata.get(Metadata_.storagePath)))).collect(Collectors.toList());
            return list;
        }
    }

    private CriteriaQuery<Tuple> restrict(CriteriaQuery<Tuple> q, Join<Study, Patient> patient, Join<Series, Study> study, Root<Series> series) {
        List predicates = this.builder.seriesPredicates(q, patient, study, series, this.context.getPatientIDs(), this.context.getIssuerOfPatientID(), this.context.getQueryKeys(), this.context.getQueryParam(), this.codeCache.findOrCreateEntities(this.context.getQueryParam().getQueryRetrieveView().getShowInstancesRejectedByCodes()));
        predicates.add(this.cb.equal((Expression)series.get(Series_.instancePurgeState), (Object)Series.InstancePurgeState.PURGED));
        return q.where(predicates.toArray(new Predicate[0]));
    }

    private boolean nextSeriesMetadataStream() throws IOException {
        SafeClose.close((Closeable)this.seriesMetadataStream);
        this.seriesMetadataStream = null;
        if (this.seriesMetadataStoragePaths.isEmpty()) {
            return false;
        }
        MetadataStoragePath metadataStoragePath = this.seriesMetadataStoragePaths.remove(0);
        this.seriesAttrs = this.context.getQueryService().getSeriesAttributes(this.context, metadataStoragePath.seriesPk);
        this.seriesMetadataStream = this.context.getQueryService().openZipInputStream(this.context, metadataStoragePath.storageID, metadataStoragePath.storagePath);
        return true;
    }

    private Attributes nextMatchFromMetadata() throws IOException {
        QueryRetrieveView qrView = this.context.getQueryParam().getQueryRetrieveView();
        while (true) {
            ZipEntry entry;
            if ((entry = this.seriesMetadataStream.getNextEntry()) != null) {
                if (this.matchSOPInstanceUID(entry.getName())) {
                    JSONReader jsonReader = new JSONReader(Json.createParser((Reader)new InputStreamReader((InputStream)this.seriesMetadataStream, StandardCharsets.UTF_8)));
                    jsonReader.setSkipBulkDataURI(true);
                    Attributes metadata = jsonReader.readDataset(null);
                    if (!qrView.hideRejectedInstance(metadata.getNestedDataset("DCM4CHEE Archive 5", 2004287554)) && !qrView.hideRejectionNote(metadata) && metadata.matches(this.instQueryKeys, false, false)) {
                        this.seriesMetadataStream.closeEntry();
                        Attributes instAtts = new Attributes(metadata, this.instTags);
                        Attributes.unifyCharacterSets((Attributes[])new Attributes[]{this.seriesAttrs, instAtts});
                        Attributes attrs = new Attributes(this.seriesAttrs.size() + instAtts.size());
                        attrs.addAll(this.seriesAttrs);
                        attrs.addAll(instAtts, true);
                        return attrs;
                    }
                }
                this.seriesMetadataStream.closeEntry();
                continue;
            }
            if (!this.nextSeriesMetadataStream()) break;
        }
        return null;
    }

    private boolean matchSOPInstanceUID(String iuid) {
        if (this.sopInstanceUIDs == null || this.sopInstanceUIDs.length == 0) {
            return true;
        }
        for (String sopInstanceUID : this.sopInstanceUIDs) {
            if (!sopInstanceUID.equals(iuid)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Attributes nextMatch() {
        if (this.seriesMetadataStoragePaths == null) {
            return super.nextMatch();
        }
        Attributes tmp = this.nextMatchFromMetadata;
        this.nextMatchFromMetadata = null;
        return tmp;
    }

    @Override
    public void close() {
        super.close();
        SafeClose.close((Closeable)this.seriesMetadataStream);
    }

    private static class MetadataStoragePath {
        final long seriesPk;
        final String storageID;
        final String storagePath;

        MetadataStoragePath(long seriesPk, String storageID, String storagePath) {
            this.seriesPk = seriesPk;
            this.storageID = storageID;
            this.storagePath = storagePath;
        }
    }
}

