/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.pdq.rs;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.WebApplication;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.PDQServiceDescriptor;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.dcm4chee.arc.patient.PatientMgtContext;
import org.dcm4chee.arc.patient.PatientService;
import org.dcm4chee.arc.pdq.PDQServiceContext;
import org.dcm4chee.arc.pdq.PDQServiceException;
import org.dcm4chee.arc.pdq.PDQServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="aets/{AETitle}/rs")
public class UpdatePatientDemographics {
    private static final Logger LOG = LoggerFactory.getLogger(UpdatePatientDemographics.class);
    private static final String SUPER_USER_ROLE = "super-user-role";
    @Context
    private HttpServletRequest request;
    @Inject
    private Device device;
    @Inject
    private PDQServiceFactory serviceFactory;
    @Inject
    private PatientService patientService;
    @PathParam(value="AETitle")
    private String aet;
    @QueryParam(value="adjustIssuerOfPatientID")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String adjustIssuerOfPatientID;

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    @POST
    @Path(value="/patients/{PatientID}/pdq/{PDQServiceID}")
    @Produces(value={"application/json"})
    public Response update(@PathParam(value="PDQServiceID") String pdqServiceID, @PathParam(value="PatientID") IDWithIssuer patientID) {
        this.logRequest();
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        ApplicationEntity ae = arcAE.getApplicationEntity();
        if (this.aet.equals(ae.getAETitle())) {
            this.validateWebAppServiceClass();
        }
        try {
            Attributes attrs;
            PDQServiceDescriptor descriptor = ((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getPDQServiceDescriptorNotNull(pdqServiceID);
            PatientMgtContext ctx = this.patientService.createPatientMgtContextWEB(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request));
            ctx.setArchiveAEExtension(arcAE);
            ctx.setPatientID(patientID);
            ctx.setPDQServiceURI(descriptor.getPDQServiceURI().toString());
            boolean adjustIssuerOfPatientID = this.adjustIssuerOfPatientID();
            try {
                PDQServiceContext pdqServiceCtx = new PDQServiceContext(adjustIssuerOfPatientID ? patientID.withoutIssuer() : patientID);
                pdqServiceCtx.setHttpServletRequestInfo(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request));
                pdqServiceCtx.setSearchMethod(PDQServiceContext.SearchMethod.UpdatePatientDemographics);
                attrs = this.serviceFactory.getPDQService(descriptor).query(pdqServiceCtx);
            }
            catch (PDQServiceException e) {
                ctx.setPatientVerificationStatus(Patient.VerificationStatus.VERIFICATION_FAILED);
                this.patientService.updatePatientStatus(ctx);
                return this.errResponseAsTextPlain(this.exceptionAsString((Exception)((Object)e)), Response.Status.BAD_GATEWAY);
            }
            if (attrs == null) {
                ctx.setPatientVerificationStatus(Patient.VerificationStatus.NOT_FOUND);
                this.patientService.updatePatientStatus(ctx);
                return Response.accepted().build();
            }
            ctx.setAttributes(attrs);
            ctx.setPatientVerificationStatus(Patient.VerificationStatus.VERIFIED);
            if (adjustIssuerOfPatientID && !ctx.getPatientID().equals((Object)patientID)) {
                ctx.setPreviousAttributes(patientID.exportPatientIDWithIssuer(null));
                this.patientService.changePatientID(ctx);
                LOG.info("Updated {} on verification against {}", (Object)patientID, (Object)descriptor);
            } else {
                this.patientService.updatePatient(ctx);
                LOG.info(ctx.getEventActionCode().equals("U") ? "Updated {} on verification against {}" : "Verified {} against {}", (Object)patientID, (Object)descriptor);
            }
            return this.rsp(ctx);
        }
        catch (IllegalArgumentException e) {
            return this.errResponse(e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Response rsp(PatientMgtContext ctx) {
        return Response.ok((Object)("{\"action\":\"" + ctx.getEventActionCode() + "\"}")).build();
    }

    private boolean adjustIssuerOfPatientID() {
        return "true".equals(this.adjustIssuerOfPatientID);
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private ArchiveAEExtension getArchiveAE() {
        ApplicationEntity ae = this.device.getApplicationEntity(this.aet, true);
        return ae == null || !ae.isInstalled() ? null : (ArchiveAEExtension)ae.getAEExtension(ArchiveAEExtension.class);
    }

    private Response errResponse(String msg, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private void validateAcceptedUserRoles(ArchiveAEExtension arcAE) {
        KeycloakContext keycloakContext = KeycloakContext.valueOf((HttpServletRequest)this.request);
        if (keycloakContext.isSecured() && !keycloakContext.isUserInRole(System.getProperty(SUPER_USER_ROLE)) && !arcAE.isAcceptedUserRole(keycloakContext.getRoles())) {
            throw new WebApplicationException("Application Entity " + arcAE.getApplicationEntity().getAETitle() + " does not list role of accessing user", Response.Status.FORBIDDEN);
        }
    }

    private void validateWebAppServiceClass() {
        this.device.getWebApplications().stream().filter(webApp -> this.request.getRequestURI().startsWith(webApp.getServicePath()) && Arrays.asList(webApp.getServiceClasses()).contains(WebApplication.ServiceClass.DCM4CHEE_ARC_AET)).findFirst().orElseThrow(() -> new WebApplicationException(this.errResponse("No Web Application with DCM4CHEE_ARC_AET service class found for Application Entity: " + this.aet, Response.Status.NOT_FOUND)));
    }
}

