/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.pdq.hl7;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import javax.enterprise.event.Event;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.hl7.IHL7ApplicationCache;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.hl7.ERRSegment;
import org.dcm4che3.hl7.HL7Exception;
import org.dcm4che3.hl7.HL7Message;
import org.dcm4che3.hl7.HL7Segment;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.hl7.HL7Application;
import org.dcm4che3.net.hl7.HL7DeviceExtension;
import org.dcm4che3.net.hl7.UnparsedHL7Message;
import org.dcm4chee.arc.conf.ArchiveHL7ApplicationExtension;
import org.dcm4chee.arc.conf.Entity;
import org.dcm4chee.arc.conf.PDQServiceDescriptor;
import org.dcm4chee.arc.hl7.HL7Sender;
import org.dcm4chee.arc.hl7.SAXTransformer;
import org.dcm4chee.arc.pdq.AbstractPDQService;
import org.dcm4chee.arc.pdq.PDQServiceContext;
import org.dcm4chee.arc.pdq.PDQServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HL7PDQService
extends AbstractPDQService {
    private static final Logger LOG = LoggerFactory.getLogger(HL7PDQService.class);
    private static final String HL7_ADT_2_DCM_XSL = "${jboss.server.temp.url}/dcm4chee-arc/hl7-adt2dcm.xsl";
    private final Device device;
    private final IHL7ApplicationCache hl7AppCache;
    private final HL7Sender hl7Sender;
    private final Event<PDQServiceContext> pdqEvent;
    private final String msh3456;

    public HL7PDQService(PDQServiceDescriptor descriptor, Device device, IHL7ApplicationCache hl7AppCache, HL7Sender hl7Sender, Event<PDQServiceContext> pdqEvent) {
        super(descriptor);
        this.device = device;
        this.hl7AppCache = hl7AppCache;
        this.hl7Sender = hl7Sender;
        this.pdqEvent = pdqEvent;
        this.msh3456 = descriptor.getPDQServiceURI().getSchemeSpecificPart();
    }

    public Attributes query(PDQServiceContext ctx) throws PDQServiceException {
        this.requireQueryEntity(Entity.Patient);
        String[] appFacility = this.msh3456.split(":");
        if (appFacility.length != 2) {
            throw new PDQServiceException("Sending and/or Receiving application and facility not specified in URI of " + this.descriptor);
        }
        HL7Application sender = this.sender(appFacility[0].replace('/', '|'));
        HL7Application receiver = this.receiver(appFacility[1].replace('/', '|'));
        ctx.setSendingAppFacility(sender.getApplicationName());
        ctx.setReceivingAppFacility(receiver.getApplicationName());
        Attributes demographics = this.query(ctx, sender, receiver);
        ctx.setPatientAttrs(demographics);
        this.pdqEvent.fire((Object)ctx);
        return demographics;
    }

    private String xslStylesheetURI() {
        return this.descriptor.getProperties().getOrDefault("XSLStylesheetURI", HL7_ADT_2_DCM_XSL);
    }

    private HL7Application sender(String sendingAppFacility) throws PDQServiceException {
        HL7Application sender = ((HL7DeviceExtension)this.device.getDeviceExtension(HL7DeviceExtension.class)).getHL7Application(sendingAppFacility, true);
        if (sender == null) {
            throw new PDQServiceException("Sending HL7 Application " + sendingAppFacility + " not configured; used in " + this.descriptor);
        }
        return sender;
    }

    private HL7Application receiver(String receivingAppFacility) throws PDQServiceException {
        try {
            return this.hl7AppCache.findHL7Application(receivingAppFacility);
        }
        catch (ConfigurationException e) {
            throw new PDQServiceException("Receiving HL7 Application " + receivingAppFacility + " not configured; used in " + this.descriptor);
        }
    }

    public Attributes query(PDQServiceContext ctx, HL7Application sender, HL7Application receiver) throws PDQServiceException {
        try {
            String[] queryParams = this.queryParams(ctx.getPatientID());
            HL7Message qbp = HL7Message.makePdqQuery((String[])queryParams, (String[])new String[0]);
            HL7Segment msh = (HL7Segment)qbp.get(0);
            msh.setSendingApplicationWithFacility(sender.getApplicationName());
            msh.setReceivingApplicationWithFacility(receiver.getApplicationName());
            msh.setField(17, sender.getHL7SendingCharacterSet());
            UnparsedHL7Message msg = new UnparsedHL7Message(qbp.getBytes(sender.getHL7SendingCharacterSet()));
            ctx.setHl7Msg(msg);
            ctx.setRsp(this.hl7Sender.sendMessage(sender, receiver, msg));
            return this.parseRsp(ctx.getRsp(), sender);
        }
        catch (Exception e) {
            throw new PDQServiceException((Throwable)e);
        }
    }

    private Attributes parseRsp(UnparsedHL7Message rsp, HL7Application sender) throws HL7Exception {
        HL7Message hl7RspMsg = HL7Message.parse((byte[])rsp.data(), (String)sender.getHL7DefaultCharacterSet());
        HL7Segment msa = hl7RspMsg.getSegment("MSA");
        if (msa == null) {
            throw new HL7Exception((HL7Segment)new ERRSegment(rsp.msh()).setUserMessage("Missing MSA segment in response message"));
        }
        String status = msa.getField(1, null);
        if (!status.equals("AA")) {
            LOG.info("Unsuccessful Patient Demographics Query using descriptor {} : \n{}", (Object)this.descriptor, (Object)hl7RspMsg);
            return null;
        }
        ArchiveHL7ApplicationExtension arcHL7App = (ArchiveHL7ApplicationExtension)sender.getHL7ApplicationExtension(ArchiveHL7ApplicationExtension.class);
        try {
            return SAXTransformer.transform((UnparsedHL7Message)rsp, (ArchiveHL7ApplicationExtension)arcHL7App, (String)this.xslStylesheetURI(), null);
        }
        catch (Exception e) {
            throw new HL7Exception((HL7Segment)new ERRSegment(rsp.msh()).setUserMessage(e.getMessage()), (Throwable)e);
        }
    }

    private String[] queryParams(IDWithIssuer pid) {
        ArrayList<CallSite> queryParams = new ArrayList<CallSite>();
        queryParams.add((CallSite)((Object)("@PID.3.1^" + pid.getID())));
        Issuer issuer = pid.getIssuer();
        if (issuer != null) {
            if (issuer.getLocalNamespaceEntityID() != null) {
                queryParams.add((CallSite)((Object)("@PID.3.4.1^" + issuer.getLocalNamespaceEntityID())));
            }
            if (issuer.getUniversalEntityID() != null) {
                queryParams.add((CallSite)((Object)("@PID.3.4.2^" + issuer.getUniversalEntityID())));
            }
            if (issuer.getUniversalEntityIDType() != null) {
                queryParams.add((CallSite)((Object)("@PID.3.4.3^" + issuer.getUniversalEntityIDType())));
            }
        }
        return queryParams.toArray(new String[0]);
    }
}

