/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.impax.report;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Code;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.VR;
import org.dcm4che3.io.ContentHandlerAdapter;
import org.dcm4che3.io.TemplatesCache;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.TagUtils;
import org.dcm4che3.util.UIDUtils;
import org.xml.sax.ContentHandler;

public class ImpaxReportConverter {
    private static final ElementDictionary dict = ElementDictionary.getStandardElementDictionary();
    private static final String DEFAULT_XSL = "${jboss.server.temp.url}/dcm4chee-arc/impax-report2sr.xsl";
    private static final String DEFAULT_DOC_TITLE = "(18748-4, LN, \"Diagnostic Imaging Report\")";
    private static final String DEFAULT_PAT_MISMATCH = "(IMPAXREP_PATDIFF, 99DCM4CHEE, \"Patient in IMPAX Report does not match Patient of Study in VNA\")";
    private static final String DEFAULT_LANGUAGE = "(en, RFC5646, \"English\")";
    private static final String DEFAULT_VERIFYING_ORGANIZATION = "N/A";
    private static final String NO_REPORT_PREFIX = "<?xml version=\"1.0\" encoding=\"utf-8\"?><agfa:DiagnosticRadiologyReport xmlns:agfa=\"http://www.agfa.com/hc\"><ReportDetails><ReportBody>";
    private static final String NO_REPORT_SUFFIX = "</ReportBody></ReportDetails></agfa:DiagnosticRadiologyReport>";
    private static final int[] TYPE2_TAGS = new int[]{524400, 528657, 0x200010, 4236146};
    private final String endpoint;
    private final Code languageCode;
    private final Code docTitleCode;
    private final Code noReportTitleCode;
    private final Code patientMismatchCode;
    private final String verifyingOrganization;
    private final String seriesIUID;
    private final Templates tpls;
    private final Attributes propsAttrs = new Attributes();
    private final Attributes studyAttrs;
    private int instanceNumber;

    public ImpaxReportConverter(Map<String, String> props, Attributes studyAttrs) throws Exception {
        this.endpoint = props.get(props.containsKey("wget") ? "wget" : "endpoint");
        this.languageCode = new Code(props.getOrDefault("Language", DEFAULT_LANGUAGE));
        this.docTitleCode = new Code(props.getOrDefault("DocumentTitle", DEFAULT_DOC_TITLE));
        this.patientMismatchCode = new Code(props.getOrDefault("PatientMismatch", DEFAULT_PAT_MISMATCH));
        this.noReportTitleCode = ImpaxReportConverter.codeOrNull(props.get("NoReportTitle"));
        this.verifyingOrganization = props.getOrDefault("VerifyingOrganization", DEFAULT_VERIFYING_ORGANIZATION);
        this.tpls = TemplatesCache.getDefault().get(StringUtils.replaceSystemProperties((String)props.getOrDefault("xsl", DEFAULT_XSL)));
        this.studyAttrs = studyAttrs;
        this.seriesIUID = UIDUtils.remapUID((String)studyAttrs.getString(0x20000D));
        for (Map.Entry<String, String> prop : props.entrySet()) {
            if (!prop.getKey().startsWith("SR.")) continue;
            int tag = TagUtils.forName((String)prop.getKey().substring(3));
            this.propsAttrs.setString(tag, dict.vrOf(tag), prop.getValue());
        }
    }

    private static Code codeOrNull(String s) {
        return s != null ? new Code(s) : null;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public Code patientMismatchOf(Attributes sr) {
        for (Attributes item : sr.getSequence(4237104)) {
            if (!"HAS OBS CONTEXT".equals(item.getString(4235280))) continue;
            switch (item.getNestedDataset(4235331).getString(524544)) {
                case "121029": 
                case "121030": 
                case "121031": 
                case "121032": {
                    return this.patientMismatchCode;
                }
            }
        }
        return null;
    }

    public List<Attributes> convert(List<String> xmlReports) throws Exception {
        if (xmlReports.isEmpty()) {
            return this.noReportTitleCode == null ? Collections.emptyList() : Collections.singletonList(this.convert(NO_REPORT_PREFIX + this.noReportTitleCode.getCodeMeaning() + NO_REPORT_SUFFIX, this.noReportTitleCode));
        }
        ArrayList<Attributes> srReports = new ArrayList<Attributes>(xmlReports.size());
        for (String xmlReport : xmlReports) {
            srReports.add(this.convert(xmlReport, this.docTitleCode));
        }
        return srReports;
    }

    private Attributes convert(String report, Code docTitleCode) throws Exception {
        Attributes attrs = new Attributes(64);
        attrs.addAll(this.studyAttrs);
        attrs.addAll(this.propsAttrs);
        attrs.setString(0x20000E, VR.UI, this.seriesIUID);
        attrs.setString(524312, VR.UI, this.seriesIUID + "." + ++this.instanceNumber);
        this.xslt(report, attrs, docTitleCode);
        if (!attrs.containsValue(524310)) {
            attrs.setString(524310, VR.UI, "1.2.840.10008.5.1.4.1.1.88.11");
        }
        if (!attrs.containsValue(0x200011)) {
            attrs.setString(0x200011, VR.IS, "0");
        }
        if (!attrs.containsValue(2097171)) {
            attrs.setString(2097171, VR.IS, Integer.toString(this.instanceNumber));
        }
        if (!attrs.contains(524323)) {
            attrs.setDate(2251950138064947L, new Date[]{new Date()});
        } else if (!attrs.contains(524339)) {
            attrs.setString(524339, VR.TM, "000000");
        }
        for (int tag : TYPE2_TAGS) {
            if (attrs.contains(tag)) continue;
            attrs.setNull(tag, dict.vrOf(tag));
        }
        return attrs;
    }

    private void xslt(String report, Attributes attrs, Code docTitleCode) throws Exception {
        Transformer t = this.tpls.newTransformer();
        t.setParameter("langCodeValue", this.languageCode.getCodeValue());
        t.setParameter("langCodingSchemeDesignator", this.languageCode.getCodingSchemeDesignator());
        t.setParameter("langCodeMeaning", this.languageCode.getCodeMeaning());
        t.setParameter("docTitleCodeValue", docTitleCode.getCodeValue());
        t.setParameter("docTitleCodingSchemeDesignator", docTitleCode.getCodingSchemeDesignator());
        t.setParameter("docTitleCodeMeaning", docTitleCode.getCodeMeaning());
        t.setParameter("VerifyingOrganization", this.verifyingOrganization);
        this.setParamIfNotNull(t, "PatientID", attrs.getString(0x100020));
        this.setParamIfNotNull(t, "PatientName", attrs.getString(0x100010));
        this.setParamIfNotNull(t, "PatientBirthDate", attrs.getString(0x100030));
        this.setParamIfNotNull(t, "PatientSex", attrs.getString(0x100040));
        this.setParamIfNotNull(t, "StudyInstanceUID", this.studyAttrs.getString(0x20000D));
        this.setParamIfNotNull(t, "AccessionNumber", attrs.getString(524368));
        this.setParamIfNotNull(t, "StudyDescription", attrs.getString(528432));
        this.setParamIfNotNull(t, "ReferringPhysicianName", attrs.getString(524432));
        t.transform(new StreamSource(new StringReader(report)), new SAXResult((ContentHandler)new ContentHandlerAdapter(attrs)));
    }

    private void setParamIfNotNull(Transformer t, String name, String val) {
        if (val != null) {
            t.setParameter(name, val);
        }
    }
}

