/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.entity;

import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import org.dcm4chee.arc.entity.CodeEntity;

@Entity
@Table(name="rejected_instance", uniqueConstraints={@UniqueConstraint(columnNames={"study_iuid", "series_iuid", "sop_iuid"})}, indexes={@Index(columnList="created_time")})
@NamedQueries(value={@NamedQuery(name="RejectedInstance.findByUIDs", query="select ri from RejectedInstance ri where ri.studyInstanceUID = ?1 and ri.seriesInstanceUID = ?2 and ri.sopInstanceUID = ?3"), @NamedQuery(name="RejectedInstance.findBySeriesUID", query="select ri from RejectedInstance ri where ri.studyInstanceUID = ?1 and ri.seriesInstanceUID = ?2"), @NamedQuery(name="RejectedInstance.deleteByUIDs", query="delete from RejectedInstance ri where ri.studyInstanceUID = ?1 and ri.seriesInstanceUID = ?2 and ri.sopInstanceUID = ?3")})
public class RejectedInstance {
    public static final String FIND_BY_UIDS = "RejectedInstance.findByUIDs";
    public static final String FIND_BY_SERIES_UID = "RejectedInstance.findBySeriesUID";
    public static final String DELETE_BY_UIDS = "RejectedInstance.deleteByUIDs";
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="pk")
    private long pk;
    @Basic(optional=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_time", updatable=false)
    private Date createdTime;
    @Basic(optional=false)
    @Column(name="study_iuid", updatable=false)
    private String studyInstanceUID;
    @Basic(optional=false)
    @Column(name="series_iuid", updatable=false)
    private String seriesInstanceUID;
    @Basic(optional=false)
    @Column(name="sop_iuid", updatable=false)
    private String sopInstanceUID;
    @Basic(optional=false)
    @Column(name="sop_cuid", updatable=false)
    private String sopClassUID;
    @ManyToOne
    @JoinColumn(name="reject_code_fk")
    private CodeEntity rejectionNoteCode;

    protected RejectedInstance() {
    }

    public RejectedInstance(String studyInstanceUID, String seriesInstanceUID, String sopInstanceUID, String sopClassUID, CodeEntity rejectionNoteCode) {
        this.studyInstanceUID = studyInstanceUID;
        this.seriesInstanceUID = seriesInstanceUID;
        this.sopInstanceUID = sopInstanceUID;
        this.sopClassUID = sopClassUID;
        this.rejectionNoteCode = rejectionNoteCode;
    }

    @PrePersist
    public void onPrePersist() {
        this.createdTime = new Date();
    }

    public String toString() {
        return "RejectedInstance[pk=" + this.pk + ", time=" + this.createdTime + ", code=" + this.rejectionNoteCode + "] of Instance[uid=" + this.sopInstanceUID + ", class=" + this.sopClassUID + "] of Series[uid=" + this.seriesInstanceUID + "] of Study[uid=" + this.studyInstanceUID + "]";
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public long getPk() {
        return this.pk;
    }

    public String getStudyInstanceUID() {
        return this.studyInstanceUID;
    }

    public String getSeriesInstanceUID() {
        return this.seriesInstanceUID;
    }

    public String getSopClassUID() {
        return this.sopClassUID;
    }

    public String getSopInstanceUID() {
        return this.sopInstanceUID;
    }

    public CodeEntity getRejectionNoteCode() {
        return this.rejectionNoteCode;
    }

    public void setRejectionNoteCode(CodeEntity rejectionNoteCode) {
        this.rejectionNoteCode = rejectionNoteCode;
    }
}

