/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.entity;

import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.entity.MPPS;

@NamedQueries(value={@NamedQuery(name="IanTask.findWithMppsByDeviceName", query="select o from IanTask o where o.mpps is not null and o.deviceName=?1 and o.pk>?2 order by o.pk"), @NamedQuery(name="IanTask.findScheduledByDeviceName", query="select o from IanTask o where o.deviceName=?1 and o.scheduledTime < current_timestamp order by o.scheduledTime"), @NamedQuery(name="IanTask.findByStudyIUID", query="select o from IanTask o where o.studyInstanceUID=?1")})
@Entity
@Table(name="ian_task", uniqueConstraints={@UniqueConstraint(columnNames={"study_iuid"})}, indexes={@Index(columnList="device_name")})
public class IanTask {
    public static final String FIND_WITH_MPPS_BY_DEVICE_NAME = "IanTask.findWithMppsByDeviceName";
    public static final String FIND_SCHEDULED_BY_DEVICE_NAME = "IanTask.findScheduledByDeviceName";
    public static final String FIND_BY_STUDY_IUID = "IanTask.findByStudyIUID";
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="pk")
    private long pk;
    @Basic(optional=false)
    @Column(name="device_name", updatable=false)
    private String deviceName;
    @Basic(optional=false)
    @Column(name="calling_aet", updatable=false)
    private String callingAET;
    @Basic(optional=false)
    @Column(name="ian_dests", updatable=false)
    private String ianDestinations;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="scheduled_time")
    private Date scheduledTime;
    @Column(name="study_iuid", updatable=false)
    private String studyInstanceUID;
    @OneToOne
    @JoinColumn(name="mpps_fk", updatable=false)
    private MPPS mpps;

    public long getPk() {
        return this.pk;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getCallingAET() {
        return this.callingAET;
    }

    public void setCallingAET(String callingAET) {
        this.callingAET = callingAET;
    }

    public String[] getIanDestinations() {
        return StringUtils.split((String)this.ianDestinations, (char)'\\');
    }

    public void setIanDestinations(String ... ianDestinations) {
        this.ianDestinations = StringUtils.concat((String[])ianDestinations, (char)'\\');
    }

    public Date getScheduledTime() {
        return this.scheduledTime;
    }

    public void setScheduledTime(Date scheduledTime) {
        this.scheduledTime = scheduledTime;
    }

    public String getStudyInstanceUID() {
        return this.studyInstanceUID;
    }

    public void setStudyInstanceUID(String studyInstanceUID) {
        this.studyInstanceUID = studyInstanceUID;
    }

    public MPPS getMpps() {
        return this.mpps;
    }

    public void setMpps(MPPS mpps) {
        this.mpps = mpps;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IanTask[pk=").append(this.pk).append(", deviceName=").append(this.deviceName);
        if (this.mpps == null) {
            sb.append(", studyInstanceUID=").append(this.studyInstanceUID);
        } else {
            sb.append(", mppsInstanceUID=").append(this.mpps.getSopInstanceUID());
        }
        if (this.scheduledTime != null) {
            sb.append(", scheduledTime=").append(this.scheduledTime);
        }
        sb.append(']');
        return sb.toString();
    }
}

