/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.diff.impl;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.IApplicationEntityCache;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.Device;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.diff.DiffBatch;
import org.dcm4chee.arc.diff.DiffContext;
import org.dcm4chee.arc.diff.DiffSCU;
import org.dcm4chee.arc.diff.DiffService;
import org.dcm4chee.arc.diff.impl.DiffSCUImpl;
import org.dcm4chee.arc.diff.impl.DiffServiceEJB;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.qmgt.Outcome;
import org.dcm4chee.arc.qmgt.TaskCanceled;
import org.dcm4chee.arc.qmgt.TaskManager;
import org.dcm4chee.arc.query.scu.CFindSCU;
import org.dcm4chee.arc.query.util.TaskQueryParam;

@ApplicationScoped
public class DiffServiceImpl
implements DiffService {
    private Map<Long, DiffSCU> diffSCUMap = Collections.synchronizedMap(new HashMap());
    @Inject
    private Device device;
    @Inject
    private IApplicationEntityCache aeCache;
    @Inject
    private CFindSCU findSCU;
    @Inject
    private DiffServiceEJB ejb;
    @Inject
    private TaskManager taskManager;

    @Override
    public DiffSCU createDiffSCU(DiffContext ctx) {
        return new DiffSCUImpl(ctx, this.findSCU, this.device);
    }

    @Override
    public void scheduleDiffTask(DiffContext ctx) {
        this.scheduleDiffTask(ctx, ctx.getQueryString());
    }

    @Override
    public void scheduleDiffTasks(DiffContext ctx, List<String> studyUIDs) {
        studyUIDs.forEach(studyUID -> this.scheduleDiffTask(ctx, ctx.getQueryString() + studyUID));
    }

    @Override
    public Outcome executeDiffTask(Task diffTask, HttpServletRequestInfo httpServletRequestInfo) throws Exception {
        this.ejb.resetDiffTask(diffTask);
        Long taskPK = diffTask.getPk();
        ScheduledFuture<?> updateDiffTask = null;
        try {
            Outcome outcome;
            block11: {
                DiffSCU diffSCU = this.createDiffSCU(this.toDiffContext(diffTask, httpServletRequestInfo));
                try {
                    Attributes diff;
                    this.diffSCUMap.put(taskPK, diffSCU);
                    diffSCU.init();
                    updateDiffTask = this.updateDiffTaskAtFixRate(diffTask, diffSCU);
                    while ((diff = diffSCU.nextDiff()) != null) {
                        this.ejb.addDiffTaskAttributes(diffTask, diff);
                    }
                    updateDiffTask.cancel(false);
                    this.ejb.updateDiffTask(diffTask, diffSCU);
                    outcome = this.toOutcome(diffSCU);
                    if (diffSCU == null) break block11;
                }
                catch (Throwable throwable) {
                    if (diffSCU != null) {
                        try {
                            diffSCU.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                diffSCU.close();
            }
            return outcome;
        }
        finally {
            if (updateDiffTask != null) {
                updateDiffTask.cancel(false);
            }
            this.diffSCUMap.remove(taskPK);
        }
    }

    private void scheduleDiffTask(DiffContext ctx, String queryString) {
        Task task = new Task();
        task.setDeviceName(this.device.getDeviceName());
        task.setQueueName("DiffTasks");
        task.setType(Task.Type.DIFF);
        task.setScheduledTime(new Date());
        if (ctx.getHttpServletRequestInfo() != null) {
            task.setRequesterUserID(ctx.getHttpServletRequestInfo().requesterUserID);
            task.setRequesterHost(ctx.getHttpServletRequestInfo().requesterHost);
            task.setRequestURI(ctx.getHttpServletRequestInfo().requestURI);
        }
        task.setBatchID(ctx.getBatchID());
        task.setStatus(Task.Status.SCHEDULED);
        task.setLocalAET(ctx.getLocalAET());
        task.setPrimaryAET(ctx.getPrimaryAE().getAETitle());
        task.setSecondaryAET(ctx.getSecondaryAE().getAETitle());
        task.setQueryString(queryString);
        task.setCheckMissing(ctx.isCheckMissing());
        task.setCheckDifferent(ctx.isCheckDifferent());
        task.setCompareFields(ctx.getCompareFields());
        this.taskManager.scheduleTask(task);
    }

    private ScheduledFuture<?> updateDiffTaskAtFixRate(Task diffTask, DiffSCU diffSCU) {
        Duration interval = ((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getDiffTaskProgressUpdateInterval();
        return interval != null ? this.device.scheduleAtFixedRate(() -> this.ejb.updateDiffTask(diffTask, diffSCU), interval.getSeconds(), interval.getSeconds(), TimeUnit.SECONDS) : null;
    }

    public void cancelDiffTask(@Observes TaskCanceled event) {
        DiffSCU diffSCU = this.diffSCUMap.get(event.task.getPk());
        if (diffSCU != null) {
            diffSCU.cancel();
        }
    }

    private Outcome toOutcome(DiffSCU diffSCU) {
        Task.Status status = Task.Status.COMPLETED;
        StringBuilder sb = new StringBuilder();
        sb.append(diffSCU.matches()).append(" studies compared");
        status = this.check(", missing: ", diffSCU.missing(), status, sb);
        status = this.check(", different: ", diffSCU.different(), status, sb);
        return new Outcome(diffSCU.isCancelled() ? Task.Status.CANCELED : status, sb.toString());
    }

    @Override
    public List<byte[]> getDiffTaskAttributes(Task task, int offset, int limit) {
        return this.ejb.getDiffTaskAttributes(task, offset, limit);
    }

    @Override
    public List<byte[]> getDiffTaskAttributes(TaskQueryParam taskQueryParam, int offset, int limit) {
        return this.ejb.getDiffTaskAttributes(taskQueryParam, offset, limit);
    }

    @Override
    public List<DiffBatch> listDiffBatches(TaskQueryParam taskQueryPara, int offset, int limit) {
        return this.ejb.listDiffBatches(taskQueryPara, offset, limit);
    }

    @Override
    public long diffTasksOfBatch(String batchID) {
        return this.ejb.diffTasksOfBatch(batchID);
    }

    private Task.Status check(String prompt, int failures, Task.Status status, StringBuilder sb) {
        if (failures == 0) {
            return status;
        }
        sb.append(prompt).append(failures);
        return Task.Status.WARNING;
    }

    private DiffContext toDiffContext(Task diffTask, HttpServletRequestInfo httpServletRequestInfo) throws ConfigurationException {
        return new DiffContext().setLocalAET(diffTask.getLocalAET()).setPrimaryAE(this.aeCache.get(diffTask.getPrimaryAET())).setSecondaryAE(this.aeCache.get(diffTask.getSecondaryAET())).setArcDev((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).setQueryString(diffTask.getQueryString()).setHttpServletRequestInfo(httpServletRequestInfo);
    }
}

