/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.diff;

import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.util.TagUtils;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.AttributeSet;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.Entity;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.query.util.QIDO;
import org.dcm4chee.arc.query.util.QueryAttributes;

public class DiffContext {
    private String localAET;
    private ArchiveDeviceExtension arcDev;
    private ApplicationEntity primaryAE;
    private ApplicationEntity secondaryAE;
    private String queryString;
    private QueryAttributes queryAttributes;
    private Duration splitStudyDateRange;
    private int priority;
    private boolean forceQueryByStudyUID;
    private boolean fuzzymatching;
    private boolean checkMissing;
    private boolean checkDifferent;
    private int[] compareKeys;
    private int[] returnKeys;
    private String compareFields;
    private String batchID;
    private HttpServletRequestInfo httpServletRequestInfo;

    public String getLocalAET() {
        return this.localAET;
    }

    public DiffContext setLocalAET(String localAET) {
        this.localAET = localAET;
        return this;
    }

    public DiffContext setArcDev(ArchiveDeviceExtension arcDev) {
        this.arcDev = arcDev;
        return this;
    }

    public ApplicationEntity getPrimaryAE() {
        return this.primaryAE;
    }

    public DiffContext setPrimaryAE(ApplicationEntity primaryAE) {
        this.primaryAE = primaryAE;
        return this;
    }

    public ApplicationEntity getSecondaryAE() {
        return this.secondaryAE;
    }

    public DiffContext setSecondaryAE(ApplicationEntity secondaryAE) {
        this.secondaryAE = secondaryAE;
        return this;
    }

    public HttpServletRequestInfo getHttpServletRequestInfo() {
        return this.httpServletRequestInfo;
    }

    public DiffContext setHttpServletRequestInfo(HttpServletRequestInfo httpServletRequestInfo) {
        this.httpServletRequestInfo = httpServletRequestInfo;
        return this;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public DiffContext setQueryString(String queryString) {
        return this.setQueryString(queryString, (MultivaluedMap<String, String>)QueryAttributes.parseQueryString((String)queryString));
    }

    public DiffContext setQueryString(String queryString, MultivaluedMap<String, String> queryParameters) {
        this.queryString = queryString;
        this.queryAttributes = new QueryAttributes(queryParameters, null);
        this.forceQueryByStudyUID = DiffContext.parseBoolean((String)queryParameters.getFirst((Object)"ForceQueryByStudyUID"), false);
        this.splitStudyDateRange = DiffContext.parseDuration((String)queryParameters.getFirst((Object)"SplitStudyDateRange"));
        this.compareKeys = this.parseComparefields((List)queryParameters.get((Object)"comparefield"));
        this.priority = DiffContext.parseInt((String)queryParameters.getFirst((Object)"priority"), 0);
        this.fuzzymatching = DiffContext.parseBoolean((String)queryParameters.getFirst((Object)"fuzzymatching"), false);
        this.checkDifferent = DiffContext.parseBoolean((String)queryParameters.getFirst((Object)"different"), true);
        this.checkMissing = DiffContext.parseBoolean((String)queryParameters.getFirst((Object)"missing"), false);
        this.batchID = (String)queryParameters.getFirst((Object)"batchID");
        return this;
    }

    public Attributes getQueryKeys() {
        return this.queryAttributes.getQueryKeys();
    }

    public boolean isForceQueryByStudyUID() {
        return this.forceQueryByStudyUID;
    }

    public Duration getSplitStudyDateRange() {
        return this.splitStudyDateRange;
    }

    public int[] getCompareKeys() {
        return this.compareKeys;
    }

    public int[] getReturnKeys() {
        return this.returnKeys;
    }

    public boolean isFuzzymatching() {
        return this.fuzzymatching;
    }

    public int priority() {
        return this.priority;
    }

    public boolean isCheckDifferent() {
        return this.checkDifferent;
    }

    public boolean isCheckMissing() {
        return this.checkMissing;
    }

    public String getCompareFields() {
        return this.compareFields;
    }

    public String getBatchID() {
        return this.batchID;
    }

    public boolean supportSorting() {
        if (this.compareKeys == null) {
            throw new IllegalStateException("compareKeys not initialized");
        }
        this.queryAttributes.addReturnTags(QIDO.STUDY.includetags);
        if (this.compareKeys != QIDO.STUDY.includetags) {
            this.queryAttributes.addReturnTags(this.compareKeys);
        }
        if (this.queryAttributes.isIncludeAll()) {
            this.queryAttributes.addReturnTags(this.arcDev.getAttributeFilter(Entity.Patient).getSelection(false));
            this.queryAttributes.addReturnTags(this.arcDev.getAttributeFilter(Entity.Study).getSelection(false));
        }
        Attributes keys = this.queryAttributes.getQueryKeys();
        this.returnKeys = keys.tags();
        keys.setString(524370, VR.CS, "STUDY");
        if (DiffContext.hasArchiveAEExtension(this.primaryAE) && DiffContext.hasArchiveAEExtension(this.secondaryAE)) {
            Attributes item = new Attributes(1);
            item.setInt(7471142, VR.AT, new int[]{0x20000D});
            keys.newSequence(7472640, 1).add(item);
            return true;
        }
        return false;
    }

    private static boolean parseBoolean(String s, boolean defval) {
        return s != null ? Boolean.parseBoolean(s) : defval;
    }

    private static int parseInt(String s, int defval) {
        return s != null ? Integer.parseInt(s) : defval;
    }

    private static Duration parseDuration(String s) {
        return s != null ? Duration.valueOf((String)s) : null;
    }

    private static boolean hasArchiveAEExtension(ApplicationEntity ae) {
        return ae.getAEExtension(ArchiveAEExtension.class) != null;
    }

    private int[] parseComparefields(List<String> comparefields) {
        Map attributeSetMap;
        AttributeSet attributeSet;
        if (comparefields == null || comparefields.isEmpty()) {
            return QIDO.STUDY.includetags;
        }
        int size = comparefields.size();
        if (size == 1 && (attributeSet = (AttributeSet)(attributeSetMap = this.arcDev.getAttributeSet(AttributeSet.Type.DIFF_RS)).get(comparefields.get(0))) != null) {
            this.compareFields = attributeSet.getID();
            return attributeSet.getSelection();
        }
        int[] compareKeys = new int[size];
        for (int i = 0; i < size; ++i) {
            try {
                compareKeys[i] = TagUtils.forName((String)comparefields.get(i));
                continue;
            }
            catch (IllegalArgumentException e2) {
                throw new IllegalArgumentException("comparefield=" + comparefields.get(i));
            }
        }
        return compareKeys;
    }
}

