/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf;

import java.io.File;
import java.time.Period;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.io.BulkDataDescriptor;
import org.dcm4che3.json.JSONWriter;
import org.dcm4che3.net.AEExtension;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.conf.AcceptConflictingPatientID;
import org.dcm4chee.arc.conf.AcceptMissingPatientID;
import org.dcm4chee.arc.conf.AllowDeletePatient;
import org.dcm4chee.arc.conf.AllowDeleteStudyPermanently;
import org.dcm4chee.arc.conf.AllowRejectionForDataRetentionPolicyExpired;
import org.dcm4chee.arc.conf.ArchiveAttributeCoercion;
import org.dcm4chee.arc.conf.ArchiveAttributeCoercion2;
import org.dcm4chee.arc.conf.ArchiveCompressionRule;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Conditions;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.ExportPriorsRule;
import org.dcm4chee.arc.conf.ExportRule;
import org.dcm4chee.arc.conf.HL7PSUMWLMatchingKey;
import org.dcm4chee.arc.conf.HL7PSUMessageType;
import org.dcm4chee.arc.conf.MPPSForwardRule;
import org.dcm4chee.arc.conf.MultipleStoreAssociations;
import org.dcm4chee.arc.conf.OverwritePolicy;
import org.dcm4chee.arc.conf.QueryRetrieveView;
import org.dcm4chee.arc.conf.RSForwardRule;
import org.dcm4chee.arc.conf.SPSStatus;
import org.dcm4chee.arc.conf.SpanningCFindSCPPolicy;
import org.dcm4chee.arc.conf.StorageVerificationPolicy;
import org.dcm4chee.arc.conf.StoreAccessControlIDRule;
import org.dcm4chee.arc.conf.StudyRetentionPolicy;
import org.dcm4chee.arc.conf.UPSOnStore;
import org.dcm4chee.arc.conf.UPSOnUPSCompleted;
import org.dcm4chee.arc.conf.UserIdentityNegotiation;

public class ArchiveAEExtension
extends AEExtension {
    private String defaultCharacterSet;
    private String mwlWorklistLabel;
    private String upsWorklistLabel;
    private String[] upsEventSCUs = new String[0];
    private int upsEventSCUKeepAlive;
    private Boolean upsUpdateWithoutTransactionUID;
    private String[] objectStorageIDs = new String[0];
    private int objectStorageCount = 1;
    private String[] metadataStorageIDs = new String[0];
    private String bulkDataDescriptorID;
    private Duration seriesMetadataDelay;
    private Duration purgeInstanceRecordsDelay;
    private String storeAccessControlID;
    private String[] accessControlIDs = new String[0];
    private OverwritePolicy overwritePolicy;
    private Boolean recordAttributeModification;
    private String bulkDataSpoolDirectory;
    private String queryRetrieveViewID;
    private Boolean validateCallingAEHostname;
    private Boolean personNameComponentOrderInsensitiveMatching;
    private Boolean sendPendingCGet;
    private Duration sendPendingCMoveInterval;
    private Boolean wadoMetadataWithoutPrivate;
    private Boolean wadoIgnorePresentationLUTShape;
    private String wadoThumbnailViewPort;
    private String wadoZIPEntryNameFormat;
    private String wadoSR2HtmlTemplateURI;
    private String wadoSR2TextTemplateURI;
    private String wadoCDA2HtmlTemplateURI;
    private String[] mppsForwardDestinations = new String[0];
    private String[] ianDestinations = new String[0];
    private Duration ianDelay;
    private Duration ianTimeout;
    private Boolean ianOnTimeout;
    private String spanningCFindSCP;
    private String[] spanningCFindSCPRetrieveAETitles = new String[0];
    private SpanningCFindSCPPolicy spanningCFindSCPPolicy;
    private Integer fallbackCMoveSCPRetries;
    private String fallbackCMoveSCP;
    private String fallbackCMoveSCPDestination;
    private String fallbackCMoveSCPCallingAET;
    private String fallbackCMoveSCPLeadingCFindSCP;
    private String fallbackCMoveSCPStudyOlderThan;
    private String fallbackWadoURIWebApplication;
    private Integer fallbackWadoURIHttpStatusCode;
    private String externalRetrieveAEDestination;
    private String alternativeCMoveSCP;
    private Integer queryMaxNumberOfResults;
    private Integer qidoMaxNumberOfResults;
    private Boolean qidoETag;
    private Boolean filterByIssuerOfPatientID;
    private Boolean matchSOPClassOnInstanceLevel;
    private SPSStatus[] hideSPSWithStatusFromMWL = new SPSStatus[0];
    private SPSStatus[] hideSPSWithStatusFromMWLRS = new SPSStatus[0];
    private String mwlAccessionNumberGenerator;
    private String mwlRequestedProcedureIDGenerator;
    private String mwlScheduledProcedureStepIDGenerator;
    private String storePermissionServiceURL;
    private String storePermissionServiceResponse;
    private Pattern storePermissionServiceResponsePattern;
    private Pattern storePermissionServiceExpirationDatePattern;
    private Pattern storePermissionServiceErrorCommentPattern;
    private Pattern storePermissionServiceErrorCodePattern;
    private AllowRejectionForDataRetentionPolicyExpired allowRejectionForDataRetentionPolicyExpired;
    private AcceptMissingPatientID acceptMissingPatientID;
    private AllowDeletePatient allowDeletePatient;
    private AllowDeleteStudyPermanently allowDeleteStudyPermanently;
    private AcceptConflictingPatientID acceptConflictingPatientID;
    private UserIdentityNegotiation userIdentityNegotiation;
    private String userIdentityNegotiationRole;
    private String userIdentityNegotiationKeycloakClientID;
    private String[] retrieveAETitles = new String[0];
    private String[] returnRetrieveAETitles = new String[0];
    private String hl7PSUSendingApplication;
    private String[] hl7PSUReceivingApplications = new String[0];
    private Duration hl7PSUDelay;
    private Duration hl7PSUTimeout;
    private Boolean hl7PSUOnTimeout;
    private Boolean hl7PSUMWL;
    private HL7PSUMWLMatchingKey hl7PSUMWLMatchingKey;
    private Boolean hl7PSUForRequestedProcedure;
    private Boolean hl7PSUPIDPV1;
    private String hl7PSURequestedProcedureID;
    private String hl7PSUAccessionNumber;
    private String hl7PSUFillerOrderNumber;
    private String hl7PSUPlacerOrderNumber;
    private HL7PSUMessageType hl7PSUMessageType;
    private Conditions hl7PSUConditions = new Conditions(new String[0]);
    private String hl7PSUMppsTemplateURI;
    private String hl7PSUStudyTemplateURI;
    private Attributes.UpdatePolicy copyMoveUpdatePolicy;
    private Attributes.UpdatePolicy linkMWLEntryUpdatePolicy;
    private StorageVerificationPolicy storageVerificationPolicy;
    private Boolean storageVerificationUpdateLocationStatus;
    private String[] storageVerificationStorageIDs = new String[0];
    private Period storageVerificationInitialDelay;
    private Boolean updateLocationStatusOnRetrieve;
    private Boolean storageVerificationOnRetrieve;
    private Boolean relationalQueryNegotiationLenient;
    private Boolean relationalRetrieveNegotiationLenient;
    private Boolean stowRetiredTransferSyntax;
    private Boolean stowExcludeAPPMarkers;
    private Boolean restrictRetrieveSilently;
    private Boolean retrieveTaskWarningOnNoMatch;
    private Boolean retrieveTaskWarningOnWarnings;
    private Boolean stowQuicktime2MP4;
    private Long stowMaxFragmentLength;
    private String changeRequesterAET;
    private int[] rejectConflictingPatientAttribute = new int[0];
    private MultipleStoreAssociations[] multipleStoreAssociations = new MultipleStoreAssociations[0];
    private final EnumSet<VR> encodeAsJSONNumber = EnumSet.noneOf(VR.class);
    private final LinkedHashSet<String> acceptedMoveDestinations = new LinkedHashSet();
    private final LinkedHashSet<String> acceptedUserRoles = new LinkedHashSet();
    private final List<UPSOnStore> upsOnStoreList = new ArrayList<UPSOnStore>();
    private final List<UPSOnUPSCompleted> upsOnUPSCompletedList = new ArrayList<UPSOnUPSCompleted>();
    private final List<ExportRule> exportRules = new ArrayList<ExportRule>();
    private final List<ExportPriorsRule> exportPriorsRules = new ArrayList<ExportPriorsRule>();
    private final List<MPPSForwardRule> mppsForwardRule = new ArrayList<MPPSForwardRule>();
    private final List<RSForwardRule> rsForwardRules = new ArrayList<RSForwardRule>();
    private final List<ArchiveCompressionRule> compressionRules = new ArrayList<ArchiveCompressionRule>();
    private final List<ArchiveAttributeCoercion> attributeCoercions = new ArrayList<ArchiveAttributeCoercion>();
    private final List<ArchiveAttributeCoercion2> attributeCoercions2 = new ArrayList<ArchiveAttributeCoercion2>();
    private final List<StudyRetentionPolicy> studyRetentionPolicies = new ArrayList<StudyRetentionPolicy>();
    private final List<StoreAccessControlIDRule> storeAccessControlIDRules = new ArrayList<StoreAccessControlIDRule>();
    private final Map<String, String> hl7PSUTemplateParams = new HashMap<String, String>();

    public String getDefaultCharacterSet() {
        return this.defaultCharacterSet;
    }

    public void setDefaultCharacterSet(String defaultCharacterSet) {
        this.defaultCharacterSet = defaultCharacterSet;
    }

    public String defaultCharacterSet() {
        return this.defaultCharacterSet != null ? this.defaultCharacterSet : this.getArchiveDeviceExtension().getDefaultCharacterSet();
    }

    public String getMWLWorklistLabel() {
        return this.mwlWorklistLabel;
    }

    public void setMWLWorklistLabel(String mwlWorklistLabel) {
        this.mwlWorklistLabel = mwlWorklistLabel;
    }

    public String getUPSWorklistLabel() {
        return this.upsWorklistLabel;
    }

    public void setUPSWorklistLabel(String upsWorklistLabel) {
        this.upsWorklistLabel = upsWorklistLabel;
    }

    public String upsWorklistLabel() {
        return this.upsWorklistLabel != null ? this.upsWorklistLabel : (String)StringUtils.maskNull((Object)this.getArchiveDeviceExtension().getUPSWorklistLabel(), (Object)this.ae.getAETitle());
    }

    public String[] getUPSEventSCUs() {
        return this.upsEventSCUs;
    }

    public void setUPSEventSCUs(String[] upsEventSCUs) {
        this.upsEventSCUs = upsEventSCUs;
    }

    public String[] upsEventSCUs() {
        return this.upsEventSCUs.length > 0 ? this.upsEventSCUs : this.getArchiveDeviceExtension().getUPSEventSCUs();
    }

    public boolean isUPSEventSCU(String aet) {
        return Stream.of(this.upsEventSCUs()).anyMatch(aet::equals);
    }

    public int getUPSEventSCUKeepAlive() {
        return this.upsEventSCUKeepAlive;
    }

    public void setUPSEventSCUKeepAlive(int upsEventSCUKeepAlive) {
        this.upsEventSCUKeepAlive = upsEventSCUKeepAlive;
    }

    public int upsEventSCUKeepAlive() {
        return this.upsEventSCUKeepAlive > 0 ? this.upsEventSCUKeepAlive : this.getArchiveDeviceExtension().getUPSEventSCUKeepAlive();
    }

    public Boolean getUPSUpdateWithoutTransactionUID() {
        return this.upsUpdateWithoutTransactionUID;
    }

    public void setUPSUpdateWithoutTransactionUID(Boolean upsUpdateWithoutTransactionUID) {
        this.upsUpdateWithoutTransactionUID = upsUpdateWithoutTransactionUID;
    }

    public boolean upsUpdateWithoutTransactionUID() {
        return this.upsUpdateWithoutTransactionUID != null ? this.upsUpdateWithoutTransactionUID.booleanValue() : this.getArchiveDeviceExtension().isUPSUpdateWithoutTransactionUID();
    }

    public String[] getObjectStorageIDs() {
        return this.objectStorageIDs;
    }

    public void setObjectStorageIDs(String ... objectStorageIDs) {
        this.objectStorageIDs = objectStorageIDs;
        Arrays.sort(objectStorageIDs);
    }

    public int getObjectStorageCount() {
        return this.objectStorageCount;
    }

    public void setObjectStorageCount(int objectStorageCount) {
        this.objectStorageCount = objectStorageCount;
    }

    public String[] getMetadataStorageIDs() {
        return this.metadataStorageIDs;
    }

    public void setMetadataStorageIDs(String ... metadataStorageIDs) {
        this.metadataStorageIDs = metadataStorageIDs;
        Arrays.sort(metadataStorageIDs);
    }

    public String getBulkDataDescriptorID() {
        return this.bulkDataDescriptorID;
    }

    public void setBulkDataDescriptorID(String bulkDataDescriptorID) {
        this.bulkDataDescriptorID = bulkDataDescriptorID;
    }

    public BulkDataDescriptor getBulkDataDescriptor() {
        ArchiveDeviceExtension arcdev = this.getArchiveDeviceExtension();
        return arcdev.getBulkDataDescriptor(this.bulkDataDescriptorID != null ? this.bulkDataDescriptorID : arcdev.getBulkDataDescriptorID());
    }

    public Duration getSeriesMetadataDelay() {
        return this.seriesMetadataDelay;
    }

    public void setSeriesMetadataDelay(Duration seriesMetadataDelay) {
        this.seriesMetadataDelay = seriesMetadataDelay;
    }

    public Duration seriesMetadataDelay() {
        return this.seriesMetadataDelay != null ? this.seriesMetadataDelay : this.getArchiveDeviceExtension().getSeriesMetadataDelay();
    }

    public Duration getPurgeInstanceRecordsDelay() {
        return this.purgeInstanceRecordsDelay;
    }

    public void setPurgeInstanceRecordsDelay(Duration purgeInstanceRecordsDelay) {
        this.purgeInstanceRecordsDelay = purgeInstanceRecordsDelay;
    }

    public Duration purgeInstanceRecordsDelay() {
        ArchiveDeviceExtension arcdev = this.getArchiveDeviceExtension();
        return arcdev.isPurgeInstanceRecords() ? (this.purgeInstanceRecordsDelay != null ? this.purgeInstanceRecordsDelay : arcdev.getPurgeInstanceRecordsDelay()) : null;
    }

    public String getStoreAccessControlID() {
        return this.storeAccessControlID;
    }

    public void setStoreAccessControlID(String storeAccessControlID) {
        this.storeAccessControlID = storeAccessControlID;
    }

    public String[] getAccessControlIDs() {
        return this.accessControlIDs;
    }

    public void setAccessControlIDs(String[] accessControlIDs) {
        this.accessControlIDs = accessControlIDs;
    }

    public OverwritePolicy getOverwritePolicy() {
        return this.overwritePolicy;
    }

    public void setOverwritePolicy(OverwritePolicy overwritePolicy) {
        this.overwritePolicy = overwritePolicy;
    }

    public OverwritePolicy overwritePolicy() {
        return this.overwritePolicy != null ? this.overwritePolicy : this.getArchiveDeviceExtension().getOverwritePolicy();
    }

    public Boolean getRecordAttributeModification() {
        return this.recordAttributeModification;
    }

    public void setRecordAttributeModification(Boolean recordAttributeModification) {
        this.recordAttributeModification = recordAttributeModification;
    }

    public boolean recordAttributeModification() {
        return this.recordAttributeModification != null ? this.recordAttributeModification.booleanValue() : this.getArchiveDeviceExtension().isRecordAttributeModification();
    }

    public AcceptMissingPatientID getAcceptMissingPatientID() {
        return this.acceptMissingPatientID;
    }

    public void setAcceptMissingPatientID(AcceptMissingPatientID acceptMissingPatientID) {
        this.acceptMissingPatientID = acceptMissingPatientID;
    }

    public AcceptMissingPatientID acceptMissingPatientID() {
        return this.acceptMissingPatientID != null ? this.acceptMissingPatientID : this.getArchiveDeviceExtension().getAcceptMissingPatientID();
    }

    public String getBulkDataSpoolDirectory() {
        return this.bulkDataSpoolDirectory;
    }

    public void setBulkDataSpoolDirectory(String bulkDataSpoolDirectory) {
        this.bulkDataSpoolDirectory = bulkDataSpoolDirectory;
    }

    public String bulkDataSpoolDirectory() {
        return this.bulkDataSpoolDirectory != null ? this.bulkDataSpoolDirectory : this.getArchiveDeviceExtension().getBulkDataSpoolDirectory();
    }

    public File getBulkDataSpoolDirectoryFile() {
        return new File(StringUtils.replaceSystemProperties((String)this.bulkDataSpoolDirectory()));
    }

    public String getQueryRetrieveViewID() {
        return this.queryRetrieveViewID;
    }

    public void setQueryRetrieveViewID(String queryRetrieveViewID) {
        this.queryRetrieveViewID = queryRetrieveViewID;
    }

    public Boolean getValidateCallingAEHostname() {
        return this.validateCallingAEHostname;
    }

    public void setValidateCallingAEHostname(Boolean validateCallingAEHostname) {
        this.validateCallingAEHostname = validateCallingAEHostname;
    }

    public boolean validateCallingAEHostname() {
        return this.validateCallingAEHostname != null ? this.validateCallingAEHostname.booleanValue() : this.getArchiveDeviceExtension().isValidateCallingAEHostname();
    }

    public Boolean getPersonNameComponentOrderInsensitiveMatching() {
        return this.personNameComponentOrderInsensitiveMatching;
    }

    public void setPersonNameComponentOrderInsensitiveMatching(Boolean personNameComponentOrderInsensitiveMatching) {
        this.personNameComponentOrderInsensitiveMatching = personNameComponentOrderInsensitiveMatching;
    }

    public boolean personNameComponentOrderInsensitiveMatching() {
        return this.personNameComponentOrderInsensitiveMatching != null ? this.personNameComponentOrderInsensitiveMatching.booleanValue() : this.getArchiveDeviceExtension().isPersonNameComponentOrderInsensitiveMatching();
    }

    public Boolean getSendPendingCGet() {
        return this.sendPendingCGet;
    }

    public void setSendPendingCGet(Boolean sendPendingCGet) {
        this.sendPendingCGet = sendPendingCGet;
    }

    public boolean sendPendingCGet() {
        return this.sendPendingCGet != null ? this.sendPendingCGet.booleanValue() : this.getArchiveDeviceExtension().isSendPendingCGet();
    }

    public Duration getSendPendingCMoveInterval() {
        return this.sendPendingCMoveInterval;
    }

    public void setSendPendingCMoveInterval(Duration sendPendingCMoveInterval) {
        this.sendPendingCMoveInterval = sendPendingCMoveInterval;
    }

    public Duration sendPendingCMoveInterval() {
        return this.sendPendingCMoveInterval != null ? this.sendPendingCMoveInterval : this.getArchiveDeviceExtension().getSendPendingCMoveInterval();
    }

    public Boolean getWadoMetadataWithoutPrivate() {
        return this.wadoMetadataWithoutPrivate;
    }

    public void setWadoMetadataWithoutPrivate(Boolean wadoMetadataWithoutPrivate) {
        this.wadoMetadataWithoutPrivate = wadoMetadataWithoutPrivate;
    }

    public boolean wadoMetadataWithoutPrivate() {
        return this.wadoMetadataWithoutPrivate != null ? this.wadoMetadataWithoutPrivate.booleanValue() : this.getArchiveDeviceExtension().isWadoMetadataWithoutPrivate();
    }

    public Boolean getWadoIgnorePresentationLUTShape() {
        return this.wadoIgnorePresentationLUTShape;
    }

    public void setWadoIgnorePresentationLUTShape(Boolean wadoIgnorePresentationLUTShape) {
        this.wadoIgnorePresentationLUTShape = wadoIgnorePresentationLUTShape;
    }

    public boolean isWadoIgnorePresentationLUTShape() {
        return this.wadoIgnorePresentationLUTShape != null ? this.wadoIgnorePresentationLUTShape.booleanValue() : this.getArchiveDeviceExtension().isWadoIgnorePresentationLUTShape();
    }

    public String getWadoThumbnailViewPort() {
        return this.wadoThumbnailViewPort;
    }

    public void setWadoThumbnailViewPort(String wadoThumbnailViewPort) {
        this.wadoThumbnailViewPort = wadoThumbnailViewPort;
    }

    public String wadoThumbnailViewPort() {
        return this.wadoThumbnailViewPort != null ? this.wadoThumbnailViewPort : this.getArchiveDeviceExtension().getWadoThumbnailViewPort();
    }

    public String getWadoZIPEntryNameFormat() {
        return this.wadoZIPEntryNameFormat;
    }

    public void setWadoZIPEntryNameFormat(String wadoZIPEntryNameFormat) {
        this.wadoZIPEntryNameFormat = wadoZIPEntryNameFormat;
    }

    public String wadoZIPEntryNameFormat() {
        return this.wadoZIPEntryNameFormat != null ? this.wadoZIPEntryNameFormat : this.getArchiveDeviceExtension().getWadoZIPEntryNameFormat();
    }

    public String getWadoSR2HtmlTemplateURI() {
        return this.wadoSR2HtmlTemplateURI;
    }

    public void setWadoSR2HtmlTemplateURI(String wadoSR2HtmlTemplateURI) {
        this.wadoSR2HtmlTemplateURI = wadoSR2HtmlTemplateURI;
    }

    public String wadoSR2HtmlTemplateURI() {
        return this.wadoSR2HtmlTemplateURI != null ? this.wadoSR2HtmlTemplateURI : this.getArchiveDeviceExtension().getWadoSR2HtmlTemplateURI();
    }

    public String getWadoSR2TextTemplateURI() {
        return this.wadoSR2TextTemplateURI;
    }

    public void setWadoSR2TextTemplateURI(String wadoSR2TextTemplateURI) {
        this.wadoSR2TextTemplateURI = wadoSR2TextTemplateURI;
    }

    public String wadoSR2TextTemplateURI() {
        return this.wadoSR2TextTemplateURI != null ? this.wadoSR2TextTemplateURI : this.getArchiveDeviceExtension().getWadoSR2TextTemplateURI();
    }

    public String getWadoCDA2HtmlTemplateURI() {
        return this.wadoCDA2HtmlTemplateURI;
    }

    public void setWadoCDA2HtmlTemplateURI(String wadoCDA2HtmlTemplateURI) {
        this.wadoCDA2HtmlTemplateURI = wadoCDA2HtmlTemplateURI;
    }

    public String wadoCDA2HtmlTemplateURI() {
        return this.wadoCDA2HtmlTemplateURI != null ? this.wadoCDA2HtmlTemplateURI : this.getArchiveDeviceExtension().getWadoCDA2HtmlTemplateURI();
    }

    public String[] getMppsForwardDestinations() {
        return this.mppsForwardDestinations;
    }

    public void setMppsForwardDestinations(String ... mppsForwardDestinations) {
        this.mppsForwardDestinations = mppsForwardDestinations;
    }

    public String[] mppsForwardDestinations() {
        return this.mppsForwardDestinations.length > 0 ? this.mppsForwardDestinations : this.getArchiveDeviceExtension().getMppsForwardDestinations();
    }

    public String[] getIanDestinations() {
        return this.ianDestinations;
    }

    public void setIanDestinations(String ... ianDestinations) {
        this.ianDestinations = ianDestinations;
    }

    public String[] ianDestinations() {
        return this.ianDestinations.length > 0 ? this.ianDestinations : this.getArchiveDeviceExtension().getIanDestinations();
    }

    public Duration getIanDelay() {
        return this.ianDelay;
    }

    public void setIanDelay(Duration ianDelay) {
        this.ianDelay = ianDelay;
    }

    public Duration ianDelay() {
        return this.ianDelay != null ? this.ianDelay : this.getArchiveDeviceExtension().getIanDelay();
    }

    public Duration getIanTimeout() {
        return this.ianTimeout;
    }

    public void setIanTimeout(Duration ianTimeout) {
        this.ianTimeout = ianTimeout;
    }

    public Duration ianTimeout() {
        return this.ianTimeout != null ? this.ianTimeout : this.getArchiveDeviceExtension().getIanTimeout();
    }

    public Boolean getIanOnTimeout() {
        return this.ianOnTimeout;
    }

    public void setIanOnTimeout(Boolean ianOnTimeout) {
        this.ianOnTimeout = ianOnTimeout;
    }

    public boolean ianOnTimeout() {
        return this.ianOnTimeout != null ? this.ianOnTimeout.booleanValue() : this.getArchiveDeviceExtension().isIanOnTimeout();
    }

    public String getSpanningCFindSCP() {
        return this.spanningCFindSCP;
    }

    public void setSpanningCFindSCP(String spanningCFindSCP) {
        this.spanningCFindSCP = spanningCFindSCP;
    }

    public String spanningCFindSCP() {
        return this.spanningCFindSCP != null ? this.spanningCFindSCP : this.getArchiveDeviceExtension().getSpanningCFindSCP();
    }

    public String[] getSpanningCFindSCPRetrieveAETitles() {
        return this.spanningCFindSCPRetrieveAETitles;
    }

    public void setSpanningCFindSCPRetrieveAETitles(String[] spanningCFindSCPRetrieveAETitles) {
        this.spanningCFindSCPRetrieveAETitles = spanningCFindSCPRetrieveAETitles;
    }

    public String[] spanningCFindSCPRetrieveAETitles() {
        return this.spanningCFindSCPRetrieveAETitles.length > 0 ? this.spanningCFindSCPRetrieveAETitles : this.getArchiveDeviceExtension().getSpanningCFindSCPRetrieveAETitles();
    }

    public SpanningCFindSCPPolicy getSpanningCFindSCPPolicy() {
        return this.spanningCFindSCPPolicy;
    }

    public void setSpanningCFindSCPPolicy(SpanningCFindSCPPolicy spanningCFindSCPPolicy) {
        this.spanningCFindSCPPolicy = spanningCFindSCPPolicy;
    }

    public SpanningCFindSCPPolicy spanningCFindSCPPolicy() {
        return this.spanningCFindSCPPolicy != null ? this.spanningCFindSCPPolicy : this.getArchiveDeviceExtension().getSpanningCFindSCPPolicy();
    }

    public String getFallbackCMoveSCP() {
        return this.fallbackCMoveSCP;
    }

    public void setFallbackCMoveSCP(String fallbackCMoveSCP) {
        this.fallbackCMoveSCP = fallbackCMoveSCP;
    }

    public String fallbackCMoveSCP() {
        return this.fallbackCMoveSCP != null ? this.fallbackCMoveSCP : this.getArchiveDeviceExtension().getFallbackCMoveSCP();
    }

    public String getFallbackCMoveSCPDestination() {
        return this.fallbackCMoveSCPDestination;
    }

    public void setFallbackCMoveSCPDestination(String fallbackCMoveSCPDestination) {
        this.fallbackCMoveSCPDestination = fallbackCMoveSCPDestination;
    }

    public String fallbackCMoveSCPDestination() {
        return this.fallbackCMoveSCPDestination != null ? this.fallbackCMoveSCPDestination : this.getArchiveDeviceExtension().getFallbackCMoveSCPDestination();
    }

    public String getFallbackCMoveSCPCallingAET() {
        return this.fallbackCMoveSCPCallingAET;
    }

    public void setFallbackCMoveSCPCallingAET(String fallbackCMoveSCPCallingAET) {
        this.fallbackCMoveSCPCallingAET = fallbackCMoveSCPCallingAET;
    }

    public String fallbackCMoveSCPCallingAET(Association as) {
        String aet = this.fallbackCMoveSCPCallingAET != null ? this.fallbackCMoveSCPCallingAET : this.getArchiveDeviceExtension().getFallbackCMoveSCPCallingAET();
        return aet != null ? aet : as.getCallingAET();
    }

    public String getFallbackCMoveSCPLeadingCFindSCP() {
        return this.fallbackCMoveSCPLeadingCFindSCP;
    }

    public void setFallbackCMoveSCPLeadingCFindSCP(String fallbackCMoveSCPLeadingCFindSCP) {
        this.fallbackCMoveSCPLeadingCFindSCP = fallbackCMoveSCPLeadingCFindSCP;
    }

    public String fallbackCMoveSCPLeadingCFindSCP() {
        return this.fallbackCMoveSCPLeadingCFindSCP != null ? this.fallbackCMoveSCPLeadingCFindSCP : this.getArchiveDeviceExtension().getFallbackCMoveSCPLeadingCFindSCP();
    }

    public void setFallbackCMoveSCPRetries(Integer fallbackCMoveSCPRetries) {
        this.fallbackCMoveSCPRetries = fallbackCMoveSCPRetries;
    }

    public Integer getFallbackCMoveSCPRetries() {
        return this.fallbackCMoveSCPRetries;
    }

    public int fallbackCMoveSCPRetries() {
        return this.fallbackCMoveSCPRetries != null ? this.fallbackCMoveSCPRetries.intValue() : this.getArchiveDeviceExtension().getFallbackCMoveSCPRetries();
    }

    public String getFallbackWadoURIWebApplication() {
        return this.fallbackWadoURIWebApplication;
    }

    public void setFallbackWadoURIWebApplication(String fallbackWadoURIWebApplication) {
        this.fallbackWadoURIWebApplication = fallbackWadoURIWebApplication;
    }

    public String fallbackWadoURIWebApplication() {
        return this.fallbackWadoURIWebApplication != null ? this.fallbackWadoURIWebApplication : this.getArchiveDeviceExtension().getFallbackWadoURIWebApplication();
    }

    public Integer getFallbackWadoURIHttpStatusCode() {
        return this.fallbackWadoURIHttpStatusCode;
    }

    public void setFallbackWadoURIHttpStatusCode(Integer fallbackWadoURIHttpStatusCode) {
        this.fallbackWadoURIHttpStatusCode = fallbackWadoURIHttpStatusCode;
    }

    public int fallbackWadoURIHttpStatusCode() {
        return this.fallbackWadoURIHttpStatusCode != null ? this.fallbackWadoURIHttpStatusCode.intValue() : this.getArchiveDeviceExtension().getFallbackWadoURIHttpStatusCode();
    }

    public String getExternalRetrieveAEDestination() {
        return this.externalRetrieveAEDestination;
    }

    public void setExternalRetrieveAEDestination(String externalRetrieveAEDestination) {
        this.externalRetrieveAEDestination = externalRetrieveAEDestination;
    }

    public String externalRetrieveAEDestination() {
        return this.externalRetrieveAEDestination != null ? this.externalRetrieveAEDestination : this.getArchiveDeviceExtension().getExternalRetrieveAEDestination();
    }

    public String getAlternativeCMoveSCP() {
        return this.alternativeCMoveSCP;
    }

    public void setAlternativeCMoveSCP(String alternativeCMoveSCP) {
        this.alternativeCMoveSCP = alternativeCMoveSCP;
    }

    public String alternativeCMoveSCP() {
        return this.alternativeCMoveSCP != null ? this.alternativeCMoveSCP : this.getArchiveDeviceExtension().getAlternativeCMoveSCP();
    }

    public String fallbackCMoveSCPStudyOlderThan() {
        return this.fallbackCMoveSCPStudyOlderThan != null ? this.fallbackCMoveSCPStudyOlderThan : this.getArchiveDeviceExtension().getFallbackCMoveSCPStudyOlderThan();
    }

    public Integer getQueryMaxNumberOfResults() {
        return this.queryMaxNumberOfResults;
    }

    public void setQueryMaxNumberOfResults(Integer queryMaxNumberOfResults) {
        this.queryMaxNumberOfResults = queryMaxNumberOfResults;
    }

    public int queryMaxNumberOfResults() {
        return this.queryMaxNumberOfResults != null ? this.queryMaxNumberOfResults.intValue() : this.getArchiveDeviceExtension().getQueryMaxNumberOfResults();
    }

    public Integer getQidoMaxNumberOfResults() {
        return this.qidoMaxNumberOfResults;
    }

    public void setQidoMaxNumberOfResults(Integer qidoMaxNumberOfResults) {
        this.qidoMaxNumberOfResults = qidoMaxNumberOfResults;
    }

    public int qidoMaxNumberOfResults() {
        return this.qidoMaxNumberOfResults != null ? this.qidoMaxNumberOfResults.intValue() : this.getArchiveDeviceExtension().getQidoMaxNumberOfResults();
    }

    public Boolean getQidoETag() {
        return this.qidoETag;
    }

    public void setQidoETag(Boolean qidoETag) {
        this.qidoETag = qidoETag;
    }

    public boolean qidoETag() {
        return this.qidoETag != null ? this.qidoETag.booleanValue() : this.getArchiveDeviceExtension().isQidoETag();
    }

    public Boolean getFilterByIssuerOfPatientID() {
        return this.filterByIssuerOfPatientID;
    }

    public void setFilterByIssuerOfPatientID(Boolean filterByIssuerOfPatientID) {
        this.filterByIssuerOfPatientID = filterByIssuerOfPatientID;
    }

    public boolean filterByIssuerOfPatientID() {
        return this.filterByIssuerOfPatientID != null ? this.filterByIssuerOfPatientID.booleanValue() : this.getArchiveDeviceExtension().isFilterByIssuerOfPatientID();
    }

    public Boolean getMatchSOPClassOnInstanceLevel() {
        return this.matchSOPClassOnInstanceLevel;
    }

    public void setMatchSOPClassOnInstanceLevel(Boolean matchSOPClassOnInstanceLevel) {
        this.matchSOPClassOnInstanceLevel = matchSOPClassOnInstanceLevel;
    }

    public boolean matchSOPClassOnInstanceLevel() {
        return this.matchSOPClassOnInstanceLevel != null ? this.matchSOPClassOnInstanceLevel.booleanValue() : this.getArchiveDeviceExtension().isMatchSOPClassOnInstanceLevel();
    }

    public SPSStatus[] getHideSPSWithStatusFromMWL() {
        return this.hideSPSWithStatusFromMWL;
    }

    public void setHideSPSWithStatusFromMWL(SPSStatus[] hideSPSWithStatusFromMWL) {
        this.hideSPSWithStatusFromMWL = hideSPSWithStatusFromMWL;
    }

    public SPSStatus[] hideSPSWithStatusFromMWL() {
        return this.hideSPSWithStatusFromMWL.length > 0 ? this.hideSPSWithStatusFromMWL : this.getArchiveDeviceExtension().getHideSPSWithStatusFrom();
    }

    public SPSStatus[] getHideSPSWithStatusFromMWLRS() {
        return this.hideSPSWithStatusFromMWLRS;
    }

    public void setHideSPSWithStatusFromMWLRS(SPSStatus[] hideSPSWithStatusFromMWLRS) {
        this.hideSPSWithStatusFromMWLRS = hideSPSWithStatusFromMWLRS;
    }

    public SPSStatus[] hideSPSWithStatusFromMWLRS() {
        return this.hideSPSWithStatusFromMWLRS.length > 0 ? this.hideSPSWithStatusFromMWLRS : this.getArchiveDeviceExtension().getHideSPSWithStatusFromMWLRS();
    }

    public String getMWLAccessionNumberGenerator() {
        return this.mwlAccessionNumberGenerator;
    }

    public void setMWLAccessionNumberGenerator(String mwlAccessionNumberGenerator) {
        this.mwlAccessionNumberGenerator = mwlAccessionNumberGenerator;
    }

    public String mwlAccessionNumberGenerator() {
        return this.mwlAccessionNumberGenerator != null ? this.mwlAccessionNumberGenerator : this.getArchiveDeviceExtension().getMWLAccessionNumberGenerator();
    }

    public String getMWLRequestedProcedureIDGenerator() {
        return this.mwlRequestedProcedureIDGenerator;
    }

    public void setMWLRequestedProcedureIDGenerator(String mwlRequestedProcedureIDGenerator) {
        this.mwlRequestedProcedureIDGenerator = mwlRequestedProcedureIDGenerator;
    }

    public String mwlRequestedProcedureIDGenerator() {
        return this.mwlRequestedProcedureIDGenerator != null ? this.mwlRequestedProcedureIDGenerator : this.getArchiveDeviceExtension().getMWLRequestedProcedureIDGenerator();
    }

    public String getMWLScheduledProcedureStepIDGenerator() {
        return this.mwlScheduledProcedureStepIDGenerator;
    }

    public void setMWLScheduledProcedureStepIDGenerator(String mwlScheduledProcedureStepIDGenerator) {
        this.mwlScheduledProcedureStepIDGenerator = mwlScheduledProcedureStepIDGenerator;
    }

    public String mwlScheduledProcedureStepIDGenerator() {
        return this.mwlScheduledProcedureStepIDGenerator != null ? this.mwlScheduledProcedureStepIDGenerator : this.getArchiveDeviceExtension().getMWLScheduledProcedureStepIDGenerator();
    }

    public String getFallbackCMoveSCPStudyOlderThan() {
        return this.fallbackCMoveSCPStudyOlderThan;
    }

    public void setFallbackCMoveSCPStudyOlderThan(String fallbackCMoveSCPStudyOlderThan) {
        this.fallbackCMoveSCPStudyOlderThan = fallbackCMoveSCPStudyOlderThan;
    }

    public String getStorePermissionServiceURL() {
        return this.storePermissionServiceURL;
    }

    public void setStorePermissionServiceURL(String storePermissionServiceURL) {
        this.storePermissionServiceURL = storePermissionServiceURL;
    }

    public String storePermissionServiceURL() {
        return this.storePermissionServiceURL != null ? this.storePermissionServiceURL : this.getArchiveDeviceExtension().getStorePermissionServiceURL();
    }

    public Pattern getStorePermissionServiceResponsePattern() {
        return this.storePermissionServiceResponsePattern;
    }

    public void setStorePermissionServiceResponsePattern(Pattern storePermissionServiceResponsePattern) {
        this.storePermissionServiceResponsePattern = storePermissionServiceResponsePattern;
    }

    public Pattern storePermissionServiceResponsePattern() {
        return this.storePermissionServiceResponsePattern != null ? this.storePermissionServiceResponsePattern : this.getArchiveDeviceExtension().getStorePermissionServiceResponsePattern();
    }

    public String getStorePermissionServiceResponse() {
        return this.storePermissionServiceResponse;
    }

    public void setStorePermissionServiceResponse(String storePermissionServiceResponse) {
        this.storePermissionServiceResponse = storePermissionServiceResponse;
    }

    public String storePermissionServiceResponse() {
        return this.storePermissionServiceResponse != null ? this.storePermissionServiceResponse : this.getArchiveDeviceExtension().getStorePermissionServiceResponse();
    }

    public Pattern getStorePermissionServiceExpirationDatePattern() {
        return this.storePermissionServiceExpirationDatePattern;
    }

    public void setStorePermissionServiceExpirationDatePattern(Pattern storePermissionServiceExpirationDatePattern) {
        this.storePermissionServiceExpirationDatePattern = storePermissionServiceExpirationDatePattern;
    }

    public Pattern storePermissionServiceExpirationDatePattern() {
        return this.storePermissionServiceExpirationDatePattern != null ? this.storePermissionServiceExpirationDatePattern : this.getArchiveDeviceExtension().getStorePermissionServiceExpirationDatePattern();
    }

    public Pattern getStorePermissionServiceErrorCommentPattern() {
        return this.storePermissionServiceErrorCommentPattern;
    }

    public void setStorePermissionServiceErrorCommentPattern(Pattern storePermissionServiceErrorCommentPattern) {
        this.storePermissionServiceErrorCommentPattern = storePermissionServiceErrorCommentPattern;
    }

    public Pattern storePermissionServiceErrorCommentPattern() {
        return this.storePermissionServiceErrorCommentPattern != null ? this.storePermissionServiceErrorCommentPattern : this.getArchiveDeviceExtension().getStorePermissionServiceErrorCommentPattern();
    }

    public Pattern getStorePermissionServiceErrorCodePattern() {
        return this.storePermissionServiceErrorCodePattern;
    }

    public void setStorePermissionServiceErrorCodePattern(Pattern storePermissionServiceErrorCodePattern) {
        this.storePermissionServiceErrorCodePattern = storePermissionServiceErrorCodePattern;
    }

    public Pattern storePermissionServiceErrorCodePattern() {
        return this.storePermissionServiceErrorCodePattern != null ? this.storePermissionServiceErrorCodePattern : this.getArchiveDeviceExtension().getStorePermissionServiceErrorCodePattern();
    }

    public QueryRetrieveView getQueryRetrieveView() {
        return this.queryRetrieveViewID != null ? this.getArchiveDeviceExtension().getQueryRetrieveViewNotNull(this.queryRetrieveViewID) : null;
    }

    public AllowRejectionForDataRetentionPolicyExpired getAllowRejectionForDataRetentionPolicyExpired() {
        return this.allowRejectionForDataRetentionPolicyExpired;
    }

    public void setAllowRejectionForDataRetentionPolicyExpired(AllowRejectionForDataRetentionPolicyExpired allowRejectionForDataRetentionPolicyExpired) {
        this.allowRejectionForDataRetentionPolicyExpired = allowRejectionForDataRetentionPolicyExpired;
    }

    public AllowRejectionForDataRetentionPolicyExpired allowRejectionForDataRetentionPolicyExpired() {
        return this.allowRejectionForDataRetentionPolicyExpired != null ? this.allowRejectionForDataRetentionPolicyExpired : this.getArchiveDeviceExtension().getAllowRejectionForDataRetentionPolicyExpired();
    }

    public String[] getAcceptedMoveDestinations() {
        return this.acceptedMoveDestinations.toArray(new String[this.acceptedMoveDestinations.size()]);
    }

    public void setAcceptedMoveDestinations(String ... aets) {
        this.acceptedMoveDestinations.clear();
        for (String name : aets) {
            this.acceptedMoveDestinations.add(name);
        }
    }

    public boolean isAcceptedMoveDestination(String aet) {
        return this.acceptedMoveDestinations.isEmpty() || this.acceptedMoveDestinations.contains(aet);
    }

    public String[] getAcceptedUserRoles() {
        return this.acceptedUserRoles.toArray(new String[this.acceptedUserRoles.size()]);
    }

    public void setAcceptedUserRoles(String ... roles) {
        this.acceptedUserRoles.clear();
        for (String name : roles) {
            this.acceptedUserRoles.add(name);
        }
    }

    public boolean isAcceptedUserRole(String ... roles) {
        if (this.acceptedUserRoles.isEmpty()) {
            return true;
        }
        for (String role : roles) {
            if (!this.acceptedUserRoles.contains(role)) continue;
            return true;
        }
        return false;
    }

    public void removeUPSOnStore(UPSOnStore rule) {
        this.upsOnStoreList.remove(rule);
    }

    public void clearUPSOnStore() {
        this.upsOnStoreList.clear();
    }

    public void addUPSOnStore(UPSOnStore upsOnStore) {
        this.upsOnStoreList.add(upsOnStore);
    }

    public Collection<UPSOnStore> listUPSOnStore() {
        return this.upsOnStoreList;
    }

    public void removeUPSOnUPSCompleted(UPSOnUPSCompleted rule) {
        this.upsOnUPSCompletedList.remove(rule);
    }

    public void clearUPSOnUPSCompleted() {
        this.upsOnUPSCompletedList.clear();
    }

    public void addUPSOnUPSCompleted(UPSOnUPSCompleted upsOnUPSCompleted) {
        this.upsOnUPSCompletedList.add(upsOnUPSCompleted);
    }

    public Collection<UPSOnUPSCompleted> listUPSOnUPSCompleted() {
        return this.upsOnUPSCompletedList;
    }

    public void removeExportRule(ExportRule rule) {
        this.exportRules.remove(rule);
    }

    public void clearExportRules() {
        this.exportRules.clear();
    }

    public void addExportRule(ExportRule rule) {
        this.exportRules.add(rule);
    }

    public Collection<ExportRule> getExportRules() {
        return this.exportRules;
    }

    public void removePrefetchRule(ExportPriorsRule rule) {
        this.exportPriorsRules.remove(rule);
    }

    public void clearPrefetchRules() {
        this.exportPriorsRules.clear();
    }

    public void addPrefetchRule(ExportPriorsRule rule) {
        this.exportPriorsRules.add(rule);
    }

    public Collection<ExportPriorsRule> getExportPriorsRules() {
        return this.exportPriorsRules;
    }

    public void removeMPPSForwardRule(MPPSForwardRule rule) {
        this.mppsForwardRule.remove(rule);
    }

    public void clearMPPSForwardRules() {
        this.mppsForwardRule.clear();
    }

    public void addMPPSForwardRule(MPPSForwardRule rule) {
        this.mppsForwardRule.add(rule);
    }

    public Collection<MPPSForwardRule> getMPPSForwardRules() {
        return this.mppsForwardRule;
    }

    public void removeRSForwardRule(RSForwardRule rule) {
        this.rsForwardRules.remove(rule);
    }

    public void clearRSForwardRules() {
        this.rsForwardRules.clear();
    }

    public void addRSForwardRule(RSForwardRule rule) {
        this.rsForwardRules.add(rule);
    }

    public Collection<RSForwardRule> getRSForwardRules() {
        return this.rsForwardRules;
    }

    public void removeCompressionRule(ArchiveCompressionRule rule) {
        this.compressionRules.remove(rule);
    }

    public void clearCompressionRules() {
        this.compressionRules.clear();
    }

    public void addCompressionRule(ArchiveCompressionRule rule) {
        this.compressionRules.add(rule);
    }

    public Collection<ArchiveCompressionRule> getCompressionRules() {
        return this.compressionRules;
    }

    public void removeStudyRetentionPolicies(StudyRetentionPolicy policy) {
        this.studyRetentionPolicies.remove(policy);
    }

    public void clearStudyRetentionPolicy() {
        this.studyRetentionPolicies.clear();
    }

    public void addStudyRetentionPolicy(StudyRetentionPolicy policy) {
        this.studyRetentionPolicies.add(policy);
    }

    public Collection<StudyRetentionPolicy> getStudyRetentionPolicies() {
        return this.studyRetentionPolicies;
    }

    public void removeAttributeCoercion(ArchiveAttributeCoercion coercion) {
        this.attributeCoercions.remove(coercion);
    }

    public void clearAttributeCoercions() {
        this.attributeCoercions.clear();
    }

    public void addAttributeCoercion(ArchiveAttributeCoercion coercion) {
        this.attributeCoercions.add(coercion);
    }

    public Collection<ArchiveAttributeCoercion> getAttributeCoercions() {
        return this.attributeCoercions;
    }

    public void removeAttributeCoercion2(ArchiveAttributeCoercion2 coercion) {
        this.attributeCoercions2.remove(coercion);
    }

    public void clearAttributeCoercions2() {
        this.attributeCoercions2.clear();
    }

    public void addAttributeCoercion2(ArchiveAttributeCoercion2 coercion) {
        this.attributeCoercions2.add(coercion);
    }

    public Collection<ArchiveAttributeCoercion2> getAttributeCoercions2() {
        return this.attributeCoercions2;
    }

    public void removeStoreAccessControlIDRule(StoreAccessControlIDRule storeAccessControlIDRule) {
        this.storeAccessControlIDRules.remove(storeAccessControlIDRule);
    }

    public void clearStoreAccessControlIDRules() {
        this.storeAccessControlIDRules.clear();
    }

    public void addStoreAccessControlIDRule(StoreAccessControlIDRule storeAccessControlIDRule) {
        this.storeAccessControlIDRules.add(storeAccessControlIDRule);
    }

    public List<StoreAccessControlIDRule> getStoreAccessControlIDRules() {
        return this.storeAccessControlIDRules;
    }

    public AllowDeleteStudyPermanently getAllowDeleteStudyPermanently() {
        return this.allowDeleteStudyPermanently;
    }

    public void setAllowDeleteStudyPermanently(AllowDeleteStudyPermanently allowDeleteStudyPermanently) {
        this.allowDeleteStudyPermanently = allowDeleteStudyPermanently;
    }

    public AllowDeleteStudyPermanently allowDeleteStudy() {
        return this.allowDeleteStudyPermanently != null ? this.allowDeleteStudyPermanently : this.getArchiveDeviceExtension().getAllowDeleteStudyPermanently();
    }

    public AllowDeletePatient getAllowDeletePatient() {
        return this.allowDeletePatient;
    }

    public void setAllowDeletePatient(AllowDeletePatient allowDeletePatient) {
        this.allowDeletePatient = allowDeletePatient;
    }

    public AllowDeletePatient allowDeletePatient() {
        return this.allowDeletePatient != null ? this.allowDeletePatient : this.getArchiveDeviceExtension().getAllowDeletePatient();
    }

    public String[] getRetrieveAETitles() {
        return this.retrieveAETitles;
    }

    public void setRetrieveAETitles(String ... retrieveAETitles) {
        this.retrieveAETitles = retrieveAETitles;
    }

    public String[] retrieveAETitles() {
        return this.retrieveAETitles.length > 0 ? this.retrieveAETitles : this.getArchiveDeviceExtension().getRetrieveAETitles();
    }

    public String[] getReturnRetrieveAETitles() {
        return this.returnRetrieveAETitles;
    }

    public void setReturnRetrieveAETitles(String[] returnRetrieveAETitles) {
        this.returnRetrieveAETitles = returnRetrieveAETitles;
    }

    public String[] returnRetrieveAETitles() {
        return this.returnRetrieveAETitles.length > 0 ? this.returnRetrieveAETitles : this.getArchiveDeviceExtension().getReturnRetrieveAETitles();
    }

    public String getHL7PSUSendingApplication() {
        return this.hl7PSUSendingApplication;
    }

    public void setHL7PSUSendingApplication(String hl7PSUSendingApplication) {
        this.hl7PSUSendingApplication = hl7PSUSendingApplication;
    }

    public String hl7PSUSendingApplication() {
        return this.hl7PSUSendingApplication != null ? this.hl7PSUSendingApplication : this.getArchiveDeviceExtension().getHL7PSUSendingApplication();
    }

    public String[] getHL7PSUReceivingApplications() {
        return this.hl7PSUReceivingApplications;
    }

    public void setHL7PSUReceivingApplications(String[] hl7PSUReceivingApplications) {
        this.hl7PSUReceivingApplications = hl7PSUReceivingApplications;
    }

    public String[] hl7PSUReceivingApplications() {
        return this.hl7PSUReceivingApplications.length > 0 ? this.hl7PSUReceivingApplications : this.getArchiveDeviceExtension().getHL7PSUReceivingApplications();
    }

    public Duration getHL7PSUDelay() {
        return this.hl7PSUDelay;
    }

    public void setHL7PSUDelay(Duration hl7PSUDelay) {
        this.hl7PSUDelay = hl7PSUDelay;
    }

    public Duration hl7PSUDelay() {
        return this.hl7PSUDelay != null ? this.hl7PSUDelay : this.getArchiveDeviceExtension().getHL7PSUDelay();
    }

    public Duration getHL7PSUTimeout() {
        return this.hl7PSUTimeout;
    }

    public void setHL7PSUTimeout(Duration hl7PSUTimeout) {
        this.hl7PSUTimeout = hl7PSUTimeout;
    }

    public Duration hl7PSUTimeout() {
        return this.hl7PSUTimeout != null ? this.hl7PSUTimeout : this.getArchiveDeviceExtension().getHL7PSUTimeout();
    }

    public Boolean getHL7PSUOnTimeout() {
        return this.hl7PSUOnTimeout;
    }

    public void setHL7PSUOnTimeout(Boolean hl7PSUOnTimeout) {
        this.hl7PSUOnTimeout = hl7PSUOnTimeout;
    }

    public boolean hl7PSUOnTimeout() {
        return this.hl7PSUOnTimeout != null ? this.hl7PSUOnTimeout.booleanValue() : this.getArchiveDeviceExtension().isHL7PSUOnTimeout();
    }

    public Boolean getHL7PSUMWL() {
        return this.hl7PSUMWL;
    }

    public void setHL7PSUMWL(Boolean hl7PSUMWL) {
        this.hl7PSUMWL = hl7PSUMWL;
    }

    public boolean hl7PSUMWL() {
        return this.hl7PSUMWL != null ? this.hl7PSUMWL.booleanValue() : this.getArchiveDeviceExtension().isHL7PSUMWL();
    }

    public HL7PSUMWLMatchingKey getHL7PSUMWLMatchingKey() {
        return this.hl7PSUMWLMatchingKey;
    }

    public void setHL7PSUMWLMatchingKey(HL7PSUMWLMatchingKey hl7PSUMWLMatchingKey) {
        this.hl7PSUMWLMatchingKey = hl7PSUMWLMatchingKey;
    }

    public HL7PSUMWLMatchingKey hl7PSUMWLMatchingKey() {
        return this.hl7PSUMWLMatchingKey != null ? this.hl7PSUMWLMatchingKey : this.getArchiveDeviceExtension().getHL7PSUMWLMatchingKey();
    }

    public Boolean getHl7PSUForRequestedProcedure() {
        return this.hl7PSUForRequestedProcedure;
    }

    public void setHl7PSUForRequestedProcedure(Boolean hl7PSUForRequestedProcedure) {
        this.hl7PSUForRequestedProcedure = hl7PSUForRequestedProcedure;
    }

    public boolean hl7PSUForRequestedProcedure() {
        return this.hl7PSUForRequestedProcedure != null ? this.hl7PSUForRequestedProcedure.booleanValue() : this.getArchiveDeviceExtension().isHl7PSUForRequestedProcedure();
    }

    public Boolean getHl7PSUPIDPV1() {
        return this.hl7PSUPIDPV1;
    }

    public void setHl7PSUPIDPV1(Boolean hl7PSUPIDPV1) {
        this.hl7PSUPIDPV1 = hl7PSUPIDPV1;
    }

    public boolean hl7PSUPIDPV1() {
        return this.hl7PSUPIDPV1 != null ? this.hl7PSUPIDPV1.booleanValue() : this.getArchiveDeviceExtension().isHl7PSUPIDPV1();
    }

    public String getHl7PSURequestedProcedureID() {
        return this.hl7PSURequestedProcedureID;
    }

    public void setHl7PSURequestedProcedureID(String hl7PSURequestedProcedureID) {
        this.hl7PSURequestedProcedureID = hl7PSURequestedProcedureID;
    }

    public String hl7PSURequestedProcedureID() {
        return this.hl7PSURequestedProcedureID != null ? this.hl7PSURequestedProcedureID : this.getArchiveDeviceExtension().getHl7PSURequestedProcedureID();
    }

    public String getHl7PSUAccessionNumber() {
        return this.hl7PSUAccessionNumber;
    }

    public void setHl7PSUAccessionNumber(String hl7PSUAccessionNumber) {
        this.hl7PSUAccessionNumber = hl7PSUAccessionNumber;
    }

    public String hl7PSUAccessionNumber() {
        return this.hl7PSUAccessionNumber != null ? this.hl7PSUAccessionNumber : this.getArchiveDeviceExtension().getHl7PSUAccessionNumber();
    }

    public String getHl7PSUFillerOrderNumber() {
        return this.hl7PSUFillerOrderNumber;
    }

    public void setHl7PSUFillerOrderNumber(String hl7PSUFillerOrderNumber) {
        this.hl7PSUFillerOrderNumber = hl7PSUFillerOrderNumber;
    }

    public String hl7PSUFillerOrderNumber() {
        return this.hl7PSUFillerOrderNumber != null ? this.hl7PSUFillerOrderNumber : this.getArchiveDeviceExtension().getHl7PSUFillerOrderNumber();
    }

    public String getHl7PSUPlacerOrderNumber() {
        return this.hl7PSUPlacerOrderNumber;
    }

    public void setHl7PSUPlacerOrderNumber(String hl7PSUPlacerOrderNumber) {
        this.hl7PSUPlacerOrderNumber = hl7PSUPlacerOrderNumber;
    }

    public String hl7PSUPlacerOrderNumber() {
        return this.hl7PSUPlacerOrderNumber != null ? this.hl7PSUPlacerOrderNumber : this.getArchiveDeviceExtension().getHl7PSUPlacerOrderNumber();
    }

    public boolean hl7PSUOnStudy() {
        return this.hl7PSUSendingApplication() != null && this.hl7PSUReceivingApplications().length > 0 && this.hl7PSUDelay() != null || this.hl7PSUDelay() != null && this.hl7PSUMWL();
    }

    public boolean hl7PSUOnMPPS() {
        return this.hl7PSUSendingApplication() != null && this.hl7PSUReceivingApplications().length > 0 && this.hl7PSUDelay() == null || this.hl7PSUDelay() == null && this.hl7PSUMWL();
    }

    public HL7PSUMessageType getHl7PSUMessageType() {
        return this.hl7PSUMessageType;
    }

    public void setHl7PSUMessageType(HL7PSUMessageType hl7PSUMessageType) {
        this.hl7PSUMessageType = hl7PSUMessageType;
    }

    public HL7PSUMessageType hl7PSUMessageType() {
        return this.hl7PSUMessageType != null ? this.hl7PSUMessageType : this.getArchiveDeviceExtension().getHl7PSUMessageType();
    }

    public Conditions getHl7PSUConditions() {
        return this.hl7PSUConditions;
    }

    public void setHl7PSUConditions(Conditions hl7PSUConditions) {
        this.hl7PSUConditions = hl7PSUConditions;
    }

    public Conditions hl7PSUConditions() {
        return !this.hl7PSUConditions.getMap().isEmpty() ? this.hl7PSUConditions : this.getArchiveDeviceExtension().getHl7PSUConditions();
    }

    public String getHl7PSUMppsTemplateURI() {
        return this.hl7PSUMppsTemplateURI;
    }

    public void setHl7PSUMppsTemplateURI(String hl7PSUMppsTemplateURI) {
        this.hl7PSUMppsTemplateURI = hl7PSUMppsTemplateURI;
    }

    public String hl7PSUMppsTemplateURI() {
        return this.hl7PSUMppsTemplateURI != null ? this.hl7PSUMppsTemplateURI : this.getArchiveDeviceExtension().getHl7PSUMppsTemplateURI();
    }

    public String getHl7PSUStudyTemplateURI() {
        return this.hl7PSUStudyTemplateURI;
    }

    public void setHl7PSUStudyTemplateURI(String hl7PSUStudyTemplateURI) {
        this.hl7PSUStudyTemplateURI = hl7PSUStudyTemplateURI;
    }

    public String hl7PSUStudyTemplateURI() {
        return this.hl7PSUStudyTemplateURI != null ? this.hl7PSUStudyTemplateURI : this.getArchiveDeviceExtension().getHl7PSUStudyTemplateURI();
    }

    public Map<String, String> hl7PSUTemplateParams() {
        return !this.hl7PSUTemplateParams.isEmpty() ? this.hl7PSUTemplateParams : this.getArchiveDeviceExtension().getHL7PSUTemplateParams();
    }

    public Map<String, String> getHL7PSUTemplateParams() {
        return this.hl7PSUTemplateParams;
    }

    public void setHL7PSUTemplateParam(String name, String value) {
        this.hl7PSUTemplateParams.put(name, value);
    }

    public void setHL7PSUTemplateParams(String[] ss) {
        this.hl7PSUTemplateParams.clear();
        for (String s : ss) {
            int index = s.indexOf(61);
            if (index < 0) {
                throw new IllegalArgumentException("XSLT parameter in incorrect format : " + s);
            }
            this.setHL7PSUTemplateParam(s.substring(0, index), s.substring(index + 1));
        }
    }

    public AcceptConflictingPatientID getAcceptConflictingPatientID() {
        return this.acceptConflictingPatientID;
    }

    public void setAcceptConflictingPatientID(AcceptConflictingPatientID acceptConflictingPatientID) {
        this.acceptConflictingPatientID = acceptConflictingPatientID;
    }

    public AcceptConflictingPatientID acceptConflictingPatientID() {
        return this.acceptConflictingPatientID != null ? this.acceptConflictingPatientID : this.getArchiveDeviceExtension().getAcceptConflictingPatientID();
    }

    public UserIdentityNegotiation getUserIdentityNegotiation() {
        return this.userIdentityNegotiation;
    }

    public void setUserIdentityNegotiation(UserIdentityNegotiation userIdentityNegotiation) {
        this.userIdentityNegotiation = userIdentityNegotiation;
    }

    public UserIdentityNegotiation userIdentityNegotiation() {
        return this.userIdentityNegotiation != null ? this.userIdentityNegotiation : this.getArchiveDeviceExtension().getUserIdentityNegotiation();
    }

    public String getUserIdentityNegotiationRole() {
        return this.userIdentityNegotiationRole;
    }

    public void setUserIdentityNegotiationRole(String userIdentityNegotiationRole) {
        this.userIdentityNegotiationRole = userIdentityNegotiationRole;
    }

    public String userIdentityNegotiationRole() {
        return this.userIdentityNegotiationRole != null ? this.userIdentityNegotiationRole : this.getArchiveDeviceExtension().getUserIdentityNegotiationRole();
    }

    public String getUserIdentityNegotiationKeycloakClientID() {
        return this.userIdentityNegotiationKeycloakClientID;
    }

    public void setUserIdentityNegotiationKeycloakClientID(String userIdentityNegotiationKeycloakClientID) {
        this.userIdentityNegotiationKeycloakClientID = userIdentityNegotiationKeycloakClientID;
    }

    public String userIdentityNegotiationKeycloakClientID() {
        return this.userIdentityNegotiationKeycloakClientID != null ? this.userIdentityNegotiationKeycloakClientID : this.getArchiveDeviceExtension().getUserIdentityNegotiationKeycloakClientID();
    }

    public Attributes.UpdatePolicy getCopyMoveUpdatePolicy() {
        return this.copyMoveUpdatePolicy;
    }

    public void setCopyMoveUpdatePolicy(Attributes.UpdatePolicy copyMoveUpdatePolicy) {
        this.copyMoveUpdatePolicy = copyMoveUpdatePolicy;
    }

    public Attributes.UpdatePolicy copyMoveUpdatePolicy() {
        return this.copyMoveUpdatePolicy != null ? this.copyMoveUpdatePolicy : this.getArchiveDeviceExtension().getCopyMoveUpdatePolicy();
    }

    public Attributes.UpdatePolicy getLinkMWLEntryUpdatePolicy() {
        return this.linkMWLEntryUpdatePolicy;
    }

    public void setLinkMWLEntryUpdatePolicy(Attributes.UpdatePolicy linkMWLEntryUpdatePolicy) {
        this.linkMWLEntryUpdatePolicy = linkMWLEntryUpdatePolicy;
    }

    public Attributes.UpdatePolicy linkMWLEntryUpdatePolicy() {
        return this.linkMWLEntryUpdatePolicy != null ? this.linkMWLEntryUpdatePolicy : this.getArchiveDeviceExtension().getLinkMWLEntryUpdatePolicy();
    }

    public StorageVerificationPolicy getStorageVerificationPolicy() {
        return this.storageVerificationPolicy;
    }

    public void setStorageVerificationPolicy(StorageVerificationPolicy storageVerificationPolicy) {
        this.storageVerificationPolicy = storageVerificationPolicy;
    }

    public StorageVerificationPolicy storageVerificationPolicy() {
        return this.storageVerificationPolicy != null ? this.storageVerificationPolicy : this.getArchiveDeviceExtension().getStorageVerificationPolicy();
    }

    public Boolean getStorageVerificationUpdateLocationStatus() {
        return this.storageVerificationUpdateLocationStatus;
    }

    public void setStorageVerificationUpdateLocationStatus(Boolean storageVerificationUpdateLocationStatus) {
        this.storageVerificationUpdateLocationStatus = storageVerificationUpdateLocationStatus;
    }

    public boolean storageVerificationUpdateLocationStatus() {
        return this.storageVerificationUpdateLocationStatus != null ? this.storageVerificationUpdateLocationStatus.booleanValue() : this.getArchiveDeviceExtension().isStorageVerificationUpdateLocationStatus();
    }

    public String[] getStorageVerificationStorageIDs() {
        return this.storageVerificationStorageIDs;
    }

    public void setStorageVerificationStorageIDs(String ... storageVerificationStorageIDs) {
        this.storageVerificationStorageIDs = storageVerificationStorageIDs;
    }

    public String[] storageVerificationStorageIDs() {
        return this.storageVerificationStorageIDs.length > 0 ? this.storageVerificationStorageIDs : this.getArchiveDeviceExtension().getStorageVerificationStorageIDs();
    }

    public Period getStorageVerificationInitialDelay() {
        return this.storageVerificationInitialDelay;
    }

    public void setStorageVerificationInitialDelay(Period storageVerificationInitialDelay) {
        this.storageVerificationInitialDelay = storageVerificationInitialDelay;
    }

    public Period storageVerificationInitialDelay() {
        ArchiveDeviceExtension arcdev = this.getArchiveDeviceExtension();
        return this.storageVerificationInitialDelay != null ? this.storageVerificationInitialDelay : arcdev.getStorageVerificationInitialDelay();
    }

    public Boolean getUpdateLocationStatusOnRetrieve() {
        return this.updateLocationStatusOnRetrieve;
    }

    public void setUpdateLocationStatusOnRetrieve(Boolean updateLocationStatusOnRetrieve) {
        this.updateLocationStatusOnRetrieve = updateLocationStatusOnRetrieve;
    }

    public boolean updateLocationStatusOnRetrieve() {
        return this.updateLocationStatusOnRetrieve != null ? this.updateLocationStatusOnRetrieve.booleanValue() : this.getArchiveDeviceExtension().isUpdateLocationStatusOnRetrieve();
    }

    public Boolean getStorageVerificationOnRetrieve() {
        return this.storageVerificationOnRetrieve;
    }

    public void setStorageVerificationOnRetrieve(Boolean storageVerificationOnRetrieve) {
        this.storageVerificationOnRetrieve = storageVerificationOnRetrieve;
    }

    public boolean storageVerificationOnRetrieve() {
        return this.storageVerificationOnRetrieve != null ? this.storageVerificationOnRetrieve.booleanValue() : this.getArchiveDeviceExtension().isStorageVerificationOnRetrieve();
    }

    public Boolean getRelationalQueryNegotiationLenient() {
        return this.relationalQueryNegotiationLenient;
    }

    public void setRelationalQueryNegotiationLenient(Boolean relationalQueryNegotiationLenient) {
        this.relationalQueryNegotiationLenient = relationalQueryNegotiationLenient;
    }

    public boolean relationalQueryNegotiationLenient() {
        return this.relationalQueryNegotiationLenient != null ? this.relationalQueryNegotiationLenient.booleanValue() : this.getArchiveDeviceExtension().isRelationalQueryNegotiationLenient();
    }

    public Boolean getRelationalRetrieveNegotiationLenient() {
        return this.relationalRetrieveNegotiationLenient;
    }

    public void setRelationalRetrieveNegotiationLenient(Boolean relationalRetrieveNegotiationLenient) {
        this.relationalRetrieveNegotiationLenient = relationalRetrieveNegotiationLenient;
    }

    public boolean relationalRetrieveNegotiationLenient() {
        return this.relationalRetrieveNegotiationLenient != null ? this.relationalRetrieveNegotiationLenient.booleanValue() : this.getArchiveDeviceExtension().isRelationalRetrieveNegotiationLenient();
    }

    public int[] getRejectConflictingPatientAttribute() {
        return this.rejectConflictingPatientAttribute;
    }

    public void setRejectConflictingPatientAttribute(int[] rejectConflictingPatientAttribute) {
        this.rejectConflictingPatientAttribute = rejectConflictingPatientAttribute;
        Arrays.sort(rejectConflictingPatientAttribute);
    }

    public int[] rejectConflictingPatientAttribute() {
        return this.rejectConflictingPatientAttribute.length > 0 ? this.rejectConflictingPatientAttribute : this.getArchiveDeviceExtension().getRejectConflictingPatientAttribute();
    }

    public Boolean getStowRetiredTransferSyntax() {
        return this.stowRetiredTransferSyntax;
    }

    public void setStowRetiredTransferSyntax(Boolean stowRetiredTransferSyntax) {
        this.stowRetiredTransferSyntax = stowRetiredTransferSyntax;
    }

    public boolean stowRetiredTransferSyntax() {
        return this.stowRetiredTransferSyntax != null ? this.stowRetiredTransferSyntax.booleanValue() : this.getArchiveDeviceExtension().isStowRetiredTransferSyntax();
    }

    public Boolean getStowExcludeAPPMarkers() {
        return this.stowExcludeAPPMarkers;
    }

    public void setStowExcludeAPPMarkers(Boolean stowExcludeAPPMarkers) {
        this.stowExcludeAPPMarkers = stowExcludeAPPMarkers;
    }

    public boolean stowExcludeAPPMarkers() {
        return this.stowExcludeAPPMarkers != null ? this.stowExcludeAPPMarkers.booleanValue() : this.getArchiveDeviceExtension().isStowExcludeAPPMarkers();
    }

    public Boolean getRestrictRetrieveSilently() {
        return this.restrictRetrieveSilently;
    }

    public void setRestrictRetrieveSilently(Boolean restrictRetrieveSilently) {
        this.restrictRetrieveSilently = restrictRetrieveSilently;
    }

    public boolean restrictRetrieveSilently() {
        return this.restrictRetrieveSilently != null ? this.restrictRetrieveSilently.booleanValue() : this.getArchiveDeviceExtension().isRestrictRetrieveSilently();
    }

    public MultipleStoreAssociations[] getMultipleStoreAssociations() {
        return this.multipleStoreAssociations;
    }

    public void setMultipleStoreAssociations(String[] ss) {
        this.multipleStoreAssociations = MultipleStoreAssociations.of(ss);
    }

    public int maxStoreAssociationsTo(String aet) {
        return MultipleStoreAssociations.maxTo(aet, this.multipleStoreAssociations, this.getArchiveDeviceExtension().getMultipleStoreAssociations());
    }

    public VR[] getEncodeAsJSONNumber() {
        return this.encodeAsJSONNumber.toArray(new VR[0]);
    }

    public void setEncodeAsJSONNumber(VR[] vrs) {
        Stream.of(vrs).forEach(ArchiveDeviceExtension::requireIS_DS_SV_UV);
        this.encodeAsJSONNumber.clear();
        this.encodeAsJSONNumber.addAll(Arrays.asList(vrs));
    }

    public JSONWriter encodeAsJSONNumber(JSONWriter writer) {
        return this.getArchiveDeviceExtension().encodeAsJSONNumber(ArchiveDeviceExtension.encodeAsJSONNumber(writer, this.encodeAsJSONNumber));
    }

    public Boolean getRetrieveTaskWarningOnNoMatch() {
        return this.retrieveTaskWarningOnNoMatch;
    }

    public void setRetrieveTaskWarningOnNoMatch(Boolean retrieveTaskWarningOnNoMatch) {
        this.retrieveTaskWarningOnNoMatch = retrieveTaskWarningOnNoMatch;
    }

    public boolean retrieveTaskWarningOnNoMatch() {
        return this.retrieveTaskWarningOnNoMatch != null ? this.retrieveTaskWarningOnNoMatch.booleanValue() : this.getArchiveDeviceExtension().isRetrieveTaskWarningOnNoMatch();
    }

    public Boolean getRetrieveTaskWarningOnWarnings() {
        return this.retrieveTaskWarningOnWarnings;
    }

    public void setRetrieveTaskWarningOnWarnings(Boolean retrieveTaskWarningOnWarnings) {
        this.retrieveTaskWarningOnWarnings = retrieveTaskWarningOnWarnings;
    }

    public boolean retrieveTaskWarningOnWarnings() {
        return this.retrieveTaskWarningOnWarnings != null ? this.retrieveTaskWarningOnWarnings.booleanValue() : this.getArchiveDeviceExtension().isRetrieveTaskWarningOnWarnings();
    }

    public Boolean getStowQuicktime2MP4() {
        return this.stowQuicktime2MP4;
    }

    public void setStowQuicktime2MP4(Boolean stowQuicktime2MP4) {
        this.stowQuicktime2MP4 = stowQuicktime2MP4;
    }

    public boolean stowQuicktime2MP4() {
        return this.stowQuicktime2MP4 != null ? this.stowQuicktime2MP4.booleanValue() : this.getArchiveDeviceExtension().isStowQuicktime2MP4();
    }

    public Long getStowMaxFragmentLength() {
        return this.stowMaxFragmentLength;
    }

    public void setStowMaxFragmentLength(Long stowMaxFragmentLength) {
        if (stowMaxFragmentLength != null) {
            ArchiveDeviceExtension.checkStowMaxFragmentLength(stowMaxFragmentLength);
        }
        this.stowMaxFragmentLength = stowMaxFragmentLength;
    }

    public long stowMaxFragmentLength() {
        return this.stowMaxFragmentLength != null ? this.stowMaxFragmentLength.longValue() : this.getArchiveDeviceExtension().getStowMaxFragmentLength();
    }

    public String changeRequesterAET() {
        return this.changeRequesterAET != null ? this.changeRequesterAET : this.getArchiveDeviceExtension().getChangeRequesterAET();
    }

    public String getChangeRequesterAET() {
        return this.changeRequesterAET;
    }

    public void setChangeRequesterAET(String changeRequesterAET) {
        this.changeRequesterAET = changeRequesterAET;
    }

    public void reconfigure(AEExtension from) {
        ArchiveAEExtension aeExt = (ArchiveAEExtension)from;
        this.defaultCharacterSet = aeExt.defaultCharacterSet;
        this.mwlWorklistLabel = aeExt.mwlWorklistLabel;
        this.upsWorklistLabel = aeExt.upsWorklistLabel;
        this.upsEventSCUs = aeExt.upsEventSCUs;
        this.upsEventSCUKeepAlive = aeExt.upsEventSCUKeepAlive;
        this.upsUpdateWithoutTransactionUID = aeExt.upsUpdateWithoutTransactionUID;
        this.objectStorageIDs = aeExt.objectStorageIDs;
        this.objectStorageCount = aeExt.objectStorageCount;
        this.metadataStorageIDs = aeExt.metadataStorageIDs;
        this.bulkDataDescriptorID = aeExt.bulkDataDescriptorID;
        this.seriesMetadataDelay = aeExt.seriesMetadataDelay;
        this.purgeInstanceRecordsDelay = aeExt.purgeInstanceRecordsDelay;
        this.storeAccessControlID = aeExt.storeAccessControlID;
        this.accessControlIDs = aeExt.accessControlIDs;
        this.overwritePolicy = aeExt.overwritePolicy;
        this.recordAttributeModification = aeExt.recordAttributeModification;
        this.bulkDataSpoolDirectory = aeExt.bulkDataSpoolDirectory;
        this.queryRetrieveViewID = aeExt.queryRetrieveViewID;
        this.validateCallingAEHostname = aeExt.validateCallingAEHostname;
        this.personNameComponentOrderInsensitiveMatching = aeExt.personNameComponentOrderInsensitiveMatching;
        this.sendPendingCGet = aeExt.sendPendingCGet;
        this.sendPendingCMoveInterval = aeExt.sendPendingCMoveInterval;
        this.wadoIgnorePresentationLUTShape = aeExt.wadoIgnorePresentationLUTShape;
        this.wadoThumbnailViewPort = aeExt.wadoThumbnailViewPort;
        this.wadoZIPEntryNameFormat = aeExt.wadoZIPEntryNameFormat;
        this.wadoSR2HtmlTemplateURI = aeExt.wadoSR2HtmlTemplateURI;
        this.wadoSR2TextTemplateURI = aeExt.wadoSR2TextTemplateURI;
        this.wadoCDA2HtmlTemplateURI = aeExt.wadoCDA2HtmlTemplateURI;
        this.mppsForwardDestinations = aeExt.mppsForwardDestinations;
        this.ianDestinations = aeExt.ianDestinations;
        this.ianDelay = aeExt.ianDelay;
        this.ianTimeout = aeExt.ianTimeout;
        this.ianOnTimeout = aeExt.ianOnTimeout;
        this.spanningCFindSCP = aeExt.spanningCFindSCP;
        this.spanningCFindSCPRetrieveAETitles = aeExt.spanningCFindSCPRetrieveAETitles;
        this.spanningCFindSCPPolicy = aeExt.spanningCFindSCPPolicy;
        this.fallbackCMoveSCP = aeExt.fallbackCMoveSCP;
        this.fallbackCMoveSCPDestination = aeExt.fallbackCMoveSCPDestination;
        this.fallbackCMoveSCPCallingAET = aeExt.fallbackCMoveSCPCallingAET;
        this.fallbackCMoveSCPLeadingCFindSCP = aeExt.fallbackCMoveSCPLeadingCFindSCP;
        this.fallbackCMoveSCPRetries = aeExt.fallbackCMoveSCPRetries;
        this.fallbackWadoURIWebApplication = aeExt.fallbackWadoURIWebApplication;
        this.fallbackWadoURIHttpStatusCode = aeExt.fallbackWadoURIHttpStatusCode;
        this.externalRetrieveAEDestination = aeExt.externalRetrieveAEDestination;
        this.alternativeCMoveSCP = aeExt.alternativeCMoveSCP;
        this.queryMaxNumberOfResults = aeExt.queryMaxNumberOfResults;
        this.qidoMaxNumberOfResults = aeExt.qidoMaxNumberOfResults;
        this.qidoETag = aeExt.qidoETag;
        this.filterByIssuerOfPatientID = aeExt.filterByIssuerOfPatientID;
        this.matchSOPClassOnInstanceLevel = aeExt.matchSOPClassOnInstanceLevel;
        this.hideSPSWithStatusFromMWL = aeExt.hideSPSWithStatusFromMWL;
        this.hideSPSWithStatusFromMWLRS = aeExt.hideSPSWithStatusFromMWLRS;
        this.mwlAccessionNumberGenerator = aeExt.mwlAccessionNumberGenerator;
        this.mwlRequestedProcedureIDGenerator = aeExt.mwlRequestedProcedureIDGenerator;
        this.mwlScheduledProcedureStepIDGenerator = aeExt.mwlScheduledProcedureStepIDGenerator;
        this.fallbackCMoveSCPStudyOlderThan = aeExt.fallbackCMoveSCPStudyOlderThan;
        this.storePermissionServiceURL = aeExt.storePermissionServiceURL;
        this.storePermissionServiceResponse = aeExt.storePermissionServiceResponse;
        this.storePermissionServiceResponsePattern = aeExt.storePermissionServiceResponsePattern;
        this.storePermissionServiceExpirationDatePattern = aeExt.storePermissionServiceExpirationDatePattern;
        this.storePermissionServiceErrorCommentPattern = aeExt.storePermissionServiceErrorCommentPattern;
        this.storePermissionServiceErrorCodePattern = aeExt.storePermissionServiceErrorCodePattern;
        this.allowRejectionForDataRetentionPolicyExpired = aeExt.allowRejectionForDataRetentionPolicyExpired;
        this.acceptMissingPatientID = aeExt.acceptMissingPatientID;
        this.allowDeleteStudyPermanently = aeExt.allowDeleteStudyPermanently;
        this.allowDeletePatient = aeExt.allowDeletePatient;
        this.acceptConflictingPatientID = aeExt.acceptConflictingPatientID;
        this.userIdentityNegotiation = aeExt.userIdentityNegotiation;
        this.userIdentityNegotiationRole = aeExt.userIdentityNegotiationRole;
        this.userIdentityNegotiationKeycloakClientID = aeExt.userIdentityNegotiationKeycloakClientID;
        this.copyMoveUpdatePolicy = aeExt.copyMoveUpdatePolicy;
        this.linkMWLEntryUpdatePolicy = aeExt.linkMWLEntryUpdatePolicy;
        this.retrieveAETitles = aeExt.retrieveAETitles;
        this.returnRetrieveAETitles = aeExt.returnRetrieveAETitles;
        this.hl7PSUSendingApplication = aeExt.hl7PSUSendingApplication;
        this.hl7PSUReceivingApplications = aeExt.hl7PSUReceivingApplications;
        this.hl7PSUDelay = aeExt.hl7PSUDelay;
        this.hl7PSUTimeout = aeExt.hl7PSUTimeout;
        this.hl7PSUOnTimeout = aeExt.hl7PSUOnTimeout;
        this.hl7PSUMWL = aeExt.hl7PSUMWL;
        this.hl7PSUMWLMatchingKey = aeExt.hl7PSUMWLMatchingKey;
        this.hl7PSUForRequestedProcedure = aeExt.hl7PSUForRequestedProcedure;
        this.hl7PSUPIDPV1 = aeExt.hl7PSUPIDPV1;
        this.hl7PSURequestedProcedureID = aeExt.hl7PSURequestedProcedureID;
        this.hl7PSUAccessionNumber = aeExt.hl7PSUAccessionNumber;
        this.hl7PSUFillerOrderNumber = aeExt.hl7PSUFillerOrderNumber;
        this.hl7PSUPlacerOrderNumber = aeExt.hl7PSUPlacerOrderNumber;
        this.hl7PSUMessageType = aeExt.hl7PSUMessageType;
        this.hl7PSUConditions = aeExt.hl7PSUConditions;
        this.hl7PSUMppsTemplateURI = aeExt.hl7PSUMppsTemplateURI;
        this.hl7PSUStudyTemplateURI = aeExt.hl7PSUStudyTemplateURI;
        this.storageVerificationPolicy = aeExt.storageVerificationPolicy;
        this.storageVerificationUpdateLocationStatus = aeExt.storageVerificationUpdateLocationStatus;
        this.storageVerificationStorageIDs = aeExt.storageVerificationStorageIDs;
        this.storageVerificationInitialDelay = aeExt.storageVerificationInitialDelay;
        this.updateLocationStatusOnRetrieve = aeExt.updateLocationStatusOnRetrieve;
        this.storageVerificationOnRetrieve = aeExt.storageVerificationOnRetrieve;
        this.relationalQueryNegotiationLenient = aeExt.relationalQueryNegotiationLenient;
        this.relationalRetrieveNegotiationLenient = aeExt.relationalRetrieveNegotiationLenient;
        this.rejectConflictingPatientAttribute = aeExt.rejectConflictingPatientAttribute;
        this.stowRetiredTransferSyntax = aeExt.stowRetiredTransferSyntax;
        this.stowExcludeAPPMarkers = aeExt.stowExcludeAPPMarkers;
        this.restrictRetrieveSilently = aeExt.restrictRetrieveSilently;
        this.retrieveTaskWarningOnNoMatch = aeExt.retrieveTaskWarningOnNoMatch;
        this.retrieveTaskWarningOnWarnings = aeExt.retrieveTaskWarningOnWarnings;
        this.stowQuicktime2MP4 = aeExt.stowQuicktime2MP4;
        this.stowMaxFragmentLength = aeExt.stowMaxFragmentLength;
        this.multipleStoreAssociations = aeExt.multipleStoreAssociations;
        this.changeRequesterAET = aeExt.changeRequesterAET;
        this.encodeAsJSONNumber.clear();
        this.encodeAsJSONNumber.addAll(aeExt.encodeAsJSONNumber);
        this.acceptedMoveDestinations.clear();
        this.acceptedMoveDestinations.addAll(aeExt.acceptedMoveDestinations);
        this.acceptedUserRoles.clear();
        this.acceptedUserRoles.addAll(aeExt.acceptedUserRoles);
        this.upsOnStoreList.clear();
        this.upsOnStoreList.addAll(aeExt.upsOnStoreList);
        this.upsOnUPSCompletedList.clear();
        this.upsOnUPSCompletedList.addAll(aeExt.upsOnUPSCompletedList);
        this.exportRules.clear();
        this.exportRules.addAll(aeExt.exportRules);
        this.exportPriorsRules.clear();
        this.exportPriorsRules.addAll(aeExt.exportPriorsRules);
        this.mppsForwardRule.clear();
        this.mppsForwardRule.addAll(aeExt.mppsForwardRule);
        this.rsForwardRules.clear();
        this.rsForwardRules.addAll(aeExt.rsForwardRules);
        this.compressionRules.clear();
        this.compressionRules.addAll(aeExt.compressionRules);
        this.studyRetentionPolicies.clear();
        this.studyRetentionPolicies.addAll(aeExt.studyRetentionPolicies);
        this.attributeCoercions.clear();
        this.attributeCoercions.addAll(aeExt.attributeCoercions);
        this.attributeCoercions2.clear();
        this.attributeCoercions2.addAll(aeExt.attributeCoercions2);
        this.storeAccessControlIDRules.clear();
        this.storeAccessControlIDRules.addAll(aeExt.storeAccessControlIDRules);
        this.hl7PSUTemplateParams.clear();
        this.hl7PSUTemplateParams.putAll(aeExt.hl7PSUTemplateParams);
    }

    public ArchiveDeviceExtension getArchiveDeviceExtension() {
        return (ArchiveDeviceExtension)this.ae.getDevice().getDeviceExtension(ArchiveDeviceExtension.class);
    }

    public Stream<ExportRule> exportRules() {
        return Stream.concat(this.exportRules.stream(), this.getArchiveDeviceExtension().getExportRules().stream());
    }

    public Stream<MPPSForwardRule> mppsForwardRule() {
        return Stream.concat(this.mppsForwardRule.stream(), this.getArchiveDeviceExtension().getMPPSForwardRules().stream());
    }

    public Stream<UPSOnStore> upsOnStoreStream() {
        return Stream.concat(this.upsOnStoreList.stream(), this.getArchiveDeviceExtension().listUPSOnStore().stream());
    }

    public Stream<UPSOnUPSCompleted> upsOnUPSCompletedStream() {
        return Stream.concat(this.upsOnUPSCompletedList.stream(), this.getArchiveDeviceExtension().listUPSOnUPSCompleted().stream());
    }

    public Stream<ExportPriorsRule> prefetchRules() {
        return Stream.concat(this.exportPriorsRules.stream(), this.getArchiveDeviceExtension().getExportPriorsRules().stream());
    }

    public Stream<RSForwardRule> rsForwardRules() {
        return Stream.concat(this.rsForwardRules.stream(), this.getArchiveDeviceExtension().getRSForwardRules().stream());
    }

    public Stream<ArchiveCompressionRule> compressionRules() {
        return Stream.concat(this.compressionRules.stream(), this.getArchiveDeviceExtension().getCompressionRules().stream()).sorted(Comparator.comparingInt(ArchiveCompressionRule::getPriority).reversed());
    }

    public Stream<ArchiveAttributeCoercion> attributeCoercions() {
        return Stream.concat(this.attributeCoercions.stream(), this.getArchiveDeviceExtension().getAttributeCoercions().stream()).sorted(Comparator.comparingInt(ArchiveAttributeCoercion::getPriority).reversed());
    }

    public ArchiveAttributeCoercion findAttributeCoercion(Dimse dimse, TransferCapability.Role role, String sopClass, String sendingHost, String sendingAET, String receivingHost, String receivingAET, Attributes attrs) {
        return this.attributeCoercions().filter(coercion -> coercion.match(role, dimse, sopClass, sendingHost, sendingAET, receivingHost, receivingAET, attrs)).findFirst().orElse(null);
    }

    public Stream<ArchiveAttributeCoercion2> attributeCoercions2() {
        return Stream.concat(this.attributeCoercions2.stream(), this.getArchiveDeviceExtension().getAttributeCoercions2().stream()).sorted(Comparator.comparingInt(ArchiveAttributeCoercion2::getPriority).reversed());
    }

    public Stream<StudyRetentionPolicy> studyRetentionPolicies() {
        return Stream.concat(this.studyRetentionPolicies.stream(), this.getArchiveDeviceExtension().getStudyRetentionPolicies().stream()).sorted(Comparator.comparingInt(StudyRetentionPolicy::getPriority).reversed());
    }

    public StudyRetentionPolicy findStudyRetentionPolicy(String sendingHost, String sendingAET, String receivingHost, String receivingAET, Attributes attrs) {
        return this.studyRetentionPolicies().filter(policy -> policy.match(sendingHost, sendingAET, receivingHost, receivingAET, attrs)).findFirst().orElse(null);
    }

    public Stream<StoreAccessControlIDRule> storeAccessControlIDRules() {
        return Stream.concat(this.storeAccessControlIDRules.stream(), this.getArchiveDeviceExtension().getStoreAccessControlIDRules().stream()).sorted(Comparator.comparingInt(StoreAccessControlIDRule::getPriority).reversed());
    }
}

