/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.coerce.impl;

import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.transform.Templates;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.io.SAXTransformer;
import org.dcm4che3.io.TemplatesCache;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.Cache;
import org.dcm4chee.arc.MergeMWLCache;
import org.dcm4chee.arc.MergeMWLQueryParam;
import org.dcm4chee.arc.coerce.CoercionProcessor;
import org.dcm4chee.arc.conf.ArchiveAttributeCoercion2;
import org.dcm4chee.arc.conf.MergeMWLMatchingKey;
import org.dcm4chee.arc.conf.SPSStatus;
import org.dcm4chee.arc.query.QueryService;
import org.dcm4chee.arc.query.scu.CFindSCU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Named(value="merge-mwl")
public class MergeMWLCoercionProcessor
implements CoercionProcessor {
    static final Logger LOG = LoggerFactory.getLogger(MergeMWLCoercionProcessor.class);
    @Inject
    private Device device;
    @Inject
    private MergeMWLCache mergeMWLCache;
    @Inject
    private QueryService queryService;
    @Inject
    private CFindSCU cfindscu;

    public boolean coerce(ArchiveAttributeCoercion2 coercion, String sopClassUID, String sendingHost, String sendingAET, String receivingHost, String receivingAET, Attributes attrs, Attributes modified) throws Exception {
        Attributes newAttrs = this.queryMWL(coercion.getRole() == TransferCapability.Role.SCU ? receivingAET : sendingAET, MergeMWLCoercionProcessor.mergeMWLQueryParam(coercion, attrs), coercion.parseBooleanCoercionParam("filter-by-scu"), coercion.getSchemeSpecificPart(), coercion.parseBooleanCoercionParam("xsl-no-keyword"));
        if (newAttrs == null) {
            return false;
        }
        LOG.info("Coerce Request Attributes from matching MWL item coerced using {}", (Object)coercion);
        Attributes.unifyCharacterSets((Attributes[])new Attributes[]{attrs, newAttrs});
        if (modified != null) {
            attrs.update(Attributes.UpdatePolicy.OVERWRITE, newAttrs, modified);
        } else {
            attrs.addAll(newAttrs);
        }
        return true;
    }

    private static MergeMWLQueryParam mergeMWLQueryParam(ArchiveAttributeCoercion2 coercion, Attributes attrs) {
        MergeMWLMatchingKey mergeMWLMatchingKey = MergeMWLMatchingKey.valueOf((String)coercion.getCoercionParam("match-by", MergeMWLMatchingKey.ScheduledProcedureStepID.name()));
        String mwlSCP = coercion.getCoercionParam("mwl-scp", null);
        String localMwlWorklistLabels = coercion.getCoercionParam("local-mwl-worklist-label", null);
        String localMwlStatus = coercion.getCoercionParam("local-mwl-status", null);
        return MergeMWLQueryParam.valueOf((String)mwlSCP, (String[])StringUtils.split((String)localMwlWorklistLabels, (char)'|'), (SPSStatus[])SPSStatus.valuesOf((String[])StringUtils.split((String)localMwlStatus, (char)'|')), (MergeMWLMatchingKey)mergeMWLMatchingKey, (Attributes)attrs, (String)coercion.getSchemeSpecificPart());
    }

    private Attributes queryMWL(String localAET, MergeMWLQueryParam queryParam, boolean filterbyscu, String tplURI, boolean xslnokeyword) throws Exception {
        List mwlItems;
        Cache.Entry entry = this.mergeMWLCache.getEntry((Object)queryParam);
        if (entry != null) {
            return (Attributes)entry.value();
        }
        LOG.info("Query for MWL Items with {}", (Object)queryParam);
        if (queryParam.mwlSCP == null) {
            mwlItems = this.queryService.queryMWL(queryParam);
            LOG.info("Found {} matching MWL Items in {}", (Object)mwlItems.size(), (Object)localAET);
        } else {
            mwlItems = this.cfindscu.findMWLItems(this.device.getApplicationEntity(localAET, true), queryParam, 0);
            if (filterbyscu) {
                mwlItems.removeIf(item -> !item.matches(queryParam.setMatchingKeys(new Attributes()), false, false));
            }
            LOG.info("Found {} matching MWL Items in {}", (Object)mwlItems.size(), (Object)queryParam.mwlSCP);
        }
        if (mwlItems.isEmpty()) {
            this.mergeMWLCache.put((Object)queryParam, null);
            return null;
        }
        Attributes result = null;
        Sequence reqAttrsSeq = null;
        Templates tpls = TemplatesCache.getDefault().get(StringUtils.replaceSystemProperties((String)tplURI));
        Collections.sort(mwlItems, Comparator.comparing(MergeMWLCoercionProcessor::startDateTime).reversed());
        for (Attributes mwlItem : mwlItems) {
            Attributes attrs = SAXTransformer.transform((Attributes)mwlItem, (Templates)tpls, (boolean)false, (!xslnokeyword ? 1 : 0) != 0);
            if (reqAttrsSeq == null) {
                result = attrs;
                reqAttrsSeq = attrs.getSequence(4194933);
                continue;
            }
            reqAttrsSeq.add(new Attributes(attrs.getNestedDataset(4194933)));
        }
        this.mergeMWLCache.put((Object)queryParam, result);
        return result;
    }

    private static Date startDateTime(Attributes mwlItem) {
        Date date;
        Attributes item = mwlItem.getNestedDataset(0x400100);
        return item != null && (date = item.getDate(18014407103610883L)) != null ? date : new Date(0L);
    }
}

