/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.audit;

import java.net.URLEncoder;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dcm4che3.net.audit.AuditLogger;
import org.dcm4che3.net.audit.AuditLoggerDeviceExtension;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.Scheduler;
import org.dcm4chee.arc.audit.AuditService;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class AuditScheduler
extends Scheduler {
    private static final Logger LOG = LoggerFactory.getLogger(AuditScheduler.class);
    private static final String FAILED = ".failed";
    @Inject
    private AuditService service;

    protected AuditScheduler() {
        super(Scheduler.Mode.scheduleWithFixedDelay);
    }

    protected Logger log() {
        return LOG;
    }

    protected Duration getPollingInterval() {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        return arcDev != null && arcDev.isAuditAggregate() ? arcDev.getAuditPollingInterval() : null;
    }

    protected void execute() {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        AuditLoggerDeviceExtension ext = (AuditLoggerDeviceExtension)this.device.getDeviceExtension(AuditLoggerDeviceExtension.class);
        String auditSpoolDir = arcDev.getAuditSpoolDirectory();
        Duration duration = arcDev.getAuditAggregateDuration();
        if (ext == null || auditSpoolDir == null || duration == null) {
            return;
        }
        for (AuditLogger logger : ext.getAuditLoggers()) {
            if (!logger.isInstalled()) continue;
            try {
                Path dir = Paths.get(StringUtils.replaceSystemProperties((String)auditSpoolDir), new String[0]).resolve(URLEncoder.encode(logger.getCommonName(), "UTF-8"));
                if (!Files.isDirectory(dir, new LinkOption[0])) continue;
                long maxLastModifiedTime = System.currentTimeMillis() - duration.getSeconds() * 1000L;
                DirectoryStream<Path> dirStream = Files.newDirectoryStream(dir, file -> !file.getFileName().toString().endsWith(FAILED) && Files.getLastModifiedTime(file, new LinkOption[0]).toMillis() <= maxLastModifiedTime);
                try {
                    for (Path path : dirStream) {
                        if (arcDev.getAuditPollingInterval() == null) {
                            return;
                        }
                        this.service.auditAndProcessFile(logger, path);
                    }
                }
                finally {
                    if (dirStream == null) continue;
                    dirStream.close();
                }
            }
            catch (Exception e) {
                LOG.warn("Failed to access Audit Spool Directory for logger - {}", (Object)logger, (Object)e);
            }
        }
    }
}

