/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.xroad.rs;

import java.io.OutputStream;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.json.JSONWriter;
import org.dcm4che3.net.Device;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.xroad.XRoadException;
import org.dcm4chee.arc.xroad.XRoadServiceProvider;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="/xroad")
public class XRoadRS {
    private static final Logger LOG = LoggerFactory.getLogger(XRoadRS.class);
    @Context
    private HttpServletRequest request;
    @Inject
    private Device device;
    @Inject
    private XRoadServiceProvider service;

    @GET
    @NoCache
    @Path(value="/RR441/{PatientID}")
    @Produces(value={"application/dicom+json,application/json"})
    public Response rr441(@PathParam(value="PatientID") IDWithIssuer patientID) throws Exception {
        Attributes attrs;
        this.logRequest();
        Map props = ((ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class)).getXRoadProperties();
        String endpoint = (String)props.get("endpoint");
        if (endpoint == null) {
            throw new ConfigurationException("Missing XRoadProperty endpoint");
        }
        try {
            attrs = this.service.rr441(endpoint, props, patientID.getID());
        }
        catch (XRoadException e) {
            return this.errResponse(e.getMessage(), Response.Status.BAD_GATEWAY);
        }
        return (attrs == null ? Response.status((Response.Status)Response.Status.NOT_FOUND) : Response.ok((Object)this.toJSON(attrs))).build();
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.request.getRequestURI(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private Response errResponse(String errorMessage, Response.Status status) {
        return Response.status((Response.Status)status).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)("{\"errorMessage\":\"" + errorMessage + "\"}")).build();
    }

    private StreamingOutput toJSON(Attributes attrs) {
        return out -> {
            try (JsonGenerator gen = Json.createGenerator((OutputStream)out);){
                ((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).encodeAsJSONNumber(new JSONWriter(gen)).write(attrs);
            }
        };
    }
}

