/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.wado;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.StreamingOutput;
import org.dcm4che3.ws.rs.MediaTypes;
import org.dcm4chee.arc.wado.RenderedImageOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThumbnailOutput
implements StreamingOutput {
    private static final Logger LOG = LoggerFactory.getLogger(ThumbnailOutput.class);
    private final File file;
    private final int rows;
    private final int columns;
    private final ImageWriter writer;
    private final MediaType mediaType;

    public ThumbnailOutput(File file, int rows, int columns, MediaType mediaType) {
        this.file = file;
        this.rows = rows;
        this.columns = columns;
        this.writer = RenderedImageOutput.getImageWriter(mediaType);
        this.mediaType = mediaType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream out) throws IOException, WebApplicationException {
        LOG.debug("Start writing thumbnail {}", (Object)this.file);
        BufferedImage bi = ImageIO.read(this.file);
        if (bi.getHeight() != this.rows || bi.getWidth() != this.columns) {
            bi = RenderedImageOutput.rescale(bi, this.rows, this.columns, 1.0f);
        }
        if (this.mediaType.equals((Object)MediaTypes.IMAGE_JPEG_TYPE)) {
            bi = ThumbnailOutput.toRGB(bi);
        }
        try (MemoryCacheImageOutputStream imageOut = new MemoryCacheImageOutputStream(out);){
            this.writer.setOutput(imageOut);
            LOG.debug("Start writing thumbnail {}", (Object)this.file.getName());
            this.writer.write(new IIOImage(bi, null, null));
            LOG.debug("Finished writing thumbnail {}", (Object)this.file.getName());
        }
        finally {
            this.writer.dispose();
        }
    }

    private static BufferedImage toRGB(BufferedImage src) {
        BufferedImage dest = new BufferedImage(src.getWidth(), src.getHeight(), 1);
        dest.createGraphics().drawImage(src, 0, 0, Color.WHITE, null);
        return dest;
    }
}

