/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.wado;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.core.StreamingOutput;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.util.StreamUtils;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.retrieve.RetrieveService;
import org.dcm4chee.arc.store.InstanceLocations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressedPixelDataOutput
implements StreamingOutput {
    private static final Logger LOG = LoggerFactory.getLogger(CompressedPixelDataOutput.class);
    private final RetrieveContext ctx;
    private final InstanceLocations inst;

    public CompressedPixelDataOutput(RetrieveContext ctx, InstanceLocations inst) {
        this.ctx = ctx;
        this.inst = inst;
    }

    public void write(OutputStream out) throws IOException {
        RetrieveService service = this.ctx.getRetrieveService();
        try (DicomInputStream dis = service.openDicomInputStream(this.ctx, this.inst);){
            dis.readDataset(-1, 2145386512);
            if (dis.tag() != 2145386512 || dis.length() != -1 || !dis.readItemHeader()) {
                throw new IOException("No or incorrect encapsulated compressed pixel data in requested object");
            }
            dis.skipFully((long)dis.length());
            LOG.debug("Start writing compressed pixel data of {}", (Object)this.inst);
            while (dis.readItemHeader()) {
                StreamUtils.copy((InputStream)dis, (OutputStream)out, (int)dis.length());
            }
            LOG.debug("Finished writing compressed pixel data of {}", (Object)this.inst);
        }
    }
}

