/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.wado;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.dcm4che3.util.SafeClose;
import org.dcm4che3.util.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CDAOutput
implements StreamingOutput {
    private static final Logger LOG = LoggerFactory.getLogger(CDAOutput.class);
    private static final int COPY_BUFFER_SIZE = 2048;
    private static final byte[] CLINICAL_DOCUMENT = new byte[]{60, 67, 108, 105, 110, 105, 99, 97, 108, 68, 111, 99, 117, 109, 101, 110, 116};
    private static final byte[] XML_STYLESHEET = new byte[]{60, 63, 120, 109, 108, 45, 115, 116, 121, 108, 101, 115, 104, 101, 101, 116};
    private static final byte[] TYPE_TEXT_XSL_HREF = new byte[]{32, 116, 121, 112, 101, 61, 34, 116, 101, 120, 116, 47, 120, 115, 108, 34, 32, 104, 114, 101, 102, 61, 34};
    private static final byte[] PROCESSING_INSTRUCTION_END = new byte[]{34, 63, 62};
    private final InputStream in;
    private final int length;
    private final String templateURI;

    public CDAOutput(InputStream in, int length, String templateURI) {
        this.in = in;
        this.length = length;
        this.templateURI = templateURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream out) throws IOException, WebApplicationException {
        try {
            byte[] buf = new byte[Math.min(2048, this.length)];
            int read = this.in.read(buf);
            int cdaStart = CDAOutput.indexOf(CLINICAL_DOCUMENT, 0, buf, read);
            if (cdaStart < 0) {
                LOG.info("Could not find <ClinicalDocument> root element in encapsulated CDA");
                out.write(buf, 0, read);
            } else {
                int styleSheetStart = CDAOutput.indexOf(XML_STYLESHEET, 0, buf, cdaStart);
                out.write(buf, 0, styleSheetStart < 0 ? cdaStart : styleSheetStart);
                out.write(XML_STYLESHEET);
                out.write(TYPE_TEXT_XSL_HREF);
                out.write(this.templateURI.getBytes("UTF-8"));
                out.write(PROCESSING_INSTRUCTION_END);
                out.write(buf, cdaStart, read - cdaStart);
            }
            StreamUtils.copy((InputStream)this.in, (OutputStream)out, (int)(this.length - read - 1), (byte[])buf);
            this.skipPaddedByte(out);
        }
        finally {
            SafeClose.close((Closeable)this.in);
        }
    }

    private void skipPaddedByte(OutputStream out) throws IOException {
        int lastByte = this.in.read();
        if (lastByte != 0) {
            out.write(lastByte);
        }
    }

    private static int indexOf(byte[] b1, int fromIndex, byte[] b2, int length) {
        int max = length - b1.length;
        for (int i = fromIndex; i < max; ++i) {
            if (!CDAOutput.startsWith(b1, i, b2)) continue;
            return i;
        }
        return -1;
    }

    private static boolean startsWith(byte[] b1, int fromIndex, byte[] b2) {
        int remaining = b1.length;
        int i1 = 0;
        int i2 = fromIndex;
        while (--remaining >= 0) {
            if (b2[i2++] == b1[i1++]) continue;
            return false;
        }
        return true;
    }
}

