/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.ups.rs;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntFunction;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.IApplicationEntityCache;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DimseRSP;
import org.dcm4che3.net.QueryOption;
import org.dcm4che3.net.Status;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.net.service.QueryRetrieveLevel2;
import org.dcm4che3.util.TagUtils;
import org.dcm4che3.util.UIDUtils;
import org.dcm4che3.ws.rs.MediaTypes;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.Entity;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.dcm4chee.arc.query.scu.CFindSCU;
import org.dcm4chee.arc.query.util.QueryAttributes;
import org.dcm4chee.arc.ups.UPSContext;
import org.dcm4chee.arc.ups.UPSService;
import org.dcm4chee.arc.ups.UPSUtils;
import org.dcm4chee.arc.ups.rs.InputType;
import org.dcm4chee.arc.ups.rs.UpsCSV;
import org.dcm4chee.arc.validation.constraints.InvokeValidate;
import org.dcm4chee.arc.validation.constraints.ValidValueOf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="aets/{AETitle}/dimse/{upsSCP}")
@InvokeValidate(type=UpsDimseRS.class)
public class UpsDimseRS {
    private static final Logger LOG = LoggerFactory.getLogger(UpsDimseRS.class);
    private static final String SUPER_USER_ROLE = "super-user-role";
    @Context
    private HttpServletRequest request;
    @Context
    private UriInfo uriInfo;
    @Context
    private HttpHeaders headers;
    @Inject
    private Device device;
    @Inject
    private UPSService upsService;
    @Inject
    private IApplicationEntityCache aeCache;
    @Inject
    private CFindSCU findSCU;
    @PathParam(value="AETitle")
    private String aet;
    @PathParam(value="upsSCP")
    private String upsSCP;
    @QueryParam(value="upsLabel")
    private String upsLabel;
    @QueryParam(value="upsScheduledTime")
    private String upsScheduledTime;
    @QueryParam(value="fuzzymatching")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String fuzzymatching;
    @QueryParam(value="priority")
    @Pattern(regexp="0|1|2")
    private @Pattern(regexp="0|1|2") String priority;
    @QueryParam(value="SplitStudyDateRange")
    @ValidValueOf(type=Duration.class)
    private String splitStudyDateRange;

    @POST
    @Path(value="/studies/workitems")
    @Produces(value={"application/json"})
    public Response upsMatchingStudies(InputStream in) {
        return this.upsMatching(QueryRetrieveLevel2.STUDY, null, null, in);
    }

    @POST
    @Path(value="/studies/{studyInstanceUID}/series/workitems")
    @Produces(value={"application/json"})
    public Response upsMatchingSeries(@PathParam(value="studyInstanceUID") String studyInstanceUID, InputStream in) {
        return this.upsMatching(QueryRetrieveLevel2.SERIES, studyInstanceUID, null, in);
    }

    @POST
    @Path(value="/studies/{studyInstanceUID}/series/{seriesInstanceUID}/instances/workitems")
    @Produces(value={"application/json"})
    public Response upsMatchingInstances(@PathParam(value="studyInstanceUID") String studyInstanceUID, @PathParam(value="seriesInstanceUID") String seriesInstanceUID, InputStream in) {
        return this.upsMatching(QueryRetrieveLevel2.IMAGE, studyInstanceUID, seriesInstanceUID, in);
    }

    @POST
    @Path(value="/query:{findSCP}/studies/workitems")
    @Produces(value={"application/json"})
    public Response upsQueryFindSCPMatchingStudies(@PathParam(value="findSCP") String findSCP, InputStream in) {
        return this.upsMatching(QueryRetrieveLevel2.STUDY, findSCP, null, null, in);
    }

    @POST
    @Path(value="/query:{findSCP}/studies/{studyInstanceUID}/series/workitems")
    @Produces(value={"application/json"})
    public Response upsQueryFindSCPMatchingSeries(@PathParam(value="findSCP") String findSCP, @PathParam(value="studyInstanceUID") String studyInstanceUID, InputStream in) {
        return this.upsMatching(QueryRetrieveLevel2.SERIES, findSCP, studyInstanceUID, null, in);
    }

    @POST
    @Path(value="/query:{findSCP}/studies/{studyInstanceUID}/series/{seriesInstanceUID}/instances/workitems")
    @Produces(value={"application/json"})
    public Response upsQueryFindSCPMatchingInstances(@PathParam(value="findSCP") String findSCP, @PathParam(value="studyInstanceUID") String studyInstanceUID, @PathParam(value="seriesInstanceUID") String seriesInstanceUID, InputStream in) {
        return this.upsMatching(QueryRetrieveLevel2.IMAGE, findSCP, studyInstanceUID, seriesInstanceUID, in);
    }

    @POST
    @Path(value="/studies/csv:{field}/workitems/{upsTemplateUID}")
    public Response createWorkitems(@PathParam(value="field") int field, @PathParam(value="upsTemplateUID") String upsTemplateUID, @QueryParam(value="csvPatientID") String csvPatientIDField, InputStream in) {
        return this.createWorkitemsFromCSV(field, upsTemplateUID, csvPatientIDField, in);
    }

    private Response upsMatching(QueryRetrieveLevel2 level, String studyInstanceUID, String seriesInstanceUID, InputStream in) {
        return this.upsMatching(level, this.upsSCP, studyInstanceUID, seriesInstanceUID, in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response upsMatching(QueryRetrieveLevel2 level, String queryAET, String studyInstanceUID, String seriesInstanceUID, InputStream in) {
        InputType inputType = InputType.valueOf(this.headers.getMediaType());
        if (inputType == null) {
            return this.notAcceptable();
        }
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse(Response.Status.NOT_FOUND, "No such Application Entity: " + this.aet);
        }
        this.validateAcceptedUserRoles(arcAE);
        try {
            String warning;
            this.aeCache.findApplicationEntity(this.upsSCP);
            Attributes upsTemplateAttrs = inputType.parse(in);
            upsTemplateAttrs.setDate(0x404005, VR.DT, new Date[]{this.scheduledTime()});
            if (this.upsLabel != null) {
                upsTemplateAttrs.setString(7606788, VR.LO, this.upsLabel);
            }
            if (queryAET != null && !queryAET.equals(this.upsSCP)) {
                this.aeCache.findApplicationEntity(queryAET);
            }
            Attributes keys = this.queryKeys(level, studyInstanceUID, seriesInstanceUID);
            EnumSet<QueryOption> queryOptions = EnumSet.of(QueryOption.DATETIME);
            if (Boolean.parseBoolean(this.fuzzymatching)) {
                queryOptions.add(QueryOption.FUZZY);
            }
            Association as = null;
            AtomicInteger count = new AtomicInteger();
            Response.Status rspStatus = Response.Status.BAD_GATEWAY;
            int matches = 0;
            try {
                int status;
                as = this.findSCU.openAssociation(arcAE.getApplicationEntity(), queryAET, "1.2.840.10008.5.1.4.1.2.2.1", queryOptions);
                DimseRSP dimseRSP = this.findSCU.query(as, UpsDimseRS.parseInt(this.priority, 0), this.findSCU.coerceCFindRQ(as, keys), 0, 1, this.splitStudyDateRange());
                dimseRSP.next();
                Attributes ups = new Attributes(upsTemplateAttrs);
                do {
                    if (!Status.isPending((int)(status = dimseRSP.getCommand().getInt(2304, -1)))) continue;
                    ups = studyInstanceUID == null ? new Attributes(upsTemplateAttrs) : ups;
                    UPSUtils.updateUPSAttributes((Attributes)ups, (Attributes)this.findSCU.coerceCFindRSP(as, dimseRSP.getDataset()), (String)studyInstanceUID, (String)seriesInstanceUID, (String)this.upsSCP);
                    ++matches;
                    if (studyInstanceUID != null) continue;
                    this.createUPS(arcAE, ups, count);
                } while (dimseRSP.next());
                if (matches > 0 && studyInstanceUID != null) {
                    this.createUPS(arcAE, ups, count);
                }
                warning = this.warning(status);
            }
            catch (IllegalArgumentException | IllegalStateException | ConfigurationException e) {
                rspStatus = Response.Status.NOT_FOUND;
                warning = e.getMessage();
            }
            catch (Exception e) {
                warning = e.getMessage();
            }
            finally {
                if (as != null) {
                    try {
                        as.release();
                    }
                    catch (IOException e) {
                        LOG.info("{}: Failed to release association:\\n", (Object)as, (Object)e);
                    }
                }
            }
            if (warning == null && count.get() > 0) {
                return Response.accepted((Object)this.count(count.get())).build();
            }
            if (count.get() == 0) {
                warning = "No matching Instances found. No Workitem was created.";
                rspStatus = Response.Status.NO_CONTENT;
            }
            Response.ResponseBuilder builder = Response.status((Response.Status)rspStatus).header("Warning", (Object)warning);
            if (count.get() > 0) {
                builder.entity((Object)this.count(count.get()));
            }
            return builder.build();
        }
        catch (IllegalArgumentException | IllegalStateException | ConfigurationException e) {
            return this.errResponse(Response.Status.NOT_FOUND, e.getMessage());
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private void createUPS(ArchiveAEExtension arcAE, Attributes ups, AtomicInteger count) {
        UPSContext ctx = this.upsService.newUPSContext(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), arcAE);
        ctx.setUPSInstanceUID(UIDUtils.createUID());
        ctx.setAttributes(ups);
        try {
            this.upsService.createUPS(ctx);
            count.getAndIncrement();
        }
        catch (DicomServiceException e) {
            LOG.info("Failed to create UPS record for Study[uid={}]\n", (Object)((Attributes)ups.getSequence(4210721).get(0)).getString(0x20000D), (Object)e);
        }
    }

    private Response createWorkitemsFromCSV(int studyUIDField, String upsTemplateUID, String csvPatientIDField, InputStream in) {
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse(Response.Status.NOT_FOUND, "No such Application Entity: " + this.aet);
        }
        this.validateAcceptedUserRoles(arcAE);
        if (studyUIDField < 1) {
            return this.errResponse(Response.Status.BAD_REQUEST, "CSV field for Study Instance UID should be greater than or equal to 1");
        }
        int patientIDField = 0;
        if (csvPatientIDField != null && (patientIDField = this.patientIDField(csvPatientIDField)) < 1) {
            return this.errResponse(Response.Status.BAD_REQUEST, "CSV field for Patient ID should be greater than or equal to 1");
        }
        try {
            this.aeCache.findApplicationEntity(this.upsSCP);
            UpsCSV upsCSV = new UpsCSV(this.upsService, HttpServletRequestInfo.valueOf((HttpServletRequest)this.request).setContentType(this.headers), arcAE, this.upsTemplateAttrs(upsTemplateUID, arcAE));
            return upsCSV.createWorkitems(studyUIDField, patientIDField, this.upsSCP, in);
        }
        catch (DicomServiceException e) {
            return this.errResponse(UpsDimseRS::createFailed, e);
        }
        catch (IllegalStateException | ConfigurationException e) {
            return this.errResponse(Response.Status.NOT_FOUND, e.getMessage());
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Attributes queryKeys(QueryRetrieveLevel2 level, String studyInstanceUID, String seriesInstanceUID) {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
        QueryAttributes queryAttributes = new QueryAttributes(this.uriInfo, null);
        queryAttributes.addReturnTags(new int[]{level.uniqueKey()});
        queryAttributes.addReturnTags(arcDev.getAttributeFilter(Entity.Patient).getSelection());
        if (level == QueryRetrieveLevel2.IMAGE) {
            queryAttributes.addReturnTags(arcDev.getAttributeFilter(Entity.Instance).getSelection());
        }
        Attributes keys = queryAttributes.getQueryKeys();
        keys.setString(524370, VR.CS, level.name());
        if (studyInstanceUID != null) {
            keys.setString(0x20000D, VR.UI, studyInstanceUID);
        }
        if (seriesInstanceUID != null) {
            keys.setString(0x20000E, VR.UI, seriesInstanceUID);
        }
        return keys;
    }

    public void validate() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
        new QueryAttributes(this.uriInfo, null);
    }

    private Attributes upsTemplateAttrs(String upsTemplateUID, ArchiveAEExtension arcAE) throws DicomServiceException {
        UPSContext ctx = this.upsService.newUPSContext(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), arcAE);
        ctx.setUPSInstanceUID(upsTemplateUID);
        Attributes upsAttrs = this.upsService.findUPS(ctx).getAttributes();
        upsAttrs.setDate(0x404005, VR.DT, new Date[]{this.scheduledTime()});
        if (this.upsLabel != null) {
            upsAttrs.setString(7606788, VR.LO, this.upsLabel);
        }
        return upsAttrs;
    }

    private ArchiveAEExtension getArchiveAE() {
        ApplicationEntity ae = this.device.getApplicationEntity(this.aet, true);
        return ae == null || !ae.isInstalled() ? null : (ArchiveAEExtension)ae.getAEExtension(ArchiveAEExtension.class);
    }

    private Duration splitStudyDateRange() {
        return this.splitStudyDateRange != null ? Duration.valueOf((String)this.splitStudyDateRange) : null;
    }

    private Date scheduledTime() {
        if (this.upsScheduledTime != null) {
            try {
                return new SimpleDateFormat("yyyyMMddhhmmss").parse(this.upsScheduledTime);
            }
            catch (Exception e) {
                LOG.info(e.getMessage());
            }
        }
        return new Date();
    }

    private static int parseInt(String s, int defval) {
        return s != null ? Integer.parseInt(s) : defval;
    }

    private String count(int count) {
        return "{\"count\":" + count + "}";
    }

    private String warning(int status) {
        switch (status) {
            case 0: {
                return null;
            }
            case 42752: {
                return "A700: Refused: Out of Resources";
            }
            case 43264: {
                return "A900: Identifier does not match SOP Class";
            }
        }
        return TagUtils.shortToHexString((int)status) + ((status & 0xC000) == 49152 ? ": Unable to Process" : ": Unexpected status code");
    }

    private int patientIDField(String csvPatientIDField) {
        try {
            return Integer.parseInt(csvPatientIDField);
        }
        catch (NumberFormatException e) {
            LOG.info("CSV Patient ID Field {} cannot be parsed", (Object)csvPatientIDField);
            return 0;
        }
    }

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    private static Response.Status createFailed(int status) {
        switch (status) {
            case 49927: {
                return Response.Status.NOT_FOUND;
            }
            case 273: {
                return Response.Status.CONFLICT;
            }
            case 261: 
            case 262: 
            case 288: 
            case 289: 
            case 49929: {
                return Response.Status.BAD_REQUEST;
            }
        }
        return Response.Status.INTERNAL_SERVER_ERROR;
    }

    private Response notAcceptable() {
        LOG.info("Response Status : Not Acceptable. Content Type in request : \n{}", (Object)this.headers.getMediaType());
        return Response.notAcceptable((List)Variant.mediaTypes((MediaType[])new MediaType[]{MediaTypes.APPLICATION_DICOM_JSON_TYPE, MediaTypes.APPLICATION_DICOM_XML_TYPE}).build()).build();
    }

    private Response errResponse(IntFunction<Response.Status> httpStatusOf, DicomServiceException e) {
        return this.errResponse(httpStatusOf.apply(e.getStatus()), e.getMessage());
    }

    private Response errResponse(Response.Status status, String msg) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private void validateAcceptedUserRoles(ArchiveAEExtension arcAE) {
        KeycloakContext keycloakContext = KeycloakContext.valueOf((HttpServletRequest)this.request);
        if (keycloakContext.isSecured() && !keycloakContext.isUserInRole(System.getProperty(SUPER_USER_ROLE)) && !arcAE.isAcceptedUserRole(keycloakContext.getRoles())) {
            throw new WebApplicationException("Application Entity " + arcAE.getApplicationEntity().getAETitle() + " does not list role of accessing user", Response.Status.FORBIDDEN);
        }
    }
}

