/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.stgcmt.rs;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.IApplicationEntityCache;
import org.dcm4che3.conf.json.JsonWriter;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DimseRSP;
import org.dcm4che3.net.WebApplication;
import org.dcm4che3.util.TagUtils;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.dcm4chee.arc.query.QueryService;
import org.dcm4chee.arc.stgcmt.StgCmtSCU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="aets/{aet}/rs")
public class StgCmtSCURS {
    private static final Logger LOG = LoggerFactory.getLogger(StgCmtSCURS.class);
    private static final String SUPER_USER_ROLE = "super-user-role";
    @Inject
    private Device device;
    @Inject
    private StgCmtSCU stgCmtSCU;
    @Inject
    private IApplicationEntityCache aeCache;
    @Inject
    private QueryService queryService;
    @PathParam(value="aet")
    private String aet;
    @Context
    private HttpServletRequest request;

    @POST
    @Path(value="/studies/{StudyInstanceUID}/stgcmt/dicom:{externalAET}")
    @Produces(value={"application/json"})
    public Response studyStorageCommit(@PathParam(value="StudyInstanceUID") String studyUID, @PathParam(value="externalAET") String externalAET) {
        return this.storageCommit(studyUID, null, null, externalAET);
    }

    @POST
    @Path(value="/studies/{StudyInstanceUID}/series/{SeriesInstanceUID}/stgcmt/dicom:{externalAET}")
    @Produces(value={"application/json"})
    public Response seriesStorageCommit(@PathParam(value="StudyInstanceUID") String studyUID, @PathParam(value="SeriesInstanceUID") String seriesUID, @PathParam(value="externalAET") String externalAET) {
        return this.storageCommit(studyUID, seriesUID, null, externalAET);
    }

    @POST
    @Path(value="/studies/{StudyInstanceUID}/series/{SeriesInstanceUID}/instances/{SOPInstanceUID}/stgcmt/dicom:{externalAET}")
    @Produces(value={"application/json"})
    public Response instanceStorageCommit(@PathParam(value="StudyInstanceUID") String studyUID, @PathParam(value="SeriesInstanceUID") String seriesUID, @PathParam(value="SOPInstanceUID") String sopUID, @PathParam(value="externalAET") String externalAET) {
        return this.storageCommit(studyUID, seriesUID, sopUID, externalAET);
    }

    private Response storageCommit(String studyUID, String seriesUID, String sopUID, String externalAET) {
        this.logRequest();
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        ApplicationEntity ae = arcAE.getApplicationEntity();
        if (this.aet.equals(ae.getAETitle())) {
            this.validateWebAppServiceClass();
        }
        try {
            this.aeCache.findApplicationEntity(externalAET);
        }
        catch (ConfigurationException e) {
            return this.errResponse(e.getMessage(), Response.Status.NOT_FOUND);
        }
        try {
            Response.Status rspStatus = Response.Status.BAD_GATEWAY;
            Attributes actionInfo = this.queryService.createActionInfo(studyUID, seriesUID, sopUID, ae);
            if (actionInfo == null || actionInfo.getSequence(528793).isEmpty()) {
                return this.errResponse("No matching instances", Response.Status.NOT_FOUND);
            }
            DimseRSP dimseRSP = this.stgCmtSCU.sendNActionRQ(this.aet, externalAET, studyUID, seriesUID, sopUID, null, null, null, actionInfo);
            if (dimseRSP.getCommand().getInt(2304, -1) == 0) {
                rspStatus = Response.Status.OK;
            }
            return Response.status((Response.Status)rspStatus).entity((Object)this.entity(actionInfo, dimseRSP)).build();
        }
        catch (IOException e) {
            return this.errResponse(e.getMessage(), Response.Status.BAD_GATEWAY);
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private StreamingOutput entity(Attributes actionInfo, DimseRSP dimseRSP) {
        return out -> {
            try (JsonGenerator gen = Json.createGenerator((OutputStream)out);){
                JsonWriter writer = new JsonWriter(gen);
                gen.writeStartObject();
                writer.writeNotNullOrDef("status", (Object)TagUtils.shortToHexString((int)dimseRSP.getCommand().getInt(2304, -1)), null);
                writer.writeNotNullOrDef("error", (Object)dimseRSP.getCommand().getString(2306), null);
                writer.writeNotNullOrDef("instances", (Object)actionInfo.getSequence(528793).size(), (Object)0);
                gen.writeEnd();
            }
        };
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.request.getRequestURI(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private Response errResponse(String msg, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private void validateAcceptedUserRoles(ArchiveAEExtension arcAE) {
        KeycloakContext keycloakContext = KeycloakContext.valueOf((HttpServletRequest)this.request);
        if (keycloakContext.isSecured() && !keycloakContext.isUserInRole(System.getProperty(SUPER_USER_ROLE)) && !arcAE.isAcceptedUserRole(keycloakContext.getRoles())) {
            throw new WebApplicationException("Application Entity " + arcAE.getApplicationEntity().getAETitle() + " does not list role of accessing user", Response.Status.FORBIDDEN);
        }
    }

    private void validateWebAppServiceClass() {
        this.device.getWebApplications().stream().filter(webApp -> this.request.getRequestURI().startsWith(webApp.getServicePath()) && Arrays.asList(webApp.getServiceClasses()).contains(WebApplication.ServiceClass.DCM4CHEE_ARC_AET)).findFirst().orElseThrow(() -> new WebApplicationException(this.errResponse("No Web Application with DCM4CHEE_ARC_AET service class found for Application Entity: " + this.aet, Response.Status.NOT_FOUND)));
    }

    private ArchiveAEExtension getArchiveAE() {
        ApplicationEntity ae = this.device.getApplicationEntity(this.aet, true);
        return ae == null || !ae.isInstalled() ? null : (ArchiveAEExtension)ae.getAEExtension(ArchiveAEExtension.class);
    }
}

