/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.rs.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import org.dcm4che3.imageio.codec.TransferSyntaxType;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.ws.rs.MediaTypes;
import org.jboss.resteasy.util.MediaTypeHelper;

public class MediaTypeUtils {
    private static final MediaTypeComparator COMPARATOR = new MediaTypeComparator();

    public static List<MediaType> acceptableMediaTypesOf(HttpHeaders headers, List<String> acceptQueryParam) {
        List<MediaType> list = acceptQueryParam.stream().flatMap(s -> Stream.of(StringUtils.split((String)s, (char)','))).map(String::trim).map(MediaType::valueOf).collect(Collectors.toList());
        if (list.isEmpty()) {
            List vals = headers.getRequestHeader("Accept");
            if (vals == null || vals.isEmpty()) {
                return Collections.singletonList(MediaType.WILDCARD_TYPE);
            }
            for (String v : vals) {
                StringTokenizer tokenizer = new StringTokenizer(v, ",");
                while (tokenizer.hasMoreElements()) {
                    String item = tokenizer.nextToken().trim();
                    list.add(MediaType.valueOf((String)item));
                }
            }
        }
        if (list.size() > 1) {
            Collections.sort(list, COMPARATOR);
        }
        return list;
    }

    public static String selectTransferSyntax(Collection<String> acceptable, String tsuid) {
        return acceptable.isEmpty() || acceptable.contains("*") || acceptable.contains(tsuid) ? tsuid : (acceptable.contains("1.2.840.10008.1.2.1") ? "1.2.840.10008.1.2.1" : "1.2.840.10008.1.2");
    }

    private static int disfavor(MediaType disfavorType, MediaType mediaType2, MediaType mediaType) {
        if (MediaTypes.equalsIgnoreParameters((MediaType)mediaType, (MediaType)disfavorType) && !MediaTypes.equalsIgnoreParameters((MediaType)mediaType2, (MediaType)disfavorType)) {
            return -1;
        }
        if (!MediaTypes.equalsIgnoreParameters((MediaType)mediaType, (MediaType)disfavorType) && MediaTypes.equalsIgnoreParameters((MediaType)mediaType2, (MediaType)disfavorType)) {
            return 1;
        }
        return 0;
    }

    private static int disfavor(TransferSyntaxType disfavorType, TransferSyntaxType type2, TransferSyntaxType type) {
        if (type == disfavorType && type2 != disfavorType) {
            return -1;
        }
        if (type != disfavorType && type2 == disfavorType) {
            return 1;
        }
        return 0;
    }

    private static int compareWildcardType(MediaType mediaType2, MediaType mediaType) {
        if (mediaType.isWildcardType() && !mediaType2.isWildcardType()) {
            return -1;
        }
        if (!mediaType.isWildcardType() && mediaType2.isWildcardType()) {
            return 1;
        }
        if (mediaType.isWildcardSubtype() && !mediaType2.isWildcardSubtype()) {
            return -1;
        }
        if (!mediaType.isWildcardSubtype() && mediaType2.isWildcardSubtype()) {
            return 1;
        }
        if (MediaTypeHelper.isComposite((String)mediaType.getSubtype()) && !MediaTypeHelper.isComposite((String)mediaType2.getSubtype())) {
            return -1;
        }
        if (!MediaTypeHelper.isComposite((String)mediaType.getSubtype()) && MediaTypeHelper.isComposite((String)mediaType2.getSubtype())) {
            return 1;
        }
        if (MediaTypeHelper.isCompositeWildcardSubtype((String)mediaType.getSubtype()) && !MediaTypeHelper.isCompositeWildcardSubtype((String)mediaType2.getSubtype())) {
            return -1;
        }
        if (!MediaTypeHelper.isCompositeWildcardSubtype((String)mediaType.getSubtype()) && MediaTypeHelper.isCompositeWildcardSubtype((String)mediaType2.getSubtype())) {
            return 1;
        }
        if (MediaTypeHelper.isWildcardCompositeSubtype((String)mediaType.getSubtype()) && !MediaTypeHelper.isWildcardCompositeSubtype((String)mediaType2.getSubtype())) {
            return -1;
        }
        if (!MediaTypeHelper.isWildcardCompositeSubtype((String)mediaType.getSubtype()) && MediaTypeHelper.isWildcardCompositeSubtype((String)mediaType2.getSubtype())) {
            return 1;
        }
        return 0;
    }

    private static class MediaTypeComparator
    implements Comparator<MediaType> {
        private MediaTypeComparator() {
        }

        @Override
        public int compare(MediaType mediaType2, MediaType mediaType) {
            String transferSyntax2;
            float q2;
            boolean wasQ2;
            boolean wasQ;
            float q = MediaTypeHelper.getQWithParamInfo((MediaType)mediaType);
            boolean bl = wasQ = q != 2.0f;
            if (q == 2.0f) {
                q = 1.0f;
            }
            boolean bl2 = wasQ2 = (q2 = MediaTypeHelper.getQWithParamInfo((MediaType)mediaType2)) != 2.0f;
            if (q2 == 2.0f) {
                q2 = 1.0f;
            }
            if (q < q2) {
                return -1;
            }
            if (q > q2) {
                return 1;
            }
            int cmp = MediaTypeUtils.compareWildcardType(mediaType2, mediaType);
            if (cmp != 0) {
                return cmp;
            }
            MediaType type2 = MediaTypes.getMultiPartRelatedType((MediaType)mediaType2);
            MediaType type = MediaTypes.getMultiPartRelatedType((MediaType)mediaType);
            if (type2 != null && type != null) {
                cmp = MediaTypeUtils.compareWildcardType(type2, type);
                if (cmp != 0) {
                    return cmp;
                }
                cmp = MediaTypeUtils.disfavor(MediaType.APPLICATION_OCTET_STREAM_TYPE, type2, type);
            } else {
                cmp = MediaTypeUtils.disfavor(MediaType.APPLICATION_OCTET_STREAM_TYPE, mediaType2, mediaType);
            }
            if (cmp != 0) {
                return cmp;
            }
            Map parameters = mediaType.getParameters();
            Map parameters2 = mediaType2.getParameters();
            String transferSyntax = parameters != null ? (String)parameters.get("transfer-syntax") : null;
            String string = transferSyntax2 = parameters2 != null ? (String)parameters2.get("transfer-syntax") : null;
            if (transferSyntax != null && transferSyntax2 != null && (cmp = MediaTypeUtils.disfavor(TransferSyntaxType.NATIVE, TransferSyntaxType.forUID((String)transferSyntax2), TransferSyntaxType.forUID((String)transferSyntax))) != 0) {
                return cmp;
            }
            int numNonQ = 0;
            if (parameters != null) {
                numNonQ = parameters.size();
                if (wasQ) {
                    --numNonQ;
                }
            }
            int numNonQ2 = 0;
            if (parameters2 != null) {
                numNonQ2 = parameters2.size();
                if (wasQ2) {
                    --numNonQ2;
                }
            }
            if (numNonQ < numNonQ2) {
                return -1;
            }
            if (numNonQ > numNonQ2) {
                return 1;
            }
            return 0;
        }
    }
}

