/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.qido;

import java.util.stream.Collectors;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.dcm4chee.arc.query.QueryService;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="/modalities")
public class ModalitiesRS {
    private static final Logger LOG = LoggerFactory.getLogger(ModalitiesRS.class);
    @Context
    private HttpServletRequest request;
    @Inject
    private QueryService queryService;

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public String listModalities() {
        this.logRequest();
        return this.queryService.getDistinctModalities().stream().filter(modality -> !modality.equals("*")).sorted().collect(Collectors.joining("\",\"", "{\"Modalities\":[\"", "\"]}"));
    }

    private void logRequest() {
        LOG.info("Process GET {} from {}@{}", new Object[]{this.request.getRequestURI(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }
}

