/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.pdq.rs;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.json.JSONWriter;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.WebApplication;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.net.service.QueryRetrieveLevel2;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Entity;
import org.dcm4chee.arc.conf.PDQServiceDescriptor;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.dcm4chee.arc.pdq.PDQService;
import org.dcm4chee.arc.pdq.PDQServiceContext;
import org.dcm4chee.arc.pdq.PDQServiceException;
import org.dcm4chee.arc.pdq.PDQServiceFactory;
import org.dcm4chee.arc.query.Query;
import org.dcm4chee.arc.query.QueryContext;
import org.dcm4chee.arc.query.QueryService;
import org.dcm4chee.arc.query.RunInTransaction;
import org.dcm4chee.arc.query.util.QueryAttributes;
import org.dcm4chee.arc.query.util.QueryParam;
import org.dcm4chee.arc.validation.constraints.InvokeValidate;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="aets/{AETitle}/diff/pdq/{PDQServiceID}")
@InvokeValidate(type=DiffPatientDemographicsRS.class)
public class DiffPatientDemographicsRS {
    private static final Logger LOG = LoggerFactory.getLogger(DiffPatientDemographicsRS.class);
    private static final String SUPER_USER_ROLE = "super-user-role";
    @Inject
    private QueryService queryService;
    @Inject
    private PDQServiceFactory serviceFactory;
    @Context
    private HttpServletRequest request;
    @Context
    private UriInfo uriInfo;
    @Context
    private HttpHeaders headers;
    @Inject
    private Device device;
    @Inject
    private RunInTransaction runInTx;
    @PathParam(value="AETitle")
    private String aet;
    @PathParam(value="PDQServiceID")
    private String pdqServiceID;
    @javax.ws.rs.QueryParam(value="onlyWithStudies")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String onlyWithStudies;
    @javax.ws.rs.QueryParam(value="patientVerificationStatus")
    @Pattern(regexp="UNVERIFIED|VERIFIED|NOT_FOUND|VERIFICATION_FAILED")
    private @Pattern(regexp="UNVERIFIED|VERIFIED|NOT_FOUND|VERIFICATION_FAILED") String patientVerificationStatus;
    @javax.ws.rs.QueryParam(value="isFuzzymatching")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String fuzzymatching;
    @javax.ws.rs.QueryParam(value="offset")
    @Pattern(regexp="0|([1-9]\\d{0,4})")
    private @Pattern(regexp="0|([1-9]\\d{0,4})") String offset;
    @javax.ws.rs.QueryParam(value="limit")
    @Pattern(regexp="[1-9]\\d{0,4}")
    private @Pattern(regexp="[1-9]\\d{0,4}") String limit;
    @javax.ws.rs.QueryParam(value="different")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String checkDifferent;
    @javax.ws.rs.QueryParam(value="missing")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String checkMissing;

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    public void validate() {
        this.logRequest();
        new QueryAttributes(this.uriInfo, null);
    }

    @GET
    @NoCache
    @Path(value="/patients")
    @Produces(value={"application/dicom+json,application/json"})
    public Response comparePatients() {
        ArchiveDeviceExtension arcdev;
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        ApplicationEntity ae = arcAE.getApplicationEntity();
        if (this.aet.equals(ae.getAETitle())) {
            this.validateWebAppServiceClass();
        }
        if ((arcdev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class)) == null) {
            return this.errResponse("Archive Device Extension not configured.", Response.Status.NOT_FOUND);
        }
        PDQServiceDescriptor descriptor = arcdev.getPDQServiceDescriptor(this.pdqServiceID);
        if (descriptor == null) {
            return this.errResponse("No such PDQ Service: " + this.pdqServiceID, Response.Status.NOT_FOUND);
        }
        try {
            QueryContext ctx = this.createQueryContext(ae);
            Query query = ctx.getQueryService().createQuery(ctx);
            int queryMaxNumberOfResults = ctx.getArchiveAEExtension().queryMaxNumberOfResults();
            if (queryMaxNumberOfResults > 0 && !ctx.containsUniqueKey() && query.fetchCount() > (long)queryMaxNumberOfResults) {
                return this.errResponse("Request entity too large", Response.Status.BAD_REQUEST);
            }
            DiffPatientDemographics diffPatientDemographics = new DiffPatientDemographics(query, descriptor);
            this.runInTx.execute((Runnable)diffPatientDemographics);
            return (diffPatientDemographics.hasMoreMatches() ? Response.ok((Object)this.entity(diffPatientDemographics.getResult(), ae)) : Response.noContent()).build();
        }
        catch (IllegalStateException e) {
            return this.errResponse(e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (Exception e) {
            return DiffPatientDemographicsRS.errResponseAsTextPlain(DiffPatientDemographicsRS.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private StreamingOutput entity(List<Attributes> diffs, ApplicationEntity ae) {
        return out -> {
            JsonGenerator gen = Json.createGenerator((OutputStream)out);
            JSONWriter writer = ((ArchiveAEExtension)ae.getAEExtensionNotNull(ArchiveAEExtension.class)).encodeAsJSONNumber(new JSONWriter(gen));
            gen.writeStartArray();
            diffs.forEach(arg_0 -> ((JSONWriter)writer).write(arg_0));
            gen.writeEnd();
            gen.flush();
        };
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private Response errResponse(String msg, Response.Status status) {
        return DiffPatientDemographicsRS.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private static Response errResponseAsTextPlain(String message, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)message);
        return Response.status((Response.Status)status).entity((Object)message).type("text/plain").build();
    }

    private static String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private QueryContext createQueryContext(ApplicationEntity ae) {
        QueryAttributes queryAttrs = new QueryAttributes(this.uriInfo, null);
        QueryParam queryParam = new QueryParam(ae);
        queryParam.setCombinedDatetimeMatching(true);
        queryParam.setFuzzySemanticMatching(Boolean.parseBoolean(this.fuzzymatching));
        queryParam.setOnlyWithStudies(Boolean.parseBoolean(this.onlyWithStudies));
        if (this.patientVerificationStatus != null) {
            queryParam.setPatientVerificationStatus(Patient.VerificationStatus.valueOf((String)this.patientVerificationStatus));
        }
        QueryContext ctx = this.queryService.newQueryContextQIDO(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), "GET", this.aet, ae, queryParam);
        ctx.setQueryRetrieveLevel(QueryRetrieveLevel2.PATIENT);
        ctx.setSOPClassUID("1.2.840.10008.5.1.4.1.2.1.1");
        Attributes keys = queryAttrs.getQueryKeys();
        IDWithIssuer idWithIssuer = IDWithIssuer.pidOf((Attributes)keys);
        if (idWithIssuer != null && !idWithIssuer.getID().equals("*")) {
            ctx.setPatientIDs(new IDWithIssuer[]{idWithIssuer});
        } else if (ctx.getArchiveAEExtension().filterByIssuerOfPatientID()) {
            ctx.setIssuerOfPatientID(Issuer.fromIssuerOfPatientID((Attributes)keys));
        }
        ctx.setQueryKeys(keys);
        ctx.setOrderByTags((List)queryAttrs.getOrderByTags());
        return ctx;
    }

    private boolean missing() {
        return DiffPatientDemographicsRS.parseBoolean(this.checkMissing, false);
    }

    private boolean different() {
        return DiffPatientDemographicsRS.parseBoolean(this.checkDifferent, true);
    }

    private static boolean parseBoolean(String s, boolean defVal) {
        return s != null ? s.equals("true") : defVal;
    }

    private int offset() {
        return DiffPatientDemographicsRS.parseInt(this.offset, 0);
    }

    private int limit() {
        return DiffPatientDemographicsRS.parseInt(this.limit, Integer.MAX_VALUE);
    }

    private static int parseInt(String s, int defVal) {
        return s != null ? Integer.parseInt(s) : defVal;
    }

    private List<Attributes> calculateDiffs(Query query, PDQService service) throws DicomServiceException {
        Attributes diff;
        ArrayList<Attributes> result = new ArrayList<Attributes>();
        int skip = this.offset();
        int remaining = this.limit();
        boolean missing = this.missing();
        boolean different = this.different();
        int[] tags = this.getPatientAttributes(service);
        while (remaining > 0 && (diff = this.nextDiff(query, service, missing, different, tags)) != null) {
            if (skip-- > 0) continue;
            result.add(diff);
            --remaining;
        }
        return result;
    }

    private int[] getPatientAttributes(PDQService service) {
        int[] selection = service.getPDQServiceDescriptor().getSelection();
        return selection.length > 0 ? selection : ((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getAttributeFilter(Entity.Patient).getSelection(false);
    }

    private Attributes nextDiff(Query query, PDQService service, boolean missing, boolean different, int[] tags) throws DicomServiceException {
        while (query.hasMoreMatches()) {
            Attributes modified;
            Attributes match = query.nextMatch();
            Attributes other = this.queryPDQService(service, match);
            if (other == null) {
                if (!missing) continue;
                return this.addOriginalAttributesSequence(match, new Attributes(0));
            }
            if (!different || other.diff(match, tags, modified = new Attributes(match.size())) <= 0) continue;
            return this.addOriginalAttributesSequence(match, modified);
        }
        return null;
    }

    private Attributes queryPDQService(PDQService service, Attributes match) {
        try {
            PDQServiceContext ctx = new PDQServiceContext(IDWithIssuer.pidOf((Attributes)match));
            ctx.setHttpServletRequestInfo(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request));
            ctx.setSearchMethod(PDQServiceContext.SearchMethod.ComparePatientDemographics);
            return service.query(ctx);
        }
        catch (PDQServiceException e) {
            throw new WebApplicationException(DiffPatientDemographicsRS.errResponseAsTextPlain(DiffPatientDemographicsRS.exceptionAsString((Exception)((Object)e)), Response.Status.BAD_GATEWAY));
        }
    }

    private Attributes addOriginalAttributesSequence(Attributes match, Attributes modified) {
        Sequence sq = match.newSequence(67110241, 1);
        Attributes item = new Attributes();
        sq.add(item);
        item.newSequence(0x4000550, 1).add(modified);
        item.setString(67110244, VR.LO, this.pdqServiceID);
        item.setDate(67110242, VR.DT, new Date[]{new Date()});
        item.setString(67110243, VR.LO, this.aet);
        item.setString(67110245, VR.CS, "DIFFS");
        return match;
    }

    private ArchiveAEExtension getArchiveAE() {
        ApplicationEntity ae = this.device.getApplicationEntity(this.aet, true);
        return ae == null || !ae.isInstalled() ? null : (ArchiveAEExtension)ae.getAEExtension(ArchiveAEExtension.class);
    }

    private void validateAcceptedUserRoles(ArchiveAEExtension arcAE) {
        KeycloakContext keycloakContext = KeycloakContext.valueOf((HttpServletRequest)this.request);
        if (keycloakContext.isSecured() && !keycloakContext.isUserInRole(System.getProperty(SUPER_USER_ROLE)) && !arcAE.isAcceptedUserRole(keycloakContext.getRoles())) {
            throw new WebApplicationException("Application Entity " + arcAE.getApplicationEntity().getAETitle() + " does not list role of accessing user", Response.Status.FORBIDDEN);
        }
    }

    private void validateWebAppServiceClass() {
        this.device.getWebApplications().stream().filter(webApp -> this.request.getRequestURI().startsWith(webApp.getServicePath()) && Arrays.asList(webApp.getServiceClasses()).contains(WebApplication.ServiceClass.DCM4CHEE_ARC_AET_DIFF)).findFirst().orElseThrow(() -> new WebApplicationException(this.errResponse("No Web Application with DCM4CHEE_ARC_AET_DIFF service class found for Application Entity: " + this.aet, Response.Status.NOT_FOUND)));
    }

    class DiffPatientDemographics
    implements Runnable {
        private List<Attributes> result = new ArrayList<Attributes>();
        private final Query query;
        private final PDQServiceDescriptor descriptor;
        private boolean hasMoreMatches;

        DiffPatientDemographics(Query query, PDQServiceDescriptor descriptor) {
            this.query = query;
            this.descriptor = descriptor;
        }

        List<Attributes> getResult() {
            return this.result;
        }

        boolean hasMoreMatches() {
            return this.hasMoreMatches;
        }

        @Override
        public void run() {
            try {
                PDQService service = DiffPatientDemographicsRS.this.serviceFactory.getPDQService(this.descriptor);
                this.query.executeQuery(((ArchiveDeviceExtension)DiffPatientDemographicsRS.this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getQueryFetchSize());
                if (this.hasMoreMatches == this.query.hasMoreMatches()) {
                    this.result = DiffPatientDemographicsRS.this.calculateDiffs(this.query, service);
                }
            }
            catch (DicomServiceException e) {
                throw new WebApplicationException((Throwable)e);
            }
        }
    }
}

