/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.mwl.rs;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.WebApplication;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.SPSStatus;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.dcm4chee.arc.procedure.ProcedureService;
import org.dcm4chee.arc.query.util.QueryAttributes;
import org.dcm4chee.arc.query.util.QueryParam;
import org.dcm4chee.arc.validation.constraints.InvokeValidate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="aets/{AETitle}/rs")
@InvokeValidate(type=UpdateSPSMatchingRS.class)
public class UpdateSPSMatchingRS {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateSPSMatchingRS.class);
    private static final String SUPER_USER_ROLE = "super-user-role";
    @PathParam(value="AETitle")
    private String aet;
    @Inject
    private Device device;
    @Inject
    private ProcedureService procedureService;
    @Context
    private HttpServletRequest request;
    @Context
    private UriInfo uriInfo;
    @javax.ws.rs.QueryParam(value="fuzzymatching")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String fuzzymatching;

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    public void validate() {
        this.logRequest();
        new QueryAttributes(this.uriInfo, null);
    }

    @POST
    @Path(value="/mwlitems/status/{status}")
    public Response updateSPSStatus(@PathParam(value="status") @Pattern(regexp="SCHEDULED|ARRIVED|READY|STARTED|DEPARTED|CANCELED|DISCONTINUED|COMPLETED") @Pattern(regexp="SCHEDULED|ARRIVED|READY|STARTED|DEPARTED|CANCELED|DISCONTINUED|COMPLETED") String spsStatus) {
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        ApplicationEntity ae = arcAE.getApplicationEntity();
        if (this.aet.equals(ae.getAETitle())) {
            this.validateWebAppServiceClass();
        }
        int updated = 0;
        int mwlFetchSize = ((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getMWLFetchSize();
        SPSStatus targetSPSStatus = SPSStatus.valueOf((String)spsStatus);
        try {
            int count;
            do {
                count = this.procedureService.updateMatchingSPS(targetSPSStatus, this.queryKeys(targetSPSStatus), this.queryParam(ae), mwlFetchSize);
                updated += count;
            } while (count >= mwlFetchSize);
            if (updated > 0) {
                LOG.info("Updated {} MWL Items with SPS Status {}", (Object)updated, (Object)spsStatus);
            }
            return Response.ok((Object)("{\"count\":" + updated + "}")).build();
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Attributes queryKeys(SPSStatus targetSPSStatus) {
        QueryAttributes queryAttrs = new QueryAttributes(this.uriInfo, null);
        Attributes sps = queryAttrs.getQueryKeys().getNestedDataset(0x400100);
        if (sps == null) {
            this.queryKeysNoTargetSPSStatus(targetSPSStatus, new Attributes(1), queryAttrs);
        } else if (sps.getString(0x400020) == null) {
            queryAttrs.getQueryKeys().remove(0x400100);
            this.queryKeysNoTargetSPSStatus(targetSPSStatus, sps, queryAttrs);
        }
        return queryAttrs.getQueryKeys();
    }

    private void queryKeysNoTargetSPSStatus(SPSStatus targetSPSStatus, Attributes sps, QueryAttributes queryAttrs) {
        sps.setString(0x400020, VR.CS, (String[])Stream.of(SPSStatus.values()).filter(spsStatus -> spsStatus != targetSPSStatus).map(Enum::name).toArray(String[]::new));
        queryAttrs.getQueryKeys().newSequence(0x400100, 1).add(sps);
    }

    private QueryParam queryParam(ApplicationEntity ae) {
        QueryParam queryParam = new QueryParam(ae);
        queryParam.setCombinedDatetimeMatching(true);
        queryParam.setFuzzySemanticMatching(Boolean.parseBoolean(this.fuzzymatching));
        queryParam.setCalledAET(this.aet);
        return queryParam;
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private Response errResponse(String msg, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private void validateAcceptedUserRoles(ArchiveAEExtension arcAE) {
        KeycloakContext keycloakContext = KeycloakContext.valueOf((HttpServletRequest)this.request);
        if (keycloakContext.isSecured() && !keycloakContext.isUserInRole(System.getProperty(SUPER_USER_ROLE)) && !arcAE.isAcceptedUserRole(keycloakContext.getRoles())) {
            throw new WebApplicationException("Application Entity " + arcAE.getApplicationEntity().getAETitle() + " does not list role of accessing user", Response.Status.FORBIDDEN);
        }
    }

    private void validateWebAppServiceClass() {
        this.device.getWebApplications().stream().filter(webApp -> this.request.getRequestURI().startsWith(webApp.getServicePath()) && Arrays.asList(webApp.getServiceClasses()).contains(WebApplication.ServiceClass.DCM4CHEE_ARC_AET)).findFirst().orElseThrow(() -> new WebApplicationException(this.errResponse("No Web Application with DCM4CHEE_ARC_AET service class found for Application Entity: " + this.aet, Response.Status.NOT_FOUND)));
    }

    private ArchiveAEExtension getArchiveAE() {
        ApplicationEntity ae = this.device.getApplicationEntity(this.aet, true);
        return ae == null || !ae.isInstalled() ? null : (ArchiveAEExtension)ae.getAEExtension(ArchiveAEExtension.class);
    }
}

