/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.mwl.rs;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonParsingException;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.VR;
import org.dcm4che3.json.JSONReader;
import org.dcm4che3.json.JSONWriter;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.WebApplication;
import org.dcm4che3.util.UIDUtils;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.RSOperation;
import org.dcm4chee.arc.conf.SPSStatus;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.id.IDService;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.dcm4chee.arc.patient.PatientService;
import org.dcm4chee.arc.procedure.ProcedureContext;
import org.dcm4chee.arc.procedure.ProcedureService;
import org.dcm4chee.arc.rs.client.RSForward;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="aets/{AETitle}/rs")
public class MwlRS {
    private static final Logger LOG = LoggerFactory.getLogger(MwlRS.class);
    private static final String SUPER_USER_ROLE = "super-user-role";
    @Inject
    private Device device;
    @Inject
    private PatientService patientService;
    @Inject
    private ProcedureService procedureService;
    @Inject
    private IDService idService;
    @Inject
    private RSForward rsForward;
    @PathParam(value="AETitle")
    private String aet;
    @Context
    private HttpServletRequest request;

    @POST
    @Path(value="/mwlitems")
    @Consumes(value={"application/dicom+json,application/json"})
    @Produces(value={"application/dicom+json,application/json"})
    public Response updateSPS(InputStream in) {
        Attributes attrs;
        IDWithIssuer patientID;
        this.logRequest();
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        if (this.aet.equals(arcAE.getApplicationEntity().getAETitle())) {
            this.validateWebAppServiceClass();
        }
        if ((patientID = IDWithIssuer.pidOf((Attributes)(attrs = this.toAttributes(in)))) == null) {
            return this.errResponse("missing Patient ID in message body", Response.Status.BAD_REQUEST);
        }
        Attributes spsItem = attrs.getNestedDataset(0x400100);
        if (spsItem == null) {
            return this.errResponse("Missing or empty (0040,0100) Scheduled Procedure Step Sequence", Response.Status.BAD_REQUEST);
        }
        Patient patient = this.patientService.findPatient(patientID);
        if (patient == null) {
            return this.errResponse("Patient[id=" + patientID + "] does not exists", Response.Status.NOT_FOUND);
        }
        try {
            if (!attrs.containsValue(524368)) {
                this.idService.newAccessionNumber(arcAE.mwlAccessionNumberGenerator(), attrs);
            }
            if (!attrs.containsValue(0x401001)) {
                this.idService.newRequestedProcedureID(arcAE.mwlRequestedProcedureIDGenerator(), attrs);
            }
            if (!spsItem.containsValue(0x400009)) {
                this.idService.newScheduledProcedureStepID(arcAE.mwlScheduledProcedureStepIDGenerator(), spsItem);
            }
            if (!attrs.containsValue(0x20000D)) {
                attrs.setString(0x20000D, VR.UI, UIDUtils.createUID());
            }
            if (!spsItem.containsValue(0x400020)) {
                spsItem.setString(0x400020, VR.CS, SPSStatus.SCHEDULED.toString());
            }
            if (!spsItem.containsValue(0x400001)) {
                this.adjustScheduledStations(spsItem);
            }
            ProcedureContext ctx = this.procedureService.createProcedureContext().setHttpServletRequest(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request));
            ctx.setLocalAET(this.aet);
            ctx.setArchiveAEExtension(arcAE);
            ctx.setPatient(patient);
            ctx.setAttributes(attrs);
            this.procedureService.updateProcedure(ctx);
            RSOperation rsOp = ctx.getEventActionCode().equals("C") ? RSOperation.CreateMWL : RSOperation.UpdateMWL;
            this.rsForward.forward(rsOp, arcAE, attrs, this.request);
            return Response.ok(out -> {
                try (JsonGenerator gen = Json.createGenerator((OutputStream)out);){
                    arcAE.encodeAsJSONNumber(new JSONWriter(gen)).write(attrs);
                }
            }).build();
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @DELETE
    @Path(value="/mwlitems/{studyIUID}/{spsID}")
    public Response deleteSPS(@PathParam(value="studyIUID") String studyIUID, @PathParam(value="spsID") String spsID) {
        this.logRequest();
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        if (this.aet.equals(arcAE.getApplicationEntity().getAETitle())) {
            this.validateWebAppServiceClass();
        }
        try {
            ProcedureContext ctx = this.procedureService.createProcedureContext().setHttpServletRequest(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request));
            ctx.setStudyInstanceUID(studyIUID);
            ctx.setSpsID(spsID);
            this.procedureService.deleteProcedure(ctx);
            if (ctx.getEventActionCode() == null) {
                return this.errResponse("MWLItem with study instance UID : " + studyIUID + " and SPS ID : " + spsID + " not found.", Response.Status.NOT_FOUND);
            }
            this.rsForward.forward(RSOperation.DeleteMWL, arcAE, null, this.request);
            return Response.noContent().build();
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="/mwlitems/{study}/{spsID}/status/{status}")
    public void updateSPSStatus(@PathParam(value="study") String studyIUID, @PathParam(value="spsID") String spsID, @PathParam(value="status") @Pattern(regexp="SCHEDULED|ARRIVED|READY|STARTED|DEPARTED|CANCELED|DISCONTINUED|COMPLETED") @Pattern(regexp="SCHEDULED|ARRIVED|READY|STARTED|DEPARTED|CANCELED|DISCONTINUED|COMPLETED") String spsStatus) {
        this.logRequest();
        ArchiveAEExtension arcAE = this.getArchiveAE();
        try {
            ProcedureContext ctx = this.procedureService.createProcedureContext().setHttpServletRequest(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request));
            ctx.setStudyInstanceUID(studyIUID);
            ctx.setSpsID(spsID);
            ctx.setSpsStatus(SPSStatus.valueOf((String)spsStatus));
            this.procedureService.updateMWLStatus(ctx);
            this.rsForward.forward(RSOperation.UpdateMWL, arcAE, null, this.request);
        }
        catch (Exception e) {
            throw new WebApplicationException(this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    private Attributes toAttributes(InputStream in) {
        try {
            return new JSONReader(Json.createParser((Reader)new InputStreamReader(in, "UTF-8"))).readDataset(null);
        }
        catch (JsonParsingException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage() + " at location : " + e.getLocation(), Response.Status.BAD_REQUEST));
        }
        catch (Exception e) {
            throw new WebApplicationException(this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.request.getRequestURI(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private ArchiveAEExtension getArchiveAE() {
        ApplicationEntity ae = this.device.getApplicationEntity(this.aet, true);
        return ae == null || !ae.isInstalled() ? null : (ArchiveAEExtension)ae.getAEExtension(ArchiveAEExtension.class);
    }

    private Response errResponse(String msg, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private void adjustScheduledStations(Attributes sps) {
        String[] ssNames;
        ArrayList ssAETs = new ArrayList();
        Collection hl7OrderScheduledStations = ((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getHL7OrderScheduledStations();
        hl7OrderScheduledStations.forEach(station -> ssAETs.addAll(station.getDevice().getApplicationAETitles()));
        if (!ssAETs.isEmpty()) {
            sps.setString(0x400001, VR.AE, ssAETs.toArray(new String[0]));
        }
        if ((ssNames = (String[])hl7OrderScheduledStations.stream().filter(station -> station.getDevice().getStationName() != null).map(station -> station.getDevice().getStationName()).toArray(String[]::new)).length > 0) {
            sps.setString(0x400010, VR.SH, ssNames);
        }
    }

    private void validateAcceptedUserRoles(ArchiveAEExtension arcAE) {
        KeycloakContext keycloakContext = KeycloakContext.valueOf((HttpServletRequest)this.request);
        if (keycloakContext.isSecured() && !keycloakContext.isUserInRole(System.getProperty(SUPER_USER_ROLE)) && !arcAE.isAcceptedUserRole(keycloakContext.getRoles())) {
            throw new WebApplicationException("Application Entity " + arcAE.getApplicationEntity().getAETitle() + " does not list role of accessing user", Response.Status.FORBIDDEN);
        }
    }

    private void validateWebAppServiceClass() {
        this.device.getWebApplications().stream().filter(webApp -> this.request.getRequestURI().startsWith(webApp.getServicePath()) && Arrays.asList(webApp.getServiceClasses()).contains(WebApplication.ServiceClass.DCM4CHEE_ARC_AET)).findFirst().orElseThrow(() -> new WebApplicationException(this.errResponse("No Web Application with DCM4CHEE_ARC_AET service class found for Application Entity: " + this.aet, Response.Status.NOT_FOUND)));
    }
}

