/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.id.rs;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.dcm4chee.arc.id.IDService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="ids")
@RequestScoped
public class IDGeneratorRS {
    private static final Logger LOG = LoggerFactory.getLogger(IDGeneratorRS.class);
    @Inject
    private IDService idService;
    @Context
    private HttpServletRequest request;

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    @POST
    @Path(value="/{name}/nextval")
    public Response nextVal(@PathParam(value="name") String idGeneratorName) {
        this.logRequest();
        try {
            return Response.ok(out -> {
                JsonGenerator gen = Json.createGenerator((OutputStream)out);
                gen.writeStartObject();
                gen.write(idGeneratorName, this.idService.createID(idGeneratorName));
                gen.writeEnd();
                gen.flush();
            }).build();
        }
        catch (IllegalArgumentException e) {
            return this.errResponse(e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this, this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private Response errResponse(String msg, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private Response errResponseAsTextPlain(String msg, Response.Status status) {
        return Response.status((Response.Status)status).entity((Object)msg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }
}

