/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.wado;

import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.IWebApplicationCache;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.image.ICCProfile;
import org.dcm4che3.imageio.plugins.dcm.DicomImageReadParam;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.WebApplication;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.ws.rs.MediaTypes;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.entity.Location;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.retrieve.RetrieveService;
import org.dcm4chee.arc.retrieve.RetrieveWADO;
import org.dcm4chee.arc.retrieve.stream.DicomObjectOutput;
import org.dcm4chee.arc.store.InstanceLocations;
import org.dcm4chee.arc.validation.constraints.NotAllowedIfEquals;
import org.dcm4chee.arc.validation.constraints.NotAllowedIfNotEquals;
import org.dcm4chee.arc.validation.constraints.NotAllowedIfNotPresent;
import org.dcm4chee.arc.validation.constraints.NotAllowedIfPresent;
import org.dcm4chee.arc.validation.constraints.RequiredIfPresent;
import org.dcm4chee.arc.validation.constraints.ValidValueOf;
import org.dcm4chee.arc.wado.CDAOutput;
import org.dcm4chee.arc.wado.CompressedPixelDataOutput;
import org.dcm4chee.arc.wado.DicomXSLTOutput;
import org.dcm4chee.arc.wado.ObjectType;
import org.dcm4chee.arc.wado.RenderedImageOutput;
import org.dcm4chee.arc.wado.StreamCopyOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="aets/{AETitle}/wado")
@NotAllowedIfEquals(paramName="contentType", paramValue="application/dicom", notAllowed={"annotation", "rows", "columns", "region", "windowCenter", "windowWidth", "frameNumber", "presentationUID", "presentationSeriesUID"})
@NotAllowedIfNotEquals(paramName="contentType", paramValue="application/dicom", notAllowed={"anonymize", "transferSyntax"})
@RequiredIfPresent.List(value={@RequiredIfPresent(paramName="windowCenter", required={"windowWidth"}), @RequiredIfPresent(paramName="windowWidth", required={"windowCenter"}), @RequiredIfPresent(paramName="presentationUID", required={"presentationSeriesUID"})})
@NotAllowedIfNotPresent(paramName="presentationUID", notAllowed={"presentationSeriesUID"})
@NotAllowedIfPresent(paramName="presentationUID", notAllowed={"windowWidth", "windowCenter"})
public class WadoURI {
    private static final Logger LOG = LoggerFactory.getLogger(WadoURI.class);
    private static final String SUPER_USER_ROLE = "super-user-role";
    @Inject
    private RetrieveService service;
    @Context
    private HttpServletRequest request;
    @Inject
    private IWebApplicationCache iWebAppCache;
    @Inject
    private Device device;
    @Inject
    @RetrieveWADO
    private Event<RetrieveContext> retrieveWado;
    @Context
    private Request req;
    @PathParam(value="AETitle")
    private String aet;
    @QueryParam(value="requestType")
    @NotNull
    @Pattern(regexp="WADO")
    private @NotNull @Pattern(regexp="WADO") String requestType;
    @QueryParam(value="studyUID")
    @NotNull
    private String studyUID;
    @QueryParam(value="seriesUID")
    private String seriesUID;
    @QueryParam(value="objectUID")
    private String objectUID;
    @QueryParam(value="contentType")
    @ValidValueOf(type=ContentTypes.class)
    private String contentType;
    @QueryParam(value="charset")
    private String charset;
    @QueryParam(value="anonymize")
    @Pattern(regexp="yes")
    private @Pattern(regexp="yes") String anonymize;
    @QueryParam(value="annotation")
    @Pattern(regexp="patient|technique|patient,technique|technique,patient")
    private @Pattern(regexp="patient|technique|patient,technique|technique,patient") String annotation;
    @QueryParam(value="rows")
    @Pattern(regexp="[1-9]\\d{0,4}")
    private @Pattern(regexp="[1-9]\\d{0,4}") String rows;
    @QueryParam(value="columns")
    @Pattern(regexp="[1-9]\\d{0,4}")
    private @Pattern(regexp="[1-9]\\d{0,4}") String columns;
    @QueryParam(value="region")
    @ValidValueOf(type=Region.class)
    private String region;
    @QueryParam(value="windowCenter")
    @Digits(integer=5, fraction=5)
    private @Digits(integer=5, fraction=5) String windowCenter;
    @QueryParam(value="windowWidth")
    @DecimalMin(value="1")
    private @DecimalMin(value="1") String windowWidth;
    @QueryParam(value="frameNumber")
    @Pattern(regexp="[1-9]\\d{0,4}")
    private @Pattern(regexp="[1-9]\\d{0,4}") String frameNumber;
    @QueryParam(value="imageQuality")
    @Pattern(regexp="([1-9]\\d?)|100")
    private @Pattern(regexp="([1-9]\\d?)|100") String imageQuality;
    @QueryParam(value="presentationUID")
    private String presentationUID;
    @QueryParam(value="presentationSeriesUID")
    private String presentationSeriesUID;
    @QueryParam(value="transferSyntax")
    private String transferSyntax;
    @QueryParam(value="iccprofile")
    @Pattern(regexp="no|yes|srgb|adobergb|rommrgb")
    private @Pattern(regexp="no|yes|srgb|adobergb|rommrgb") String iccprofile;
    private Collection<String> acceptableTransferSyntaxes;
    private ContentTypes contentTypes;

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    @GET
    public void get(@Suspended AsyncResponse ar) {
        if (this.contentType != null) {
            this.contentTypes = new ContentTypes(this.contentType);
        }
        this.logRequest();
        ApplicationEntity ae = this.getApplicationEntity();
        this.validateAcceptedUserRoles((ArchiveAEExtension)ae.getAEExtensionNotNull(ArchiveAEExtension.class));
        if (this.aet.equals(ae.getAETitle())) {
            this.validateWebAppServiceClass();
        }
        try {
            RetrieveContext ctx = this.service.newRetrieveContextWADO(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), this.aet, this.studyUID, this.seriesUID, this.objectUID);
            if (this.request.getHeader("If-Modified-Since") == null && this.request.getHeader("If-Unmodified-Since") == null && this.request.getHeader("If-Match") == null && this.request.getHeader("If-None-Match") == null) {
                this.buildResponse(ar, ctx, null);
                return;
            }
            LOG.debug("Query Last Modified date of Instance");
            Date lastModified = this.service.getLastModified(ctx, this.ignorePatientUpdates());
            if (lastModified == null) {
                LOG.info("Last Modified date for Study[uid={}] Series[uid={} Instance[uid={}] is unavailable.", new Object[]{this.studyUID, this.seriesUID, this.objectUID});
                throw new WebApplicationException(WadoURI.errResponse("No matches found.", Response.Status.NOT_FOUND));
            }
            LOG.debug("Last Modified date: {}", (Object)lastModified);
            Response.ResponseBuilder respBuilder = this.evaluatePreConditions(lastModified);
            if (respBuilder == null) {
                LOG.debug("Preconditions are not met - build response");
                this.buildResponse(ar, ctx, lastModified);
            } else {
                Response response = respBuilder.build();
                LOG.debug("Preconditions are met - return status {}", (Object)response.getStatus());
                ar.resume((Object)response);
            }
        }
        catch (Exception e) {
            ar.resume((Throwable)e);
        }
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
        LOG.debug(" with HTTPHeaders[{}]", (Object)this.headers());
    }

    private String headers() {
        Enumeration headerNames = this.request.getHeaderNames();
        StringBuilder header = new StringBuilder();
        boolean multipleHeaders = false;
        while (headerNames.hasMoreElements()) {
            if (multipleHeaders) {
                header.append(", ");
            }
            String headerName = (String)headerNames.nextElement();
            header.append(headerName).append(":").append(this.headerValues(headerName));
            multipleHeaders = true;
        }
        return header.toString();
    }

    private String headerValues(String headerName) {
        Enumeration header = this.request.getHeaders(headerName);
        StringBuilder headerValues = new StringBuilder();
        boolean multipleValues = false;
        while (header.hasMoreElements()) {
            if (multipleValues) {
                headerValues.append(",");
            }
            headerValues.append((String)header.nextElement());
            multipleValues = true;
        }
        return headerValues.toString();
    }

    private void validateAcceptedUserRoles(ArchiveAEExtension arcAE) {
        KeycloakContext keycloakContext = KeycloakContext.valueOf((HttpServletRequest)this.request);
        if (keycloakContext.isSecured() && !keycloakContext.isUserInRole(System.getProperty(SUPER_USER_ROLE)) && !arcAE.isAcceptedUserRole(keycloakContext.getRoles())) {
            throw new WebApplicationException("Application Entity " + arcAE.getApplicationEntity().getAETitle() + " does not list role of accessing user", Response.Status.FORBIDDEN);
        }
    }

    private void validateWebAppServiceClass() {
        this.device.getWebApplications().stream().filter(webApp -> this.request.getRequestURI().startsWith(webApp.getServicePath()) && Arrays.asList(webApp.getServiceClasses()).contains(WebApplication.ServiceClass.WADO_URI)).findFirst().orElseThrow(() -> new WebApplicationException(WadoURI.errResponse("No Web Application with WADO_URI service class found for Application Entity: " + this.aet, Response.Status.NOT_FOUND)));
    }

    private void buildResponse(@Suspended AsyncResponse ar, RetrieveContext ctx, Date lastModified) throws IOException {
        LOG.debug("Query for requested instance");
        if (!this.service.calculateMatches(ctx)) {
            ArchiveAEExtension arcAE = ctx.getArchiveAEExtension();
            String webAppName = arcAE.fallbackWadoURIWebApplication();
            if (webAppName != null) {
                try {
                    ar.resume((Object)Response.status((int)arcAE.fallbackWadoURIHttpStatusCode()).location(this.redirectURI(webAppName)).build());
                    return;
                }
                catch (Exception e) {
                    LOG.warn("Failed to redirect to {}:\n", (Object)webAppName, (Object)e);
                }
            }
            throw new WebApplicationException(WadoURI.errResponse("No matches found.", Response.Status.NOT_FOUND));
        }
        List matches = ctx.getMatches();
        int numMatches = matches.size();
        if (numMatches > 1) {
            LOG.debug("{} matches found. Return {}. match", (Object)numMatches, (Object)(numMatches >>> 1));
        }
        InstanceLocations inst = (InstanceLocations)matches.get(numMatches >>> 1);
        int frame = this.frame(inst.getAttributes());
        ObjectType objectType = ObjectType.objectTypeOf(ctx, inst, frame);
        MediaType mimeType = this.selectMimeType(objectType).orElseThrow(() -> new WebApplicationException(WadoURI.errResponse("Supported Media Types for " + objectType + " not acceptable", Response.Status.NOT_ACCEPTABLE)));
        if (lastModified == null) {
            lastModified = this.service.getLastModifiedFromMatches(ctx, this.ignorePatientUpdates());
        }
        StreamingOutput entity = this.entityOf(ctx, inst, objectType, mimeType, frame);
        ar.register(throwable -> {
            ctx.getRetrieveService().updateLocations(ctx);
            ctx.setException(throwable);
            this.retrieveWado.fire((Object)ctx);
        });
        ar.resume((Object)Response.ok((Object)entity, (MediaType)(mimeType == MediaTypes.APPLICATION_DICOM_TYPE ? new MediaType(mimeType.getType(), mimeType.getSubtype(), this.parameters(inst)) : mimeType)).lastModified(lastModified).tag(String.valueOf(lastModified.hashCode())).build());
    }

    private boolean ignorePatientUpdates() {
        return this.contentTypes != null && this.contentTypes.ignorePatientUpdates;
    }

    private URI redirectURI(String webAppName) throws ConfigurationException {
        WebApplication webApp = this.iWebAppCache.findWebApplication(webAppName);
        if (!webApp.containsServiceClass(WebApplication.ServiceClass.WADO_URI)) {
            throw new ConfigurationException("WebApplication: " + webAppName + " does not provide WADO-URI service");
        }
        if (webApp.getDevice().getDeviceName().equals(this.device.getDeviceName())) {
            throw new ConfigurationException("WebApplication: " + webAppName + " is provided by this Device: " + this.device.getDeviceName() + " - prevent redirect to itself");
        }
        return URI.create(webApp.getServiceURL(this.selectConnection(webApp)).append('?').append(this.request.getQueryString()).toString());
    }

    private Connection selectConnection(WebApplication webApp) throws ConfigurationException {
        boolean https = "https:".equalsIgnoreCase(this.request.getRequestURL().substring(0, 6));
        Connection altConn = null;
        for (Connection conn : webApp.getConnections()) {
            if (!conn.isInstalled() || (altConn = conn).isTls() != https) continue;
            return conn;
        }
        if (altConn == null) {
            throw new ConfigurationException("No installed Network Connection for WebApplication: " + webApp.getApplicationName());
        }
        return altConn;
    }

    private Response.ResponseBuilder evaluatePreConditions(Date lastModified) {
        return this.req.evaluatePreconditions(new Date(lastModified.getTime() / 1000L * 1000L), new EntityTag(String.valueOf(lastModified.hashCode())));
    }

    private ApplicationEntity getApplicationEntity() {
        ApplicationEntity ae = this.device.getApplicationEntity(this.aet, true);
        if (ae == null || !ae.isInstalled()) {
            throw new WebApplicationException(WadoURI.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND));
        }
        return ae;
    }

    private Map<String, String> parameters(InstanceLocations inst) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        String tsuid = this.acceptableTransferSyntaxes.iterator().next();
        parameters.put("transfer-syntax", tsuid.equals("*") ? ((Location)inst.getLocations().get(0)).getTransferSyntaxUID() : tsuid);
        return parameters;
    }

    private StreamingOutput entityOf(RetrieveContext ctx, InstanceLocations inst, ObjectType objectType, MediaType mimeType, int frame) throws IOException {
        if (mimeType == MediaTypes.APPLICATION_DICOM_TYPE) {
            this.acceptableTransferSyntaxes = this.acceptableTransferSyntaxes(objectType, inst);
            return new DicomObjectOutput(ctx, inst, this.acceptableTransferSyntaxes);
        }
        switch (objectType) {
            case UncompressedSingleFrameImage: 
            case CompressedSingleFrameImage: 
            case UncompressedMultiFrameImage: 
            case CompressedMultiFrameImage: {
                return this.renderImage(ctx, inst, mimeType, frame);
            }
            case EncapsulatedCDA: {
                return this.decapsulateCDA(this.service.openDicomInputStream(ctx, inst), ctx.getArchiveAEExtension().wadoCDA2HtmlTemplateURI());
            }
            case EncapsulatedPDF: 
            case EncapsulatedSTL: 
            case EncapsulatedOBJ: 
            case EncapsulatedMTL: 
            case EncapsulatedGenozip: {
                return this.decapsulateDocument(this.service.openDicomInputStream(ctx, inst));
            }
            case MPEG2Video: 
            case MPEG4Video: {
                return new CompressedPixelDataOutput(ctx, inst);
            }
            case SRDocument: {
                return new DicomXSLTOutput(ctx, inst, mimeType, this.wadoURL());
            }
        }
        throw new AssertionError((Object)("objectType: " + objectType));
    }

    private RenderedImageOutput renderImage(RetrieveContext ctx, InstanceLocations inst, MediaType mimeType, int frame) throws IOException {
        Attributes attrs = inst.getAttributes();
        DicomImageReadParam readParam = new DicomImageReadParam();
        if (this.windowCenter != null && this.windowWidth != null) {
            readParam.setWindowCenter(Float.parseFloat(this.windowCenter));
            readParam.setWindowWidth(Float.parseFloat(this.windowWidth));
        }
        if (this.region != null) {
            readParam.setSourceRegion(new Region(this.region).getSourceRegion(attrs.getInt(2621456, 1), attrs.getInt(2621457, 1)));
        }
        if (this.presentationUID != null) {
            readParam.setPresentationState(this.retrievePresentationState());
        }
        readParam.setIgnorePresentationLUTShape(ctx.getArchiveAEExtension().isWadoIgnorePresentationLUTShape());
        return new RenderedImageOutput(ctx, inst, readParam, WadoURI.parseInt(this.rows), WadoURI.parseInt(this.columns), mimeType, this.imageQuality, this.iccProfile(mimeType), frame);
    }

    private ICCProfile.Option iccProfile(MediaType mimeType) {
        if (this.iccprofile == null) {
            return ICCProfile.Option.none;
        }
        ICCProfile.Option iccProfile = ICCProfile.Option.valueOf((String)this.iccprofile);
        if (iccProfile != ICCProfile.Option.no && !MediaTypes.equalsIgnoreParameters((MediaType)mimeType, (MediaType)MediaTypes.IMAGE_JPEG_TYPE)) {
            throw new WebApplicationException(WadoURI.errResponseAsTextPlain("Cannot embed ICC profile into " + mimeType, Response.Status.BAD_REQUEST));
        }
        return iccProfile;
    }

    private int frame(Attributes attrs) {
        int numFrames = attrs.getInt(0x280008, 1);
        if (this.frameNumber == null) {
            return numFrames > 1 ? 0 : 1;
        }
        int n = Integer.parseInt(this.frameNumber);
        if (n > numFrames) {
            throw new WebApplicationException(WadoURI.errResponse("frameNumber=" + this.frameNumber + " exceeds number of frames of specified resource", Response.Status.NOT_FOUND));
        }
        return n;
    }

    private static int parseInt(String s) {
        return s != null ? Integer.parseInt(s) : 0;
    }

    private String wadoURL() {
        return ((ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class)).remapRetrieveURL(this.request).toString();
    }

    private StreamingOutput decapsulateCDA(DicomInputStream dis, String templateURI) throws IOException {
        this.seekEncapsulatedDocument(dis);
        return templateURI != null ? new CDAOutput((InputStream)dis, dis.length(), templateURI) : new StreamCopyOutput((InputStream)dis, dis.length());
    }

    private StreamingOutput decapsulateDocument(DicomInputStream dis) throws IOException {
        this.seekEncapsulatedDocument(dis);
        return new StreamCopyOutput((InputStream)dis, dis.length());
    }

    private void seekEncapsulatedDocument(DicomInputStream dis) throws IOException {
        dis.readDataset(-1, 4325393);
        if (dis.tag() != 4325393) {
            throw new IOException("No encapsulated document in requested object");
        }
    }

    private Attributes retrievePresentationState() throws IOException {
        RetrieveContext ctx = this.service.newRetrieveContextWADO(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), this.aet, this.studyUID, this.presentationSeriesUID, this.presentationUID);
        if (!this.service.calculateMatches(ctx)) {
            throw new WebApplicationException(WadoURI.errResponse("Specified Presentation State does not exist", Response.Status.NOT_FOUND));
        }
        List matches = ctx.getMatches();
        if (matches.size() > 1) {
            throw new WebApplicationException(WadoURI.errResponse("More than one matching Presentation State found", Response.Status.BAD_REQUEST));
        }
        InstanceLocations inst = (InstanceLocations)matches.iterator().next();
        try (DicomInputStream dis = this.service.openDicomInputStream(ctx, inst);){
            Attributes attributes = dis.readDataset(-1, -1);
            return attributes;
        }
    }

    private Optional<MediaType> selectMimeType(ObjectType objectType) {
        if (this.contentType == null) {
            return Optional.of(objectType.getDefaultMimeType());
        }
        return Stream.of(this.contentTypes.values).map(objectType::getCompatibleMimeType).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    private Collection<String> acceptableTransferSyntaxes(ObjectType objectType, InstanceLocations inst) {
        ArrayList<String> tsuids = new ArrayList<String>(this.transferSyntax == null ? Collections.singleton("1.2.840.10008.1.2.1") : Arrays.asList(StringUtils.split((String)this.transferSyntax, (char)',')));
        tsuids.removeIf(tsuid -> !WadoURI.transcodeableTo(objectType, inst, tsuid));
        if (tsuids.isEmpty()) {
            throw new WebApplicationException(WadoURI.errResponse("Supported Transfer Syntaxes for " + objectType + " not acceptable", Response.Status.NOT_ACCEPTABLE));
        }
        return tsuids;
    }

    private static boolean transcodeableTo(ObjectType objectType, InstanceLocations inst, String accepted) {
        return accepted.equals("*") || !objectType.isVideo() && WadoURI.isUncompressed(accepted) || inst.getLocations().stream().anyMatch(l -> accepted.equals(l.getTransferSyntaxUID()));
    }

    private static boolean isUncompressed(String tsuid) {
        switch (tsuid) {
            case "1.2.840.10008.1.2": 
            case "1.2.840.10008.1.2.1": 
            case "1.2.840.10008.1.2.2": 
            case "1.2.840.10008.1.2.1.99": {
                return true;
            }
        }
        return false;
    }

    static boolean ignorePatientUpdates(MediaType mediaType) {
        return mediaType.getType().equalsIgnoreCase("image") || mediaType.getType().equalsIgnoreCase("video") || mediaType.getSubtype().equalsIgnoreCase("pdf");
    }

    private static Response errResponse(String errorMessage, Response.Status status) {
        return WadoURI.errResponseAsTextPlain("{\"errorMessage\":\"" + errorMessage + "\"}", status);
    }

    private static Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private static String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static final class Region {
        private final float left;
        private final float top;
        private final float right;
        private final float bottom;

        public Region(String s) {
            String[] ss = StringUtils.split((String)s, (char)',');
            if (ss.length != 4) {
                throw new IllegalArgumentException(s);
            }
            this.left = Float.parseFloat(ss[0]);
            this.top = Float.parseFloat(ss[1]);
            this.right = Float.parseFloat(ss[2]);
            this.bottom = Float.parseFloat(ss[3]);
            if ((double)this.left < 0.0 || (double)this.right > 1.0 || (double)this.top < 0.0 || (double)this.bottom > 1.0 || this.left >= this.right || this.top >= this.bottom) {
                throw new IllegalArgumentException(s);
            }
        }

        public Rectangle getSourceRegion(int rows, int columns) {
            return new Rectangle((int)(this.left * (float)columns), (int)(this.top * (float)rows), (int)Math.ceil((this.right - this.left) * (float)columns), (int)Math.ceil((this.bottom - this.top) * (float)rows));
        }
    }

    public static final class ContentTypes {
        final MediaType[] values;
        final boolean ignorePatientUpdates;

        public ContentTypes(String s) {
            String[] ss = StringUtils.split((String)s, (char)',');
            this.values = new MediaType[ss.length];
            boolean ignorePatientUpdates = true;
            for (int i = 0; i < ss.length; ++i) {
                this.values[i] = MediaType.valueOf((String)ss[i]);
                if (WadoURI.ignorePatientUpdates(this.values[i])) continue;
                ignorePatientUpdates = false;
            }
            this.ignorePatientUpdates = ignorePatientUpdates;
        }
    }
}

