/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.validation.constraints;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.dcm4chee.arc.validation.constraints.InvokeValidate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokeValidateValidator
implements ConstraintValidator<InvokeValidate, Object> {
    private static final Logger log = LoggerFactory.getLogger(InvokeValidateValidator.class);
    private Method validate;

    public void initialize(InvokeValidate constraint) {
        Class<?> type = constraint.type();
        String methodName = constraint.methodName();
        try {
            this.validate = type.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            log.warn("Failed to initialize validator: ", (Throwable)e);
        }
    }

    public boolean isValid(Object obj, ConstraintValidatorContext context) {
        try {
            this.validate.invoke(obj, new Object[0]);
        }
        catch (InvocationTargetException e) {
            return false;
        }
        catch (Exception e) {
            log.warn("Unexpected Exception: ", (Throwable)e);
        }
        return true;
    }
}

