/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.ups.storescu;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.ConfigurationNotFoundException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Code;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.dcmr.ScopeOfAccumulation;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4chee.arc.conf.UPSProcessingRule;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.retrieve.RetrieveService;
import org.dcm4chee.arc.store.InstanceLocations;
import org.dcm4chee.arc.store.scu.CStoreSCU;
import org.dcm4chee.arc.ups.UPSContext;
import org.dcm4chee.arc.ups.UPSService;
import org.dcm4chee.arc.ups.UPSUtils;
import org.dcm4chee.arc.ups.process.AbstractUPSProcessor;
import org.dcm4chee.arc.ups.process.UPSProcessorException;

public class UPSStoreSCU
extends AbstractUPSProcessor {
    private final RetrieveService retrieveService;
    private final CStoreSCU storeSCU;
    private final String defDestinationAE;

    public UPSStoreSCU(UPSProcessingRule rule, UPSService upsService, RetrieveService retrieveService, CStoreSCU storeSCU) {
        super(rule, upsService, true);
        this.retrieveService = retrieveService;
        this.storeSCU = storeSCU;
        this.defDestinationAE = rule.getUPSProcessorURI().getSchemeSpecificPart();
    }

    protected void processA(UPSContext upsCtx, Attributes ups) throws Exception {
        String destinationAE = this.destinationAEOf(ups);
        RetrieveContext retrieveContext = this.calculateMatches(ups, destinationAE);
        if (retrieveContext == null) {
            throw new UPSProcessorException(NOOP_UPS, "No matching Instances found");
        }
        if (this.retrieveService.restrictRetrieveAccordingTransferCapabilities(retrieveContext)) {
            this.storeSCU.newRetrieveTaskSTORE(retrieveContext).run();
            String outcomeDescription = retrieveContext.getOutcomeDescription();
            Attributes performedProcedure = this.getPerformedProcedureStep(upsCtx);
            performedProcedure.setString(4194900, VR.LO, outcomeDescription);
            Sequence outputInformationSeq = performedProcedure.getSequence(0x404033);
            for (InstanceLocations match : retrieveContext.getMatches()) {
                if (retrieveContext.isFailedSOPInstanceUID(match.getSopInstanceUID())) continue;
                UPSStoreSCU.refSOPSequence(outputInformationSeq, match, destinationAE).add(UPSStoreSCU.toSOPRef(match));
            }
            if (retrieveContext.status() != 0) {
                throw new DicomServiceException(retrieveContext.status(), outcomeDescription);
            }
        }
    }

    private String destinationAEOf(Attributes ups) {
        Attributes dicomStorage;
        Attributes outputDestination = ups.getNestedDataset(0x404070);
        return outputDestination != null && (dicomStorage = outputDestination.getNestedDataset(4210801)) != null ? dicomStorage.getString(553648448, this.defDestinationAE) : this.defDestinationAE;
    }

    private RetrieveContext calculateMatches(Attributes ups, String destAET) throws DicomServiceException {
        RetrieveContext retrieveContext = null;
        RetrieveLevel retrieveLevel = RetrieveLevel.of(UPSUtils.getScheduledProcessingCodeParameter((Attributes)ups, (Code)ScopeOfAccumulation.CODE));
        HashSet<String> suids = new HashSet<String>();
        for (Attributes inputInformation : ups.getSequence(4210721)) {
            RetrieveContext tmp = this.newRetrieveContext(retrieveLevel, inputInformation, destAET, suids);
            if (tmp == null || !this.retrieveService.calculateMatches(tmp)) continue;
            if (retrieveContext == null) {
                retrieveContext = tmp;
                continue;
            }
            retrieveContext.getMatches().addAll(tmp.getMatches());
            retrieveContext.setNumberOfMatches(retrieveContext.getNumberOfMatches() + tmp.getNumberOfMatches());
        }
        return retrieveContext;
    }

    private RetrieveContext newRetrieveContext(RetrieveLevel retrieveLevel, Attributes inputInformation, String destAET, Set<String> suids) throws DicomServiceException {
        try {
            return retrieveLevel.newRetrieveContextSTORE(this.retrieveService, this.rule.getAETitle(), inputInformation, destAET, suids);
        }
        catch (ConfigurationNotFoundException e) {
            throw new DicomServiceException(43009, e.getMessage());
        }
        catch (ConfigurationException e) {
            throw new DicomServiceException(42754, (Throwable)e);
        }
    }

    private static Attributes toSOPRef(InstanceLocations inst) {
        Attributes item = new Attributes(2);
        item.setString(528720, VR.UI, inst.getSopClassUID());
        item.setString(528725, VR.UI, inst.getSopInstanceUID());
        return item;
    }

    private static Sequence refSOPSequence(Sequence sq, InstanceLocations inst, String destAET) {
        String studyIUID = inst.getAttributes().getString(0x20000D);
        String seriesIUID = inst.getAttributes().getString(0x20000E);
        for (Attributes item : sq) {
            if (!studyIUID.equals(item.getString(0x20000D)) || !seriesIUID.equals(item.getString(0x20000E))) continue;
            return item.getSequence(528793);
        }
        Attributes item = new Attributes(5);
        sq.add(item);
        Sequence refSOPSequence = item.newSequence(528793, 10);
        item.setString(0x20000D, VR.UI, studyIUID);
        item.setString(0x20000E, VR.UI, seriesIUID);
        item.setString(4251680, VR.CS, "DICOM");
        item.newSequence(4251681, 1).add(UPSStoreSCU.retrieveAETItem(destAET));
        return refSOPSequence;
    }

    private static Attributes retrieveAETItem(String destAET) {
        Attributes item = new Attributes(1);
        item.setString(524372, VR.AE, destAET);
        return item;
    }

    private static enum RetrieveLevel {
        STUDY{

            @Override
            RetrieveContext newRetrieveContextSTORE(RetrieveService retrieveService, String aet, Attributes inputInformation, String destAET, Set<String> suids) throws ConfigurationException {
                String suid = inputInformation.getString(0x20000D);
                return suids.add(suid) ? retrieveService.newRetrieveContextSTORE(aet, suid, (String)null, (String)null, destAET) : null;
            }
        }
        ,
        SERIES{

            @Override
            RetrieveContext newRetrieveContextSTORE(RetrieveService retrieveService, String aet, Attributes inputInformation, String destAET, Set<String> suids) throws ConfigurationException {
                return retrieveService.newRetrieveContextSTORE(aet, inputInformation.getString(0x20000D), inputInformation.getString(0x20000E), (String)null, destAET);
            }
        }
        ,
        IMAGE{

            @Override
            RetrieveContext newRetrieveContextSTORE(RetrieveService retrieveService, String aet, Attributes inputInformation, String destAET, Set<String> suids) throws ConfigurationException {
                return retrieveService.newRetrieveContextSTORE(aet, inputInformation.getString(0x20000D), inputInformation.getString(0x20000E), inputInformation.getSequence(528793), destAET);
            }
        };


        public static RetrieveLevel of(Optional<Code> scopeOfAccumlation) {
            return scopeOfAccumlation.isPresent() ? (scopeOfAccumlation.get().equalsIgnoreMeaning(ScopeOfAccumulation.Study) ? STUDY : (scopeOfAccumlation.get().equalsIgnoreMeaning(ScopeOfAccumulation.Series) ? SERIES : IMAGE)) : IMAGE;
        }

        abstract RetrieveContext newRetrieveContextSTORE(RetrieveService var1, String var2, Attributes var3, String var4, Set<String> var5) throws ConfigurationException;
    }
}

