/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.ups.process.impl;

import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Code;
import org.dcm4che3.data.DateRange;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4chee.arc.Scheduler;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.ScheduleExpression;
import org.dcm4chee.arc.conf.UPSProcessingRule;
import org.dcm4chee.arc.query.Query;
import org.dcm4chee.arc.query.QueryContext;
import org.dcm4chee.arc.query.QueryService;
import org.dcm4chee.arc.query.util.OrderByTag;
import org.dcm4chee.arc.query.util.QueryParam;
import org.dcm4chee.arc.ups.UPSService;
import org.dcm4chee.arc.ups.process.UPSProcessor;
import org.dcm4chee.arc.ups.process.UPSProcessorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class UPSProcessingScheduler
extends Scheduler {
    private static final Logger LOG = LoggerFactory.getLogger(UPSProcessingScheduler.class);
    private static final List<OrderByTag> orderByTags = Arrays.asList(OrderByTag.desc((int)7606784), OrderByTag.asc((int)0x404005));
    @Inject
    private UPSService upsService;
    @Inject
    private QueryService queryService;
    @Inject
    private UPSProcessorFactory processorFactory;
    private Map<String, ProcessWorkitems> inProcess = new ConcurrentHashMap<String, ProcessWorkitems>();

    protected UPSProcessingScheduler() {
        super(Scheduler.Mode.scheduleWithFixedDelay);
    }

    protected Logger log() {
        return LOG;
    }

    protected Duration getPollingInterval() {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        return arcDev.getUPSProcessingPollingInterval();
    }

    protected void execute() {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
        if (arcDev.getUPSProcessingPollingInterval() == null) {
            return;
        }
        for (UPSProcessingRule rule : arcDev.listUPSProcessingRules()) {
            if (this.inProcess.containsKey(rule.getUPSProcessingRuleID()) || !ScheduleExpression.emptyOrAnyContainsNow((ScheduleExpression[])rule.getSchedules())) continue;
            try {
                this.device.execute((Runnable)new ProcessWorkitems(rule));
            }
            catch (Exception e) {
                LOG.warn("Failed to process {}: ", (Object)rule, (Object)e);
            }
        }
    }

    private static Attributes getQueryKeys(UPSProcessingRule rule) {
        Attributes keys = new Attributes(10);
        UPSProcessingScheduler.setCode(keys, 4210712, rule.getScheduledWorkitemCode());
        UPSProcessingScheduler.setCode(keys, 4210725, rule.getScheduledStationName());
        UPSProcessingScheduler.setCode(keys, 4210726, rule.getScheduledStationClass());
        UPSProcessingScheduler.setCode(keys, 4210727, rule.getScheduledStationLocation());
        keys.setString(0x404041, VR.CS, rule.getInputReadinessState().toString());
        keys.setString(7606272, VR.CS, "SCHEDULED");
        UPSProcessingScheduler.setString(keys, 7606784, VR.CS, rule.getUPSPriority());
        UPSProcessingScheduler.setString(keys, 7606786, VR.LO, rule.getWorklistLabel());
        UPSProcessingScheduler.setString(keys, 7606788, VR.LO, rule.getProcedureStepLabel());
        return keys;
    }

    private static void setString(Attributes keys, int tag, VR vr, Object value) {
        if (value != null) {
            keys.setString(tag, vr, value.toString());
        }
    }

    private static void setCode(Attributes attrs, int sqtag, Code code) {
        if (code != null) {
            attrs.newSequence(sqtag, 1).add(code.toItem());
        }
    }

    private class ProcessWorkitems
    implements Runnable {
        private final ArchiveAEExtension arcAE;
        private final UPSProcessor processor;
        private final QueryContext queryContext;

        public ProcessWorkitems(UPSProcessingRule rule) {
            ApplicationEntity ae = Objects.requireNonNull(UPSProcessingScheduler.this.device.getApplicationEntity(rule.getAETitle(), true), () -> String.format("No such Archive AE - %s", rule.getAETitle()));
            this.arcAE = (ArchiveAEExtension)ae.getAEExtensionNotNull(ArchiveAEExtension.class);
            this.processor = UPSProcessingScheduler.this.processorFactory.getUPSProcessor(rule);
            QueryParam queryParam = new QueryParam(this.arcAE);
            this.queryContext = UPSProcessingScheduler.this.queryService.newQueryContext(ae, queryParam);
            this.queryContext.setQueryKeys(UPSProcessingScheduler.getQueryKeys(rule));
            this.queryContext.setOrderByTags(orderByTags);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)UPSProcessingScheduler.this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
            UPSProcessingRule rule = this.processor.getUPSProcessingRule();
            int permits = rule.getMaxThreads();
            Semaphore semaphore = permits > 1 ? new Semaphore(permits) : null;
            UPSProcessingScheduler.this.inProcess.put(rule.getUPSProcessingRuleID(), this);
            try {
                while (this.processMatching(arcDev, semaphore)) {
                }
                if (semaphore != null) {
                    semaphore.acquire(permits);
                }
            }
            catch (Exception e) {
                LOG.warn("Failure on processing {}:/n", (Object)rule, (Object)e);
            }
            finally {
                UPSProcessingScheduler.this.inProcess.remove(rule.getUPSProcessingRuleID());
            }
        }

        private boolean processMatching(ArchiveDeviceExtension arcDev, Semaphore semaphore) throws DicomServiceException, InterruptedException {
            this.queryContext.getQueryKeys().setDateRange(0x404005, VR.DT, new DateRange(null, Calendar.getInstance().getTime()));
            try (Query query = UPSProcessingScheduler.this.queryService.createUPSWithoutQueryEvent(this.queryContext);){
                query.executeQuery(arcDev.getUPSProcessingFetchSize());
                if (!query.hasMoreMatches()) {
                    boolean bl = false;
                    return bl;
                }
                do {
                    if (arcDev.getUPSProcessingPollingInterval() == null) {
                        boolean bl = false;
                        return bl;
                    }
                    Attributes match = query.nextMatch();
                    if (semaphore != null) {
                        semaphore.acquire();
                        UPSProcessingScheduler.this.device.execute(() -> {
                            try {
                                this.processor.process(this.arcAE, match);
                            }
                            finally {
                                semaphore.release();
                            }
                        });
                        continue;
                    }
                    this.processor.process(this.arcAE, match);
                } while (query.hasMoreMatches());
            }
            return true;
        }
    }
}

