/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.ups.process;

import java.util.Date;
import java.util.Optional;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Code;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.dcmr.ProcedureDiscontinuationReasons;
import org.dcm4che3.dcmr.UnitsOfMeasurement;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.util.TagUtils;
import org.dcm4che3.util.UIDUtils;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.Entity;
import org.dcm4chee.arc.conf.UPSProcessingRule;
import org.dcm4chee.arc.ups.UPSContext;
import org.dcm4chee.arc.ups.UPSService;
import org.dcm4chee.arc.ups.UPSUtils;
import org.dcm4chee.arc.ups.process.UPSProcessor;
import org.dcm4chee.arc.ups.process.UPSProcessorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUPSProcessor
implements UPSProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractUPSProcessor.class);
    private static final int[] EXCLUDE_FROM_REPLACEMENT = new int[]{524310, 524312, 0x404010, 7606274, 7606806};
    public static final Code BAD_UPS = new Code("BAD_UPS", "99DCM4CHEE", null, "Unified Procedure Step does not meet processing requirements");
    public static final Code NOOP_UPS = new Code("NOP_UPS", "99DCM4CHEE", null, "Processing Unified Procedure Step with no operation");
    public static final Code FAILED_UPS = new Code("FAILED_UPS", "99DCM4CHEE", null, "Failure on processing Unified Procedure Step");
    private static final Code NUM_UPS_FAILED = new Code("NUM_UPS_FAILED", "99DCM4CHEE", null, "Number of failed attempts to process this Procedure Step");
    protected final UPSProcessingRule rule;
    protected final UPSService upsService;
    protected final boolean inputInformationRequired;

    public AbstractUPSProcessor(UPSProcessingRule rule, UPSService upsService, boolean inputInformationRequired) {
        this.rule = rule;
        this.upsService = upsService;
        this.inputInformationRequired = inputInformationRequired;
    }

    @Override
    public UPSProcessingRule getUPSProcessingRule() {
        return this.rule;
    }

    @Override
    public void process(ArchiveAEExtension arcAE, Attributes ups) {
        UPSContext upsCtx = this.upsService.newUPSContext(null, arcAE);
        upsCtx.setUPSInstanceUID(ups.getString(524312));
        upsCtx.setRequesterAET(arcAE.getApplicationEntity().getAETitle());
        Attributes transaction = new Attributes(2);
        transaction.setString(528789, VR.UI, UIDUtils.createUID());
        transaction.setString(7606272, VR.CS, "IN PROGRESS");
        upsCtx.setAttributes(transaction);
        Attributes performedProcedure = this.initPerformedProcedure(upsCtx, ups);
        try {
            this.upsService.changeUPSState(upsCtx);
        }
        catch (DicomServiceException e) {
            switch (e.getStatus()) {
                case 49922: {
                    LOG.info("UPS[uid={}] already IN PROCESS", (Object)upsCtx.getUPSInstanceUID());
                    break;
                }
                case 49920: {
                    LOG.info("UPS[uid={}] may no longer be updated", (Object)upsCtx.getUPSInstanceUID());
                    break;
                }
                default: {
                    LOG.warn("Failed to change status of UPS[uid={}] to IN PROCESS:\n", (Object)upsCtx.getUPSInstanceUID(), (Object)e);
                }
            }
            return;
        }
        Attributes replacement = null;
        try {
            this.verify(ups);
            try {
                this.processA(upsCtx, ups);
            }
            catch (DicomServiceException e) {
                throw new UPSProcessorException(AbstractUPSProcessor.reasonCodeOf(e.getStatus()), (Throwable)e);
            }
            catch (Exception e) {
                throw new UPSProcessorException(FAILED_UPS, (Throwable)e);
            }
            transaction.setString(7606272, VR.CS, "COMPLETED");
            performedProcedure.setDate(4210769, VR.DT, new Date[]{new Date()});
        }
        catch (UPSProcessorException e) {
            long delay;
            if (this.rule.isIgnoreDiscontinuationReasonCodes(e.reasonCode)) {
                transaction.setString(7606272, VR.CS, "COMPLETED");
                performedProcedure.setDate(4210769, VR.DT, new Date[]{new Date()});
                if (!performedProcedure.containsValue(4194900)) {
                    performedProcedure.setString(4194900, VR.LO, e.getMessage());
                }
            }
            transaction.setString(7606272, VR.CS, "CANCELED");
            if (BAD_UPS.equalsIgnoreMeaning(e.reasonCode) || !this.rule.isRescheduleDiscontinuationReasonCodes(e.reasonCode) || (delay = this.retryDelay(ups)) < 0L) {
                LOG.warn("Failed to process UPS[uid={}]:\n", (Object)ups.getString(524312), (Object)e);
                this.setReasonForCancellation(upsCtx, e.getMessage(), e.reasonCode);
                this.newUPSOnCancel(arcAE, ups);
            }
            LOG.info("Failed to process UPS[uid={}] - retry:\n", (Object)ups.getString(524312), (Object)e);
            this.setReasonForCancellation(upsCtx, e.getMessage(), ProcedureDiscontinuationReasons.DiscontinuedProcedureStepRescheduled);
            replacement = new Attributes(ups.size());
            replacement.addNotSelected(ups, EXCLUDE_FROM_REPLACEMENT);
            replacement.setDate(0x404005, VR.DT, new Date[]{new Date(System.currentTimeMillis() + delay * 1000L)});
            replacement.setString(7606272, VR.CS, "SCHEDULED");
            replacement.newSequence(7606820, 1).add(AbstractUPSProcessor.refSOP(ups.getString(524310), ups.getString(524312)));
            this.incrNumUPSFailed(replacement);
        }
        try {
            this.upsService.changeUPSState(upsCtx);
        }
        catch (DicomServiceException e) {
            LOG.warn("Failed to change status of UPS[uid={}] to {}:\n", new Object[]{upsCtx.getUPSInstanceUID(), transaction.getString(7606272), e});
        }
        if (replacement != null) {
            try {
                this.createUPS(upsCtx, replacement);
            }
            catch (DicomServiceException e) {
                LOG.warn("Failed to schedule replacement of UPS[uid={}]\n", (Object)ups.getString(524312), (Object)e);
            }
        }
    }

    private void newUPSOnCancel(ArchiveAEExtension arcAE, Attributes ups) {
        if (this.rule.getUpsTemplateID() == null) {
            return;
        }
        try {
            UPSContext upsCtx = this.upsService.newUPSContext(null, arcAE);
            upsCtx.setRequesterAET(arcAE.getApplicationEntity().getAETitle());
            Attributes upsOnCancel = this.upsTemplateAttrs(arcAE);
            upsOnCancel.setDate(0x404005, VR.DT, new Date[]{new Date()});
            upsOnCancel.newSequence(7606820, 1).add(AbstractUPSProcessor.refSOP(ups.getString(524310), ups.getString(524312)));
            upsOnCancel.addSelected(ups, arcAE.getArchiveDeviceExtension().getAttributeFilter(Entity.Patient).getSelection());
            this.createUPS(upsCtx, upsOnCancel);
        }
        catch (DicomServiceException e) {
            LOG.warn("Failed to create new UPS record for failed UPS[uid={}] processing, using UPS Template Workitem[IUID={}]\n", new Object[]{ups.getString(524312), this.rule.getUpsTemplateID(), e});
        }
    }

    private Attributes upsTemplateAttrs(ArchiveAEExtension arcAE) throws DicomServiceException {
        UPSContext ctx = this.upsService.newUPSContext(null, arcAE);
        ctx.setUPSInstanceUID(this.rule.getUpsTemplateID());
        return this.upsService.findUPS(ctx).getAttributes();
    }

    private void createUPS(UPSContext upsCtx, Attributes upsAttrs) throws DicomServiceException {
        upsCtx.setUPSInstanceUID(UIDUtils.createUID());
        upsCtx.setAttributes(upsAttrs);
        this.upsService.createUPS(upsCtx);
    }

    private void incrNumUPSFailed(Attributes replacement) {
        Optional numUPSFailedAttrs = UPSUtils.getScheduledProcessingParameter((Attributes)replacement, (Code)NUM_UPS_FAILED);
        if (numUPSFailedAttrs.isPresent()) {
            Attributes attrs = (Attributes)numUPSFailedAttrs.get();
            attrs.setFloat(4236042, VR.DS, new float[]{attrs.getFloat(4236042, 0.0f) + 1.0f});
        } else {
            replacement.ensureSequence(7606800, 1).add(this.initNumUPSFailedAttrs());
        }
    }

    private Attributes initNumUPSFailedAttrs() {
        Attributes item = new Attributes(4);
        item.newSequence(4196586, 1).add(UnitsOfMeasurement.NO_UNITS.toItem());
        item.setString(0x40A040, VR.CS, "NUMERIC");
        item.newSequence(4235331, 1).add(NUM_UPS_FAILED.toItem());
        item.setString(4236042, VR.DS, "1");
        return item;
    }

    protected void verify(Attributes ups) throws UPSProcessorException {
        if (this.inputInformationRequired && !ups.containsValue(4210721)) {
            throw new UPSProcessorException(BAD_UPS, "Missing Input Information");
        }
    }

    private long retryDelay(Attributes ups) {
        Optional numUPSFailed = UPSUtils.getScheduledProcessingParameter((Attributes)ups, (Code)NUM_UPS_FAILED);
        return this.rule.getRetryDelayInSeconds(numUPSFailed.map(a -> (int)a.getFloat(4236042, 0.0f)).orElse(0) + 1);
    }

    private static Attributes refSOP(String cuid, String iuid) {
        Attributes item = new Attributes(2);
        item.setString(528720, VR.UI, cuid);
        item.setString(528725, VR.UI, iuid);
        return item;
    }

    protected Attributes initPerformedProcedure(UPSContext upsCtx, Attributes ups) {
        Attributes mergeAttributes = new Attributes(2);
        mergeAttributes.ensureSequence(7606274, 1);
        Sequence sq = mergeAttributes.newSequence(7606806, 1);
        Attributes performedProcedure = new Attributes();
        performedProcedure.newSequence(4210713, 1).add(this.rule.getPerformedWorkitemCode().toItem());
        performedProcedure.newSequence(4210728, 1).add(this.rule.getPerformedStationNameCode().toItem());
        performedProcedure.newSequence(0x404033, 10);
        performedProcedure.setDate(0x404050, VR.DT, new Date[]{new Date()});
        sq.add(performedProcedure);
        upsCtx.setMergeAttributes(mergeAttributes);
        return performedProcedure;
    }

    protected Attributes getPerformedProcedureStep(UPSContext upsCtx) {
        return upsCtx.getMergeAttributes().getNestedDataset(7606806);
    }

    protected Attributes getProgressInformation(UPSContext upsCtx) {
        Sequence sq = upsCtx.getMergeAttributes().getSequence(7606274);
        if (!sq.isEmpty()) {
            return (Attributes)sq.get(0);
        }
        Attributes progressInformation = new Attributes();
        sq.add(progressInformation);
        return progressInformation;
    }

    private void setReasonForCancellation(UPSContext upsCtx, String reason, Code reasonCode) {
        Attributes progressInformation = this.getProgressInformation(upsCtx);
        progressInformation.setDate(4210770, VR.DT, new Date[]{new Date()});
        progressInformation.newSequence(7606286, 1).add(reasonCode.toItem());
        progressInformation.setString(7606840, VR.LT, reason);
    }

    protected abstract void processA(UPSContext var1, Attributes var2) throws Exception;

    private static Code reasonCodeOf(int status) {
        String codeValue = TagUtils.shortToHexString((int)status);
        return new Code(codeValue + "_UPS", "99DCM4CHEE", null, "Processing Unified Procedure Step failed with DICOM Status Code: " + codeValue);
    }
}

