/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.ups.ianscu;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DimseRSP;
import org.dcm4che3.util.TagUtils;
import org.dcm4che3.util.UIDUtils;
import org.dcm4chee.arc.conf.Availability;
import org.dcm4chee.arc.conf.UPSProcessingRule;
import org.dcm4chee.arc.ian.scu.IANSCU;
import org.dcm4chee.arc.query.QueryService;
import org.dcm4chee.arc.ups.UPSContext;
import org.dcm4chee.arc.ups.UPSService;
import org.dcm4chee.arc.ups.process.AbstractUPSProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UPSIANSCU
extends AbstractUPSProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(UPSIANSCU.class);
    private final IANSCU ianSCU;
    private final QueryService queryService;
    private final String defDestinationAE;
    private final Device device;

    public UPSIANSCU(UPSProcessingRule rule, UPSService upsService, IANSCU ianSCU, QueryService queryService, Device device) {
        super(rule, upsService, true);
        this.ianSCU = ianSCU;
        this.queryService = queryService;
        this.device = device;
        this.defDestinationAE = rule.getUPSProcessorURI().getSchemeSpecificPart();
    }

    protected void processA(UPSContext upsCtx, Attributes ups) throws Exception {
        String destinationAE = this.destinationAEOf(ups);
        ApplicationEntity ae = Objects.requireNonNull(this.device.getApplicationEntity(this.rule.getAETitle(), true), () -> String.format("No such Archive AE - %s", this.rule.getAETitle()));
        for (Map.Entry<String, IanInfo> entry : this.studyIanInfoFrom(ups).entrySet()) {
            IanInfo ianInfo = entry.getValue();
            Attributes ian = this.queryService.createIAN(ae, entry.getKey(), ianInfo.getSeriesRefSOPSeq().keySet().toArray(new String[0]), null, null, null, null);
            if (ian == null) {
                LOG.info("Ignore IAN of Study[uid={}] without referenced objects.", (Object)entry.getKey());
                continue;
            }
            ianInfo.setIan(ian);
            String sopInstanceUID = UIDUtils.createUID();
            DimseRSP dimseRSP = this.ianSCU.sendIANRQ(this.rule.getAETitle(), destinationAE, sopInstanceUID, ianInfo.getIan());
            dimseRSP.next();
            Attributes cmd = dimseRSP.getCommand();
            int status = cmd.getInt(2304, -1);
            this.getPerformedProcedureStep(upsCtx).setString(4194900, VR.LO, this.outcomeDesc(status, cmd.getString(2306), sopInstanceUID, destinationAE));
        }
    }

    private String destinationAEOf(Attributes ups) {
        Attributes dicomStorage;
        Attributes outputDestination = ups.getNestedDataset(0x404070);
        return outputDestination != null && (dicomStorage = outputDestination.getNestedDataset(4210801)) != null ? dicomStorage.getString(553648448, this.defDestinationAE) : this.defDestinationAE;
    }

    private String outcomeDesc(int status, String errorComment, String sopInstanceUID, String destinationAE) {
        return status != 0 ? "Send IAN[uid=" + sopInstanceUID + "] to AE: " + destinationAE + " failed with status: " + TagUtils.shortToHexString((int)status) + "H, error comment: " + errorComment : "Send IAN[uid=" + sopInstanceUID + "] to AE: " + destinationAE;
    }

    private Map<String, IanInfo> studyIanInfoFrom(Attributes ups) {
        HashMap<String, IanInfo> studyIanInfo = new HashMap<String, IanInfo>();
        ups.getSequence(4210721).forEach(inputInformation -> studyIanInfo.computeIfAbsent(inputInformation.getString(0x20000D), ianInfo -> new IanInfo((Attributes)inputInformation, this.rule.getAETitle())).addSeriesRefSopSeq((Attributes)inputInformation));
        return studyIanInfo;
    }

    static class IanInfo {
        private Attributes ian;
        private final Map<String, Sequence> seriesRefSOPSeq = new HashMap<String, Sequence>();
        private final String retrieveAET;

        IanInfo(Attributes inputInformation, String retrieveAET) {
            this.retrieveAET = retrieveAET;
            this.addSeriesRefSopSeq(inputInformation);
        }

        Attributes getIan() {
            return this.ian;
        }

        public void setIan(Attributes ian) {
            this.ian = this.compute(ian);
        }

        Map<String, Sequence> getSeriesRefSOPSeq() {
            return this.seriesRefSOPSeq;
        }

        void addSeriesRefSopSeq(Attributes inputInformation) {
            this.seriesRefSOPSeq.put(inputInformation.getString(0x20000E), inputInformation.getSequence(528793));
        }

        Attributes compute(Attributes ian) {
            for (Map.Entry<String, Sequence> entry : this.seriesRefSOPSeq.entrySet()) {
                Sequence refSeriesSeqIAN;
                Sequence refSOPSeq;
                String seriesUID = entry.getKey();
                if (this.removeNotReferredAddUnavailableInstances(seriesUID, refSOPSeq = entry.getValue(), refSeriesSeqIAN = ian.getSequence(528661))) continue;
                this.addUnavailableSeries(seriesUID, refSOPSeq, refSeriesSeqIAN);
            }
            return ian;
        }

        private boolean removeNotReferredAddUnavailableInstances(String seriesUID, Sequence refSOPSeq, Sequence refSeriesSeqIAN) {
            for (Attributes refSeriesIAN : refSeriesSeqIAN) {
                if (!seriesUID.equals(refSeriesIAN.getString(0x20000E))) continue;
                Sequence refSOPSeqIAN = refSeriesIAN.getSequence(528793);
                refSOPSeqIAN.removeIf(refSOPIAN -> !this.referred(refSOPSeq, (Attributes)refSOPIAN));
                this.addUnavailableInstances(refSOPSeqIAN, refSOPSeq);
                return true;
            }
            return false;
        }

        private void addUnavailableInstances(Sequence refSOPSeqIAN, Sequence refSOPSeq) {
            for (Attributes refSOP : refSOPSeq) {
                if (this.availableInstance(refSOPSeqIAN, refSOP)) continue;
                refSOPSeqIAN.add(this.unavailable(refSOP));
            }
        }

        private boolean availableInstance(Sequence refSOPSeqIAN, Attributes refSOP) {
            String iuid = refSOP.getString(528725);
            for (Attributes refSOPIAN : refSOPSeqIAN) {
                if (!iuid.equals(refSOPIAN.getString(528725))) continue;
                return true;
            }
            return false;
        }

        private void addUnavailableSeries(String seriesUID, Sequence refSOPSeq, Sequence refSeriesSeqIAN) {
            Attributes refSeries = new Attributes(2);
            refSeries.setString(0x20000E, VR.UI, seriesUID);
            Sequence refSOPSeq1 = refSeries.newSequence(528793, refSOPSeq.size());
            refSOPSeq.forEach(refSOP -> refSOPSeq1.add(this.unavailable((Attributes)refSOP)));
            refSeriesSeqIAN.add(refSeries);
        }

        private Attributes unavailable(Attributes refSOP) {
            Attributes unavailable = new Attributes(4);
            unavailable.setString(528720, VR.UI, refSOP.getString(528720));
            unavailable.setString(528725, VR.UI, refSOP.getString(528725));
            unavailable.setString(524372, VR.AE, this.retrieveAET);
            unavailable.setString(524374, VR.CS, Availability.UNAVAILABLE.name());
            return unavailable;
        }

        private boolean referred(Sequence refSOPSeq, Attributes refSOP) {
            String iuid = refSOP.getString(528725);
            for (Attributes ref : refSOPSeq) {
                if (!iuid.equals(ref.getString(528725))) continue;
                return true;
            }
            return false;
        }
    }
}

