/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.ups.impl;

import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.util.ReverseDNS;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.ArchiveHL7ApplicationExtension;
import org.dcm4chee.arc.conf.UPSOnStore;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.store.StoreContext;
import org.dcm4chee.arc.ups.UPSContext;
import org.dcm4chee.arc.ups.UPSEvent;

public class UPSContextImpl
implements UPSContext {
    private final Association as;
    private final HttpServletRequestInfo httpRequestInfo;
    private final ArchiveAEExtension archiveAEExtension;
    private final ArchiveHL7ApplicationExtension archiveHL7AppExtension;
    private final Socket socket;
    private final Patient patient;
    private Attributes attributes;
    private Attributes mergeAttributes;
    private String upsInstanceUID;
    private String requesterAET;
    private String subscriberAET;
    private boolean deletionLock;
    private boolean template;
    private int status;
    private List<UPSEvent> upsEvents;

    public UPSContextImpl(HttpServletRequestInfo httpRequestInfo, ArchiveAEExtension archiveAEExtension) {
        this.as = null;
        this.httpRequestInfo = httpRequestInfo;
        this.archiveAEExtension = archiveAEExtension;
        this.patient = null;
        this.socket = null;
        this.archiveHL7AppExtension = null;
    }

    public UPSContextImpl(Association as) {
        this.as = as;
        this.requesterAET = as.getCallingAET();
        this.httpRequestInfo = null;
        this.archiveAEExtension = (ArchiveAEExtension)as.getApplicationEntity().getAEExtensionNotNull(ArchiveAEExtension.class);
        this.patient = null;
        this.socket = null;
        this.archiveHL7AppExtension = null;
    }

    public UPSContextImpl(StoreContext storeContext, UPSOnStore rule) {
        this.as = storeContext.getStoreSession().getAssociation();
        this.httpRequestInfo = storeContext.getStoreSession().getHttpRequest();
        this.archiveAEExtension = storeContext.getStoreSession().getArchiveAEExtension();
        this.patient = rule.isIncludePatient() ? storeContext.getStoredInstance().getSeries().getStudy().getPatient() : null;
        this.socket = storeContext.getStoreSession().getSocket();
        this.archiveHL7AppExtension = null;
    }

    public UPSContextImpl(Socket socket, ArchiveHL7ApplicationExtension archiveHL7AppExtension) {
        this.as = null;
        this.httpRequestInfo = null;
        this.archiveAEExtension = archiveHL7AppExtension.getArchiveAEExtension();
        this.patient = null;
        this.socket = socket;
        this.requesterAET = archiveHL7AppExtension.getAETitle();
        this.archiveHL7AppExtension = archiveHL7AppExtension;
    }

    public UPSContextImpl(UPSContext other) {
        this.as = other.getAssociation();
        this.httpRequestInfo = other.getHttpRequestInfo();
        this.socket = other.getSocket();
        this.archiveAEExtension = other.getArchiveAEExtension();
        this.archiveHL7AppExtension = other.getArchiveHL7AppExtension();
        this.patient = other.getPatient();
        this.requesterAET = other.getRequesterAET();
    }

    @Override
    public HttpServletRequestInfo getHttpRequestInfo() {
        return this.httpRequestInfo;
    }

    @Override
    public Association getAssociation() {
        return this.as;
    }

    @Override
    public ArchiveAEExtension getArchiveAEExtension() {
        return this.archiveAEExtension;
    }

    @Override
    public ApplicationEntity getApplicationEntity() {
        return this.archiveAEExtension.getApplicationEntity();
    }

    @Override
    public ArchiveDeviceExtension getArchiveDeviceExtension() {
        return this.archiveAEExtension != null ? this.archiveAEExtension.getArchiveDeviceExtension() : this.archiveHL7AppExtension.getArchiveDeviceExtension();
    }

    @Override
    public String getRemoteHostName() {
        return this.httpRequestInfo != null ? this.httpRequestInfo.requesterHost : (this.socket != null ? ReverseDNS.hostNameOf((InetAddress)this.socket.getInetAddress()) : null);
    }

    @Override
    public String getLocalHostName() {
        return this.httpRequestInfo != null ? this.httpRequestInfo.localHost : (this.socket != null ? ReverseDNS.hostNameOf((InetAddress)this.socket.getLocalAddress()) : null);
    }

    @Override
    public String getUPSInstanceUID() {
        return this.upsInstanceUID;
    }

    @Override
    public void setUPSInstanceUID(String upsInstanceUID) {
        this.upsInstanceUID = upsInstanceUID;
    }

    @Override
    public boolean isGlobalSubscription() {
        return this.upsInstanceUID.equals("1.2.840.10008.5.1.4.34.5") || this.upsInstanceUID.equals("1.2.840.10008.5.1.4.34.5.1");
    }

    @Override
    public Patient getPatient() {
        return this.patient;
    }

    @Override
    public String getRequesterAET() {
        return this.requesterAET;
    }

    @Override
    public void setRequesterAET(String requesterAET) {
        this.requesterAET = requesterAET;
    }

    @Override
    public String getSubscriberAET() {
        return this.subscriberAET;
    }

    @Override
    public void setSubscriberAET(String subscriberAET) {
        this.subscriberAET = subscriberAET;
    }

    @Override
    public boolean isDeletionLock() {
        return this.deletionLock;
    }

    @Override
    public void setDeletionLock(boolean deletionLock) {
        this.deletionLock = deletionLock;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    @Override
    public Attributes getMergeAttributes() {
        return this.mergeAttributes;
    }

    @Override
    public void setMergeAttributes(Attributes mergeAttributes) {
        this.mergeAttributes = mergeAttributes;
    }

    @Override
    public boolean isTemplate() {
        return this.template;
    }

    @Override
    public void setTemplate(boolean template) {
        this.template = template;
    }

    @Override
    public boolean isUPSUpdateWithoutTransactionUID() {
        return this.archiveAEExtension.upsUpdateWithoutTransactionUID();
    }

    @Override
    public ArchiveHL7ApplicationExtension getArchiveHL7AppExtension() {
        return this.archiveHL7AppExtension;
    }

    @Override
    public Socket getSocket() {
        return this.socket;
    }

    @Override
    public List<UPSEvent> getUPSEvents() {
        if (this.upsEvents == null) {
            this.upsEvents = new ArrayList<UPSEvent>();
        }
        return this.upsEvents;
    }

    @Override
    public void addUPSEvent(UPSEvent.Type type, String upsInstanceUID, Attributes eventInformation, List<String> subcribers) {
        this.getUPSEvents().add(new UPSEvent(this.archiveAEExtension, type, upsInstanceUID, eventInformation, subcribers));
    }

    public String toString() {
        return this.as != null ? this.as.toString() : (this.httpRequestInfo != null ? this.httpRequestInfo.requesterUserID + "@" + this.httpRequestInfo.requesterHost + "->" + this.archiveAEExtension.getApplicationEntity().getAETitle() : (this.socket != null ? this.socket.toString() : this.archiveAEExtension.getApplicationEntity().getAETitle()));
    }
}

