/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.stow;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.RequestScoped;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonParsingException;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.BulkData;
import org.dcm4che3.data.BulkDataWithPrefix;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.Fragments;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.UID;
import org.dcm4che3.data.VR;
import org.dcm4che3.dcmr.ContributingEquipmentPurposeOfReference;
import org.dcm4che3.image.BufferedImageUtils;
import org.dcm4che3.imageio.codec.jpeg.JPEGParser;
import org.dcm4che3.imageio.codec.mp4.MP4Parser;
import org.dcm4che3.imageio.codec.mpeg.MPEG2Parser;
import org.dcm4che3.io.SAXReader;
import org.dcm4che3.json.JSONReader;
import org.dcm4che3.mime.MultipartInputStream;
import org.dcm4che3.mime.MultipartParser;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.WebApplication;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.util.ByteUtils;
import org.dcm4che3.util.StreamUtils;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.TagUtils;
import org.dcm4che3.util.UIDUtils;
import org.dcm4che3.ws.rs.MediaTypes;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.dcm4chee.arc.procedure.ProcedureService;
import org.dcm4chee.arc.query.util.QueryAttributes;
import org.dcm4chee.arc.store.StoreContext;
import org.dcm4chee.arc.store.StoreService;
import org.dcm4chee.arc.store.StoreSession;
import org.dcm4chee.arc.stow.OutputType;
import org.dcm4chee.arc.validation.constraints.InvokeValidate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@RequestScoped
@javax.ws.rs.Path(value="aets/{AETitle}/rs")
@InvokeValidate(type=StowRS.class)
public class StowRS {
    private static final Logger LOG = LoggerFactory.getLogger(StowRS.class);
    private static final String NOT_A_DICOM_FILE_UID = "1.2.40.0.13.1.15.110.3.165.2";
    private static final int[] IUIDS_TAGS = new int[]{0x20000D, 0x20000E, 524312};
    private static final int[] IMAGE_PIXEL_TAGS = new int[]{0x280002, 2621444, 2621456, 2621457, 2621696, 2621697, 2621698, 2621699};
    private static final ElementDictionary DICT = ElementDictionary.getStandardElementDictionary();
    private static final String SUPER_USER_ROLE = "super-user-role";
    private static final String IRWF_NOT_SUPPORTED = "Query Parameter 'irwf' not supported for Metadata and Bulkdata payload";
    private static final String IRWF_MISSING_PATIENT_ID = "Query Parameter 'irwf=UNSCHEDULED' requires Query Parameter '00100020'";
    private static final String IRWF_PATIENT_ID_NOT_SUPPORTED = "Query Parameter 'irwf=SCHEDULED' can't be used with Query Parameter '00100020'";
    private static final String IRWF_MISSING_SPS = "Query Parameter 'irwf=SCHEDULED' requires Query Parameters '0020000D' and '00400100.00400009'";
    private static final String IRWF_NOT_SCHEDULED = "No Procedure Step with given '0020000D' and '00400100.00400009' scheduled";
    @Inject
    private ProcedureService procedureService;
    @Inject
    private StoreService service;
    @Context
    private HttpServletRequest request;
    @Context
    private UriInfo uriInfo;
    @Inject
    private Device device;
    @HeaderParam(value="Content-Type")
    private MediaType contentType;
    @PathParam(value="AETitle")
    private String aet;
    @QueryParam(value="updatePolicy")
    @Pattern(regexp="SUPPLEMENT|MERGE|OVERWRITE")
    @DefaultValue(value="OVERWRITE")
    private @Pattern(regexp="SUPPLEMENT|MERGE|OVERWRITE") String updatePolicy;
    @QueryParam(value="reasonForModification")
    @Pattern(regexp="COERCE|CORRECT")
    private @Pattern(regexp="COERCE|CORRECT") String reasonForModification;
    @QueryParam(value="sourceOfPreviousValues")
    private String sourceOfPreviousValues;
    @QueryParam(value="irwf")
    @Pattern(regexp="UNSCHEDULED|SCHEDULED|SCHEDULED_COERCE_STUDY")
    private @Pattern(regexp="UNSCHEDULED|SCHEDULED|SCHEDULED_COERCE_STUDY") String irwf;
    private String acceptedStudyInstanceUID;
    private final Set<String> studyInstanceUIDs = new HashSet<String>();
    private final ArrayList<Attributes> instances = new ArrayList();
    private final Attributes response = new Attributes();
    private volatile String warning;
    private Sequence sopSequence;
    private Sequence failedSOPSequence;
    private Path spoolDirectory;
    private Map<String, PathWithMediaType> bulkdataMap = new HashMap<String, PathWithMediaType>();
    private Attributes coerce;

    public void validate() {
        this.logRequest();
        this.coerce = new QueryAttributes(this.uriInfo, null).getQueryKeys();
    }

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    @POST
    @javax.ws.rs.Path(value="/studies")
    @Consumes(value={"multipart/related;type=application/dicom"})
    @Produces(value={"application/dicom+xml"})
    public void storeInstancesXML(@Suspended AsyncResponse ar, InputStream in) throws Exception {
        this.store(ar, in, Input.DICOM, OutputType.DICOM_XML);
    }

    @POST
    @javax.ws.rs.Path(value="/studies/{StudyInstanceUID}")
    @Consumes(value={"multipart/related;type=application/dicom"})
    @Produces(value={"application/dicom+xml"})
    public void storeInstancesXML(@PathParam(value="StudyInstanceUID") String studyInstanceUID, @Suspended AsyncResponse ar, InputStream in) throws Exception {
        this.acceptedStudyInstanceUID = studyInstanceUID;
        this.store(ar, in, Input.DICOM, OutputType.DICOM_XML);
    }

    @POST
    @javax.ws.rs.Path(value="/studies")
    @Consumes(value={"multipart/related;type=application/dicom+xml"})
    @Produces(value={"application/dicom+xml"})
    public void storeXMLMetadataAndBulkdataXML(@Suspended AsyncResponse ar, InputStream in) throws Exception {
        this.store(ar, in, Input.METADATA_XML, OutputType.DICOM_XML);
    }

    @POST
    @javax.ws.rs.Path(value="/studies/{StudyInstanceUID}")
    @Consumes(value={"multipart/related;type=application/dicom+xml"})
    @Produces(value={"application/dicom+xml"})
    public void storeXMLMetadataAndBulkdataXML(@PathParam(value="StudyInstanceUID") String studyInstanceUID, @Suspended AsyncResponse ar, InputStream in) throws Exception {
        this.acceptedStudyInstanceUID = studyInstanceUID;
        this.store(ar, in, Input.METADATA_XML, OutputType.DICOM_XML);
    }

    @POST
    @javax.ws.rs.Path(value="/studies")
    @Consumes(value={"multipart/related;type=application/dicom+json"})
    @Produces(value={"application/dicom+xml"})
    public void storeJSONMetadataAndBulkdataXML(@Suspended AsyncResponse ar, InputStream in) throws Exception {
        this.store(ar, in, Input.METADATA_JSON, OutputType.DICOM_XML);
    }

    @POST
    @javax.ws.rs.Path(value="/studies/{StudyInstanceUID}")
    @Consumes(value={"multipart/related;type=application/dicom+json"})
    @Produces(value={"application/dicom+xml"})
    public void storeJSONMetadataAndBulkdata(@PathParam(value="StudyInstanceUID") String studyInstanceUID, @Suspended AsyncResponse ar, InputStream in) throws Exception {
        this.acceptedStudyInstanceUID = studyInstanceUID;
        this.store(ar, in, Input.METADATA_JSON, OutputType.DICOM_XML);
    }

    @POST
    @javax.ws.rs.Path(value="/studies")
    @Consumes(value={"multipart/related;type=application/dicom"})
    @Produces(value={"application/dicom+json"})
    public void storeInstancesJSON(@Suspended AsyncResponse ar, InputStream in) throws Exception {
        this.store(ar, in, Input.DICOM, OutputType.JSON);
    }

    @POST
    @javax.ws.rs.Path(value="/studies/{StudyInstanceUID}")
    @Consumes(value={"multipart/related;type=application/dicom"})
    @Produces(value={"application/dicom+json"})
    public void storeInstancesJSON(@PathParam(value="StudyInstanceUID") String studyInstanceUID, @Suspended AsyncResponse ar, InputStream in) throws Exception {
        this.acceptedStudyInstanceUID = studyInstanceUID;
        this.store(ar, in, Input.DICOM, OutputType.JSON);
    }

    @POST
    @javax.ws.rs.Path(value="/studies")
    @Consumes(value={"multipart/related;type=application/dicom+xml"})
    @Produces(value={"application/dicom+json"})
    public void storeXMLMetadataAndBulkdataJSON(@Suspended AsyncResponse ar, InputStream in) throws Exception {
        this.store(ar, in, Input.METADATA_XML, OutputType.JSON);
    }

    @POST
    @javax.ws.rs.Path(value="/studies/{StudyInstanceUID}")
    @Consumes(value={"multipart/related;type=application/dicom+xml"})
    @Produces(value={"application/dicom+json"})
    public void storeXMLMetadataAndBulkdataJSON(@PathParam(value="StudyInstanceUID") String studyInstanceUID, @Suspended AsyncResponse ar, InputStream in) throws Exception {
        this.acceptedStudyInstanceUID = studyInstanceUID;
        this.store(ar, in, Input.METADATA_XML, OutputType.JSON);
    }

    @POST
    @javax.ws.rs.Path(value="/studies")
    @Consumes(value={"multipart/related;type=application/dicom+json"})
    @Produces(value={"application/dicom+json"})
    public void storeJSONMetadataAndBulkdataJSON(@Suspended AsyncResponse ar, InputStream in) throws Exception {
        this.store(ar, in, Input.METADATA_JSON, OutputType.JSON);
    }

    @POST
    @javax.ws.rs.Path(value="/studies/{StudyInstanceUID}")
    @Consumes(value={"multipart/related;type=application/dicom+json"})
    @Produces(value={"application/dicom+json"})
    public void storeJSONMetadataAndBulkdataJSON(@PathParam(value="StudyInstanceUID") String studyInstanceUID, @Suspended AsyncResponse ar, InputStream in) throws Exception {
        this.acceptedStudyInstanceUID = studyInstanceUID;
        this.store(ar, in, Input.METADATA_JSON, OutputType.JSON);
    }

    private static String getHeaderParamValue(Map<String, List<String>> headerParams, String key) {
        List<String> list = headerParams.get(key);
        return list != null && !list.isEmpty() ? list.get(0) : null;
    }

    private void store(AsyncResponse ar, InputStream in, Input input, OutputType output) throws Exception {
        ApplicationEntity ae = this.getApplicationEntity();
        this.validateAcceptedUserRoles((ArchiveAEExtension)ae.getAEExtensionNotNull(ArchiveAEExtension.class));
        if (this.aet.equals(ae.getAETitle())) {
            this.validateWebAppServiceClass();
        }
        if (this.irwf != null) {
            this.validateIRWF(input);
        }
        ar.register(throwable -> this.purgeSpoolDirectory());
        StoreSession session = this.service.newStoreSession(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), ae, this.aet, null);
        new MultipartParser(this.boundary()).parse((InputStream)new BufferedInputStream(in), (partNumber, multipartInputStream) -> {
            Map headerParams = multipartInputStream.readHeaderParams();
            LOG.info("storeInstances: Extract Part #{}{}", (Object)partNumber, (Object)headerParams);
            String contentLocation = StowRS.getHeaderParamValue(headerParams, "content-location");
            String contentType = StowRS.getHeaderParamValue(headerParams, "content-type");
            MediaType mediaType = StowRS.normalize(MediaType.valueOf((String)contentType));
            try {
                if (!input.readBodyPart(this, session, multipartInputStream, mediaType, contentLocation)) {
                    LOG.info("{}: Ignore Part with Content-Type={}", (Object)session, (Object)mediaType);
                    multipartInputStream.skipAll();
                }
            }
            catch (JsonParsingException | SAXException e) {
                throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.BAD_REQUEST));
            }
            catch (Exception e) {
                if (this.instances.size() == 1) {
                    throw new WebApplicationException(StowRS.errResponseAsTextPlain(StowRS.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
                }
                LOG.warn("Failed to process Part #" + partNumber + headerParams);
                throw new WebApplicationException(StowRS.errResponseAsTextPlain(StowRS.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
            }
        });
        int instanceNumber = 0;
        for (Attributes instance : this.instances) {
            this.storeDicomObject(session, instance, ++instanceNumber);
        }
        this.response.setString(528784, VR.UR, this.retrieveURL());
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)this.status());
        ar.resume((Object)responseBuilder.entity((Object)output.entity(this.response, ae)).header("Warning", (Object)this.warning).build());
    }

    private void validateIRWF(Input input) {
        if (input != Input.DICOM) {
            throw new WebApplicationException(this.errResponse(IRWF_NOT_SUPPORTED, Response.Status.BAD_REQUEST));
        }
        if ("UNSCHEDULED".equals(this.irwf)) {
            if (!this.coerce.containsValue(0x100020)) {
                throw new WebApplicationException(this.errResponse(IRWF_MISSING_PATIENT_ID, Response.Status.BAD_REQUEST));
            }
        } else {
            String spsid;
            Attributes sps;
            if (this.coerce.contains(0x100020)) {
                throw new WebApplicationException(this.errResponse(IRWF_PATIENT_ID_NOT_SUPPORTED, Response.Status.BAD_REQUEST));
            }
            String suid = this.coerce.getString(0x20000D);
            if (suid == null || (sps = this.coerce.getNestedDataset(0x400100)) == null || (spsid = sps.getString(0x400009)) == null) {
                throw new WebApplicationException(this.errResponse(IRWF_MISSING_SPS, Response.Status.BAD_REQUEST));
            }
            Attributes mwlAttrs = this.procedureService.getMWLItemAttrs(suid, spsid);
            if (mwlAttrs == null) {
                throw new WebApplicationException(this.errResponse(IRWF_NOT_SCHEDULED, Response.Status.NOT_FOUND));
            }
            if ("SCHEDULED".equals(this.irwf)) {
                this.coerce.remove(0x20000D);
            }
            this.coerce.remove(0x400100);
            this.coerce.addSelected(mwlAttrs, new int[]{524293, 524368, 524369, 0x100020, 0x100021, 1048612, 3670032, 3670033});
            Attributes procedureCode = mwlAttrs.getNestedDataset(3280996);
            if (procedureCode != null) {
                this.coerce.newSequence(528434, 1).add(new Attributes(procedureCode));
            }
            this.coerce.newSequence(4194933, 1).add(this.irwfRequestAttrs(mwlAttrs, spsid));
        }
        this.coerce(0x100021, VR.LO);
        this.coerce(1048612, VR.SQ);
        this.coerce(524368, VR.SH);
        this.coerce(524369, VR.SQ);
        this.coerce(3670032, VR.SH);
        this.coerce(3670033, VR.SQ);
        this.coerce.newSequence(1613825, 1).add(this.irwfContributingEquipment());
        this.reasonForModification = "COERCE";
    }

    private Attributes irwfContributingEquipment() {
        Attributes attrs = new Attributes(3);
        attrs.setString(524400, VR.LO, this.device.getManufacturer());
        attrs.setString(524416, VR.LO, this.device.getInstitutionNames());
        attrs.setString(528400, VR.SH, this.getStationName());
        attrs.setDate(1613826, VR.DT, new Date[]{new Date()});
        attrs.newSequence(4235632, 1).add(ContributingEquipmentPurposeOfReference.PortableMediaImporterEquipment.toItem());
        return attrs;
    }

    private void coerce(int tag, VR vr) {
        if (!this.coerce.contains(tag)) {
            this.coerce.setNull(tag, vr);
        }
    }

    private Attributes irwfRequestAttrs(Attributes mwlAttrs, String spsid) {
        Attributes attrs = new Attributes(3);
        attrs.setString(3280992, VR.LO, mwlAttrs.getString(3280992));
        attrs.setString(0x400009, VR.SH, spsid);
        attrs.setString(0x401001, VR.SH, mwlAttrs.getString(0x401001));
        return attrs;
    }

    private static MediaType normalize(MediaType mediaType) {
        return MediaTypes.isSTLType((MediaType)mediaType) ? MediaTypes.MODEL_STL_TYPE : mediaType;
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}:{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost(), this.request.getRemotePort()});
    }

    private void validateAcceptedUserRoles(ArchiveAEExtension arcAE) {
        KeycloakContext keycloakContext = KeycloakContext.valueOf((HttpServletRequest)this.request);
        if (keycloakContext.isSecured() && !keycloakContext.isUserInRole(System.getProperty(SUPER_USER_ROLE)) && !arcAE.isAcceptedUserRole(keycloakContext.getRoles())) {
            throw new WebApplicationException("Application Entity " + arcAE.getApplicationEntity().getAETitle() + " does not list role of accessing user", Response.Status.FORBIDDEN);
        }
    }

    private void validateWebAppServiceClass() {
        this.device.getWebApplications().stream().filter(webApp -> this.request.getRequestURI().startsWith(webApp.getServicePath()) && Arrays.asList(webApp.getServiceClasses()).contains(WebApplication.ServiceClass.STOW_RS)).findFirst().orElseThrow(() -> new WebApplicationException(this.errResponse("No Web Application with STOW_RS service class found for Application Entity: " + this.aet, Response.Status.NOT_FOUND)));
    }

    private void validateWebApp() {
        WebApplication webApplication = this.device.getWebApplications().stream().filter(webApp -> this.request.getRequestURI().startsWith(webApp.getServicePath()) && Arrays.asList(webApp.getServiceClasses()).contains(WebApplication.ServiceClass.STOW_RS)).findFirst().orElseThrow(() -> new WebApplicationException(this.errResponse("No Web Application with STOW_RS service class found for Application Entity: " + this.aet, Response.Status.NOT_FOUND)));
        KeycloakContext keycloakContext = KeycloakContext.valueOf((HttpServletRequest)this.request);
        if (keycloakContext.isSecured() && webApplication.getProperties().containsKey("roles")) {
            Arrays.stream(((String)webApplication.getProperties().get("roles")).split(",")).filter(arg_0 -> ((KeycloakContext)keycloakContext).isUserInRole(arg_0)).findFirst().orElseThrow(() -> new WebApplicationException(this.errResponse("Web Application with STOW_RS service class does not list role of accessing user", Response.Status.FORBIDDEN)));
        }
    }

    private void purgeSpoolDirectory() {
        if (this.spoolDirectory == null) {
            return;
        }
        try {
            try (DirectoryStream<Path> dir = Files.newDirectoryStream(this.spoolDirectory);){
                dir.forEach(file -> {
                    try {
                        Files.delete(file);
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to delete bulkdata spool file {}", file, (Object)e);
                    }
                });
            }
            Files.delete(this.spoolDirectory);
        }
        catch (IOException e) {
            LOG.warn("Failed to purge spool directory {}", (Object)this.spoolDirectory, (Object)e);
        }
    }

    private String boundary() {
        String boundary = (String)this.contentType.getParameters().get("boundary");
        if (boundary == null) {
            throw new WebApplicationException(this.errResponse("Missing Boundary Parameter", Response.Status.BAD_REQUEST));
        }
        return boundary;
    }

    private ApplicationEntity getApplicationEntity() {
        ApplicationEntity ae = this.device.getApplicationEntity(this.aet, true);
        if (ae == null || !ae.isInstalled()) {
            throw new WebApplicationException(this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND));
        }
        return ae;
    }

    private void storeDicomObject(StoreSession session, MultipartInputStream in) throws IOException {
        StoreContext ctx = this.service.newStoreContext(session);
        ctx.setAcceptedStudyInstanceUID(this.acceptedStudyInstanceUID);
        try {
            this.service.store(ctx, (InputStream)in, this::coerceAttributes);
            this.studyInstanceUIDs.add(ctx.getStudyInstanceUID());
            this.sopSequence().add(this.mkSOPRefWithRetrieveURL(ctx));
        }
        catch (DicomServiceException e) {
            LOG.info("{}: Failed to store {}", new Object[]{session, StowRS.getSopClassName(ctx), e});
            this.setWarning(e);
            this.failedSOPSequence().add(this.mkSOPRefWithFailureReason(ctx, e));
        }
    }

    private void setWarning(DicomServiceException e) {
        this.warning = "299 " + this.device.getDeviceName() + " \"" + e.getMessage() + "\"";
    }

    private static String getSopClassName(StoreContext ctx) {
        Attributes attributes = ctx.getAttributes();
        return attributes != null ? UID.nameOf((String)attributes.getString(524310)) : "?";
    }

    private void coerceAttributes(Attributes attrs) {
        if (!this.coerce.isEmpty()) {
            if (this.irwf != null) {
                Sequence otherPatientIDs = this.coerce.newSequence(0x101002, 2);
                otherPatientIDs.add(StowRS.selectPatientIDWithIssuer(attrs));
                otherPatientIDs.add(StowRS.selectPatientIDWithIssuer(this.coerce));
                Attributes irwfRequestAttrs = this.coerce.getNestedDataset(4194933);
                if (irwfRequestAttrs != null) {
                    irwfRequestAttrs.remove(0x400007);
                    irwfRequestAttrs.remove(0x400008);
                    Attributes reqAttrs = attrs.getNestedDataset(4194933);
                    if (reqAttrs != null) {
                        irwfRequestAttrs.addSelected(reqAttrs, new int[]{0x400007, 0x400008});
                    }
                }
            }
            Attributes modified = new Attributes();
            attrs.update(Attributes.UpdatePolicy.valueOf((String)this.updatePolicy), false, this.coerce, modified);
            if (!modified.isEmpty() && this.reasonForModification != null) {
                attrs.addOriginalAttributes(this.sourceOfPreviousValues, new Date(), this.reasonForModification, this.getStationName(), modified);
            }
        }
    }

    private String getStationName() {
        String stationName = this.device.getStationName();
        return stationName != null ? stationName : this.device.getDeviceName();
    }

    private static Attributes selectPatientIDWithIssuer(Attributes src) {
        Attributes qualifiers;
        Attributes result = new Attributes(3);
        result.setString(0x100020, VR.LO, src.getString(0x100020));
        String issuer = src.getString(0x100021);
        if (issuer != null) {
            result.setString(0x100021, VR.LO, issuer);
        }
        if ((qualifiers = src.getNestedDataset(1048612)) != null) {
            result.newSequence(1048612, 1).add(new Attributes(qualifiers));
        }
        return result;
    }

    private void storeDicomObject(StoreSession session, Attributes attrs, int instanceNumber) throws IOException {
        StoreContext ctx = this.service.newStoreContext(session);
        ctx.setAcceptedStudyInstanceUID(this.acceptedStudyInstanceUID);
        try {
            PathWithMediaType pathWithMediaType = this.resolveBulkdataRefs(session, attrs);
            if (pathWithMediaType == null) {
                ctx.setReceiveTransferSyntax("1.2.840.10008.1.2.1");
            } else {
                ctx.setReceiveTransferSyntax(MediaTypes.transferSyntaxOf((MediaType)pathWithMediaType.mediaType));
                this.supplementAttrs(ctx, session, attrs, instanceNumber, pathWithMediaType);
            }
            this.service.store(ctx, attrs);
            this.studyInstanceUIDs.add(ctx.getStudyInstanceUID());
            this.sopSequence().add(this.mkSOPRefWithRetrieveURL(ctx));
        }
        catch (DicomServiceException e) {
            ctx.setAttributes(attrs);
            LOG.info("{}: Failed to store {}", new Object[]{session, StowRS.getSopClassName(ctx), e});
            this.setWarning(e);
            this.failedSOPSequence().add(this.mkSOPRefWithFailureReason(ctx, e));
        }
    }

    private void supplementAttrs(StoreContext ctx, StoreSession session, Attributes attrs, int instanceNumber, PathWithMediaType bulkdata) throws DicomServiceException {
        for (int tag : IUIDS_TAGS) {
            if (attrs.containsValue(tag)) continue;
            String uid = UIDUtils.createUID();
            StowRS.logSupplementMissing(session, tag, uid);
            attrs.setString(tag, VR.UI, uid);
        }
        String cuid = attrs.getString(524310);
        if (cuid == null) {
            cuid = MediaTypes.sopClassOf((MediaType)bulkdata.mediaType);
            if (cuid == null) {
                throw StowRS.missingAttribute(524310);
            }
            StowRS.logSupplementMissing(session, 524310, cuid + " " + UID.nameOf((String)cuid));
            attrs.setString(524310, VR.UI, cuid);
        }
        if (!attrs.containsValue(524306)) {
            Date now = new Date();
            StowRS.logSupplementMissing(session, 524306, now);
            attrs.setDate(2251877123620883L, new Date[]{now});
        }
        if (!attrs.containsValue(0x200011)) {
            StowRS.logSupplementMissing(session, 0x200011, 999);
            attrs.setInt(0x200011, VR.IS, new int[]{999});
        }
        if (!attrs.containsValue(2097171)) {
            StowRS.logSupplementMissing(session, 2097171, instanceNumber);
            attrs.setInt(2097171, VR.IS, new int[]{instanceNumber});
        }
        if (attrs.containsValue(2145386512)) {
            this.supplementImagePixelModule(ctx, session, attrs, bulkdata);
            StowRS.verifyImagePixelModule(attrs);
        }
        if (attrs.containsValue(4325393)) {
            StowRS.verifyEncapsulatedDocumentModule(session, attrs, bulkdata);
        } else {
            switch (cuid) {
                case "1.2.840.10008.5.1.4.1.1.104.1": 
                case "1.2.840.10008.5.1.4.1.1.104.2": 
                case "1.2.840.10008.5.1.4.1.1.104.3": 
                case "1.2.840.10008.5.1.4.1.1.104.4": 
                case "1.2.840.10008.5.1.4.1.1.104.5": 
                case "1.2.40.0.13.1.5.1.4.1.1.104.1": {
                    throw StowRS.missingAttribute(4325393);
                }
            }
        }
    }

    private void supplementImagePixelModule(StoreContext ctx, StoreSession session, Attributes attrs, PathWithMediaType bulkdata) throws DicomServiceException {
        block21: {
            CompressedPixelData compressedPixelData = CompressedPixelData.valueOf(bulkdata.mediaType);
            if (compressedPixelData != null) {
                try (SeekableByteChannel channel = Files.newByteChannel(bulkdata.path, new OpenOption[0]);){
                    ctx.setReceiveTransferSyntax(compressedPixelData.supplementImagePixelModule(session, channel, attrs, bulkdata.length > session.getArchiveAEExtension().stowMaxFragmentLength()));
                    break block21;
                }
                catch (IOException e) {
                    LOG.info("Failed to parse {} compressed pixel data from {}:\n", new Object[]{compressedPixelData, bulkdata.path, e});
                    throw new DicomServiceException(272, (Throwable)e);
                }
            }
            ImageReader imageReader = StowRS.findImageReader(bulkdata.mediaType, "com.sun.imageio");
            if (imageReader != null) {
                try (ImageInputStream iio = ImageIO.createImageInputStream(bulkdata.path.toFile());){
                    imageReader.setInput(iio);
                    BufferedImageUtils.toImagePixelModule((ImageReader)imageReader, (Attributes)attrs);
                    ctx.setReceiveTransferSyntax("1.2.840.10008.1.2.1");
                }
                catch (Exception e) {
                    LOG.info("Failed to extract pixel data from bulkdata:\n", (Throwable)e);
                    throw new DicomServiceException(272, (Throwable)e);
                }
                finally {
                    imageReader.dispose();
                }
            }
        }
    }

    private static ImageReader findImageReader(MediaType mediaType, String pkg) {
        Iterator<ImageReader> iter = ImageIO.getImageReadersByMIMEType(mediaType.toString());
        if (iter.hasNext()) {
            ImageReader reader = iter.next();
            while (!reader.getClass().getName().startsWith(pkg) && iter.hasNext()) {
                reader = iter.next();
            }
            return reader;
        }
        return null;
    }

    private static void supplementMissing(StoreSession session, int tag, VR vr, String value, Attributes attrs) {
        StowRS.logSupplementMissing(session, tag, value);
        attrs.setString(tag, vr, value);
    }

    private static void supplementMissing(StoreSession session, int tag, VR vr, int value, Attributes attrs) {
        StowRS.logSupplementMissing(session, tag, value);
        attrs.setInt(tag, vr, new int[]{value});
    }

    private static void logSupplementMissing(StoreSession session, int tag, Object value) {
        LOG.info("{}: Supplement Missing {} {} - {}", new Object[]{session, DICT.keywordOf(tag), TagUtils.toString((int)tag), value});
    }

    private static void verifyImagePixelModule(Attributes attrs) throws DicomServiceException {
        for (int tag : IMAGE_PIXEL_TAGS) {
            if (attrs.containsValue(tag)) continue;
            throw StowRS.missingAttribute(tag);
        }
        if (attrs.getInt(0x280002, 1) > 1 && !attrs.containsValue(2621446)) {
            throw StowRS.missingAttribute(2621446);
        }
    }

    private static void verifyEncapsulatedDocumentModule(StoreSession session, Attributes attrs, PathWithMediaType bulkdata) throws DicomServiceException {
        String cuid = attrs.getString(524310);
        if (!attrs.containsValue(4325394)) {
            String mimeType = bulkdata.mediaType.toString();
            if (mimeType == null) {
                throw StowRS.missingAttribute(4325394);
            }
            StowRS.supplementMissing(session, 4325394, VR.LO, mimeType, attrs);
        }
        if (!attrs.containsValue(2622209)) {
            StowRS.supplementMissing(session, 2622209, VR.CS, "YES", attrs);
        }
        if (!attrs.containsValue(4325397)) {
            StowRS.supplementMissing(session, 4325397, VR.UL, (int)bulkdata.length, attrs);
        }
        switch (cuid) {
            case "1.2.840.10008.5.1.4.1.1.104.3": 
            case "1.2.840.10008.5.1.4.1.1.104.5": 
            case "1.2.840.10008.5.1.4.1.1.104.4": {
                if (!attrs.contains(4196586)) {
                    Attributes item = new Attributes(3);
                    item.setString(524544, VR.SH, "mm");
                    item.setString(524546, VR.SH, "UCUM");
                    item.setString(524548, VR.LO, "mm");
                    StowRS.logSupplementMissing(session, 4196586, item);
                    attrs.newSequence(4196586, 1).add(item);
                }
                if (!attrs.containsValue(524384)) {
                    StowRS.supplementMissing(session, 524384, VR.CS, "M3D", attrs);
                }
                if (!attrs.containsValue(524400)) {
                    StowRS.supplementMissing(session, 524400, VR.LO, "UNKNOWN", attrs);
                }
                if (!attrs.containsValue(528528)) {
                    StowRS.supplementMissing(session, 528528, VR.LO, "UNKNOWN", attrs);
                }
                if (!attrs.containsValue(0x181000)) {
                    StowRS.supplementMissing(session, 0x181000, VR.LO, "UNKNOWN", attrs);
                }
                if (!attrs.containsValue(1576992)) {
                    StowRS.supplementMissing(session, 1576992, VR.LO, "UNKNOWN", attrs);
                }
                if (attrs.containsValue(0x200052) || cuid.equals("1.2.840.10008.5.1.4.1.1.104.5")) break;
                StowRS.supplementMissing(session, 0x200052, VR.UI, UIDUtils.createUID(), attrs);
                break;
            }
            case "1.2.840.10008.5.1.4.1.1.104.1": {
                if (!attrs.containsValue(524384)) {
                    StowRS.supplementMissing(session, 524384, VR.CS, "DOC", attrs);
                }
                if (attrs.containsValue(524388)) break;
                StowRS.supplementMissing(session, 524388, VR.CS, "SD", attrs);
                break;
            }
            case "1.2.840.10008.5.1.4.1.1.104.2": {
                if (!attrs.containsValue(524384)) {
                    StowRS.supplementMissing(session, 524384, VR.CS, "SR", attrs);
                }
                if (attrs.containsValue(524388)) break;
                StowRS.supplementMissing(session, 524388, VR.CS, "WSD", attrs);
            }
        }
    }

    private static DicomServiceException missingAttribute(int tag) {
        return new DicomServiceException(43264, "Missing " + DICT.keywordOf(tag) + " " + TagUtils.toString((int)tag));
    }

    private PathWithMediaType resolveBulkdataRefs(StoreSession session, Attributes attrs) throws DicomServiceException {
        PathWithMediaType[] bulkdataWithMediaType = new PathWithMediaType[1];
        try {
            attrs.accept((attrs1, tag, vr, value) -> {
                if (value instanceof BulkData) {
                    bulkdataWithMediaType[0] = this.resolveBulkdataRef(session, attrs1, tag, vr, (BulkData)value);
                }
                return true;
            }, true);
        }
        catch (DicomServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DicomServiceException(272, (Throwable)e);
        }
        return bulkdataWithMediaType[0];
    }

    private PathWithMediaType resolveBulkdataRef(StoreSession session, Attributes attrs, int tag, VR vr, BulkData bulkdata) throws IOException {
        PathWithMediaType pathWithMediaType = this.bulkdataMap.get(bulkdata.getURI());
        if (pathWithMediaType == null) {
            throw new DicomServiceException(43298, "Missing Bulkdata: " + bulkdata.getURI());
        }
        if (tag != 2145386512 || MediaType.APPLICATION_OCTET_STREAM_TYPE.equals((Object)pathWithMediaType.mediaType)) {
            bulkdata.setURI(pathWithMediaType.path.toUri() + "?offset=0&length=" + pathWithMediaType.length);
        } else {
            StowRS.addFragments(session, attrs, pathWithMediaType, tag, vr);
        }
        return pathWithMediaType;
    }

    private static void addFragments(StoreSession session, Attributes attrs, PathWithMediaType pathWithMediaType, int tag, VR vr) {
        long remaining;
        String uri = pathWithMediaType.path.toUri().toString();
        long offset = 0L;
        long maxFragmentLength = session.getArchiveAEExtension().stowMaxFragmentLength();
        Fragments frags = attrs.newFragments(tag, vr, 2 + (int)((remaining - 1L) / maxFragmentLength));
        frags.add((Object)ByteUtils.EMPTY_BYTES);
        for (remaining = pathWithMediaType.length; remaining > maxFragmentLength; remaining -= maxFragmentLength) {
            frags.add((Object)new BulkData(uri, offset, maxFragmentLength, false));
            offset += maxFragmentLength;
        }
        frags.add((Object)new BulkData(uri, offset, remaining, false));
    }

    private static void adjustBulkdata(Attributes attrs, JPEGParser parser, ArchiveAEExtension arcAE) {
        if (parser.getCodeStreamPosition() > 0L) {
            StowRS.excludeJP2FileFormatHeader(parser, attrs);
            return;
        }
        if (parser.getPositionAfterAPPSegments() != -1L && arcAE.stowExcludeAPPMarkers()) {
            StowRS.excludeAppMarkers(attrs, parser);
        }
    }

    private static void excludeJP2FileFormatHeader(JPEGParser parser, Attributes attrs) {
        BulkData bulkData = (BulkData)((Fragments)attrs.getValue(2145386512)).get(1);
        bulkData.setLength((long)bulkData.length() - parser.getCodeStreamPosition());
        bulkData.setOffset(parser.getCodeStreamPosition());
    }

    private static void excludeAppMarkers(Attributes attrs, JPEGParser parser) {
        Fragments fragments = (Fragments)attrs.getValue(2145386512);
        BulkData bulkData = (BulkData)fragments.get(1);
        fragments.set(1, (Object)new BulkDataWithPrefix(bulkData.uriWithoutOffsetAndLength(), parser.getPositionAfterAPPSegments(), (int)((long)bulkData.length() - parser.getPositionAfterAPPSegments()), false, new byte[]{-1, -40}));
    }

    private static String adjustJPEGTransferSyntax(String tsuid, boolean allowRetired, Attributes attrs) {
        return allowRetired || !tsuid.equals("1.2.840.10008.1.2.4.55") ? tsuid : (attrs.getInt(2621696, 8) == 8 ? "1.2.840.10008.1.2.4.50" : "1.2.840.10008.1.2.4.51");
    }

    private static void adjustBulkdata(Attributes attrs, MP4Parser parser, ArchiveAEExtension arcAE) throws IOException {
        if (parser.getMP4FileType() != null && parser.getMP4FileType().majorBrand() == 1903435808 && arcAE.stowQuicktime2MP4()) {
            Fragments fragments = (Fragments)attrs.getValue(2145386512);
            BulkData bulkData = (BulkData)fragments.get(1);
            File mpFile = StowRS.qt2MP4(bulkData.getFile());
            bulkData.setURI(mpFile.toURI().toString());
            bulkData.setLength(mpFile.length());
        }
    }

    private static File qt2MP4(File qtFile) throws IOException {
        String line;
        File mp4File = new File(qtFile.getParent(), qtFile.getName() + ".mp4");
        long start = System.currentTimeMillis();
        Process process = new ProcessBuilder("ffmpeg", "-i", qtFile.toString(), "-c", "copy", mp4File.toString()).redirectErrorStream(true).start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = reader.readLine()) != null) {
            LOG.debug(line);
        }
        int exitValue = StowRS.exitValueOf(process);
        long end = System.currentTimeMillis();
        LOG.info("Converted Quicktime to MP4 container in {} ms - exit code: {}", (Object)(start - end), (Object)exitValue);
        if (exitValue != 0) {
            throw new IOException("Failed to convert Quicktime to MP4 container - " + exitValue);
        }
        return mp4File;
    }

    private static int exitValueOf(Process process) {
        try {
            return process.waitFor();
        }
        catch (InterruptedException e) {
            return 999;
        }
    }

    private boolean spoolBulkdata(MultipartInputStream in, MediaType mediaType, String contentLocation) {
        try {
            if (this.spoolDirectory == null) {
                this.spoolDirectory = Files.createTempDirectory(this.spoolDirectoryRoot(), null, new FileAttribute[0]);
            }
            Path spoolFile = Files.createTempFile(this.spoolDirectory, null, null, new FileAttribute[0]);
            try (OutputStream out = Files.newOutputStream(spoolFile, new OpenOption[0]);){
                StreamUtils.copy((InputStream)in, (OutputStream)out);
            }
            this.bulkdataMap.put(contentLocation, new PathWithMediaType(spoolFile, mediaType));
            return true;
        }
        catch (IOException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            LOG.error(sw.toString());
            throw new WebApplicationException(this.errResponse("IOException caught while spooling bulkdata : " + e.getMessage(), Response.Status.BAD_REQUEST));
        }
    }

    private Path spoolDirectoryRoot() throws IOException {
        return Files.createDirectories(Paths.get(StringUtils.replaceSystemProperties((String)((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getStowSpoolDirectory()), new String[0]), new FileAttribute[0]);
    }

    private Attributes mkSOPRefWithRetrieveURL(StoreContext ctx) {
        Attributes attrs = this.mkSOPRef(ctx, 3);
        attrs.setString(528784, VR.UR, this.retrieveURL(ctx));
        return attrs;
    }

    private String retrieveURL() {
        if (this.studyInstanceUIDs.size() != 1) {
            return null;
        }
        StringBuffer retrieveURL = this.request.getRequestURL();
        if (retrieveURL.lastIndexOf("/studies") + 8 == retrieveURL.length()) {
            retrieveURL.append('/').append(this.studyInstanceUIDs.iterator().next());
        }
        return retrieveURL.toString();
    }

    private String retrieveURL(StoreContext ctx) {
        StringBuffer retrieveURL = this.request.getRequestURL();
        if (retrieveURL.lastIndexOf("/studies") + 8 == retrieveURL.length()) {
            retrieveURL.append('/').append(ctx.getStudyInstanceUID());
        }
        retrieveURL.append("/series/").append(ctx.getSeriesInstanceUID());
        retrieveURL.append("/instances/").append(ctx.getSopInstanceUID());
        return retrieveURL.toString();
    }

    private Attributes mkSOPRefWithFailureReason(StoreContext ctx, DicomServiceException e) {
        Attributes attrs = this.mkSOPRef(ctx, 3);
        attrs.setInt(528791, VR.US, new int[]{e.getStatus()});
        return attrs;
    }

    private Attributes mkSOPRef(StoreContext ctx, int size) {
        Attributes attrs = new Attributes(size);
        if (ctx.getAttributes() != null) {
            attrs.setString(528720, VR.UI, ctx.getSopClassUID());
            attrs.setString(528725, VR.UI, ctx.getSopInstanceUID());
        } else {
            attrs.setString(528720, VR.UI, NOT_A_DICOM_FILE_UID);
            attrs.setString(528725, VR.UI, UIDUtils.createUID());
        }
        return attrs;
    }

    private Sequence sopSequence() {
        if (this.sopSequence == null) {
            this.sopSequence = this.response.newSequence(528793, 10);
        }
        return this.sopSequence;
    }

    private Sequence failedSOPSequence() {
        if (this.failedSOPSequence == null) {
            this.failedSOPSequence = this.response.newSequence(528792, 10);
        }
        return this.failedSOPSequence;
    }

    private Response.Status status() {
        return this.sopSequence == null ? Response.Status.CONFLICT : (this.failedSOPSequence == null ? Response.Status.OK : Response.Status.ACCEPTED);
    }

    private Response errResponse(String errorMessage, Response.Status status) {
        return StowRS.errResponseAsTextPlain("{\"errorMessage\":\"" + errorMessage + "\"}", status);
    }

    private static Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private static String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private static class PathWithMediaType {
        final Path path;
        final long length;
        final MediaType mediaType;

        private PathWithMediaType(Path path, MediaType mediaType) throws IOException {
            this.path = path;
            this.length = Files.size(path);
            this.mediaType = mediaType;
        }
    }

    private static enum CompressedPixelData {
        JPEG{

            @Override
            String supplementImagePixelModule(StoreSession session, SeekableByteChannel channel, Attributes attrs, boolean fragmented) throws IOException {
                JPEGParser jpegParser = new JPEGParser(channel);
                jpegParser.getAttributes(attrs);
                ArchiveAEExtension arcAE = session.getArchiveAEExtension();
                StowRS.adjustBulkdata(attrs, jpegParser, arcAE);
                return StowRS.adjustJPEGTransferSyntax(jpegParser.getTransferSyntaxUID(fragmented), arcAE.stowRetiredTransferSyntax(), attrs);
            }
        }
        ,
        MPEG{

            @Override
            String supplementImagePixelModule(StoreSession session, SeekableByteChannel channel, Attributes attrs, boolean fragmented) throws IOException {
                MPEG2Parser mpeg2Parser = new MPEG2Parser(channel);
                mpeg2Parser.getAttributes(attrs);
                return mpeg2Parser.getTransferSyntaxUID(fragmented);
            }
        }
        ,
        MP4{

            @Override
            String supplementImagePixelModule(StoreSession session, SeekableByteChannel channel, Attributes attrs, boolean fragmented) throws IOException {
                MP4Parser mp4Parser = new MP4Parser(channel);
                mp4Parser.getAttributes(attrs);
                StowRS.adjustBulkdata(attrs, mp4Parser, session.getArchiveAEExtension());
                return mp4Parser.getTransferSyntaxUID(fragmented);
            }
        };


        abstract String supplementImagePixelModule(StoreSession var1, SeekableByteChannel var2, Attributes var3, boolean var4) throws IOException;

        static CompressedPixelData valueOf(MediaType mediaType) {
            return MediaTypes.equalsIgnoreParameters((MediaType)mediaType, (MediaType)MediaTypes.IMAGE_JPEG_TYPE) || MediaTypes.equalsIgnoreParameters((MediaType)mediaType, (MediaType)MediaTypes.IMAGE_JP2_TYPE) ? JPEG : (MediaTypes.equalsIgnoreParameters((MediaType)mediaType, (MediaType)MediaTypes.VIDEO_MPEG_TYPE) ? MPEG : (MediaTypes.equalsIgnoreParameters((MediaType)mediaType, (MediaType)MediaTypes.VIDEO_MP4_TYPE) || MediaTypes.equalsIgnoreParameters((MediaType)mediaType, (MediaType)MediaTypes.VIDEO_QUICKTIME_TYPE) ? MP4 : null));
        }
    }

    private static enum Input {
        DICOM{

            @Override
            boolean readBodyPart(StowRS stowRS, StoreSession session, MultipartInputStream in, MediaType mediaType, String contentLocation) throws Exception {
                if (!MediaTypes.equalsIgnoreParameters((MediaType)mediaType, (MediaType)MediaTypes.APPLICATION_DICOM_TYPE)) {
                    return false;
                }
                stowRS.storeDicomObject(session, in);
                return true;
            }
        }
        ,
        METADATA_XML{

            @Override
            boolean readBodyPart(StowRS stowRS, StoreSession session, MultipartInputStream in, MediaType mediaType, String contentLocation) throws Exception {
                if (!MediaTypes.equalsIgnoreParameters((MediaType)mediaType, (MediaType)MediaTypes.APPLICATION_DICOM_XML_TYPE)) {
                    return stowRS.spoolBulkdata(in, mediaType, contentLocation);
                }
                stowRS.instances.add(SAXReader.parse((InputStream)in));
                return true;
            }
        }
        ,
        METADATA_JSON{

            @Override
            boolean readBodyPart(StowRS stowRS, StoreSession session, MultipartInputStream in, MediaType mediaType, String contentLocation) throws Exception {
                if (!MediaTypes.equalsIgnoreParameters((MediaType)mediaType, (MediaType)MediaTypes.APPLICATION_DICOM_JSON_TYPE)) {
                    return stowRS.spoolBulkdata(in, mediaType, contentLocation);
                }
                JSONReader reader = new JSONReader(Json.createParser((Reader)new InputStreamReader((InputStream)in, StandardCharsets.UTF_8)));
                reader.readDatasets((fmi, dataset) -> stowRS.instances.add(dataset));
                return true;
            }
        };


        abstract boolean readBodyPart(StowRS var1, StoreSession var2, MultipartInputStream var3, MediaType var4, String var5) throws Exception;
    }
}

