/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.store.scu.impl;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import org.dcm4che3.data.Attributes;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.store.StoreContext;
import org.dcm4chee.arc.store.StoreSession;
import org.dcm4chee.arc.store.scu.CStoreForwardSCU;
import org.dcm4chee.arc.store.scu.impl.CStoreForward;

@ApplicationScoped
public class CStoreForwardSCUImpl
implements CStoreForwardSCU {
    private final Map<String, Map<RetrieveContext, CStoreForward>> registry = new HashMap<String, Map<RetrieveContext, CStoreForward>>();

    @Override
    public synchronized void addRetrieveContext(RetrieveContext ctx, String callingAET) {
        this.forMoveOriginatorAET(callingAET).put(ctx, new CStoreForward(ctx));
    }

    private Map<RetrieveContext, CStoreForward> forMoveOriginatorAET(String aet) {
        Map<RetrieveContext, CStoreForward> map = this.registry.get(aet);
        if (map == null) {
            map = new IdentityHashMap<RetrieveContext, CStoreForward>();
            this.registry.put(aet, map);
        }
        return map;
    }

    @Override
    public synchronized boolean removeRetrieveContext(RetrieveContext ctx, String callingAET) {
        Map<RetrieveContext, CStoreForward> map = this.forMoveOriginatorAET(callingAET);
        return map != null && map.remove(ctx) != null;
    }

    public void onStore(@Observes StoreContext storeContext) {
        if (storeContext.getStoredInstance() == null || storeContext.getException() != null) {
            return;
        }
        CStoreForward forward = this.forStoreContext(storeContext);
        if (forward != null) {
            forward.onStore(storeContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CStoreForward forStoreContext(StoreContext storeContext) {
        StoreSession storeSession = storeContext.getStoreSession();
        String storeSCU = storeSession.getCallingAET();
        if (storeSCU == null) {
            return null;
        }
        String aeTitle = (String)storeSession.getArchiveDeviceExtension().getCStoreSCUOfCMoveSCPs().get(storeSCU);
        if (aeTitle == null) {
            aeTitle = storeContext.getMoveOriginatorAETitle();
        }
        if (aeTitle == null) {
            return null;
        }
        CStoreForwardSCUImpl cStoreForwardSCUImpl = this;
        synchronized (cStoreForwardSCUImpl) {
            Map<RetrieveContext, CStoreForward> map = this.registry.get(aeTitle);
            if (map == null) {
                return null;
            }
            Attributes attrs = storeContext.getAttributes();
            String studyIUID = attrs.getString(0x20000D);
            String seriesIUID = attrs.getString(0x20000E);
            String sopIUID = storeContext.getSopInstanceUID();
            for (CStoreForward forward1 : map.values()) {
                if (!forward1.match(studyIUID, seriesIUID, sopIUID)) continue;
                return forward1;
            }
        }
        return null;
    }
}

