/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.store.scu.impl;

import java.util.IdentityHashMap;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.AssociationListener;
import org.dcm4che3.net.pdu.AAssociateRQ;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.store.StoreContext;
import org.dcm4chee.arc.store.scu.impl.CStoreForwardTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CStoreForward {
    static final Logger LOG = LoggerFactory.getLogger(CStoreForward.class);
    private final RetrieveContext retrieveCtx;
    private final IdentityHashMap<Association, CStoreForwardTask> forwardTasks = new IdentityHashMap();

    public CStoreForward(RetrieveContext retrieveCtx) {
        this.retrieveCtx = retrieveCtx;
    }

    public void onStore(StoreContext storeCtx) {
        Association as = storeCtx.getStoreSession().getAssociation();
        CStoreForwardTask task = this.forwardTasks.get(as);
        if (task == null) {
            task = this.createTask(as);
        }
        task.onStore(storeCtx);
    }

    private CStoreForwardTask createTask(final Association as) {
        ApplicationEntity localAE = this.retrieveCtx.getLocalApplicationEntity();
        Association storeas = this.openAssociation(as, localAE);
        final CStoreForwardTask task = new CStoreForwardTask(this.retrieveCtx, storeas);
        this.forwardTasks.put(as, task);
        as.addAssociationListener(new AssociationListener(){

            public void onClose(Association association) {
                task.onStore(null);
                CStoreForward.this.forwardTasks.remove(as);
            }
        });
        if (storeas != null) {
            this.retrieveCtx.incrementPendingCStoreForward();
            localAE.getDevice().execute((Runnable)task);
        }
        return task;
    }

    private Association openAssociation(Association as, ApplicationEntity localAE) {
        try {
            LOG.info("{}: open association to {} for forwarding C-STORE-RQ received in association {}", new Object[]{this.retrieveCtx.getRequestAssociation(), this.retrieveCtx.getDestinationAETitle(), as});
            return localAE.connect(this.retrieveCtx.getDestinationAE(), this.createAARQ(as));
        }
        catch (Exception e) {
            LOG.warn("{}: failed to open association to {} for forwarding C-STORE-RQ received in association {}:\n", new Object[]{this.retrieveCtx.getRequestAssociation(), this.retrieveCtx.getDestinationAETitle(), as, e});
            return null;
        }
    }

    private AAssociateRQ createAARQ(Association as) {
        AAssociateRQ aarq = new AAssociateRQ();
        for (PresentationContext pc : as.getAAssociateRQ().getPresentationContexts()) {
            aarq.addPresentationContext(pc);
        }
        return aarq;
    }

    boolean match(String studyIUID, String seriesIUID, String sopIUID) {
        switch (this.retrieveCtx.getQueryRetrieveLevel()) {
            case STUDY: {
                for (String uid : this.retrieveCtx.getStudyInstanceUIDs()) {
                    if (!studyIUID.equals(uid)) continue;
                    return true;
                }
                break;
            }
            case SERIES: {
                if (!studyIUID.equals(this.retrieveCtx.getStudyInstanceUID())) break;
                for (String uid : this.retrieveCtx.getSeriesInstanceUIDs()) {
                    if (!seriesIUID.equals(uid)) continue;
                    return true;
                }
                break;
            }
            case IMAGE: {
                if (!studyIUID.equals(this.retrieveCtx.getStudyInstanceUID()) || !seriesIUID.equals(this.retrieveCtx.getSeriesInstanceUID())) break;
                for (String uid : this.retrieveCtx.getSopInstanceUIDs()) {
                    if (!sopIUID.equals(uid)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }
}

