/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.store.impl;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.hl7.HL7Application;
import org.dcm4che3.net.hl7.UnparsedHL7Message;
import org.dcm4che3.util.ReverseDNS;
import org.dcm4che3.util.SafeClose;
import org.dcm4chee.arc.conf.AcceptConflictingPatientID;
import org.dcm4chee.arc.conf.AcceptMissingPatientID;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Entity;
import org.dcm4chee.arc.conf.ExportPriorsRule;
import org.dcm4chee.arc.entity.Series;
import org.dcm4chee.arc.entity.Study;
import org.dcm4chee.arc.entity.UIDMap;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.storage.Storage;
import org.dcm4chee.arc.storage.StorageFactory;
import org.dcm4chee.arc.store.StoreService;
import org.dcm4chee.arc.store.StoreSession;

class StoreSessionImpl
implements StoreSession {
    private static final AtomicInteger prevSerialNo = new AtomicInteger();
    private final int serialNo;
    private ApplicationEntity ae;
    private Association as;
    private HttpServletRequestInfo httpRequest;
    private HL7Application hl7App;
    private String calledAET;
    private String callingAET;
    private Socket socket;
    private UnparsedHL7Message msg;
    private final StoreService storeService;
    private final Map<String, Storage> storageMap = new HashMap<String, Storage>();
    private Study cachedStudy;
    private final Map<String, Series> seriesCache = new HashMap<String, Series>();
    private final Set<String> processedPrefetchRules = new HashSet<String>();
    private final Map<Long, UIDMap> uidMapCache = new HashMap<Long, UIDMap>();
    private Map<String, String> uidMap;
    private String objectStorageID;
    private String metadataStorageID;
    private AcceptMissingPatientID acceptMissingPatientID;
    private AcceptConflictingPatientID acceptConflictingPatientID;
    private Attributes.UpdatePolicy patientUpdatePolicy;
    private Attributes.UpdatePolicy studyUpdatePolicy;
    private String impaxReportEndpoint;

    StoreSessionImpl(StoreService storeService) {
        this.serialNo = prevSerialNo.incrementAndGet();
        this.storeService = storeService;
    }

    public String toString() {
        return this.httpRequest != null ? this.httpRequest.requesterUserID + "@" + this.httpRequest.requesterHost + "->" + this.ae.getAETitle() : (this.as != null ? this.as.toString() : (this.msg != null ? this.msg.msh().toString() : this.ae.getAETitle()));
    }

    void setApplicationEntity(ApplicationEntity ae) {
        this.ae = ae;
        this.calledAET = ae.getAETitle();
        ArchiveAEExtension arcAE = (ArchiveAEExtension)ae.getAEExtensionNotNull(ArchiveAEExtension.class);
        this.acceptMissingPatientID = arcAE.acceptMissingPatientID();
        this.acceptConflictingPatientID = arcAE.acceptConflictingPatientID();
        ArchiveDeviceExtension arcDev = arcAE.getArchiveDeviceExtension();
        this.patientUpdatePolicy = arcDev.getAttributeFilter(Entity.Patient).getAttributeUpdatePolicy();
        this.studyUpdatePolicy = arcDev.getAttributeFilter(Entity.Study).getAttributeUpdatePolicy();
    }

    void setHttpRequest(HttpServletRequestInfo httpRequest) {
        this.httpRequest = httpRequest;
    }

    void setHL7Application(HL7Application hl7App) {
        this.hl7App = hl7App;
    }

    void setCalledAET(String calledAET) {
        this.calledAET = calledAET;
    }

    void setCallingAET(String callingAET) {
        this.callingAET = callingAET;
    }

    void setSocket(Socket socket) {
        this.socket = socket;
    }

    public void setMsg(UnparsedHL7Message msg) {
        this.msg = msg;
    }

    void setAssociation(Association as) {
        this.setApplicationEntity(as.getApplicationEntity());
        this.as = as;
        this.socket = as.getSocket();
        this.calledAET = as.getCalledAET();
        this.callingAET = as.getCallingAET();
    }

    @Override
    public int getSerialNo() {
        return this.serialNo;
    }

    @Override
    public Association getAssociation() {
        return this.as;
    }

    @Override
    public HttpServletRequestInfo getHttpRequest() {
        return this.httpRequest;
    }

    @Override
    public Socket getSocket() {
        return this.socket;
    }

    @Override
    public UnparsedHL7Message getUnparsedHL7Message() {
        return this.msg;
    }

    @Override
    public HL7Application getLocalHL7Application() {
        return this.hl7App;
    }

    @Override
    public ApplicationEntity getLocalApplicationEntity() {
        return this.ae;
    }

    @Override
    public ArchiveAEExtension getArchiveAEExtension() {
        return (ArchiveAEExtension)this.ae.getAEExtension(ArchiveAEExtension.class);
    }

    @Override
    public ArchiveDeviceExtension getArchiveDeviceExtension() {
        return (ArchiveDeviceExtension)this.ae.getDevice().getDeviceExtension(ArchiveDeviceExtension.class);
    }

    @Override
    public StoreService getStoreService() {
        return this.storeService;
    }

    @Override
    public Storage getStorage(String storageID, StorageFactory storageFactory) {
        return this.storageMap.computeIfAbsent(storageID, x -> storageFactory.getStorage(this.getArchiveAEExtension().getArchiveDeviceExtension().getStorageDescriptor(x)));
    }

    @Override
    public void putStorage(String storageID, Storage storage) {
        this.storageMap.put(storageID, storage);
    }

    @Override
    public String getCalledAET() {
        return this.calledAET;
    }

    @Override
    public String getCallingAET() {
        return this.callingAET;
    }

    @Override
    public String getRemoteHostName() {
        return this.httpRequest != null ? this.httpRequest.requesterHost : (this.socket != null ? ReverseDNS.hostNameOf((InetAddress)this.socket.getInetAddress()) : null);
    }

    @Override
    public String getLocalHostName() {
        return this.httpRequest != null ? this.httpRequest.localHost : (this.socket != null ? ReverseDNS.hostNameOf((InetAddress)this.socket.getLocalAddress()) : null);
    }

    @Override
    public String getSendingPresentationAddress() {
        return this.httpRequest != null ? "http-client:" + this.httpRequest.requesterHost + ":" + this.httpRequest.requesterPort : (this.as != null ? "dicom:" + ReverseDNS.hostNameOf((InetAddress)this.socket.getInetAddress()) + ":" + this.socket.getPort() : (this.hl7App != null ? "mllp:" + ReverseDNS.hostNameOf((InetAddress)this.socket.getInetAddress()) + ":" + this.socket.getPort() : null));
    }

    @Override
    public String getReceivingPresentationAddress() {
        return this.httpRequest != null ? StoreSessionImpl.toReceivingPresentationAddress(this.httpRequest) : (this.as != null ? "dicom:" + ReverseDNS.hostNameOf((InetAddress)this.socket.getLocalAddress()) + ":" + this.socket.getLocalPort() : (this.hl7App != null ? "mllp:" + ReverseDNS.hostNameOf((InetAddress)this.socket.getLocalAddress()) + ":" + this.socket.getLocalPort() : null));
    }

    private static String toReceivingPresentationAddress(HttpServletRequestInfo httpRequest) {
        int rsPos = httpRequest.requestURI.indexOf("/rs/");
        return httpRequest.requestURI.startsWith("https") ? "http" + (rsPos < 0 ? httpRequest.requestURI.substring(5) : httpRequest.requestURI.substring(5, rsPos + 4)) : (rsPos < 0 ? httpRequest.requestURI : httpRequest.requestURI.substring(0, rsPos + 4));
    }

    @Override
    public Study getCachedStudy(String studyInstanceUID) {
        return this.isStudyCached(studyInstanceUID) ? this.cachedStudy : null;
    }

    @Override
    public Series getCachedSeries(String studyInstanceUID, String seriesIUID) {
        return this.isStudyCached(studyInstanceUID) ? this.seriesCache.get(seriesIUID) : null;
    }

    @Override
    public void cacheSeries(Series series) {
        Study study = series.getStudy();
        if (!this.isStudyCached(study.getStudyInstanceUID())) {
            this.cachedStudy = study;
            this.seriesCache.clear();
            this.processedPrefetchRules.clear();
        }
        this.seriesCache.put(series.getSeriesInstanceUID(), series);
    }

    @Override
    public void invalidateCachedStudyAndSeries() {
        this.cachedStudy = null;
        this.seriesCache.clear();
    }

    @Override
    public boolean isNotProcessed(ExportPriorsRule rule) {
        return !this.processedPrefetchRules.contains(rule.getCommonName());
    }

    @Override
    public boolean markAsProcessed(ExportPriorsRule rule) {
        return this.processedPrefetchRules.add(rule.getCommonName());
    }

    private boolean isStudyCached(String studyInstanceUID) {
        return this.cachedStudy != null && this.cachedStudy.getStudyInstanceUID().equals(studyInstanceUID);
    }

    @Override
    public void close() throws IOException {
        for (Storage storage : this.storageMap.values()) {
            SafeClose.close((Closeable)storage);
        }
    }

    @Override
    public Map<Long, UIDMap> getUIDMapCache() {
        return this.uidMapCache;
    }

    @Override
    public Map<String, String> getUIDMap() {
        if (this.uidMap == null) {
            this.uidMap = new HashMap<String, String>();
        }
        return this.uidMap;
    }

    @Override
    public String getObjectStorageID() {
        return this.objectStorageID;
    }

    @Override
    public StoreSession withObjectStorageID(String objectStorageID) {
        this.objectStorageID = objectStorageID;
        return this;
    }

    @Override
    public String getMetadataStorageID() {
        return this.metadataStorageID;
    }

    @Override
    public void setMetadataStorageID(String metadataStorageID) {
        this.metadataStorageID = metadataStorageID;
    }

    @Override
    public AcceptMissingPatientID getAcceptMissingPatientID() {
        return this.acceptMissingPatientID;
    }

    @Override
    public AcceptConflictingPatientID getAcceptConflictingPatientID() {
        return this.acceptConflictingPatientID;
    }

    @Override
    public void setAcceptConflictingPatientID(AcceptConflictingPatientID acceptConflictingPatientID) {
        this.acceptConflictingPatientID = acceptConflictingPatientID;
    }

    @Override
    public Attributes.UpdatePolicy getPatientUpdatePolicy() {
        return this.patientUpdatePolicy;
    }

    @Override
    public void setPatientUpdatePolicy(Attributes.UpdatePolicy patientUpdatePolicy) {
        this.patientUpdatePolicy = patientUpdatePolicy;
    }

    @Override
    public Attributes.UpdatePolicy getStudyUpdatePolicy() {
        return this.studyUpdatePolicy;
    }

    @Override
    public void setStudyUpdatePolicy(Attributes.UpdatePolicy studyUpdatePolicy) {
        this.studyUpdatePolicy = studyUpdatePolicy;
    }

    @Override
    public String getImpaxReportEndpoint() {
        return this.impaxReportEndpoint;
    }

    @Override
    public void setImpaxReportEndpoint(String impaxReportEndpoint) {
        this.impaxReportEndpoint = impaxReportEndpoint;
    }
}

