/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.store.impl;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Code;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.conf.ArchiveCompressionRule;
import org.dcm4chee.arc.conf.Availability;
import org.dcm4chee.arc.conf.ExportReoccurredInstances;
import org.dcm4chee.arc.conf.RejectionNote;
import org.dcm4chee.arc.entity.Instance;
import org.dcm4chee.arc.entity.Location;
import org.dcm4chee.arc.entity.RejectedInstance;
import org.dcm4chee.arc.storage.ReadContext;
import org.dcm4chee.arc.storage.WriteContext;
import org.dcm4chee.arc.store.StoreContext;
import org.dcm4chee.arc.store.StoreSession;

class StoreContextImpl
implements StoreContext {
    private final StoreSession storeSession;
    private String receiveTranferSyntaxUID;
    private String storeTranferSyntaxUID;
    private ArchiveCompressionRule compressionRule;
    private String acceptedStudyInstanceUID;
    private int moveOriginatorMessageID;
    private String moveOriginatorAETitle;
    private final EnumMap<Location.ObjectType, WriteContext> writeContexts = new EnumMap(Location.ObjectType.class);
    private ReadContext readContext;
    private Attributes attributes;
    private Attributes coercedAttributes = new Attributes();
    private RejectionNote rejectionNote;
    private RejectedInstance rejectedInstance;
    private Instance previousInstance;
    private Instance storedInstance;
    private Exception exception;
    private final List<Location> locations = new ArrayList<Location>();
    private String[] retrieveAETs;
    private Availability availability;
    private LocalDate expirationDate;
    private Code impaxReportPatientMismatch;

    public StoreContextImpl(StoreSession storeSession) {
        this.storeSession = storeSession;
    }

    @Override
    public StoreSession getStoreSession() {
        return this.storeSession;
    }

    @Override
    public String getSopClassUID() {
        return this.attributes.getString(524310);
    }

    @Override
    public String getSopInstanceUID() {
        return this.attributes.getString(524312);
    }

    @Override
    public String getStudyInstanceUID() {
        return this.attributes.getString(0x20000D);
    }

    @Override
    public String getSeriesInstanceUID() {
        return this.attributes.getString(0x20000E);
    }

    @Override
    public String getMppsInstanceUID() {
        Attributes ppsRef = this.attributes.getNestedDataset(528657);
        return ppsRef != null && "1.2.840.10008.3.1.2.3.3".equals(ppsRef.getString(528720)) ? ppsRef.getString(528725) : null;
    }

    @Override
    public String getReceiveTranferSyntax() {
        return this.receiveTranferSyntaxUID;
    }

    @Override
    public void setReceiveTransferSyntax(String transferSyntaxUID) {
        this.receiveTranferSyntaxUID = transferSyntaxUID;
        this.storeTranferSyntaxUID = transferSyntaxUID;
    }

    @Override
    public String getStoreTranferSyntax() {
        return this.storeTranferSyntaxUID;
    }

    @Override
    public void setStoreTranferSyntax(String storeTranferSyntaxUID) {
        this.storeTranferSyntaxUID = storeTranferSyntaxUID;
    }

    @Override
    public ArchiveCompressionRule getCompressionRule() {
        return this.compressionRule;
    }

    @Override
    public void setCompressionRule(ArchiveCompressionRule compressionRule) {
        this.compressionRule = compressionRule;
    }

    @Override
    public String getAcceptedStudyInstanceUID() {
        return this.acceptedStudyInstanceUID;
    }

    @Override
    public void setAcceptedStudyInstanceUID(String acceptedStudyInstanceUID) {
        this.acceptedStudyInstanceUID = acceptedStudyInstanceUID;
    }

    @Override
    public int getMoveOriginatorMessageID() {
        return this.moveOriginatorMessageID;
    }

    @Override
    public void setMoveOriginatorMessageID(int moveOriginatorMessageID) {
        this.moveOriginatorMessageID = moveOriginatorMessageID;
    }

    @Override
    public String getMoveOriginatorAETitle() {
        return this.moveOriginatorAETitle;
    }

    @Override
    public void setMoveOriginatorAETitle(String moveOriginatorAETitle) {
        this.moveOriginatorAETitle = moveOriginatorAETitle;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(Attributes attrs) {
        this.attributes = attrs;
    }

    @Override
    public ReadContext getReadContext() {
        return this.readContext;
    }

    @Override
    public void setReadContext(ReadContext readContext) {
        this.readContext = readContext;
    }

    @Override
    public WriteContext getWriteContext(Location.ObjectType objectType) {
        return this.writeContexts.get(objectType);
    }

    @Override
    public void setWriteContext(Location.ObjectType objectType, WriteContext writeCtx) {
        this.writeContexts.put(objectType, writeCtx);
        if (objectType == Location.ObjectType.DICOM_FILE) {
            this.readContext = writeCtx;
        }
    }

    @Override
    public Collection<WriteContext> getWriteContexts() {
        return this.writeContexts.values();
    }

    @Override
    public Attributes getCoercedAttributes() {
        return this.coercedAttributes;
    }

    @Override
    public void setCoercedAttributes(Attributes coercedAttributes) {
        this.coercedAttributes = coercedAttributes;
    }

    @Override
    public RejectionNote getRejectionNote() {
        return this.rejectionNote;
    }

    @Override
    public void setRejectionNote(RejectionNote rejectionNote) {
        this.rejectionNote = rejectionNote;
    }

    @Override
    public RejectedInstance getRejectedInstance() {
        return this.rejectedInstance;
    }

    @Override
    public void setRejectedInstance(RejectedInstance rejectedInstance) {
        this.rejectedInstance = rejectedInstance;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    @Override
    public void setException(Exception exception) {
        this.exception = exception;
    }

    @Override
    public Instance getPreviousInstance() {
        return this.previousInstance;
    }

    @Override
    public void setPreviousInstance(Instance previousInstance) {
        this.previousInstance = previousInstance;
    }

    @Override
    public Instance getStoredInstance() {
        return this.storedInstance;
    }

    @Override
    public void setStoredInstance(Instance storedInstance) {
        this.storedInstance = storedInstance;
    }

    @Override
    public List<Location> getLocations() {
        return this.locations;
    }

    @Override
    public String[] getRetrieveAETs() {
        String[] stringArray;
        if (this.retrieveAETs != null) {
            return this.retrieveAETs;
        }
        String[] aets = this.storeSession.getArchiveAEExtension().retrieveAETitles();
        if (aets != null && aets.length > 0) {
            stringArray = aets;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.storeSession.getCalledAET();
        }
        return stringArray;
    }

    @Override
    public void setRetrieveAETs(String[] retrieveAETs) {
        this.retrieveAETs = retrieveAETs;
    }

    @Override
    public Availability getAvailability() {
        if (this.availability != null) {
            return this.availability;
        }
        return (Availability)StringUtils.maskNull((Object)this.readContext.getStorage().getStorageDescriptor().getInstanceAvailability(), (Object)Availability.ONLINE);
    }

    @Override
    public void setAvailability(Availability availability) {
        this.availability = availability;
    }

    @Override
    public LocalDate getExpirationDate() {
        return this.expirationDate;
    }

    @Override
    public void setExpirationDate(LocalDate expirationDate) {
        this.expirationDate = expirationDate;
    }

    @Override
    public boolean isPreviousDifferentStudy() {
        return this.previousInstance != null && this.previousInstance.getSeries().getStudy().getPk() != this.storedInstance.getSeries().getStudy().getPk();
    }

    @Override
    public boolean isPreviousDifferentSeries() {
        return this.previousInstance != null && this.previousInstance.getSeries().getPk() != this.storedInstance.getSeries().getPk();
    }

    @Override
    public Code getImpaxReportPatientMismatch() {
        return this.impaxReportPatientMismatch;
    }

    @Override
    public void setImpaxReportPatientMismatch(Code impaxReportPatientMismatch) {
        this.impaxReportPatientMismatch = impaxReportPatientMismatch;
    }

    @Override
    public boolean match(ExportReoccurredInstances exportReoccurredInstances) {
        return exportReoccurredInstances == ExportReoccurredInstances.ALWAYS || exportReoccurredInstances == ExportReoccurredInstances.NEVER && this.previousInstance == null || !this.locations.isEmpty();
    }
}

