/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.store;

import java.io.Closeable;
import java.net.Socket;
import java.util.Map;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.hl7.HL7Application;
import org.dcm4che3.net.hl7.UnparsedHL7Message;
import org.dcm4chee.arc.conf.AcceptConflictingPatientID;
import org.dcm4chee.arc.conf.AcceptMissingPatientID;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.ExportPriorsRule;
import org.dcm4chee.arc.entity.Series;
import org.dcm4chee.arc.entity.Study;
import org.dcm4chee.arc.entity.UIDMap;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.storage.Storage;
import org.dcm4chee.arc.storage.StorageFactory;
import org.dcm4chee.arc.store.StoreService;

public interface StoreSession
extends Closeable {
    public int getSerialNo();

    public Association getAssociation();

    public HttpServletRequestInfo getHttpRequest();

    public Socket getSocket();

    public UnparsedHL7Message getUnparsedHL7Message();

    public HL7Application getLocalHL7Application();

    public ApplicationEntity getLocalApplicationEntity();

    public ArchiveAEExtension getArchiveAEExtension();

    public ArchiveDeviceExtension getArchiveDeviceExtension();

    public StoreService getStoreService();

    public Storage getStorage(String var1, StorageFactory var2);

    public void putStorage(String var1, Storage var2);

    public String getCalledAET();

    public String getCallingAET();

    public String getRemoteHostName();

    public String getLocalHostName();

    public String getSendingPresentationAddress();

    public String getReceivingPresentationAddress();

    public Study getCachedStudy(String var1);

    public Series getCachedSeries(String var1, String var2);

    public void cacheSeries(Series var1);

    public void invalidateCachedStudyAndSeries();

    public boolean isNotProcessed(ExportPriorsRule var1);

    public boolean markAsProcessed(ExportPriorsRule var1);

    public Map<Long, UIDMap> getUIDMapCache();

    public Map<String, String> getUIDMap();

    public String getObjectStorageID();

    public StoreSession withObjectStorageID(String var1);

    public String getMetadataStorageID();

    public void setMetadataStorageID(String var1);

    public AcceptConflictingPatientID getAcceptConflictingPatientID();

    public AcceptMissingPatientID getAcceptMissingPatientID();

    public void setAcceptConflictingPatientID(AcceptConflictingPatientID var1);

    public Attributes.UpdatePolicy getPatientUpdatePolicy();

    public void setPatientUpdatePolicy(Attributes.UpdatePolicy var1);

    public Attributes.UpdatePolicy getStudyUpdatePolicy();

    public void setStudyUpdatePolicy(Attributes.UpdatePolicy var1);

    public String getImpaxReportEndpoint();

    public void setImpaxReportEndpoint(String var1);
}

