/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.store;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.zip.ZipInputStream;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.hl7.HL7Application;
import org.dcm4che3.net.hl7.UnparsedHL7Message;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.entity.Instance;
import org.dcm4chee.arc.entity.Location;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.storage.ReadContext;
import org.dcm4chee.arc.store.InstanceLocations;
import org.dcm4chee.arc.store.StoreContext;
import org.dcm4chee.arc.store.StoreSession;
import org.dcm4chee.arc.store.UpdateLocation;

public interface StoreService {
    public static final int DUPLICATE_REJECTION_NOTE = 42864;
    public static final int SUBSEQUENT_OCCURRENCE_OF_REJECTED_OBJECT = 42865;
    public static final int REJECTION_FAILED_NO_SUCH_INSTANCE = 42866;
    public static final int REJECTION_FAILED_CLASS_INSTANCE_CONFLICT = 42867;
    public static final int REJECTION_FAILED_ALREADY_REJECTED = 42868;
    public static final int REJECTION_FOR_RETENTION_POLICY_EXPIRED_NOT_ALLOWED = 42869;
    public static final int RETENTION_PERIOD_OF_STUDY_NOT_YET_EXPIRED = 42870;
    public static final int PATIENT_ID_MISSING_IN_OBJECT = 42871;
    public static final int CONFLICTING_PID_NOT_ACCEPTED = 42872;
    public static final int CONFLICTING_PATIENT_ATTRS_REJECTED = 42873;
    public static final String DUPLICATE_REJECTION_NOTE_MSG = "Rejection Note [uid={0}] already received.";
    public static final String SUBSEQUENT_OCCURRENCE_OF_REJECTED_OBJECT_MSG = "Subsequent occurrence of rejected Object [uid={0}, rejection={1}]";
    public static final String REJECTION_FAILED_NO_SUCH_INSTANCE_MSG = "Failed to reject Instance[uid={0}] - no such Instance.";
    public static final String REJECTION_FAILED_NO_SUCH_SERIES_MSG = "Failed to reject Instance of Series[uid={0}] - no such Series.";
    public static final String REJECTION_FAILED_CLASS_INSTANCE_CONFLICT_MSG = "Failed to reject Instance[uid={0}] - class-instance conflict.";
    public static final String REJECTION_FAILED_ALREADY_REJECTED_MSG = "Failed to reject Instance[uid={0}] - already rejected.";
    public static final String REJECTION_FOR_RETENTION_POLICY_EXPIRED_NOT_ALLOWED_MSG = "Rejection for Retention Policy Expired not allowed.";
    public static final String RETENTION_PERIOD_OF_STUDY_NOT_YET_EXPIRED_MSG = "Retention Period of Study not yet expired.";
    public static final String PATIENT_ID_MISSING_IN_OBJECT_MSG = "Patient ID missing in object.";
    public static final String NOT_AUTHORIZED = "Storage denied.";
    public static final String FAILED_TO_QUERY_STORE_PERMISSION_SERVICE = "Failed to query Store Permission Service";
    public static final String CONFLICTING_PID_NOT_ACCEPTED_MSG = "Patient ID {0} differs from Patient ID {1} in previous received object of Study[uid={2}].";
    public static final String CONFLICTING_PATIENT_ATTRS_REJECTED_MSG = "Patient with {0} differs from previous received object in attribute {1} {2}";

    public StoreSession newStoreSession(Association var1);

    public StoreSession newStoreSession(HttpServletRequestInfo var1, ApplicationEntity var2, String var3, String var4);

    public StoreSession newStoreSession(ApplicationEntity var1);

    public StoreSession newStoreSession(HL7Application var1, Socket var2, UnparsedHL7Message var3, ApplicationEntity var4);

    public StoreContext newStoreContext(StoreSession var1);

    public void store(StoreContext var1, InputStream var2) throws IOException;

    public void store(StoreContext var1, InputStream var2, Consumer<Attributes> var3) throws IOException;

    public void addStorageID(String var1, String var2);

    public void scheduleMetadataUpdate(String var1, String var2);

    public void store(StoreContext var1, Attributes var2) throws IOException;

    public void importInstanceOnStorage(StoreContext var1, Attributes var2, ReadContext var3) throws IOException;

    public Attributes copyInstances(StoreSession var1, Collection<InstanceLocations> var2, Attributes var3, Attributes.UpdatePolicy var4) throws Exception;

    public ZipInputStream openZipInputStream(StoreSession var1, String var2, String var3, String var4) throws IOException;

    public List<Instance> restoreInstances(StoreSession var1, String var2, String var3, Duration var4) throws IOException;

    public List<String> studyIUIDsByAccessionNo(String var1);

    public void addLocation(StoreSession var1, Long var2, Location var3);

    public void replaceLocation(StoreSession var1, Long var2, Location var3, List<Location> var4);

    public void compress(StoreContext var1, InstanceLocations var2, InputStream var3) throws IOException;

    public void updateLocations(ArchiveAEExtension var1, List<UpdateLocation> var2);
}

