/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.storage.cloud;

import com.google.common.hash.HashCode;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.file.NoSuchFileException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadLocalRandom;
import org.dcm4che3.net.Device;
import org.dcm4chee.arc.conf.BinaryPrefix;
import org.dcm4chee.arc.conf.StorageDescriptor;
import org.dcm4chee.arc.metrics.MetricsService;
import org.dcm4chee.arc.storage.AbstractStorage;
import org.dcm4chee.arc.storage.ReadContext;
import org.dcm4chee.arc.storage.Storage;
import org.dcm4chee.arc.storage.WriteContext;
import org.dcm4chee.arc.storage.cloud.CloudWriteContext;
import org.dcm4chee.arc.storage.cloud.S3Uploader;
import org.dcm4chee.arc.storage.cloud.Uploader;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.payloads.InputStreamPayload;
import org.jclouds.logging.slf4j.config.SLF4JLoggingModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudStorage
extends AbstractStorage {
    private static final Logger LOG = LoggerFactory.getLogger(CloudStorage.class);
    private static final String DEFAULT_CONTAINER = "org.dcm4chee.arc";
    private static final Uploader STREAMING_UPLOADER = new Uploader(){

        @Override
        public void upload(BlobStoreContext context, InputStream in, long length, BlobStore blobStore, String container, String storagePath) {
            InputStreamPayload payload = new InputStreamPayload(in);
            if (length >= 0L) {
                payload.getContentMetadata().setContentLength(Long.valueOf(length));
            }
            Blob blob = blobStore.blobBuilder(storagePath).payload((Payload)payload).build();
            blobStore.putBlob(container, blob);
        }
    };
    private final Device device;
    private final String container;
    private final BlobStoreContext context;
    private final boolean streamingUpload;
    private final long maxPartSize;
    private int count;

    public WriteContext createWriteContext(String storagePath) {
        CloudWriteContext writeContext = new CloudWriteContext((Storage)this);
        writeContext.setStoragePath(storagePath);
        return writeContext;
    }

    protected CloudStorage(StorageDescriptor descriptor, MetricsService metricsService, Device device) {
        super(descriptor, metricsService);
        this.device = device;
        this.container = descriptor.getProperty("container", DEFAULT_CONTAINER);
        if (Boolean.parseBoolean(descriptor.getProperty("containerExists", null))) {
            ++this.count;
        }
        String api = descriptor.getStorageURI().getSchemeSpecificPart();
        String endpoint = null;
        int endApi = api.indexOf(58);
        if (endApi != -1) {
            endpoint = api.substring(endApi + 1);
            api = api.substring(0, endApi);
        }
        this.streamingUpload = Boolean.parseBoolean(descriptor.getProperty("streamingUpload", null));
        this.maxPartSize = BinaryPrefix.parse((String)descriptor.getProperty("maxPartSize", "5G"));
        ContextBuilder ctxBuilder = ContextBuilder.newBuilder((String)api);
        String identity = descriptor.getProperty("identity", null);
        if (identity != null) {
            ctxBuilder.credentials(identity, descriptor.getProperty("credential", null));
        }
        if (endpoint != null) {
            ctxBuilder.endpoint(endpoint);
        }
        Properties overrides = new Properties();
        for (Map.Entry entry : descriptor.getProperties().entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("jclouds.")) continue;
            overrides.setProperty(key, (String)entry.getValue());
        }
        ctxBuilder.overrides(overrides);
        ctxBuilder.modules(Collections.singleton(new SLF4JLoggingModule()));
        this.context = (BlobStoreContext)ctxBuilder.buildView(BlobStoreContext.class);
    }

    protected Logger log() {
        return LOG;
    }

    protected OutputStream openOutputStreamA(final WriteContext ctx) throws IOException {
        final PipedInputStream in = new PipedInputStream();
        PipedOutputStream out = new PipedOutputStream(in);
        FutureTask<Void> task = new FutureTask<Void>(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    CloudStorage.this.upload(ctx, in);
                }
                finally {
                    in.close();
                }
                return null;
            }
        });
        ((CloudWriteContext)ctx).setUploadTask(task);
        this.device.execute(task);
        return out;
    }

    protected void copyA(InputStream in, WriteContext ctx) throws IOException {
        this.upload(ctx, in);
    }

    protected void afterOutputStreamClosed(WriteContext ctx) throws IOException {
        FutureTask<Void> task = ((CloudWriteContext)ctx).getUploadTask();
        try {
            task.get();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        catch (ExecutionException e) {
            Throwable c = e.getCause();
            if (c instanceof IOException) {
                throw (IOException)c;
            }
            throw new IOException("Upload failed", c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upload(WriteContext ctx, InputStream in) throws IOException {
        if (this.isSynchronizeUpload()) {
            StorageDescriptor storageDescriptor = this.descriptor;
            synchronized (storageDescriptor) {
                this.upload(in, ctx);
            }
        } else {
            this.upload(in, ctx);
        }
    }

    private void upload(InputStream in, WriteContext ctx) throws IOException {
        BlobStore blobStore = this.context.getBlobStore();
        String storagePath = ctx.getStoragePath();
        if (this.count++ == 0 && !blobStore.containerExists(this.container)) {
            blobStore.createContainerInLocation(null, this.container);
        } else {
            while (blobStore.blobExists(this.container, storagePath)) {
                storagePath = storagePath.substring(0, storagePath.lastIndexOf(47) + 1).concat(String.format("%08X", ThreadLocalRandom.current().nextInt()));
                ctx.setStoragePath(storagePath);
            }
        }
        long length = ctx.getContentLength();
        Uploader uploader = this.streamingUpload || length >= 0L && length <= this.maxPartSize ? STREAMING_UPLOADER : new S3Uploader();
        uploader.upload(this.context, in, length, blobStore, this.container, storagePath);
    }

    private boolean isSynchronizeUpload() {
        return "true".equals(this.descriptor.getProperty("synchronizeUpload", "false"));
    }

    protected InputStream openInputStreamA(ReadContext ctx) throws IOException {
        BlobStore blobStore = this.context.getBlobStore();
        Blob blob = blobStore.getBlob(this.container, ctx.getStoragePath());
        if (blob == null) {
            throw this.objectNotFound(ctx.getStoragePath());
        }
        return blob.getPayload().openStream();
    }

    public boolean exists(ReadContext ctx) {
        BlobStore blobStore = this.context.getBlobStore();
        return blobStore.blobExists(this.container, ctx.getStoragePath());
    }

    public long getContentLength(ReadContext ctx) throws IOException {
        BlobStore blobStore = this.context.getBlobStore();
        BlobMetadata blobMetadata = blobStore.blobMetadata(this.container, ctx.getStoragePath());
        if (blobMetadata == null) {
            throw this.objectNotFound(ctx.getStoragePath());
        }
        return blobMetadata.getContentMetadata().getContentLength();
    }

    public byte[] getContentMD5(ReadContext ctx) throws IOException {
        BlobStore blobStore = this.context.getBlobStore();
        BlobMetadata blobMetadata = blobStore.blobMetadata(this.container, ctx.getStoragePath());
        if (blobMetadata == null) {
            throw this.objectNotFound(ctx.getStoragePath());
        }
        HashCode hashCode = blobMetadata.getContentMetadata().getContentMD5AsHashCode();
        return hashCode != null ? hashCode.asBytes() : null;
    }

    protected void deleteObjectA(String storagePath) throws IOException {
        BlobStore blobStore = this.context.getBlobStore();
        if (!blobStore.blobExists(this.container, storagePath)) {
            throw this.objectNotFound(storagePath);
        }
        blobStore.removeBlob(this.container, storagePath);
    }

    private IOException objectNotFound(String storagePath) {
        return new NoSuchFileException("No Object[" + storagePath + "] in Container[" + this.container + "] on " + this.getStorageDescriptor());
    }

    public void close() throws IOException {
        this.context.close();
    }
}

