/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.storage;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.dcm4chee.arc.NamedCDIBeanCache;
import org.dcm4chee.arc.conf.StorageDescriptor;
import org.dcm4chee.arc.conf.StorageThreshold;
import org.dcm4chee.arc.storage.Storage;
import org.dcm4chee.arc.storage.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class StorageFactory {
    private static final Logger LOG = LoggerFactory.getLogger(StorageFactory.class);
    @Inject
    private NamedCDIBeanCache namedCDIBeanCache;
    @Inject
    private Instance<StorageProvider> providers;

    public Storage getStorage(StorageDescriptor descriptor) {
        String scheme = descriptor.getStorageURI().getScheme();
        StorageProvider provider = (StorageProvider)this.namedCDIBeanCache.get(this.providers, scheme);
        return provider.openStorage(descriptor);
    }

    public UsableStorage getUsableStorage(List<StorageDescriptor> free, List<StorageDescriptor> full) throws IOException {
        Iterator<StorageDescriptor> freeIter = free.iterator();
        Iterator<StorageDescriptor> fullIter = null;
        Date now = null;
        while (freeIter.hasNext()) {
            StorageDescriptor desc = freeIter.next();
            Storage storage = this.getStorage(desc);
            if (this.hasMinUsableSpace(storage)) {
                return new UsableStorage(storage, now == null ? null : StorageFactory.updateStorageIDs(free, full));
            }
            LOG.info(desc.isStorageThresholdExceedsPermanently() ? "No space left on {} - disable storage" : "No space left on {} - suspend storage", (Object)storage);
            storage.close();
            if (now == null) {
                now = new Date();
            }
            desc.setStorageThresholdExceeded(now);
            if (desc.isStorageThresholdExceedsPermanently()) {
                freeIter.remove();
            }
            if (fullIter != null) continue;
            Collections.sort(full, Comparator.comparing(StorageDescriptor::getStorageThresholdExceeded));
            fullIter = full.iterator();
            while (fullIter.hasNext()) {
                desc = fullIter.next();
                storage = this.getStorage(desc);
                if (this.hasMinUsableSpace(storage)) {
                    LOG.info("Free space on {} - resume storage", (Object)storage);
                    desc.setStorageThresholdExceeded(null);
                    return new UsableStorage(storage, StorageFactory.updateStorageIDs(free, full));
                }
                storage.close();
                desc.setStorageThresholdExceeded(now);
                if (!desc.isStorageThresholdExceedsPermanently()) continue;
                fullIter.remove();
            }
        }
        throw new IOException("No space left on configured storage systems");
    }

    private boolean hasMinUsableSpace(Storage storage) throws IOException {
        StorageDescriptor descriptor = storage.getStorageDescriptor();
        StorageThreshold storageThreshold = descriptor.getStorageThreshold();
        if (storageThreshold == null) {
            return true;
        }
        long usableSpace = storage.getUsableSpace();
        return usableSpace < 0L || usableSpace >= storageThreshold.getMinUsableDiskSpace();
    }

    private static String[] updateStorageIDs(List<StorageDescriptor> free, List<StorageDescriptor> full) {
        return (String[])Stream.of(free, full).flatMap(Collection::stream).map(StorageDescriptor::getStorageID).toArray(String[]::new);
    }

    public static class UsableStorage
    implements Closeable {
        public final Storage storage;
        public final String[] updateStorageIDs;

        public UsableStorage(Storage storage, String[] updateStorageIDs) {
            this.storage = storage;
            this.updateStorageIDs = updateStorageIDs;
        }

        @Override
        public void close() throws IOException {
            this.storage.close();
        }
    }
}

