/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.storage;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class CacheInputStream
extends InputStream {
    private static int BUFFER_SIZE = 8192;
    private static int MAX_BUFFERS = 640;
    private final ArrayList<byte[]> buffers = new ArrayList();
    private int pos;
    private int count;

    @Override
    public int available() {
        return this.count - this.pos;
    }

    @Override
    public int read() throws IOException {
        if (this.available() <= 0) {
            return -1;
        }
        int index = this.pos++;
        return this.buffers.get(index / BUFFER_SIZE)[index % BUFFER_SIZE];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.count) {
            return -1;
        }
        int srcOff = this.pos % BUFFER_SIZE;
        int avail = Math.min(this.count - this.pos, BUFFER_SIZE - srcOff);
        if (len > avail) {
            len = avail;
        }
        byte[] src = this.buffers.get(this.pos / BUFFER_SIZE);
        System.arraycopy(src, srcOff, b, 0, len);
        this.pos += len;
        return len;
    }

    public boolean fillBuffers(InputStream in) throws IOException {
        this.pos = 0;
        this.count = 0;
        for (int i = 0; i < MAX_BUFFERS; ++i) {
            int r;
            byte[] b = this.getOrCreateBuffer(i);
            int off = 0;
            int len = BUFFER_SIZE;
            do {
                if ((r = in.read(b, off, len)) < 0) {
                    return false;
                }
                off += r;
                this.count += r;
            } while ((len -= r) > 0);
        }
        return true;
    }

    private byte[] getOrCreateBuffer(int i) {
        if (this.buffers.size() > i) {
            return this.buffers.get(i);
        }
        byte[] b = new byte[BUFFER_SIZE];
        this.buffers.add(b);
        return b;
    }
}

