/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.stgcmt.impl;

import java.time.Period;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4chee.arc.Scheduler;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.ScheduleExpression;
import org.dcm4chee.arc.entity.Series;
import org.dcm4chee.arc.stgcmt.impl.StgCmtEJB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class StgVerScheduler
extends Scheduler {
    private static final Logger LOG = LoggerFactory.getLogger(StgVerScheduler.class);
    @Inject
    private StgCmtEJB ejb;

    protected StgVerScheduler() {
        super(Scheduler.Mode.scheduleWithFixedDelay);
    }

    protected Logger log() {
        return LOG;
    }

    protected Duration getPollingInterval() {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        return arcDev != null ? arcDev.getStorageVerificationPollingInterval() : null;
    }

    protected void execute() {
        List<Series.StorageVerification> storageVerifications;
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        if (!ScheduleExpression.emptyOrAnyContainsNow((ScheduleExpression[])arcDev.getStorageVerificationSchedules())) {
            return;
        }
        String aet = arcDev.getStorageVerificationAETitle();
        ApplicationEntity ae = this.device.getApplicationEntity(aet, true);
        if (ae == null || !ae.isInstalled()) {
            LOG.warn("No such Application Entity: " + aet);
            return;
        }
        int maxScheduled = arcDev.getStorageVerificationMaxScheduled();
        int remaining = this.remaining(maxScheduled);
        if (remaining == 0) {
            LOG.info("Maximal number of scheduled Storage Verification Tasks[{}] reached", (Object)maxScheduled);
            return;
        }
        int fetchSize = arcDev.getStorageVerificationFetchSize();
        Period period = arcDev.getStorageVerificationPeriod();
        String batchID = arcDev.getStorageVerificationBatchID();
        do {
            storageVerifications = this.ejb.findSeriesForScheduledStorageVerifications(fetchSize);
            LOG.info("Found {} Series scheduled for Storage Verification", (Object)storageVerifications.size());
            for (Series.StorageVerification storageVerification : storageVerifications) {
                if (!this.claim(storageVerification, period)) continue;
                try {
                    if (!this.ejb.scheduleStgVerTask(aet, storageVerification.studyInstanceUID, storageVerification.seriesInstanceUID, batchID) || --remaining > 0) continue;
                    LOG.info("Maximal number of scheduled Storage Verification Tasks[{}] reached", (Object)maxScheduled);
                    return;
                }
                catch (Exception e) {
                    LOG.warn("Failed to schedule {}:\n", (Object)storageVerification, (Object)e);
                }
            }
        } while (this.getPollingInterval() != null && storageVerifications.size() == fetchSize);
    }

    private int remaining(int maxScheduled) {
        if (maxScheduled <= 0) {
            return Integer.MAX_VALUE;
        }
        long scheduled = this.ejb.countScheduledTasksOnThisDevice("StgVerTasks");
        return (int)Math.max((long)maxScheduled - scheduled, 0L);
    }

    private boolean claim(Series.StorageVerification storageVerification, Period period) {
        try {
            return this.ejb.claimForStorageVerification(storageVerification.seriesPk, storageVerification.storageVerificationTime, this.nextVerificationTime(storageVerification, period)) > 0;
        }
        catch (Exception e) {
            LOG.info("Failed to claim {}:\n", (Object)storageVerification, (Object)e);
            return false;
        }
    }

    private Date nextVerificationTime(Series.StorageVerification storageVerification, Period period) {
        if (period == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(storageVerification.storageVerificationTime);
        cal.add(1, period.getYears());
        cal.add(2, period.getMonths());
        cal.add(5, period.getDays());
        return cal.getTime();
    }
}

