/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.stgcmt.impl;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.dcm4che3.conf.api.IApplicationEntityCache;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.qmgt.Outcome;
import org.dcm4chee.arc.qmgt.TaskProcessor;
import org.dcm4chee.arc.stgcmt.StgCmtContext;
import org.dcm4chee.arc.stgcmt.StgCmtManager;
import org.dcm4chee.arc.stgcmt.StgCmtSCP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Named(value="STGCMT_SCP")
public class StgCmtSCPTaskProcessor
implements TaskProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(StgCmtSCPTaskProcessor.class);
    @Inject
    private Device device;
    @Inject
    private IApplicationEntityCache aeCache;
    @Inject
    private Event<StgCmtContext> stgCmtEvent;
    @Inject
    private StgCmtSCP stgCmtSCP;
    @Inject
    private StgCmtManager stgCmtMgr;

    public Outcome process(Task task) throws Exception {
        String localAET = task.getLocalAET();
        ApplicationEntity localAE = this.device.getApplicationEntity(localAET, true);
        ApplicationEntity remoteAE = this.aeCache.findApplicationEntity(task.getRemoteAET());
        Attributes actionInfo = (Attributes)task.getPayload(Attributes.class);
        StgCmtContext ctx = new StgCmtContext(localAE, localAET).setRemoteAE(remoteAE).setTransactionUID(actionInfo.getString(528789));
        this.stgCmtMgr.calculateResult(ctx, actionInfo.getSequence(528793));
        this.stgCmtEvent.fire((Object)ctx);
        return this.stgCmtSCP.sendNEventReport(localAET, remoteAE, this.removeExtendedEventInfo(ctx.getEventInfo()));
    }

    private Attributes removeExtendedEventInfo(Attributes eventInfo) {
        eventInfo.remove(0x20000D);
        eventInfo.remove(0x100010);
        eventInfo.remove(0x100020);
        eventInfo.remove(0x100021);
        return eventInfo;
    }
}

