/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.impl;

import java.net.Socket;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.dcm4che3.hl7.HL7Exception;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.hl7.HL7Application;
import org.dcm4che3.net.hl7.HL7ConnectionMonitor;
import org.dcm4che3.net.hl7.UnparsedHL7Message;
import org.dcm4chee.arc.HL7ConnectionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class HL7ConnectionEventSource
implements HL7ConnectionMonitor {
    private static Logger LOG = LoggerFactory.getLogger(HL7ConnectionEventSource.class);
    @Inject
    private Event<HL7ConnectionEvent> hl7ConnectionEvent;

    public void onMessageReceived(Connection conn, Socket s, UnparsedHL7Message msg) {
        this.fire(HL7ConnectionEvent.onMessageReceived(conn, s, msg));
    }

    public void onMessageProcessed(Connection conn, Socket s, UnparsedHL7Message msg, UnparsedHL7Message rsp, HL7Exception ex) {
        this.fire(HL7ConnectionEvent.onMessageProcessed(conn, s, msg, rsp, ex));
    }

    public void onMessageSent(HL7Application hl7App, Socket s, UnparsedHL7Message msg, Exception ex) {
        this.fire(HL7ConnectionEvent.onMessageSent(hl7App, s, msg, ex));
    }

    public void onMessageResponse(HL7Application hl7App, Socket s, UnparsedHL7Message msg, UnparsedHL7Message rsp, Exception ex) {
        this.fire(HL7ConnectionEvent.onMessageResponse(hl7App, s, msg, rsp, ex));
    }

    private void fire(HL7ConnectionEvent event) {
        try {
            this.hl7ConnectionEvent.fire((Object)event);
        }
        catch (Exception e) {
            LOG.warn("Observer of {} throws:", (Object)event, (Object)e);
        }
    }
}

