/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.impl;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.AssociationMonitor;
import org.dcm4che3.net.pdu.AAssociateRJ;
import org.dcm4chee.arc.AssociationEvent;
import org.dcm4chee.arc.metrics.MetricsService;

@ApplicationScoped
public class AssociationEventSource
implements AssociationMonitor {
    @Inject
    private Event<AssociationEvent> event;
    @Inject
    private MetricsService metricsService;

    public void onAssociationEstablished(Association as) {
        this.assocTo(as);
        as.addAssociationListener(this::assocTo);
        this.event.fire((Object)AssociationEvent.onAssociationEstablished(as));
    }

    private void assocTo(Association as) {
        this.metricsService.accept("assoc-to-" + as.getCalledAET(), () -> as.getApplicationEntity().getDevice().getNumberOfAssociationsInitiatedTo(as.getCalledAET()));
    }

    public void onAssociationFailed(Association as, Throwable e) {
        this.event.fire((Object)AssociationEvent.onAssociationFailed(as, e));
    }

    public void onAssociationRejected(Association as, AAssociateRJ e) {
        this.event.fire((Object)AssociationEvent.onAssociationRejected(as, e));
    }

    public void onAssociationAccepted(Association as) {
        this.assocFrom(as);
        as.addAssociationListener(this::assocFrom);
        this.event.fire((Object)AssociationEvent.onAssociationAccepted(as));
    }

    private void assocFrom(Association as) {
        this.metricsService.accept("assoc-from-" + as.getCallingAET(), () -> as.getApplicationEntity().getDevice().getNumberOfAssociationsInitiatedBy(as.getCallingAET()));
    }
}

